/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.FunctTestConstants;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Filter;
import com.atlassian.jira.testkit.client.restclient.FilterClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.ProjectRole;
import com.google.common.base.Objects;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.FILTERS})
@RestoreBlankInstance
public class TestFilterPermissionResource
extends BaseJiraRestTest {
    private FilterClient client;
    private static final String NON_EXISTENT_FILTER_ID = "123132";
    private static final FilterClient.FilterPermissionInputBean GROUP_PERMISSION = new FilterClient.FilterPermissionInputBean("group", null, null, "jira-administrators", null, true, false);
    private static final FilterClient.FilterPermissionInputBean USER_PERMISSION = new FilterClient.FilterPermissionInputBean("user", null, null, null, "admin", true, true);

    @Before
    public void setUp() throws Exception {
        this.backdoor.applicationProperties().enableGlobalSharing();
        this.client = new FilterClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void getAllPermissionsReturnsUnauthorizedForAnonymous() {
        String filterId = this.createFilter("test");
        this.client.loginAs(null);
        ParsedResponse response = this.client.getFilterPermissions(filterId);
        this.assertUnauthorizedResponse(response);
    }

    @Test
    public void getAllPermissionsForPrivateFilterFfDisabledReturnsNotFound() {
        try {
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            String filterId = this.backdoor.searchRequests().createFilter("fred", "assignee=currentUser()", "Fred's private filter", null);
            ParsedResponse response = this.client.getFilterPermissions(filterId);
            this.assertNotFoundResponse(response);
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=811000)
    public void getAllPermissionsForPrivateFilter() {
        String filterId = this.backdoor.searchRequests().createFilter("fred", "assignee=currentUser()", "Fred's private filter", null);
        ParsedResponse response = this.client.getFilterPermissions(filterId);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)IsEqual.equalTo((Object)Response.Status.OK.getStatusCode()));
    }

    @Test
    public void noPermissionsReturnsEmptyList() {
        String filterId = this.createFilter("test");
        List result = (List)this.client.getFilterPermissions((String)filterId).body;
        MatcherAssert.assertThat((Object)result, (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    @Test
    public void addGroupPermissionWorksAndResultsInPermissionBeingAdded() {
        String filterId = this.createFilter("test");
        List<Filter.FilterPermission> putResult = this.assertCreated(this.postPermission(filterId, GROUP_PERMISSION));
        MatcherAssert.assertThat(putResult, (Matcher)IsCollectionWithSize.hasSize((int)1));
        List result = (List)this.client.getFilterPermissions((String)filterId).body;
        MatcherAssert.assertThat((Object)result, (Matcher)IsCollectionWithSize.hasSize((int)1));
    }

    @Test
    public void addGlobalPermissionWorksAndResultsInPermissionBeingAdded() {
        String filterId = this.createFilter("test");
        FilterClient.FilterPermissionInputBean inputPermission = this.globalPermission();
        List<Filter.FilterPermission> putResult = this.assertCreated(this.postPermission(filterId, inputPermission));
        MatcherAssert.assertThat(putResult, (Matcher)IsCollectionWithSize.hasSize((int)1));
        List result = (List)this.client.getFilterPermissions((String)filterId).body;
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.contains(this.filterPermission(inputPermission)));
    }

    @Test
    public void addGlobalPermissionOverwritesPreviousPermissions() {
        String filterId = this.createFilter("test");
        this.withFilterContainingPermission(filterId, GROUP_PERMISSION);
        FilterClient.FilterPermissionInputBean inputPermission = this.globalPermission();
        List<Filter.FilterPermission> result = this.assertCreated(this.postPermission(filterId, inputPermission));
        MatcherAssert.assertThat(result, (Matcher)Matchers.contains(this.filterPermission(inputPermission)));
    }

    @Test
    public void addGlobalPermissionForPrivateFilterFfDisabledReturnsNotFound() {
        try {
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            String filterId = this.backdoor.searchRequests().createFilter("fred", "assignee=currentUser()", "Fred's private filter", null);
            ParsedResponse<List<Filter.FilterPermission>> response = this.postPermission(filterId, GROUP_PERMISSION);
            this.assertNotFoundResponse(response);
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=811000)
    public void addGlobalPermissionForPrivateFilter() {
        String filterId = this.backdoor.searchRequests().createFilter("fred", "assignee=currentUser()", "Fred's private filter", null);
        List<Filter.FilterPermission> putResult = this.assertCreated(this.postPermission(filterId, GROUP_PERMISSION));
        MatcherAssert.assertThat(putResult, (Matcher)IsCollectionWithSize.hasSize((int)1));
        List result = (List)this.client.getFilterPermissions((String)filterId).body;
        MatcherAssert.assertThat((Object)result, (Matcher)IsCollectionWithSize.hasSize((int)1));
    }

    @Test
    public void addProjectPermissionWorksAndResultsInPermissionBeingAdded() {
        String filterId = this.createFilter("test");
        long projectId = this.backdoor.project().addProject(RandomStringUtils.randomAlphabetic((int)5), RandomStringUtils.randomAlphabetic((int)3).toUpperCase(), "admin");
        List<Filter.FilterPermission> putResult = this.assertCreated(this.postPermission(filterId, this.projectPermission(projectId)));
        MatcherAssert.assertThat(putResult, (Matcher)IsCollectionWithSize.hasSize((int)1));
        List result = (List)this.client.getFilterPermissions((String)filterId).body;
        MatcherAssert.assertThat((Object)result, (Matcher)IsCollectionWithSize.hasSize((int)1));
    }

    @Test
    public void addProjectRolePermissionWorksAndResultsInPermissionBeingAdded() {
        String filterId = this.createFilter("test");
        String projectKey = RandomStringUtils.randomAlphabetic((int)3).toUpperCase();
        long projectId = this.backdoor.project().addProject(RandomStringUtils.randomAlphabetic((int)5), projectKey, "admin");
        this.backdoor.projectRole().addActors(projectKey, "Developers", null, new String[]{"admin"});
        ProjectRole projectRole = this.backdoor.projectRole().get(projectKey, "Developers");
        List<Filter.FilterPermission> putResult = this.assertCreated(this.postPermission(filterId, this.projectRolePermission(projectId, projectRole)));
        MatcherAssert.assertThat(putResult, (Matcher)IsCollectionWithSize.hasSize((int)1));
        List result = (List)this.client.getFilterPermissions((String)filterId).body;
        MatcherAssert.assertThat((Object)result, (Matcher)IsCollectionWithSize.hasSize((int)1));
    }

    @Test
    public void addUserPermissionWorksAndResultsInPermissionBeingAdded() {
        String filterId = this.createFilter("test");
        List<Filter.FilterPermission> putResult = this.assertCreated(this.postPermission(filterId, USER_PERMISSION));
        MatcherAssert.assertThat(putResult, (Matcher)IsCollectionWithSize.hasSize((int)1));
        List result = (List)this.client.getFilterPermissions((String)filterId).body;
        MatcherAssert.assertThat((Object)result, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.contains(this.filterPermission(USER_PERMISSION)));
    }

    @Test
    public void getSinglePermissionWorks() {
        String filterId = this.createFilter("test");
        List<Filter.FilterPermission> putResult = this.assertCreated(this.postPermission(filterId, USER_PERMISSION));
        MatcherAssert.assertThat(putResult, (Matcher)IsCollectionWithSize.hasSize((int)1));
        Filter.FilterPermission filterPermission = putResult.get(0);
        Filter.FilterPermission result = (Filter.FilterPermission)this.client.getFilterPermission((String)filterId, (String)filterPermission.id.toString()).body;
        MatcherAssert.assertThat((Object)result, (Matcher)IsEqual.equalTo((Object)filterPermission));
    }

    @Test
    public void getSinglePermissionReturnsUnauthorizedForAnonymous() {
        String filterId = this.createFilter("test");
        this.client.loginAs(null);
        ParsedResponse response = this.client.getFilterPermission(filterId, "1");
        this.assertUnauthorizedResponse(response);
    }

    @Test
    public void getPermissionsReturns404ForNonExistingFilter() {
        this.assertNotFoundResponse(this.client.getFilterPermissions(NON_EXISTENT_FILTER_ID));
    }

    @Test
    public void getPermissionReturns404ForNonExistingFilter() {
        this.assertNotFoundResponse(this.client.getFilterPermission(NON_EXISTENT_FILTER_ID, "1"));
    }

    @Test
    public void putPermissionReturns404ForNonExistingFilter() {
        this.assertNotFoundResponse(this.postPermission(NON_EXISTENT_FILTER_ID, GROUP_PERMISSION));
    }

    @Test
    public void deletePermissionReturns404ForNonExistingFilter() {
        this.assertNotFoundResponse(this.client.deleteFilterPermission(NON_EXISTENT_FILTER_ID, "1"));
    }

    @Test
    public void getPermissionReturns404ForNonExistingPermission() {
        String filterId = this.createFilter("asdf");
        this.assertNotFoundResponse(this.client.getFilterPermission(filterId, NON_EXISTENT_FILTER_ID));
    }

    @Test
    public void deletePermissionWorksAndResultsInPermissionBeingAdded() {
        String filterId = this.createFilter("test");
        Filter.FilterPermission filterPermission = this.withFilterContainingPermission(filterId, GROUP_PERMISSION);
        ParsedResponse response = this.client.deleteFilterPermission(filterId, filterPermission.id.toString());
        Assert.assertEquals((long)204L, (long)response.statusCode);
        List result = (List)this.client.getFilterPermissions((String)filterId).body;
        MatcherAssert.assertThat((Object)result, (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cannotShareFilterWithoutShareObjectsGlobalPermission() {
        try {
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.ADMINS_CAN_SHARE_FILTERS_AND_DASHBOARDS_WITH_ALL_GROUPS_AND_ROLES);
            this.client.loginAs("fred");
            String filterId = this.createFilter("test");
            ParsedResponse<List<Filter.FilterPermission>> putResponse = this.postPermission(filterId, new FilterClient.FilterPermissionInputBean("group", null, null, "jira-users", null, true, false));
            Assert.assertEquals((long)400L, (long)putResponse.statusCode);
            List result = (List)this.client.getFilterPermissions((String)filterId).body;
            MatcherAssert.assertThat((Object)result, (Matcher)IsCollectionWithSize.hasSize((int)0));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_SHARE_FILTERS_AND_DASHBOARDS_WITH_ALL_GROUPS_AND_ROLES);
        }
    }

    @Test
    public void canShareFilterWithGroupWhenHasAdminPermissionsAndFeatureFlagIsEnabled() {
        try {
            this.backdoor.darkFeatures().enableForSite(FunctTestConstants.ADMINS_CAN_SHARE_FILTERS_AND_DASHBOARDS_WITH_ALL_GROUPS_AND_ROLES);
            String filterId = this.createFilter("test");
            this.backdoor.usersAndGroups().addGroup("group-without-admin");
            this.assertCreated(this.postPermission(filterId, new FilterClient.FilterPermissionInputBean("group", null, null, "group-without-admin", null, true, true)));
            List result = (List)this.client.getFilterPermissions((String)filterId).body;
            MatcherAssert.assertThat((Object)result, (Matcher)IsCollectionWithSize.hasSize((int)1));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_SHARE_FILTERS_AND_DASHBOARDS_WITH_ALL_GROUPS_AND_ROLES);
        }
    }

    @Test
    public void cannotShareFilterWithGroupWhenHasAdminPermissionsAndFeatureFlagIsDisabled() {
        try {
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.ADMINS_CAN_SHARE_FILTERS_AND_DASHBOARDS_WITH_ALL_GROUPS_AND_ROLES);
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            String filterId = this.createFilter("test");
            this.backdoor.usersAndGroups().addGroup("group-without-admin");
            this.assertBadRequestForPutFilterPermission(filterId, new FilterClient.FilterPermissionInputBean("group", null, null, "group-without-admin", null, true, true));
            List result = (List)this.client.getFilterPermissions((String)filterId).body;
            MatcherAssert.assertThat((Object)result, (Matcher)IsCollectionWithSize.hasSize((int)0));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_SHARE_FILTERS_AND_DASHBOARDS_WITH_ALL_GROUPS_AND_ROLES);
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        }
    }

    @Test
    public void canShareIfNotMemberOfTheGroupAndFFIsEnabled() {
        try {
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.ADMINS_CAN_SHARE_FILTERS_AND_DASHBOARDS_WITH_ALL_GROUPS_AND_ROLES);
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            this.backdoor.darkFeatures().enableForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            String filterId = this.createFilter("test");
            this.backdoor.usersAndGroups().addGroup("group-without-admin");
            this.assertCreated(this.postPermission(filterId, new FilterClient.FilterPermissionInputBean("group", null, null, "group-without-admin", null, true, true)));
            List result = (List)this.client.getFilterPermissions((String)filterId).body;
            MatcherAssert.assertThat((Object)result, (Matcher)IsCollectionWithSize.hasSize((int)1));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_SHARE_FILTERS_AND_DASHBOARDS_WITH_ALL_GROUPS_AND_ROLES);
        }
    }

    @Test
    public void canShareIfNotMemberOfTheGroupAndFFIsEnabledAndIsNotAdmin() {
        try {
            this.backdoor.darkFeatures().enableForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            this.client.loginAs("fred");
            String filterId = this.createFilter("test");
            this.backdoor.usersAndGroups().addGroup("group-without-user");
            this.backdoor.usersAndGroups().addUserToGroup("fred", "jira-developers");
            this.assertCreated(this.postPermission(filterId, new FilterClient.FilterPermissionInputBean("group", null, null, "group-without-user", null, true, true)));
            List result = (List)this.client.getFilterPermissions((String)filterId).body;
            MatcherAssert.assertThat((Object)result, (Matcher)IsCollectionWithSize.hasSize((int)1));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            this.backdoor.usersAndGroups().removeUserFromGroup("fred", "jira-developers");
        }
    }

    @Test
    public void canShareIfNotMemberOfTheGroupAndFFIsEnabledAndIsNotOwner() {
        try {
            this.backdoor.darkFeatures().enableForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            String filterId = this.createFilter("test");
            this.assertCreated(this.postPermission(filterId, new FilterClient.FilterPermissionInputBean("group", null, null, "jira-administrators", null, true, true)));
            MatcherAssert.assertThat((Object)this.client.getFilterPermissions((String)filterId).body, (Matcher)IsCollectionWithSize.hasSize((int)1));
            this.assertCreated(this.postPermission(filterId, new FilterClient.FilterPermissionInputBean("user", null, null, null, "fred", true, true)));
            MatcherAssert.assertThat((Object)this.client.getFilterPermissions((String)filterId).body, (Matcher)IsCollectionWithSize.hasSize((int)2));
            this.client.loginAs("fred");
            this.backdoor.usersAndGroups().addGroup("group-without-user");
            this.backdoor.usersAndGroups().addUserToGroup("fred", "jira-developers");
            this.assertCreated(this.postPermission(filterId, new FilterClient.FilterPermissionInputBean("group", null, null, "group-without-user", null, true, true)));
            MatcherAssert.assertThat((Object)this.client.getFilterPermissions((String)filterId).body, (Matcher)IsCollectionWithSize.hasSize((int)3));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            this.backdoor.usersAndGroups().removeUserFromGroup("fred", "jira-developers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void canShareFilterWithProjectRoleWhenHasAdminPermissionsAndFeatureFlagIsEnabled() {
        try {
            this.backdoor.darkFeatures().enableForSite(FunctTestConstants.ADMINS_CAN_SHARE_FILTERS_AND_DASHBOARDS_WITH_ALL_GROUPS_AND_ROLES);
            String filterId = this.createFilter("test");
            long projectId = this.backdoor.project().addProject("Test project", "TP", "fred");
            this.backdoor.projectRole().deleteGroup("TP", "Developers", "jira-developers");
            ProjectRole projectRole = this.backdoor.projectRole().get("TP", "Developers");
            this.assertCreated(this.postPermission(filterId, this.projectRolePermission(projectId, projectRole)));
            List result = (List)this.client.getFilterPermissions((String)filterId).body;
            MatcherAssert.assertThat((Object)result, (Matcher)IsCollectionWithSize.hasSize((int)1));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_SHARE_FILTERS_AND_DASHBOARDS_WITH_ALL_GROUPS_AND_ROLES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cannotShareFilterWithProjectRoleWhenHasAdminPermissionsAndFeatureFlagIsDisabled() {
        try {
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.ADMINS_CAN_SHARE_FILTERS_AND_DASHBOARDS_WITH_ALL_GROUPS_AND_ROLES);
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            String filterId = this.createFilter("test");
            long projectId = this.backdoor.project().addProject("Test project", "TP", "fred");
            this.backdoor.projectRole().deleteGroup("TP", "Developers", "jira-developers");
            ProjectRole projectRole = this.backdoor.projectRole().get("TP", "Developers");
            this.assertBadRequestForPutFilterPermission(filterId, this.projectRolePermission(projectId, projectRole));
            List result = (List)this.client.getFilterPermissions((String)filterId).body;
            MatcherAssert.assertThat((Object)result, (Matcher)IsCollectionWithSize.hasSize((int)0));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_SHARE_FILTERS_AND_DASHBOARDS_WITH_ALL_GROUPS_AND_ROLES);
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void canShareFilterWithProjectRoleIfIsNotAMemberOfProjectRole() {
        try {
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.ADMINS_CAN_SHARE_FILTERS_AND_DASHBOARDS_WITH_ALL_GROUPS_AND_ROLES);
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            this.backdoor.darkFeatures().enableForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            String filterId = this.createFilter("test");
            long projectId = this.backdoor.project().addProject("Test project", "TP", "fred");
            this.backdoor.projectRole().deleteGroup("TP", "Developers", "jira-developers");
            ProjectRole projectRole = this.backdoor.projectRole().get("TP", "Developers");
            ParsedResponse<List<Filter.FilterPermission>> putResponse = this.postPermission(filterId, this.projectRolePermission(projectId, projectRole));
            Assert.assertEquals((long)201L, (long)putResponse.statusCode);
            List result = (List)this.client.getFilterPermissions((String)filterId).body;
            MatcherAssert.assertThat((Object)result, (Matcher)IsCollectionWithSize.hasSize((int)1));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_SHARE_FILTERS_AND_DASHBOARDS_WITH_ALL_GROUPS_AND_ROLES);
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cannotShareFilterWithProjectIfIsNotAMemberOfProjectAndFeatureFlagIsDisabled() {
        try {
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.ADMINS_CAN_SHARE_FILTERS_AND_DASHBOARDS_WITH_ALL_GROUPS_AND_ROLES);
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            this.client.loginAs("admin");
            String filterId = this.createFilter("test");
            long projectId = this.backdoor.project().addProject("Test project", "TP", "admin");
            ParsedResponse<List<Filter.FilterPermission>> putResponseUser = this.postPermission(filterId, new FilterClient.FilterPermissionInputBean("user", null, null, null, "fred", true, true));
            ParsedResponse<List<Filter.FilterPermission>> putResponseProject = this.postPermission(filterId, this.projectPermission(projectId));
            this.client.loginAs("fred");
            this.backdoor.usersAndGroups().addUserToGroup("fred", "jira-developers");
            this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.BROWSE_PROJECTS, "jira-users");
            this.assertBadRequestForPutFilterPermission(filterId, this.projectPermission(projectId));
            List result = (List)this.client.getFilterPermissions((String)filterId).body;
            MatcherAssert.assertThat((Object)result, (Matcher)IsCollectionWithSize.hasSize((int)2));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_SHARE_FILTERS_AND_DASHBOARDS_WITH_ALL_GROUPS_AND_ROLES);
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            this.backdoor.usersAndGroups().removeUserFromGroup("fred", "jira-developers");
            this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.BROWSE_PROJECTS, "jira-users");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void canShareFilterWithProjectIfIsNotAMemberOfProject() {
        try {
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.ADMINS_CAN_SHARE_FILTERS_AND_DASHBOARDS_WITH_ALL_GROUPS_AND_ROLES);
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            this.backdoor.darkFeatures().enableForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            this.client.loginAs("admin");
            String filterId = this.createFilter("test");
            long projectId = this.backdoor.project().addProject("Test project", "TP", "admin");
            ParsedResponse<List<Filter.FilterPermission>> putResponseUser = this.postPermission(filterId, new FilterClient.FilterPermissionInputBean("user", null, null, null, "fred", true, true));
            ParsedResponse<List<Filter.FilterPermission>> putResponseProject = this.postPermission(filterId, this.projectPermission(projectId));
            this.client.loginAs("fred");
            this.backdoor.usersAndGroups().addUserToGroup("fred", "jira-developers");
            this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.BROWSE_PROJECTS, "jira-users");
            ParsedResponse<List<Filter.FilterPermission>> putResponse = this.postPermission(filterId, this.projectPermission(projectId));
            Assert.assertEquals((long)201L, (long)putResponse.statusCode);
            List result = (List)this.client.getFilterPermissions((String)filterId).body;
            MatcherAssert.assertThat((Object)result, (Matcher)IsCollectionWithSize.hasSize((int)2));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_SHARE_FILTERS_AND_DASHBOARDS_WITH_ALL_GROUPS_AND_ROLES);
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            this.backdoor.usersAndGroups().removeUserFromGroup("fred", "jira-developers");
            this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.BROWSE_PROJECTS, "jira-users");
        }
    }

    @Test
    public void invalidAddPermissionBeanResultsIn400() {
        String filterId = this.createFilter("test");
        this.assertBadRequestForPutFilterPermission(filterId, new FilterClient.FilterPermissionInputBean("group", null, null, null, null, true, false));
        this.assertBadRequestForPutFilterPermission(filterId, new FilterClient.FilterPermissionInputBean("project", null, null, null, null, true, false));
        this.assertBadRequestForPutFilterPermission(filterId, new FilterClient.FilterPermissionInputBean("projectRole", null, null, null, null, true, false));
        this.assertBadRequestForPutFilterPermission(filterId, new FilterClient.FilterPermissionInputBean("invalid", null, null, null, null, true, false));
        this.assertBadRequestForPutFilterPermission(filterId, new FilterClient.FilterPermissionInputBean("project-unknown", null, null, null, null, true, false));
        this.assertBadRequestForPutFilterPermission(filterId, new FilterClient.FilterPermissionInputBean("user", null, null, null, null, true, false));
        this.assertBadRequestForPutFilterPermission(filterId, new FilterClient.FilterPermissionInputBean("user", null, null, null, "admin", true, false));
        this.assertBadRequestForPutFilterPermission(filterId, new FilterClient.FilterPermissionInputBean("global", null, null, null, null, true, true));
    }

    private FilterClient.FilterPermissionInputBean projectRolePermission(long projectId, ProjectRole projectRole) {
        return new FilterClient.FilterPermissionInputBean("projectRole", String.valueOf(projectId), projectRole.id.toString(), null, null, true, false);
    }

    private FilterClient.FilterPermissionInputBean projectPermission(long l) {
        return new FilterClient.FilterPermissionInputBean("project", String.valueOf(l), null, null, null, true, false);
    }

    private FilterClient.FilterPermissionInputBean globalPermission() {
        return new FilterClient.FilterPermissionInputBean("global", null, null, null, null, true, false);
    }

    private ParsedResponse<List<Filter.FilterPermission>> postPermission(String filter, FilterClient.FilterPermissionInputBean inputBean) {
        return this.client.postFilterPermission(filter, inputBean);
    }

    private <T> T assertCreated(ParsedResponse<T> response) {
        Assert.assertEquals((long)201L, (long)response.statusCode);
        return (T)response.body;
    }

    private void assertBadRequestForPutFilterPermission(String filterId, FilterClient.FilterPermissionInputBean inputBean) {
        ParsedResponse<List<Filter.FilterPermission>> putResponse = this.postPermission(filterId, inputBean);
        Assert.assertEquals((long)400L, (long)putResponse.statusCode);
    }

    private void assertUnauthorizedResponse(ParsedResponse response) {
        Assert.assertEquals((long)401L, (long)response.statusCode);
    }

    private void assertNotFoundResponse(ParsedResponse response) {
        Assert.assertEquals((long)response.statusCode, (long)404L);
    }

    private Filter.FilterPermission withFilterContainingPermission(String filterId, FilterClient.FilterPermissionInputBean permissionInputBean) {
        List<Filter.FilterPermission> putResult = this.assertCreated(this.postPermission(filterId, permissionInputBean));
        MatcherAssert.assertThat(putResult, (Matcher)IsCollectionWithSize.hasSize((int)1));
        return putResult.get(0);
    }

    private Matcher<? super Filter.FilterPermission> filterPermission(final FilterClient.FilterPermissionInputBean permission) {
        return new TypeSafeMatcher<Filter.FilterPermission>(){

            protected boolean matchesSafely(Filter.FilterPermission item) {
                return Objects.equal((Object)permission.groupname, item.group == null ? null : item.group.getName()) && Objects.equal((Object)permission.projectId, item.project == null ? null : item.project.id) && Objects.equal((Object)permission.projectRoleId, item.role == null ? null : item.role.id.toString()) && Objects.equal((Object)permission.type, (Object)item.type) && Objects.equal((Object)permission.userKey, item.user == null ? null : item.user.key) && Objects.equal((Object)permission.view, (Object)item.view) && Objects.equal((Object)permission.edit, (Object)item.edit);
            }

            public void describeTo(Description description) {
                description.appendValue((Object)permission);
            }
        };
    }

    private String createFilter(String name) {
        Filter filter1 = new Filter();
        filter1.name = name;
        filter1.jql = "project=homosapien";
        filter1.description = "test description";
        filter1.favourite = true;
        ParsedResponse response = this.client.postFilterResponse(filter1, new Filter.Expand[0]);
        return ((Filter)response.body).id;
    }
}

