/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.FunctTestConstants;
import com.atlassian.jira.functest.framework.RestoreDataCenterInstance;
import com.atlassian.jira.functest.framework.backdoor.ColumnControl;
import com.atlassian.jira.functest.framework.backdoor.UserAnonymizeControl;
import com.atlassian.jira.functest.framework.matchers.IterableMatchers;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.atlassian.jira.testkit.client.restclient.Filter;
import com.atlassian.jira.testkit.client.restclient.FilterClient;
import com.atlassian.jira.testkit.client.restclient.Group;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.testkit.client.restclient.ProjectRole;
import com.atlassian.jira.testkit.client.restclient.User;
import com.atlassian.jira.testkit.client.restclient.matcher.ContainsStringThatStartsWith;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.FILTERS})
@RestoreDataCenterInstance(value="TestFilterResource.xml")
public class TestFilterResource
extends BaseJiraRestTest {
    private static final FeatureFlag JQL_FILTER_PRESERVE_USER_INPUT = FeatureFlag.featureFlag((String)JiraFeatureFlagRegistrar.JQL_FILTER_PRESERVE_USER_INPUT.featureKey());
    private FilterClient filterClient;

    @Before
    public void setUpTest() {
        this.filterClient = new FilterClient((JIRAEnvironmentData)this.environmentData);
        this.backdoor.darkFeatures().enableForSite(JQL_FILTER_PRESERVE_USER_INPUT);
    }

    @Test
    public void testAnonymous() {
        this.filterClient.anonymous();
        ParsedResponse response = this.filterClient.getResponse("10000");
        Assert.assertEquals((long)400L, (long)response.statusCode);
        Assert.assertEquals((Object)"The selected filter is not available to you, perhaps it has been deleted or had its permissions changed.", response.entity.errorMessages.get(0));
        Filter json = this.filterClient.get("10002", new Filter.Expand[0]);
        Assert.assertEquals((Object)(this.environmentData.getBaseUrl() + "/rest/api/2/filter/10002"), (Object)json.self);
        Assert.assertEquals((Object)"10002", (Object)json.id);
        Assert.assertEquals((Object)"Public filter", (Object)json.name);
        Assert.assertEquals((Object)"Everyone can see this!", (Object)json.description);
        Assert.assertEquals((Object)"admin", (Object)json.owner.name);
        Assert.assertEquals((Object)"Administrator", (Object)json.owner.displayName);
        Assert.assertEquals((Object)(this.environmentData.getBaseUrl() + "/rest/api/2/user?username=admin"), (Object)json.owner.self);
        Assert.assertEquals((Object)"project = 10000 AND type = bug", (Object)json.jql);
        Assert.assertEquals((Object)this.getBaseUrlPlus("issues/?filter=10002"), (Object)json.viewUrl);
        Assert.assertEquals((Object)(this.environmentData.getBaseUrl() + "/rest/api/2/search?jql=project+%3D+10000+AND+type+%3D+bug"), (Object)json.searchUrl);
        Assert.assertFalse((boolean)json.favourite);
    }

    @Test
    public void testFilterJson() throws Exception {
        Filter json = this.filterClient.get("10000", new Filter.Expand[0]);
        Assert.assertEquals((Object)(this.environmentData.getBaseUrl() + "/rest/api/2/filter/10000"), (Object)json.self);
        Assert.assertEquals((Object)"10000", (Object)json.id);
        Assert.assertEquals((Object)"My new awesome filter!", (Object)json.name);
        Assert.assertEquals((Object)"And here's a description", (Object)json.description);
        Assert.assertEquals((Object)"admin", (Object)json.owner.name);
        Assert.assertEquals((Object)"Administrator", (Object)json.owner.displayName);
        Assert.assertEquals((Object)(this.environmentData.getBaseUrl() + "/rest/api/2/user?username=admin"), (Object)json.owner.self);
        Assert.assertEquals((Object)"type = Bug", (Object)json.jql);
        Assert.assertEquals((Object)this.getBaseUrlPlus("issues/?filter=10000"), (Object)json.viewUrl);
        Assert.assertEquals((Object)this.getBaseUrlPlus("rest/api/2/search?jql=type+%3D+Bug"), (Object)json.searchUrl);
        Assert.assertFalse((boolean)json.favourite);
        json = this.filterClient.get("10001", new Filter.Expand[0]);
        Assert.assertEquals((Object)(this.environmentData.getBaseUrl() + "/rest/api/2/filter/10001"), (Object)json.self);
        Assert.assertEquals((Object)"10001", (Object)json.id);
        Assert.assertEquals((Object)"All Issues", (Object)json.name);
        Assert.assertEquals(null, (Object)json.description);
        Assert.assertEquals((Object)"admin", (Object)json.owner.name);
        Assert.assertEquals((Object)"Administrator", (Object)json.owner.displayName);
        Assert.assertEquals((Object)(this.environmentData.getBaseUrl() + "/rest/api/2/user?username=admin"), (Object)json.owner.self);
        Assert.assertEquals((Object)"", (Object)json.jql);
        Assert.assertEquals((Object)this.getBaseUrlPlus("issues/?filter=10001"), (Object)json.viewUrl);
        Assert.assertEquals((Object)this.getBaseUrlPlus("rest/api/2/search?jql="), (Object)json.searchUrl);
        Assert.assertTrue((boolean)json.favourite);
        this.filterClient.loginAs("bob");
        ParsedResponse response = this.filterClient.getResponse("10000");
        Assert.assertEquals((long)400L, (long)response.statusCode);
        Assert.assertEquals((Object)"The selected filter is not available to you, perhaps it has been deleted or had its permissions changed.", response.entity.errorMessages.get(0));
        json = this.filterClient.get("10002", new Filter.Expand[0]);
        Assert.assertEquals((Object)(this.environmentData.getBaseUrl() + "/rest/api/2/filter/10002"), (Object)json.self);
        Assert.assertEquals((Object)"10002", (Object)json.id);
        Assert.assertEquals((Object)"Public filter", (Object)json.name);
        Assert.assertEquals((Object)"Everyone can see this!", (Object)json.description);
        Assert.assertEquals((Object)"admin", (Object)json.owner.name);
        Assert.assertEquals((Object)"Administrator", (Object)json.owner.displayName);
        Assert.assertEquals((Object)(this.environmentData.getBaseUrl() + "/rest/api/2/user?username=admin"), (Object)json.owner.self);
        Assert.assertEquals((Object)"project = homosapien and type = bug", (Object)json.jql);
        Assert.assertEquals((Object)this.getBaseUrlPlus("issues/?filter=10002"), (Object)json.viewUrl);
        Assert.assertEquals((Object)this.getBaseUrlPlus("rest/api/2/search?jql=project+%3D+homosapien+and+type+%3D+bug"), (Object)json.searchUrl);
        Assert.assertTrue((boolean)json.favourite);
        json = this.filterClient.get("10003", new Filter.Expand[0]);
        Assert.assertEquals((Object)(this.environmentData.getBaseUrl() + "/rest/api/2/filter/10003"), (Object)json.self);
        Assert.assertEquals((Object)"10003", (Object)json.id);
        Assert.assertEquals((Object)"This is bob's filter!", (Object)json.name);
        Assert.assertEquals(null, (Object)json.description);
        Assert.assertEquals((Object)"bob", (Object)json.owner.name);
        Assert.assertEquals((Object)"Bob Brown", (Object)json.owner.displayName);
        Assert.assertEquals((Object)(this.environmentData.getBaseUrl() + "/rest/api/2/user?username=bob"), (Object)json.owner.self);
        Assert.assertEquals((Object)"text ~ \"some fancy text\"", (Object)json.jql);
        Assert.assertEquals((Object)this.getBaseUrlPlus("issues/?filter=10003"), (Object)json.viewUrl);
        Assert.assertEquals((Object)this.getBaseUrlPlus("rest/api/2/search?jql=text+~+%22some+fancy+text%22"), (Object)json.searchUrl);
    }

    @Test
    public void bobCanAccessFilterSharedWithHimOwnedByAdmin() {
        String filterId = this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "shared with bob", "", "[{\"type\":\"user\", \"param1\":\"bob\", \"rights\": {\"value\": 3}}]");
        this.filterClient.loginAs("bob");
        Filter json = this.filterClient.get(filterId, new Filter.Expand[0]);
        Assert.assertEquals((Object)"shared with bob", (Object)json.name);
        Assert.assertTrue((boolean)json.editable);
    }

    @Test
    public void fredCanNotAccessFilterSharedWithBobOwnedByAdmin() {
        String filterId = this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "shared with bob", "", "[{\"type\":\"user\", \"param1\":\"bob\" ,\"rights\": {\"value\": 3}}]");
        this.filterClient.loginAs("fred");
        ParsedResponse response = this.filterClient.getResponse(filterId);
        Assert.assertEquals((long)400L, (long)response.statusCode);
    }

    @Test
    public void adminCanEditFilterCreatedByHimSharedWithBob() {
        String filterId = this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "shared with bob", "", "[{\"type\":\"user\", \"param1\":\"bob\", \"rights\": {\"value\": 3}}]");
        this.filterClient.loginAs("admin");
        Filter json = this.filterClient.get(filterId, new Filter.Expand[0]);
        Assert.assertTrue((boolean)json.editable);
    }

    @Test
    public void adminCanEditFilterCreatedByHimWhichIsPrivate() {
        String filterId = this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "private", "", "");
        this.filterClient.loginAs("admin");
        Filter json = this.filterClient.get(filterId, new Filter.Expand[0]);
        Assert.assertTrue((boolean)json.editable);
    }

    @Test
    public void bobCanEditFilterCreatedByAdminAndSharedWithHimWithEditRights() {
        String filterId = this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "shared with bob with edit Rights", "", "[{\"type\":\"user\", \"param1\":\"bob\", \"rights\": {\"value\": 3}}]");
        this.filterClient.loginAs("bob");
        Filter json = this.filterClient.get(filterId, new Filter.Expand[0]);
        Assert.assertTrue((boolean)json.editable);
    }

    @Test
    public void fredCanEditFilterCreatedByAdminAndSharedWithGroupWithEditRights() {
        String filterId = this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "shared jira-brows-users with edit rights", "", "[{\"type\":\"group\", \"param1\":\"jira-brows-users\", \"rights\": {\"value\": 3}},{\"type\":\"group\", \"param1\":\"jira-users\"}]");
        this.filterClient.loginAs("fred");
        Filter json = this.filterClient.get(filterId, new Filter.Expand[0]);
        Assert.assertTrue((boolean)json.editable);
    }

    @Test
    public void bobCannotEditFilterCreatedByAdmin() {
        String filterId = this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "shared jira-brows-users with edit rights", "", "[{\"type\":\"group\", \"param1\":\"jira-administrators\", \"rights\": {\"value\": 3}},{\"type\":\"group\", \"param1\":\"jira-users\"}]");
        this.filterClient.loginAs("bob");
        Filter json = this.filterClient.get(filterId, new Filter.Expand[0]);
        Assert.assertFalse((boolean)json.editable);
    }

    @Test
    public void inactiveUserCanBeAddedAsEditor() {
        this.backdoor.userManager().setActive("bob", false);
        String filterId = this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "shared with inactiveUser with edit Rights", "", "[{\"type\":\"user\", \"param1\":\"bob\", \"rights\": {\"value\": 3}}]");
        this.filterClient.loginAs("admin");
        Matcher<Iterable<String>> matcher = IterableMatchers.hasItems(String.class, "bob");
        this.assertSharedUsers(filterId, matcher);
        this.backdoor.userManager().setActive("bob", true);
        this.filterClient.loginAs("bob");
        Filter json = this.filterClient.get(filterId, new Filter.Expand[]{Filter.Expand.sharedUsers});
        Assert.assertTrue((boolean)json.editable);
    }

    @Test
    public void bobCanEditHisFilterByChangingJQL() {
        String filterId = this.backdoor.searchRequests().createFilter("bob", "assignee=currentUser()", "created by bob", "", "");
        this.filterClient.loginAs("bob");
        Filter editedFilter = this.filterClient.get(filterId, new Filter.Expand[0]);
        editedFilter.name = "renamed by bob";
        editedFilter.jql = "";
        ParsedResponse response = this.filterClient.putFilterResponse(editedFilter, new Filter.Expand[0]);
        this.assertFilterEqual(editedFilter, (Filter)response.body);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.statusCode);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=712001)
    public void bobCanEditFilterByChangingJQLCreatedByAdminAndSharedWithHimWithEditRights() {
        String filterId = this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "shared with bob with edit Rights", "", "[{\"type\":\"user\", \"param1\":\"bob\", \"rights\": {\"value\": 3}}]");
        this.filterClient.loginAs("bob");
        Filter editedFilter = this.filterClient.get(filterId, new Filter.Expand[0]);
        editedFilter.name = "named by bob";
        editedFilter.jql = "";
        ParsedResponse response = this.filterClient.putFilterResponse(editedFilter, new Filter.Expand[0]);
        this.assertFilterCreateEquals(editedFilter, (Filter)response.body);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.statusCode);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=9100000)
    public void bobCannotChangeOwnerOfHisOwnFilter() {
        String filterId = this.backdoor.searchRequests().createFilter("bob", "assignee=currentUser()", "created by bob", "", "");
        this.filterClient.loginAs("bob");
        Filter editedFilter = this.filterClient.get(filterId, new Filter.Expand[0]);
        editedFilter.owner = new User().name("fred");
        ParsedResponse response = this.filterClient.putFilterResponse(editedFilter, new Filter.Expand[0]);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
        MatcherAssert.assertThat(response.entity.errorMessages.get(0), (Matcher)Matchers.equalTo((Object)"You must be an administrator to change filter ownership."));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=9100000)
    public void bobCannotChangeOwnerOfAdminsFilterSharedWithHimWithEditRights() {
        String filterId = this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "shared with bob with edit Rights", "", "[{\"type\":\"user\", \"param1\":\"bob\", \"rights\": {\"value\": 3}}]");
        this.filterClient.loginAs("bob");
        Filter editedFilter = this.filterClient.get(filterId, new Filter.Expand[0]);
        editedFilter.owner = new User().name("bob");
        ParsedResponse response = this.filterClient.putFilterResponse(editedFilter, new Filter.Expand[0]);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
        MatcherAssert.assertThat(response.entity.errorMessages.get(0), (Matcher)Matchers.equalTo((Object)"You must be an administrator to change filter ownership."));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=9100000)
    public void adminCanModifyOwnerOfPrivateFilterOfAnActiveUser() {
        this.adminCanModifyOwnerOfFredsPrivateFilter(() -> {});
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=9100000)
    public void adminCanModifyOwnerOfPrivateFilterOfAnInactiveUser() {
        this.adminCanModifyOwnerOfFredsPrivateFilter(() -> this.backdoor.userManager().setActive("fred", false));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=9100000)
    public void adminCanModifyOwnerOfPrivateFilterOfAnAnonymisedUser() {
        this.adminCanModifyOwnerOfFredsPrivateFilter(() -> new UserAnonymizeControl(this.environmentData).anonymize("fred"));
    }

    private void adminCanModifyOwnerOfFredsPrivateFilter(Runnable userOperation) {
        String filterId = this.backdoor.searchRequests().createFilter("fred", "assignee=currentUser()", "Fred's private filter", null);
        userOperation.run();
        Filter filter = this.filterClient.get(filterId, new Filter.Expand[0]);
        Assert.assertTrue((boolean)filter.editable);
        filter.owner = new User().name("bob");
        filter.name = filter.name + " given to Bob";
        ParsedResponse response = this.filterClient.putFilterResponse(filter, new Filter.Expand[0]);
        this.assertFilterEqual(filter, (Filter)response.body);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.statusCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void adminCantModifyPrivateFilterOfAnotherUserWithFfDisabled() {
        try {
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            String filterId = this.backdoor.searchRequests().createFilter("fred", "assignee=currentUser()", "Fred's private filter", null);
            WebApplicationException exception = (WebApplicationException)Assertions.assertThrows(WebApplicationException.class, () -> this.filterClient.get(filterId, new Filter.Expand[0]));
            MatcherAssert.assertThat((Object)exception.getResponse().getStatus(), (Matcher)Matchers.equalTo((Object)400));
            Filter filter = this.filterClient.get("10000", new Filter.Expand[0]);
            filter.id = filterId;
            ParsedResponse response = this.filterClient.putFilterResponse(filter, new Filter.Expand[0]);
            MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
            MatcherAssert.assertThat(response.entity.errorMessages.get(0), (Matcher)Matchers.equalTo((Object)"The selected filter is not available to you, perhaps it has been deleted or had its permissions changed."));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=811000)
    public void adminCanModifyPrivateFilterOfAnotherUser() {
        String filterId = this.backdoor.searchRequests().createFilter("fred", "assignee=currentUser()", "Fred's private filter", null);
        Filter filter = this.filterClient.get(filterId, new Filter.Expand[0]);
        Assert.assertTrue((boolean)filter.editable);
        filter = this.filterClient.get("10000", new Filter.Expand[0]);
        filter.id = filterId;
        ParsedResponse response = this.filterClient.putFilterResponse(filter, new Filter.Expand[0]);
        this.assertFilterCreateEquals(filter, (Filter)response.body);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testGetFavouriteFilters() {
        this.filterClient.anonymous();
        List filters = this.filterClient.getFavouriteFilters(new Filter.Expand[0]);
        MatcherAssert.assertThat((Object)filters, (Matcher)Matchers.empty());
        this.filterClient.loginAs("admin");
        List favouriteFilters = this.filterClient.getFavouriteFilters(new Filter.Expand[0]);
        MatcherAssert.assertThat((Object)favouriteFilters, (Matcher)Matchers.contains((Matcher[])new Matcher[]{this.filterWithId("10001"), this.filterWithId("10100"), this.filterWithId("10002")}));
    }

    @Test
    public void testCreateBasicFavoriteFilterWorks() {
        Filter expected = this.basicFilter("test", "project = homosapien", true);
        ParsedResponse response = this.filterClient.postFilterResponse(expected, new Filter.Expand[0]);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.statusCode);
        this.assertFilterCreateEquals(expected, (Filter)response.body);
    }

    @Test
    public void testCreateNotFavoriteFilterWorks() {
        Filter expected = this.basicFilter("test2", "project = homosapien", false);
        ParsedResponse response = this.filterClient.postFilterResponse(expected, new Filter.Expand[0]);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.statusCode);
        this.assertFilterCreateEquals(expected, (Filter)response.body);
    }

    @Test
    public void testCreateFilterWithBadJqlReturns400() {
        Filter filter1 = this.basicFilter("test3", "a=", true);
        ParsedResponse response = this.filterClient.postFilterResponse(filter1, new Filter.Expand[0]);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        MatcherAssert.assertThat((Object)response.entity.errorMessages, (Matcher)ContainsStringThatStartsWith.containsStringThatStartsWith((String)"Error in JQL Query:"));
    }

    @Test
    public void testCreateFilterWithBadJql2Returns400() {
        Filter filter1 = this.basicFilter("test3.1", "1234", true);
        ParsedResponse response = this.filterClient.postFilterResponse(filter1, new Filter.Expand[0]);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        MatcherAssert.assertThat((Object)response.entity.errorMessages, (Matcher)ContainsStringThatStartsWith.containsStringThatStartsWith((String)"Error in the JQL Query:"));
    }

    @Test
    public void testCreateFilterWithEmptyJqlWorks() {
        Filter filter1 = this.basicFilter("test4", "", true);
        ParsedResponse response = this.filterClient.postFilterResponse(filter1, new Filter.Expand[0]);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.statusCode);
        this.assertFilterCreateEquals(filter1, (Filter)response.body);
    }

    @Test
    public void testCreateFilterWithEmptNameReturns400() {
        Filter filter1 = this.basicFilter("", "project=homosapien", true);
        ParsedResponse response = this.filterClient.postFilterResponse(filter1, new Filter.Expand[0]);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        Assert.assertEquals((Object)"You must specify a name to save this filter as.", response.entity.errors.get("filterName"));
    }

    @Test
    public void testCreateFilterWithEmptyNameAndBadJqlReturns400With2Errors() {
        Filter filter1 = this.basicFilter("", "project=", true);
        ParsedResponse response = this.filterClient.postFilterResponse(filter1, new Filter.Expand[0]);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        Assert.assertEquals((long)2L, (long)(response.entity.errorMessages.size() + response.entity.errors.size()));
        Assert.assertEquals((Object)"You must specify a name to save this filter as.", response.entity.errors.get("filterName"));
        MatcherAssert.assertThat((Object)response.entity.errorMessages, (Matcher)ContainsStringThatStartsWith.containsStringThatStartsWith((String)"Error in JQL Query:"));
    }

    @Test
    public void testCreateFilterWithTooLongNameReturns400() {
        String tooLongName = "ehdWvkq23yifp2xxXUd1xJcaUM9U2i4U7SUTlKQE1vHw3J8VY03sfkKjvNje6pqqHH69HlUwpO3gbJh5uujOZP00OHH06YxhX8NcTvpjWYzE2qQDa9Ji6MhoZ0kjYA1GmEd7MMAa88s9PJX01Hxtmfg5WiYeDFviROgNX1xy2WeeywetM4jKNuwJV3AFJnzxMcT0wjFi1xWknNicdq9G9qp7SUTm6b6MfOS5XU63MKWmI6RisTIOgAjnFeqEjp4SnzdB";
        Filter filter1 = this.basicFilter(tooLongName, "project = homosapien", true);
        ParsedResponse response = this.filterClient.postFilterResponse(filter1, new Filter.Expand[0]);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        Assert.assertEquals((long)1L, (long)(response.entity.errorMessages.size() + response.entity.errors.size()));
        Assert.assertEquals((Object)"The entered filter name is too long, it must be less than 255 chars.", response.entity.errors.get("filterName"));
    }

    @Test
    public void testCreateFilterWithExistingNameReturns400() {
        Filter filter1 = this.basicFilter("test", "project = homosapien", true);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)this.filterClient.postFilterResponse((Filter)filter1, (Filter.Expand[])new Filter.Expand[0]).statusCode);
        ParsedResponse response = this.filterClient.postFilterResponse(filter1, new Filter.Expand[0]);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        Assert.assertEquals((long)1L, (long)(response.entity.errorMessages.size() + response.entity.errors.size()));
        Assert.assertEquals((Object)"Filter with same name already exists.", response.entity.errors.get("filterName"));
    }

    @Test
    public void testCreateFilterChecksQueryValidation() {
        Filter filter1 = this.basicFilter("test5", "a=b", true);
        ParsedResponse response = this.filterClient.postFilterResponse(filter1, new Filter.Expand[0]);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        Assert.assertEquals((long)1L, (long)(response.entity.errorMessages.size() + response.entity.errors.size()));
        Assert.assertEquals((Object)"Field 'a' does not exist or you do not have permission to view it.", response.entity.errorMessages.get(0));
    }

    @Test
    public void testCreateFilterForAnonymousAndBadJqlReturns401() {
        Filter filter1 = this.basicFilter("asdf", "project=homosapien", true);
        this.filterClient.anonymous();
        ParsedResponse response = this.filterClient.postFilterResponse(filter1, new Filter.Expand[0]);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        Assert.assertEquals((Object)"You are not authenticated. Authentication required to perform this operation.", response.entity.errorMessages.get(0));
    }

    @Test
    public void testCreateFilterChecksUserPermissions() {
        this.filterClient.loginAs("admin");
        Filter filter1 = this.basicFilter("test6", "project = homosapien", true);
        String newFilterId = ((Filter)this.filterClient.postFilterResponse((Filter)filter1, (Filter.Expand[])new Filter.Expand[0]).body).id;
        this.filterClient.loginAs("fred");
        ParsedResponse response = this.filterClient.getResponse(newFilterId);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        MatcherAssert.assertThat((Object)response.entity.errorMessages, (Matcher)ContainsStringThatStartsWith.containsStringThatStartsWith((String)"The selected filter is not available to you"));
    }

    @Test
    public void testAdminCannotCreateFilterOwnedByAnotherUser() {
        this.testUserCannotCreateFilterOwnedByAnotherUser("admin");
    }

    @Test
    public void testBobCannotCreateFilterOwnedByAnotherUser() {
        this.testUserCannotCreateFilterOwnedByAnotherUser("bob");
    }

    private void testUserCannotCreateFilterOwnedByAnotherUser(String loggedInUser) {
        Filter filter1 = this.basicFilter("testCannotCreateFilterOwnedByAnotherUser", "", false);
        filter1.owner = new User().name("fred");
        this.filterClient.loginAs(loggedInUser);
        ParsedResponse response = this.filterClient.postFilterResponse(filter1, new Filter.Expand[0]);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        Assert.assertEquals((long)1L, (long)(response.entity.errorMessages.size() + response.entity.errors.size()));
        Assert.assertEquals((Object)"You may only create, modify or delete filters that you own.", response.entity.errorMessages.get(0));
    }

    @Test
    public void testCopyFilter() {
        this.backdoor.darkFeatures().disableForSite(JQL_FILTER_PRESERVE_USER_INPUT);
        this.filterClient.loginAs("admin");
        Filter filter = new Filter();
        filter.id = "10100";
        filter.name = "blah clone";
        filter.description = "blah description";
        ParsedResponse response = this.filterClient.postFilterResponse(filter, new Filter.Expand[0]);
        Assert.assertEquals((Object)"", (Object)((Filter)response.body).jql);
        Assert.assertEquals((Object)"blah clone", (Object)((Filter)response.body).name);
        Assert.assertEquals((Object)"blah description", (Object)((Filter)response.body).description);
        Assert.assertEquals((String)"Expected the filters column config to also be copied", (Object)Lists.newArrayList((Object[])new String[]{"issuetype", "issuekey", "assignee", "reporter", "priority", "status", "resolution", "created", "updated", "duedate"}), this.backdoor.filters().getColumnsForFilter(((Filter)response.body).id));
        this.filterClient.loginAs("admin");
        filter = new Filter();
        filter.id = "10100";
        filter.name = "only clone columns";
        filter.jql = "project in (HSP, MKY)";
        response = this.filterClient.postFilterResponse(filter, new Filter.Expand[0]);
        Assert.assertEquals((Object)"only clone columns", (Object)((Filter)response.body).name);
        Assert.assertEquals((Object)"project in (HSP, MKY)", (Object)((Filter)response.body).jql);
        Assert.assertEquals((String)"Expected the filters column config to also be copied", (Object)Lists.newArrayList((Object[])new String[]{"issuetype", "issuekey", "assignee", "reporter", "priority", "status", "resolution", "created", "updated", "duedate"}), this.backdoor.filters().getColumnsForFilter(((Filter)response.body).id));
        filter = new Filter();
        filter.id = "10002";
        filter.name = "@Test public filter clone";
        response = this.filterClient.postFilterResponse(filter, new Filter.Expand[0]);
        Assert.assertEquals((Object)"project = homosapien AND type = bug", (Object)((Filter)response.body).jql);
        Assert.assertTrue((String)"Expected a different id as we cloned the filter", (!((Filter)response.body).id.equals(filter.id) ? 1 : 0) != 0);
        Assert.assertEquals((Object)"@Test public filter clone", (Object)((Filter)response.body).name);
        String privateFilterId = ((Filter)response.body).id;
        Assert.assertEquals((String)"Expected the user column config", (Object)Lists.newArrayList((Object[])new String[]{"issuetype", "issuekey", "summary", "assignee", "reporter", "priority", "status", "resolution", "created", "updated", "duedate"}), this.backdoor.filters().getColumnsForFilter(privateFilterId));
        filter = new Filter();
        filter.id = "1001322";
        filter.name = "@Test public filter clone";
        response = this.filterClient.postFilterResponse(filter, new Filter.Expand[0]);
        Assert.assertEquals((String)"Invalid filter id should not throw server error", (long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        MatcherAssert.assertThat((Object)response.entity.errorMessages, (Matcher)ContainsStringThatStartsWith.containsStringThatStartsWith((String)"The selected filter is not available to you"));
        this.filterClient.loginAs("fred");
        filter = new Filter();
        filter.id = privateFilterId;
        filter.name = "@Test public filter clone";
        response = this.filterClient.postFilterResponse(filter, new Filter.Expand[0]);
        Assert.assertEquals((String)"Private filter id should not throw server error", (long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        MatcherAssert.assertThat((Object)response.entity.errorMessages, (Matcher)ContainsStringThatStartsWith.containsStringThatStartsWith((String)"The selected filter is not available to you"));
    }

    @Test
    public void testUpdateFilter() {
        String filterId = "10000";
        Filter filter = this.filterClient.get(filterId, new Filter.Expand[0]);
        filter.name = "New Filter Name";
        filter.description = "New Filter Description";
        filter.jql = "project = MKY";
        ParsedResponse putResponse = this.filterClient.putFilterResponse(filter, new Filter.Expand[0]);
        Assert.assertNotNull((Object)putResponse);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)putResponse.statusCode);
        this.assertFilterEqual(filter, (Filter)putResponse.body);
        filter.name = "new name";
        filter.jql = null;
        filter.description = null;
        putResponse = this.filterClient.putFilterResponse(filter, new Filter.Expand[0]);
        Assert.assertNotNull((Object)putResponse);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)putResponse.statusCode);
        filter.description = "New Filter Description";
        filter.jql = "project = MKY";
        this.assertFilterEqual(filter, (Filter)putResponse.body);
        filter.name = null;
        filter.jql = null;
        filter.description = "new description";
        putResponse = this.filterClient.putFilterResponse(filter, new Filter.Expand[0]);
        Assert.assertNotNull((Object)putResponse);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)putResponse.statusCode);
        filter.jql = "project = MKY";
        filter.name = "new name";
        this.assertFilterEqual(filter, (Filter)putResponse.body);
        filter.name = null;
        filter.jql = "project = HSP";
        filter.description = null;
        putResponse = this.filterClient.putFilterResponse(filter, new Filter.Expand[0]);
        Assert.assertNotNull((Object)putResponse);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)putResponse.statusCode);
        filter.name = "new name";
        filter.description = "new description";
        this.assertFilterEqual(filter, (Filter)putResponse.body);
        filter.name = "New Filter Name";
        filter.description = "New Filter Description";
        filter.jql = "invalid JQL";
        putResponse = this.filterClient.putFilterResponse(filter, new Filter.Expand[0]);
        Assert.assertNotNull((Object)putResponse);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)putResponse.statusCode);
        MatcherAssert.assertThat((Object)putResponse.entity.errorMessages, (Matcher)ContainsStringThatStartsWith.containsStringThatStartsWith((String)"Error in the JQL Query: Expecting operator but got"));
        filter.jql = "";
        putResponse = this.filterClient.putFilterResponse(filter, new Filter.Expand[0]);
        Assert.assertNotNull((Object)putResponse);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)putResponse.statusCode);
        this.assertFilterEqual(filter, (Filter)putResponse.body);
        filter.name = "";
        putResponse = this.filterClient.putFilterResponse(filter, new Filter.Expand[0]);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)putResponse.statusCode);
        Assert.assertEquals((Object)"You must specify a name to save this filter as.", putResponse.entity.errors.get("filterName"));
        filter.jql = "project=homosapien";
        filter.name = "ehdWvkq23yifp2xxXUd1xJcaUM9U2i4U7SUTlKQE1vHw3J8VY03sfkKjvNje6pqqHH69HlUwpO3gbJh5uujOZP00OHH06YxhX8NcTvpjWYzE2qQDa9Ji6MhoZ0kjYA1GmEd7MMAa88s9PJX01Hxtmfg5WiYeDFviROgNX1xy2WeeywetM4jKNuwJV3AFJnzxMcT0wjFi1xWknNicdq9G9qp7SUTm6b6MfOS5XU63MKWmI6RisTIOgAjnFeqEjp4SnzdB";
        putResponse = this.filterClient.putFilterResponse(filter, new Filter.Expand[0]);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)putResponse.statusCode);
        Assert.assertEquals((long)1L, (long)(putResponse.entity.errorMessages.size() + putResponse.entity.errors.size()));
        Assert.assertEquals((Object)"The entered filter name is too long, it must be less than 255 chars.", putResponse.entity.errors.get("filterName"));
        filter.jql = "project=homosapien";
        filter.name = "All Issues";
        putResponse = this.filterClient.putFilterResponse(filter, new Filter.Expand[0]);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)putResponse.statusCode);
        Assert.assertEquals((long)1L, (long)(putResponse.entity.errorMessages.size() + putResponse.entity.errors.size()));
        Assert.assertEquals((Object)"Filter with same name already exists.", putResponse.entity.errors.get("filterName"));
        filter.name = "test5";
        filter.jql = "a=b";
        filter.description = "test description";
        filter.favourite = true;
        putResponse = this.filterClient.putFilterResponse(filter, new Filter.Expand[0]);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)putResponse.statusCode);
        Assert.assertEquals((long)1L, (long)(putResponse.entity.errorMessages.size() + putResponse.entity.errors.size()));
        Assert.assertEquals((Object)"Field 'a' does not exist or you do not have permission to view it.", putResponse.entity.errorMessages.get(0));
        this.filterClient.anonymous();
        filter.jql = "asd";
        filter.name = "";
        putResponse = this.filterClient.putFilterResponse(filter, new Filter.Expand[0]);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)putResponse.statusCode);
        Assert.assertEquals((Object)"You are not authenticated. Authentication required to perform this operation.", putResponse.entity.errorMessages.get(0));
        this.filterClient.loginAs("admin");
        filter.name = "test6";
        filter.jql = "project=homosapien";
        filter.description = "test description";
        filter.favourite = true;
        String newFilterId = ((Filter)this.filterClient.putFilterResponse((Filter)filter, (Filter.Expand[])new Filter.Expand[0]).body).id;
        this.filterClient.loginAs("fred");
        putResponse = this.filterClient.getResponse(newFilterId);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)putResponse.statusCode);
        MatcherAssert.assertThat((Object)putResponse.entity.errorMessages, (Matcher)ContainsStringThatStartsWith.containsStringThatStartsWith((String)"The selected filter is not available to you"));
        this.filterClient.loginAs("admin");
        filter.id = "bad";
        filter.jql = "asd";
        filter.name = "";
        putResponse = this.filterClient.putFilterResponse(filter, new Filter.Expand[0]);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)putResponse.statusCode);
    }

    @Test
    public void testSharePermissions() {
        this.runSinglePermission(this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "globes", "", "[{\"type\":\"global\"}]"), new Filter.FilterPermission().type("global").view(true));
        this.runSinglePermission(this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "projes", "", "[{\"type\":\"project\", \"param1\":\"10000\"}]"), new Filter.FilterPermission().type("project").project(new Project().id("10000")).view(true));
        this.runSinglePermission(this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "projes", "", "[{\"type\":\"user\", \"param1\":\"bob\",\"rights\": {\"value\": 3}}]"), new Filter.FilterPermission().type("user").user(new User().name("bob").key("bob")).view(true).edit(true));
        this.runSinglePermission(this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "projes roles", "", "[{\"type\":\"project\", \"param1\":\"10000\", \"param2\":\"10000\"}]"), new Filter.FilterPermission().type("project").project(new Project().id("10000")).role(new ProjectRole().id(Long.valueOf(10000L))).view(true));
        this.runSinglePermission(this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "projes roles", "", "[{\"type\":\"group\", \"param1\":\"jira-administrators\"}]"), new Filter.FilterPermission().type("group").group(new Group("jira-administrators")).view(true));
        this.runMultiplePermission(this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "multiman", "", "[{\"type\":\"project\", \"param1\":\"10000\", \"param2\":\"10000\"}, {\"type\":\"group\", \"param1\":\"jira-administrators\"}]"), new Filter.FilterPermission().type("group").group(new Group("jira-administrators")).view(true), new Filter.FilterPermission().type("project").project(new Project().id("10000")).role(new ProjectRole().id(Long.valueOf(10000L))).view(true));
        String filterId = this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "multi-openproject", "", "[{\"type\":\"project\", \"param1\":\"10000\"}, {\"type\":\"group\", \"param1\":\"jira-users\"}]");
        this.filterClient.loginAs("fred");
        this.runMultiplePermission(filterId, new Filter.FilterPermission().type("project-unknown").view(true), new Filter.FilterPermission().type("group").group(new Group("jira-users")).view(true));
        this.filterClient.loginAs("admin");
        this.runMultiplePermission(filterId, new Filter.FilterPermission().type("group").group(new Group("jira-users")).view(true), new Filter.FilterPermission().type("project").project(new Project().id("10000")).view(true));
    }

    @Test(expected=WebApplicationException.class)
    public void testGlobalUsageInEditContextThrowsAnError() {
        this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "globes", "", "[{\"type\":\"global\", \"rights\": {\"value\": 3}}]");
    }

    @Test
    public void testGlobalUsageInViewContextIsOK() {
        this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "globes", "", "[{\"type\":\"global\", \"rights\": {\"value\": 1}}]");
    }

    @Test(expected=WebApplicationException.class)
    public void testAuthenticatedUsageInEditContextThrowsAnError() {
        this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "loggedIn", "", "[{\"type\":\"loggedin\", \"rights\": {\"value\": 3}}]");
    }

    @Test
    public void testLoggedInlUsageInViewContextIsOK() {
        this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "loggedIn", "", "[{\"type\":\"global\", \"rights\": {\"value\": 1}}]");
    }

    @Test
    public void testGroupUsageInEditContextIsOK() {
        this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "group", "", "[{\"type\":\"group\", \"param1\":\"jira-administrators\", \"rights\": {\"value\": 3}}]");
    }

    @Test
    public void testGroupUsageInViewContextIsOK() {
        this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "group", "", "[{\"type\":\"group\", \"param1\":\"jira-administrators\", \"rights\": {\"value\": 1}}]");
    }

    @Test
    public void testProjectUsageInEditContextIsOK() {
        this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "project", "", "[{\"type\":\"project\", \"param1\":\"10000\", \"rights\": {\"value\": 3}}]");
    }

    @Test
    public void testProjectUsageInViewContextIsOK() {
        this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "project", "", "[{\"type\":\"project\", \"param1\":\"10000\", \"rights\": {\"value\": 1}}]");
    }

    @Test
    public void testUserUsageInEditContextIsOK() {
        this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "user", "", "[{\"type\":\"user\", \"param1\":\"bob\", \"rights\": {\"value\": 3}}]");
    }

    @Test(expected=WebApplicationException.class)
    public void testUserUsageInViewContextThrowsError() {
        this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "group", "", "[{\"type\":\"user\", \"param1\":\"bob\", \"rights\": {\"value\": 1}}]");
    }

    @Test
    public void testFilterSubscriptions() {
        this.filterClient.loginAs("admin");
        String filterId = this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "filter with subs", "", "[{\"type\":\"project\", \"param1\":\"10000\", \"param2\":\"10000\"}, {\"type\":\"group\", \"param1\":\"jira-administrators\"}]");
        this.backdoor.filterSubscriptions().addSubscription(Long.valueOf(filterId), "jira-administrators", "0 0 0 ? 1 MON#3", false);
        Filter filter = this.filterClient.get(filterId, new Filter.Expand[]{Filter.Expand.subscriptions});
        Assert.assertEquals((long)1L, (long)filter.subscriptions.size);
        Assert.assertEquals((Object)"admin", (Object)((Filter.FilterSubscription)filter.subscriptions.items.get((int)0)).user.name);
        Assert.assertEquals((Object)"jira-administrators", (Object)((Filter.FilterSubscription)filter.subscriptions.items.get((int)0)).group.name());
        this.backdoor.filterSubscriptions().addSubscription(Long.valueOf(filterId), null, "0 0 0 ? 1 MON#3", false);
        filter = this.filterClient.get(filterId, new Filter.Expand[]{Filter.Expand.subscriptions});
        Assert.assertEquals((long)2L, (long)filter.subscriptions.size);
        Assert.assertEquals((Object)"admin", (Object)((Filter.FilterSubscription)filter.subscriptions.items.get((int)1)).user.name);
        Assert.assertNull((Object)((Filter.FilterSubscription)filter.subscriptions.items.get((int)1)).group);
    }

    @Test
    public void testSharedUsersWithGroup() {
        String filterId = this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "shared with group", "", "[{\"type\":\"group\", \"param1\":\"jira-administrators\"}]");
        Matcher<Iterable<String>> matcher = IterableMatchers.hasItems(String.class, "admin");
        this.assertSharedUsers(filterId, matcher);
    }

    @Test
    public void testSharedUsersGlobal() {
        String filterId = this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "shared with global", "", "[{\"type\":\"global\"}]");
        Matcher<Iterable<String>> matcher = IterableMatchers.hasItems(String.class, "admin", "bob", "fred");
        this.assertSharedUsers(filterId, matcher);
    }

    @Test
    public void testSharedUsersWithRole() {
        String filterId = this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "shared with role", "", "[{\"type\":\"project\", \"param1\":\"10000\", \"param2\":\"10000\"}]");
        Matcher<Iterable<String>> matcher = IterableMatchers.hasItems(String.class, "admin", "bob", "fred");
        this.assertSharedUsers(filterId, matcher);
    }

    @Test
    public void testSharedUsersWithProject() {
        String filterId = this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "shared with project", "", "[{\"type\":\"project\", \"param1\":\"10000\"}]");
        Matcher<Iterable<String>> matcher = IterableMatchers.hasItems(String.class, "admin", "bob");
        this.assertSharedUsers(filterId, matcher);
    }

    @Test
    public void testSharedUsersWithUser() {
        String filterId = this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "shared with user", "", "[{\"type\":\"user\", \"param1\":\"bob\", \"rights\": {\"value\": 3}}]");
        Matcher<Iterable<String>> matcher = IterableMatchers.hasItems(String.class, "bob");
        this.assertSharedUsers(filterId, matcher);
    }

    @Test
    public void testSharedUsersHaveSizeOnlyWhenExpanded() {
        String filterId = this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "shared with global", "", "[{\"type\":\"global\"}]");
        Assert.assertEquals((long)0L, (long)this.filterClient.get((String)filterId, (Filter.Expand[])new Filter.Expand[0]).sharedUsers.size);
        Assert.assertEquals((long)0L, (long)this.filterClient.get((String)filterId, (Filter.Expand[])new Filter.Expand[0]).sharedUsers.items.size());
        Assert.assertEquals((long)3L, (long)this.filterClient.get((String)filterId, (Filter.Expand[])new Filter.Expand[]{Filter.Expand.sharedUsers}).sharedUsers.size);
        Assert.assertEquals((long)3L, (long)this.filterClient.get((String)filterId, (Filter.Expand[])new Filter.Expand[]{Filter.Expand.sharedUsers}).sharedUsers.items.size());
    }

    @Test
    public void testGetAndSetColumns() {
        String filterId = this.backdoor.filters().createFilter("", "myfilter");
        String message = null;
        try {
            this.backdoor.columnControl().getFilterColumns(filterId);
        }
        catch (WebApplicationException e) {
            message = e.getMessage();
        }
        Assert.assertEquals((Object)"HTTP 404 Not Found", (Object)message);
        ArrayList defaultColumns = Lists.newArrayList((Object[])new String[]{"issuetype", "issuekey", "summary", "assignee", "reporter"});
        Assert.assertTrue((String)"No errors when setting columns to filter", (boolean)this.backdoor.columnControl().setFilterColumns(filterId, defaultColumns));
        List<ColumnControl.ColumnItem> filterColumns = this.backdoor.columnControl().getFilterColumns(filterId);
        for (int i = 0; i < filterColumns.size(); ++i) {
            Assert.assertEquals(defaultColumns.get(0), (Object)filterColumns.get((int)0).value);
        }
        Assert.assertEquals((long)defaultColumns.size(), (long)filterColumns.size());
        Assert.assertTrue((String)"No errors when removing all columns of filter", (boolean)this.backdoor.columnControl().setFilterColumns(filterId, Lists.newArrayList()));
        Assert.assertEquals((long)0L, (long)this.backdoor.columnControl().getFilterColumns(filterId).size());
    }

    private void assertSharedUsers(String filterId, Matcher<Iterable<String>> matcher) {
        Assert.assertEquals((long)0L, (long)this.filterClient.get((String)filterId, (Filter.Expand[])new Filter.Expand[0]).sharedUsers.items.size());
        Assert.assertEquals((long)0L, (long)this.filterClient.get((String)filterId, (Filter.Expand[])new Filter.Expand[0]).sharedUsers.size);
        List sharedUsers = this.filterClient.get((String)filterId, (Filter.Expand[])new Filter.Expand[]{Filter.Expand.sharedUsers}).sharedUsers.items;
        Collection sharedUserNames = Collections2.transform((Collection)sharedUsers, user -> {
            assert (user != null);
            return user.name;
        });
        MatcherAssert.assertThat((Object)sharedUserNames, matcher);
    }

    @Test
    public void testDefaultShareScope() {
        this.backdoor.permissions().addGlobalPermission(22, "jira-users");
        this.filterClient.loginAs("fred");
        Map result = this.filterClient.getDefaultShareScope();
        Assert.assertEquals((Object)"PRIVATE", result.get("scope"));
        LinkedHashMap<String, String> scope = new LinkedHashMap<String, String>();
        scope.put("scope", "AUTHENTICATED");
        result = this.filterClient.setDefaultShareScope(scope);
        Assert.assertEquals((Object)"AUTHENTICATED", result.get("scope"));
        result = this.filterClient.getDefaultShareScope();
        Assert.assertEquals((Object)"AUTHENTICATED", result.get("scope"));
        this.backdoor.permissions().removeGlobalPermission(22, "jira-users");
        result = this.filterClient.getDefaultShareScope();
        Assert.assertEquals((Object)"PRIVATE", result.get("scope"));
    }

    private void runSinglePermission(String filterId, Filter.FilterPermission expected) {
        Filter filter = this.filterClient.get(filterId, new Filter.Expand[0]);
        MatcherAssert.assertThat(filter.sharePermissions.get(0), TestFilterResource.matchesFilterPermission(expected));
    }

    private void runMultiplePermission(String filterId, Filter.FilterPermission ... expected) {
        Filter filter = this.filterClient.get(filterId, new Filter.Expand[0]);
        Assert.assertEquals((long)expected.length, (long)filter.sharePermissions.size());
        List<Filter.FilterPermission> expectedFilterPermissions = Arrays.asList(expected);
        for (Filter.FilterPermission expectedFilterPermission : expectedFilterPermissions) {
            MatcherAssert.assertThat((Object)filter.sharePermissions, (Matcher)Matchers.hasItem(TestFilterResource.matchesFilterPermission(expectedFilterPermission)));
        }
    }

    public static Matcher<Filter.FilterPermission> matchesFilterPermission(final Filter.FilterPermission expected) {
        return new DiagnosingMatcher<Filter.FilterPermission>(){

            public boolean matches(Object actualObj, Description mismatch) {
                Filter.FilterPermission actual = (Filter.FilterPermission)actualObj;
                if (!expected.type.equals(actual.type)) {
                    return false;
                }
                if (null == expected.project) {
                    if (actual.project != null) {
                        return false;
                    }
                } else {
                    if (actual.project == null) {
                        return false;
                    }
                    if (!actual.project.id.equals(expected.project.id)) {
                        return false;
                    }
                }
                if (null == expected.role) {
                    if (actual.role != null) {
                        return false;
                    }
                } else {
                    if (actual.role == null) {
                        return false;
                    }
                    if (actual.role.id.longValue() != expected.role.id.longValue()) {
                        return false;
                    }
                }
                if (null == expected.group) {
                    if (actual.group != null) {
                        return false;
                    }
                } else {
                    if (actual.group == null) {
                        return false;
                    }
                    if (!actual.group.name().equals(expected.group.name())) {
                        return false;
                    }
                }
                if (null == expected.user) {
                    if (actual.user != null) {
                        return false;
                    }
                } else {
                    if (actual.user == null) {
                        return false;
                    }
                    if (!actual.user.key.equals(expected.user.key)) {
                        return false;
                    }
                }
                if (expected.view != actual.view) {
                    return false;
                }
                return expected.edit == actual.edit;
            }

            public void describeTo(Description description) {
                description.appendText("Id=").appendValue((Object)expected.id);
                description.appendText(", Type=").appendText(expected.type);
                if (expected.project != null) {
                    description.appendText(", Project=").appendText(expected.project.id);
                } else {
                    description.appendText(", Project=null");
                }
                if (expected.role != null) {
                    description.appendText(", Role=").appendValue((Object)expected.role.id);
                } else {
                    description.appendText(", Role=null");
                }
                if (expected.group != null) {
                    description.appendText(", Group=").appendValue((Object)expected.group.name());
                } else {
                    description.appendText(", Group=null");
                }
                if (expected.user != null) {
                    description.appendText(", User=").appendValue((Object)expected.user.key);
                } else {
                    description.appendText(", User=null");
                }
                description.appendText(", isView=").appendValue((Object)expected.view);
                description.appendText(", isEdit=").appendValue((Object)expected.edit);
            }
        };
    }

    private void assertFilterEqual(Filter expectedFilter, Filter actualFilter) {
        Assert.assertNotNull((Object)actualFilter.id);
        Assert.assertNotNull((Object)actualFilter.self);
        this.assertFilterCreateEquals(expectedFilter, actualFilter);
    }

    private void assertFilterCreateEquals(Filter expected, Filter result) {
        Assert.assertEquals((Object)expected.name, (Object)result.name);
        Assert.assertEquals((Object)expected.jql, (Object)result.jql);
        Assert.assertEquals((Object)expected.description, (Object)result.description);
        Assert.assertEquals((Object)expected.favourite, (Object)result.favourite);
        if (expected.owner != null) {
            Assert.assertEquals((Object)expected.owner.name, (Object)result.owner.name);
        }
    }

    private Filter basicFilter(String name, String jql, boolean favorite) {
        Filter filter = new Filter();
        filter.name = name;
        filter.jql = jql;
        filter.description = "test description";
        filter.favourite = favorite;
        return filter;
    }

    private Matcher<? super Filter> filterWithId(final String id) {
        return new TypeSafeMatcher<Filter>(){

            protected boolean matchesSafely(Filter item) {
                return item.id.equals(id);
            }

            public void describeTo(Description description) {
                description.appendValue((Object)id);
            }
        };
    }

    private String getBaseUrlPlus(String ... paths) {
        Iterable pathsNoLeadingSlashes = Iterables.transform(Arrays.asList(paths), path -> path.startsWith("/") ? path.substring(1) : path);
        String path2 = StringUtils.join((Iterable)Lists.newArrayList((Iterable)pathsNoLeadingSlashes), (char)'/');
        return String.format("%s/%s", this.environmentData.getBaseUrl().toExternalForm(), path2);
    }
}

