/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.v2.monitoring.IpdMonitoringController;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import java.util.HashMap;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestIpdMonitoringController
extends BaseJiraFuncTest {
    private IpdMonitoringClient client;

    @Before
    public void setUp() {
        this.client = new IpdMonitoringClient(this.getEnvironmentData());
    }

    @Test
    public void testSetIpdMonitoringWithWebsudoEnabled() {
        ParsedResponse<IpdMonitoringController.IpdMonitoringRestEntity> ipdMonitoringResponse = this.client.getIpdMonitoringState();
        IpdMonitoringController.IpdMonitoringRestEntity ipdMonitoringStateBefore = (IpdMonitoringController.IpdMonitoringRestEntity)ipdMonitoringResponse.body;
        this.backdoor.websudo().enable();
        ParsedResponse response = this.client.setIpdMonitoringState(ipdMonitoringStateBefore.isEnabled() == false);
        Assert.assertEquals((long)401L, (long)response.statusCode);
        this.backdoor.websudo().disable();
        IpdMonitoringController.IpdMonitoringRestEntity ipdMonitoringStateAfter = (IpdMonitoringController.IpdMonitoringRestEntity)this.client.getIpdMonitoringState().body;
        Assert.assertEquals((Object)ipdMonitoringStateBefore.isEnabled(), (Object)ipdMonitoringStateAfter.isEnabled());
    }

    @Test
    public void testSetIpdMonitoringStartWithWebsudoDisabled() {
        ParsedResponse<IpdMonitoringController.IpdMonitoringRestEntity> ipdMonitoringResponse = this.client.getIpdMonitoringState();
        IpdMonitoringController.IpdMonitoringRestEntity ipdMonitoringStateBefore = (IpdMonitoringController.IpdMonitoringRestEntity)ipdMonitoringResponse.body;
        ParsedResponse response = this.client.setIpdMonitoringState(ipdMonitoringStateBefore.isEnabled() == false);
        Assert.assertEquals((long)204L, (long)response.statusCode);
        IpdMonitoringController.IpdMonitoringRestEntity ipdMonitoringStateAfter = (IpdMonitoringController.IpdMonitoringRestEntity)this.client.getIpdMonitoringState().body;
        Assert.assertEquals((Object)ipdMonitoringStateBefore.isEnabled(), (Object)(ipdMonitoringStateAfter.isEnabled() == false ? 1 : 0));
    }

    @Test
    public void testGetIpdMonitoringWithWebsudoEnabled() {
        this.backdoor.websudo().enable();
        ParsedResponse<IpdMonitoringController.IpdMonitoringRestEntity> response = this.client.getIpdMonitoringState();
        Assert.assertEquals((long)401L, (long)response.statusCode);
        this.backdoor.websudo().disable();
    }

    @Test
    public void testGetIpdMonitoringStartWithWebsudoDisabled() {
        ParsedResponse<IpdMonitoringController.IpdMonitoringRestEntity> response = this.client.getIpdMonitoringState();
        Assert.assertEquals((long)200L, (long)response.statusCode);
    }

    public static class IpdMonitoringClient
    extends RestApiClient<IpdMonitoringClient> {
        public IpdMonitoringClient(JIRAEnvironmentData environmentData) {
            super(environmentData);
        }

        public ParsedResponse setIpdMonitoringState(final boolean isIpdMonitoringEnabled) {
            HashMap<String, String> map = new HashMap<String, String>(){
                {
                    this.put("enabled", String.valueOf(isIpdMonitoringEnabled).toLowerCase());
                }
            };
            return this.toResponse(() -> (Response)this.createResource().path("monitoring").path("ipd").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)map), Response.class));
        }

        public ParsedResponse<IpdMonitoringController.IpdMonitoringRestEntity> getIpdMonitoringState() {
            return this.toResponse(() -> (Response)this.createResource().path("monitoring").path("ipd").request().get(Response.class), IpdMonitoringController.IpdMonitoringRestEntity.class);
        }
    }
}

