/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.backdoor.IssuePickerControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.ISSUES})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestIssuePickerResource
extends BaseJiraRestTest {
    private ArrayList<IssuePickerControl> issuePickerControls;
    private IssueClient issueClient;

    @Before
    public void setUpTest() {
        this.issuePickerControls = Lists.newArrayList((Object[])new IssuePickerControl[]{IssuePickerControl.version1(this.environmentData), IssuePickerControl.version2(this.environmentData)});
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testCurrentIssueNotInIssuePickerResultList() {
        long demoProjectId = this.backdoor.project().addProject("Demonstration project", "DEMO", "admin");
        IssueCreateResponse issue1 = this.backdoor.issues().createIssue(demoProjectId, "first issue, which will not appear in autocomplete");
        IssueCreateResponse issue2 = this.backdoor.issues().createIssue(demoProjectId, "second issue which will appear in autocomplete");
        for (IssuePickerControl pickerControl : this.issuePickerControls) {
            IssuePickerControl.IssuePickerResult pickerResult = pickerControl.getIssuePickerResult("DE", null, "DEMO-1", String.valueOf(demoProjectId), true, true);
            Assert.assertThat(this.flattenSections(pickerResult), (Matcher)Matchers.not((Matcher)Matchers.hasItem(this.pickerIssueMatcher(issue1.key))));
            Assert.assertThat(this.flattenSections(pickerResult), (Matcher)Matchers.hasItem(this.pickerIssueMatcher(issue2.key)));
        }
    }

    @Test
    public void testOnlyIssuesFromSelectedProjectInAutoCompleteResult() {
        long projectInAutoCompleteResult = this.backdoor.project().addProject("one project", "DEN", "admin");
        long notInAutoCompleteResults = this.backdoor.project().addProject("second project", "DEM", "admin");
        IssueCreateResponse issue1 = this.backdoor.issues().createIssue(notInAutoCompleteResults, "issue which will appear in autocomplete");
        IssueCreateResponse issue2 = this.backdoor.issues().createIssue(projectInAutoCompleteResult, "issue, which will not appear in autocomplete");
        for (IssuePickerControl pickerControl : this.issuePickerControls) {
            IssuePickerControl.IssuePickerResult pickerResult = pickerControl.getIssuePickerResult("DE", null, null, String.valueOf(projectInAutoCompleteResult), true, true);
            Assert.assertThat(this.flattenSections(pickerResult), (Matcher)Matchers.not((Matcher)Matchers.hasItem(this.pickerIssueMatcher(issue1.key))));
            Assert.assertThat(this.flattenSections(pickerResult), (Matcher)Matchers.hasItem(this.pickerIssueMatcher(issue2.key)));
        }
    }

    @Test
    public void testOnlyIssuesMatchingJqlQueryIncludedInResults() {
        long projectInAutoCompleteResult = this.backdoor.project().addProject("one project", "DEN", "admin");
        long notInAutoCompleteResults = this.backdoor.project().addProject("second project", "DEM", "admin");
        IssueCreateResponse issue1 = this.backdoor.issues().createIssue(notInAutoCompleteResults, "issue which will appear in autocomplete");
        IssueCreateResponse issue2 = this.backdoor.issues().createIssue(projectInAutoCompleteResult, "issue, which will not appear in autocomplete");
        for (IssuePickerControl pickerControl : this.issuePickerControls) {
            IssuePickerControl.IssuePickerResult pickerResult = pickerControl.getIssuePickerResult("DE", "project = DEN", null, null, true, true);
            Assert.assertThat(this.flattenSections(pickerResult), (Matcher)Matchers.not((Matcher)Matchers.hasItem(this.pickerIssueMatcher(issue1.key))));
            Assert.assertThat(this.flattenSections(pickerResult), (Matcher)Matchers.hasItem(this.pickerIssueMatcher(issue2.key)));
        }
    }

    @Test
    public void testSubTasksDisplayedInAutoCompletionResult() {
        this.backdoor.subtask().enable();
        long project = this.backdoor.project().addProject("one project", "DEN", "admin");
        IssueCreateResponse issue1 = this.backdoor.issues().createIssue(project, "Issue 1");
        IssueCreateResponse issue2 = this.backdoor.issues().createIssue(project, "Issue 2");
        IssueCreateResponse subtask = this.createSubtask(project, issue1.key);
        for (IssuePickerControl pickerControl : this.issuePickerControls) {
            IssuePickerControl.IssuePickerResult pickerResult = pickerControl.getIssuePickerResult("DE", "project = DEN", null, null, true, true);
            Assert.assertThat(this.flattenSections(pickerResult), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{this.pickerIssueMatcher(issue2.key), this.pickerIssueMatcher(issue1.key), this.pickerIssueMatcher(subtask.key)}));
            IssuePickerControl.IssuePickerResult pickerResultsWithoutSubTasks = pickerControl.getIssuePickerResult("DE", "project = DEN", null, null, false, true);
            Assert.assertThat(this.flattenSections(pickerResultsWithoutSubTasks), (Matcher)Matchers.not((Matcher)Matchers.hasItem(this.pickerIssueMatcher(subtask.key))));
            Assert.assertThat(this.flattenSections(pickerResultsWithoutSubTasks), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{this.pickerIssueMatcher(issue1.key), this.pickerIssueMatcher(issue2.key)}));
        }
    }

    @Test
    public void testParentIssueIncludedInAutoCompletionResult() {
        this.backdoor.subtask().enable();
        long project = this.backdoor.project().addProject("one project", "DEN", "admin");
        IssueCreateResponse issue1 = this.backdoor.issues().createIssue(project, "Issue 1");
        IssueCreateResponse issue2 = this.backdoor.issues().createIssue(project, "Issue 2");
        IssueCreateResponse subtask = this.createSubtask(project, issue1.key);
        for (IssuePickerControl pickerControl : this.issuePickerControls) {
            IssuePickerControl.IssuePickerResult pickerResult = pickerControl.getIssuePickerResult("DE", null, subtask.key, null, true, true);
            Assert.assertThat(this.flattenSections(pickerResult), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{this.pickerIssueMatcher(issue2.key), this.pickerIssueMatcher(issue1.key)}));
            IssuePickerControl.IssuePickerResult pickerResultWithoutParent = pickerControl.getIssuePickerResult("DE", null, subtask.key, null, true, false);
            Assert.assertThat(this.flattenSections(pickerResultWithoutParent), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{this.pickerIssueMatcher(issue2.key)}));
            Assert.assertThat(this.flattenSections(pickerResultWithoutParent), (Matcher)Matchers.not((Matcher)Matchers.hasItems((Matcher[])new Matcher[]{this.pickerIssueMatcher(issue1.key)})));
        }
    }

    private IssueCreateResponse createSubtask(long project, String parentKey) {
        IssueFields fields = new IssueFields();
        fields.project(ResourceRef.withId((String)String.valueOf(project)));
        fields.parent(ResourceRef.withKey((String)parentKey));
        fields.issueType(ResourceRef.withId((String)"10000"));
        fields.priority(ResourceRef.withId((String)"1"));
        fields.summary("subtask");
        return this.issueClient.create(new IssueUpdateRequest().fields(fields));
    }

    private Iterable<IssuePickerControl.IssuePickerIssue> flattenSections(IssuePickerControl.IssuePickerResult result) {
        return Iterables.concat((Iterable)Iterables.transform(result.getSections(), (Function)new Function<IssuePickerControl.IssueSection, List<IssuePickerControl.IssuePickerIssue>>(){

            public List<IssuePickerControl.IssuePickerIssue> apply(IssuePickerControl.IssueSection issueSection) {
                return issueSection.getIssues();
            }
        }));
    }

    private Matcher<IssuePickerControl.IssuePickerIssue> pickerIssueMatcher(String issueKey) {
        return Matchers.hasProperty((String)"key", (Matcher)Matchers.equalTo((Object)issueKey));
    }
}

