/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreDataCenterInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.issue.fields.rest.json.beans.ProjectJsonBean;
import com.atlassian.jira.rest.api.issue.FieldOperation;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.rest.api.issue.TimeTracking;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.atlassian.jira.testkit.client.restclient.EntityProperty;
import com.atlassian.jira.testkit.client.restclient.EntityPropertyClient;
import com.atlassian.jira.testkit.client.restclient.EntityPropertyKeys;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.ProjectClient;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.atlassian.jira.testkit.client.restclient.Worklog;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.GenericType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
public class TestIssueResourceCreate
extends BaseJiraRestTest {
    private static final FeatureFlag PRIORITIES_PER_PROJECT = FeatureFlag.featureFlag((String)"jira.priorities.per.project");
    private static final FeatureFlag DEFAULT_VALUES_FOR_SYSTEM_FIELDS = FeatureFlag.featureFlag((String)"com.atlassian.jira.defaultValuesForSystemFields");
    private static final GenericType<List<ProjectJsonBean>> PROJECT_LIST_TYPE = new GenericType<List<ProjectJsonBean>>(){};
    private static final String MINOR_PRIORITY = "Minor";
    private static final String MAJOR_PRIORITY = "Major";
    private static final String TRIVIAL_PRIORITY = "Trivial";
    private static final String BLOCKER_PRIORITY = "Blocker";
    final long DATE_CF = 10000L;
    final long DATETIME_CF = 10001L;
    final long CASCADING_SELECT_CF = 10010L;
    final long TEXT_AREA_CF = 10020L;
    final long TEXT_FIELD_CF = 10021L;
    final long GROUP_PICKER = 10030L;
    final long GROUPS_PICKER = 10031L;
    final long SINGLE_VERSION_CF = 10040L;
    final long MULTI_VERSION_CF = 10041L;
    private IssueClient issueClient;
    private ProjectClient projectClient;

    @Test
    @Restore(value="TestCreateIssueWithRequiredSystemFields.xml")
    public void testCreateIssueWithRequiredSystemFields() throws Exception {
        IssueUpdateRequest request = this.getRequiredSystemFields(new String[0]);
        IssueFields fields = request.fields();
        IssueCreateResponse created = ((IssueClient)this.issueClient.loginAs("admin")).create(request);
        Issue newIssue = this.issueClient.get(created.key(), new Issue.Expand[0]);
        Assert.assertThat((Object)created.self, (Matcher)CoreMatchers.equalTo((Object)newIssue.self));
        Assert.assertThat((Object)newIssue.fields.project.key, (Matcher)CoreMatchers.equalTo((Object)"TST"));
        Assert.assertThat((Object)newIssue.fields.issuetype.name, (Matcher)CoreMatchers.equalTo((Object)"Bug"));
        Assert.assertThat((Object)newIssue.fields.priority.name(), (Matcher)CoreMatchers.equalTo((Object)BLOCKER_PRIORITY));
        Assert.assertThat((Object)newIssue.fields.reporter.name, (Matcher)CoreMatchers.equalTo((Object)fields.reporter().name()));
        Assert.assertThat((Object)newIssue.fields.assignee.name, (Matcher)CoreMatchers.equalTo((Object)fields.assignee().name()));
        Assert.assertThat((Object)newIssue.fields.summary, (Matcher)CoreMatchers.equalTo((Object)fields.summary()));
        Assert.assertThat((Object)newIssue.fields.labels, (Matcher)CoreMatchers.equalTo((Object)fields.labels()));
        Assert.assertThat((Object)newIssue.fields.timetracking.originalEstimate, (Matcher)CoreMatchers.equalTo((Object)fields.timeTracking().originalEstimate));
        Assert.assertThat((Object)newIssue.fields.timetracking.remainingEstimate, (Matcher)CoreMatchers.equalTo((Object)"1h 10m"));
        Assert.assertThat((Object)newIssue.fields.security.name, (Matcher)CoreMatchers.equalTo((Object)"lvl1"));
        Assert.assertThat((Object)((Version)newIssue.fields.versions.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"v1"));
        Assert.assertThat((Object)newIssue.fields.environment, (Matcher)CoreMatchers.equalTo((Object)fields.environment()));
        Assert.assertThat((Object)newIssue.fields.description, (Matcher)CoreMatchers.equalTo((Object)fields.description()));
        Assert.assertThat((Object)newIssue.fields.duedate, (Matcher)CoreMatchers.equalTo((Object)fields.dueDate()));
        Assert.assertThat((Object)((Version)newIssue.fields.fixVersions.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"v2"));
        Assert.assertThat((Object)((Component)newIssue.fields.components.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"comp1"));
        Assert.assertEquals((long)1L, (long)newIssue.fields.worklog.worklogs.size());
        Worklog worklog = (Worklog)newIssue.fields.worklog.worklogs.get(0);
        Assert.assertThat((Object)this.toDateTime(worklog.started), (Matcher)CoreMatchers.equalTo((Object)this.toDateTime("2011-07-05T11:05:00.000+0000")));
        Assert.assertThat((Object)worklog.timeSpent, (Matcher)CoreMatchers.equalTo((Object)"50m"));
    }

    @Test
    @Restore(value="TestCreateIssueWithRequiredSystemFields.xml")
    public void testCreateIssueWithInvalidIssueType() {
        IssueUpdateRequest request = this.getRequiredSystemFields(new String[0]);
        request.fields().issueType = ResourceRef.withId((String)"-99999");
        ParsedResponse response = ((IssueClient)this.issueClient.loginAs("admin")).getResponse(request);
        Assert.assertThat((Object)response.statusCode, (Matcher)CoreMatchers.equalTo((Object)400));
        Assert.assertNotNull((String)"No error message for invalid issueType", response.entity.errors.get("issuetype"));
    }

    @Test
    @Restore(value="TestCreateIssueWithRequiredSystemFields.xml")
    public void testCreateIssueWithDefaultedSystemFields() throws Exception {
        IssueUpdateRequest request = this.getRequiredSystemFields("priority", "assignee", "reporter", "securityLevel");
        IssueFields fields = request.fields();
        IssueCreateResponse created = ((IssueClient)this.issueClient.loginAs("admin")).create(request);
        Issue newIssue = this.issueClient.get(created.key(), new Issue.Expand[0]);
        Assert.assertThat((Object)created.self, (Matcher)CoreMatchers.equalTo((Object)newIssue.self));
        Assert.assertThat((Object)newIssue.fields.project.key, (Matcher)CoreMatchers.equalTo((Object)"TST"));
        Assert.assertThat((Object)newIssue.fields.issuetype.name, (Matcher)CoreMatchers.equalTo((Object)"Bug"));
        Assert.assertThat((Object)newIssue.fields.priority.name(), (Matcher)CoreMatchers.equalTo((Object)MAJOR_PRIORITY));
        Assert.assertThat((Object)newIssue.fields.reporter.name, (Matcher)CoreMatchers.equalTo((Object)"admin"));
        Assert.assertThat((Object)newIssue.fields.assignee.name, (Matcher)CoreMatchers.equalTo((Object)"admin"));
        Assert.assertThat((Object)newIssue.fields.summary, (Matcher)CoreMatchers.equalTo((Object)fields.summary()));
        Assert.assertThat((Object)newIssue.fields.labels, (Matcher)CoreMatchers.equalTo((Object)fields.labels()));
        Assert.assertThat((Object)newIssue.fields.timetracking.originalEstimate, (Matcher)CoreMatchers.equalTo((Object)fields.timeTracking().originalEstimate));
        Assert.assertThat((Object)newIssue.fields.timetracking.remainingEstimate, (Matcher)CoreMatchers.equalTo((Object)"1h 10m"));
        Assert.assertThat((Object)newIssue.fields.security.name, (Matcher)CoreMatchers.equalTo((Object)"lvl1"));
        Assert.assertThat((Object)((Version)newIssue.fields.versions.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"v1"));
        Assert.assertThat((Object)newIssue.fields.environment, (Matcher)CoreMatchers.equalTo((Object)fields.environment()));
        Assert.assertThat((Object)newIssue.fields.description, (Matcher)CoreMatchers.equalTo((Object)fields.description()));
        Assert.assertThat((Object)newIssue.fields.duedate, (Matcher)CoreMatchers.equalTo((Object)fields.dueDate()));
        Assert.assertThat((Object)((Version)newIssue.fields.fixVersions.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"v2"));
        Assert.assertThat((Object)((Component)newIssue.fields.components.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"comp1"));
        Assert.assertEquals((long)1L, (long)newIssue.fields.worklog.worklogs.size());
        Worklog worklog = (Worklog)newIssue.fields.worklog.worklogs.get(0);
        Assert.assertThat((Object)this.toDateTime(worklog.started), (Matcher)CoreMatchers.equalTo((Object)this.toDateTime("2011-07-05T11:05:00.000+0000")));
        Assert.assertThat((Object)worklog.timeSpent, (Matcher)CoreMatchers.equalTo((Object)"50m"));
    }

    private Date toDateTime(String time) {
        try {
            String TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
            return new SimpleDateFormat(TIME_FORMAT).parse(time);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    @Restore(value="TestCreateIssueWithRequiredCustomFields.xml")
    public void testCreateIssueWithRequiredCustomFields() throws Exception {
        IssueFields fields = this.getRequiredCustomFields(new String[0]);
        IssueCreateResponse created = ((IssueClient)this.issueClient.loginAs("admin")).create(new IssueUpdateRequest().fields(fields));
        Issue newIssue = this.issueClient.get(created.key(), new Issue.Expand[0]);
        Assert.assertThat((Object)newIssue.fields.get("customfield_10000"), (Matcher)CoreMatchers.equalTo((Object)"1981-06-09"));
        Assert.assertThat((Object)newIssue.fields.get("customfield_10001"), (Matcher)Matchers.startsWith((String)"2011-07-06T15:25:00.000"));
        Map cascadingSelect = (Map)newIssue.fields.get("customfield_10010");
        Assert.assertThat((Object)((String)cascadingSelect.get("value")), (Matcher)CoreMatchers.equalTo((Object)"level1_a"));
        Map child = (Map)cascadingSelect.get("child");
        Assert.assertThat((Object)((String)child.get("value")), (Matcher)CoreMatchers.equalTo((Object)"level2_c"));
        Assert.assertThat((Object)newIssue.fields.get("customfield_10021"), (Matcher)CoreMatchers.equalTo((Object)"this is a text field"));
        Assert.assertThat((Object)newIssue.fields.get("customfield_10020"), (Matcher)CoreMatchers.equalTo((Object)"this is a text area. big text."));
        Map group = (Map)newIssue.fields.get("customfield_10030");
        Assert.assertThat((Object)((String)group.get("name")), (Matcher)CoreMatchers.equalTo((Object)"jira-developers"));
        List groups = (List)newIssue.fields.get("customfield_10031");
        Map group1 = (Map)groups.get(0);
        Map group2 = (Map)groups.get(1);
        Assert.assertThat((Object)((String)group1.get("name")), (Matcher)CoreMatchers.equalTo((Object)"jira-administrators"));
        Assert.assertThat((Object)((String)group2.get("name")), (Matcher)CoreMatchers.equalTo((Object)"jira-users"));
        ObjectMapper MAPPER = new ObjectMapper();
        Version version = (Version)MAPPER.convertValue(newIssue.fields.get("customfield_10040"), Version.class);
        Assert.assertThat((Object)version.name, (Matcher)CoreMatchers.equalTo((Object)"v1"));
        List versions = (List)newIssue.fields.get("customfield_10041");
        Version version1 = (Version)MAPPER.convertValue(versions.get(0), Version.class);
        Version version2 = (Version)MAPPER.convertValue(versions.get(1), Version.class);
        Assert.assertThat((Object)version1.name, (Matcher)CoreMatchers.equalTo((Object)"v1"));
        Assert.assertThat((Object)version2.name, (Matcher)CoreMatchers.equalTo((Object)"v2"));
    }

    @Test
    @Restore(value="TestCreateIssueWithRequiredSystemFields.xml")
    public void testCreateIssueWithoutRequiredSystemFields() throws Exception {
        List<String> requiredFields = Arrays.asList("project", "issuetype", "summary", "labels", "description", "fixVersions", "versions", "components");
        for (String requiredField : requiredFields) {
            IssueUpdateRequest request = this.getRequiredSystemFields(requiredField);
            ParsedResponse response = ((IssueClient)this.issueClient.loginAs("admin")).getResponse(request);
            Assert.assertEquals((String)("Create without required field: " + requiredField), (long)400L, (long)response.statusCode);
            Assert.assertNotNull((String)("No error message for missing field: " + requiredField), response.entity.errors.get(requiredField));
        }
    }

    @Test
    @Restore(value="TestCreateIssueWithRequiredSystemFields.xml")
    public void testCreateIssueWithBadSystemFieldValue() throws Exception {
        IssueUpdateRequest request = this.getRequiredSystemFields(new String[0]);
        IssueFields fields = request.fields();
        fields.project(ResourceRef.withId((String)"-1"));
        ParsedResponse response = ((IssueClient)this.issueClient.loginAs("admin")).getResponse(request);
        Assert.assertEquals((long)400L, (long)response.statusCode);
        Assert.assertNotNull((String)"No error message for invalid project", response.entity.errors.get("project"));
    }

    @Test
    @Restore(value="TestCreateIssueWithRequiredCustomFields.xml")
    public void testCreateIssueWithoutRequiredCustomFields() throws Exception {
        List<String> requiredFields = Arrays.asList("customfield_10000", "customfield_10001", "customfield_10010", "customfield_10021", "customfield_10020", "customfield_10030", "customfield_10031", "customfield_10040", "customfield_10041");
        for (String requiredField : requiredFields) {
            IssueUpdateRequest request = this.getRequiredSystemFields(requiredField);
            ParsedResponse response = ((IssueClient)this.issueClient.loginAs("admin")).getResponse(request);
            Assert.assertEquals((long)400L, (long)response.statusCode);
            Assert.assertNotNull((String)("No error message for missing field: " + requiredField), response.entity.errors.get(requiredField));
        }
    }

    @Test
    @Restore(value="TestCreateIssueWithRequiredSystemFields.xml")
    public void testCreateIssueWithNames() throws Exception {
        IssueUpdateRequest request = this.getSystemFieldsByName(new String[0]);
        IssueFields fields = request.fields();
        this.issueClient.loginAs("admin");
        IssueCreateResponse created = this.issueClient.create(request);
        Issue newIssue = this.issueClient.get(created.key(), new Issue.Expand[0]);
        Assert.assertThat((Object)created.self, (Matcher)CoreMatchers.equalTo((Object)newIssue.self));
        Assert.assertThat((Object)newIssue.fields.project.key, (Matcher)CoreMatchers.equalTo((Object)"TST"));
        Assert.assertThat((Object)newIssue.fields.issuetype.name, (Matcher)CoreMatchers.equalTo((Object)"Bug"));
        Assert.assertThat((Object)newIssue.fields.priority.name(), (Matcher)CoreMatchers.equalTo((Object)BLOCKER_PRIORITY));
        Assert.assertThat((Object)newIssue.fields.reporter.name, (Matcher)CoreMatchers.equalTo((Object)fields.reporter().name()));
        Assert.assertThat((Object)newIssue.fields.assignee.name, (Matcher)CoreMatchers.equalTo((Object)fields.assignee().name()));
        Assert.assertThat((Object)newIssue.fields.summary, (Matcher)CoreMatchers.equalTo((Object)fields.summary()));
        Assert.assertThat((Object)newIssue.fields.labels, (Matcher)CoreMatchers.equalTo((Object)fields.labels()));
        Assert.assertThat((Object)newIssue.fields.timetracking.originalEstimate, (Matcher)CoreMatchers.equalTo((Object)fields.timeTracking().originalEstimate));
        Assert.assertThat((Object)newIssue.fields.timetracking.remainingEstimate, (Matcher)CoreMatchers.equalTo((Object)"1h 10m"));
        Assert.assertThat((Object)newIssue.fields.security.name, (Matcher)CoreMatchers.equalTo((Object)"lvl1"));
        Assert.assertThat((Object)((Version)newIssue.fields.versions.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"v1"));
        Assert.assertThat((Object)newIssue.fields.environment, (Matcher)CoreMatchers.equalTo((Object)fields.environment()));
        Assert.assertThat((Object)newIssue.fields.description, (Matcher)CoreMatchers.equalTo((Object)fields.description()));
        Assert.assertThat((Object)newIssue.fields.duedate, (Matcher)CoreMatchers.equalTo((Object)fields.dueDate()));
        Assert.assertThat((Object)((Version)newIssue.fields.fixVersions.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"v2"));
        Assert.assertThat((Object)((Component)newIssue.fields.components.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"comp1"));
        Assert.assertEquals((long)1L, (long)newIssue.fields.worklog.worklogs.size());
        Worklog worklog = (Worklog)newIssue.fields.worklog.worklogs.get(0);
        Assert.assertThat((Object)this.toDateTime(worklog.started), (Matcher)CoreMatchers.equalTo((Object)this.toDateTime("2011-07-05T11:05:00.000+0000")));
        Assert.assertThat((Object)worklog.timeSpent, (Matcher)CoreMatchers.equalTo((Object)"50m"));
    }

    @Test
    @Restore(value="TestCreateIssueWithRequiredSystemFields.xml")
    public void testCreateIssueWithNamesAndIds() throws Exception {
        IssueUpdateRequest request = this.getSystemFieldsByNameAndId(new String[0]);
        IssueFields fields = request.fields();
        this.issueClient.loginAs("admin");
        IssueCreateResponse created = this.issueClient.create(request);
        Issue newIssue = this.issueClient.get(created.key(), new Issue.Expand[0]);
        Assert.assertThat((Object)created.self, (Matcher)CoreMatchers.equalTo((Object)newIssue.self));
        Assert.assertThat((Object)newIssue.fields.project.key, (Matcher)CoreMatchers.equalTo((Object)"TST"));
        Assert.assertThat((Object)newIssue.fields.issuetype.name, (Matcher)CoreMatchers.equalTo((Object)"Bug"));
        Assert.assertThat((Object)newIssue.fields.priority.name(), (Matcher)CoreMatchers.equalTo((Object)BLOCKER_PRIORITY));
        Assert.assertThat((Object)newIssue.fields.reporter.name, (Matcher)CoreMatchers.equalTo((Object)fields.reporter().name()));
        Assert.assertThat((Object)newIssue.fields.assignee.name, (Matcher)CoreMatchers.equalTo((Object)fields.assignee().name()));
        Assert.assertThat((Object)newIssue.fields.summary, (Matcher)CoreMatchers.equalTo((Object)fields.summary()));
        Assert.assertThat((Object)newIssue.fields.labels, (Matcher)CoreMatchers.equalTo((Object)fields.labels()));
        Assert.assertThat((Object)newIssue.fields.timetracking.originalEstimate, (Matcher)CoreMatchers.equalTo((Object)fields.timeTracking().originalEstimate));
        Assert.assertThat((Object)newIssue.fields.timetracking.remainingEstimate, (Matcher)CoreMatchers.equalTo((Object)"1h 10m"));
        Assert.assertThat((Object)newIssue.fields.security.name, (Matcher)CoreMatchers.equalTo((Object)"lvl1"));
        Assert.assertThat((Object)((Version)newIssue.fields.versions.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"v1"));
        Assert.assertThat((Object)((Version)newIssue.fields.versions.get((int)1)).name, (Matcher)CoreMatchers.equalTo((Object)"v2"));
        Assert.assertThat((Object)newIssue.fields.environment, (Matcher)CoreMatchers.equalTo((Object)fields.environment()));
        Assert.assertThat((Object)newIssue.fields.description, (Matcher)CoreMatchers.equalTo((Object)fields.description()));
        Assert.assertThat((Object)newIssue.fields.duedate, (Matcher)CoreMatchers.equalTo((Object)fields.dueDate()));
        Assert.assertThat((Object)((Version)newIssue.fields.fixVersions.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"v1"));
        Assert.assertThat((Object)((Version)newIssue.fields.fixVersions.get((int)1)).name, (Matcher)CoreMatchers.equalTo((Object)"v2"));
        Assert.assertThat((Object)((Component)newIssue.fields.components.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"comp1"));
        Assert.assertThat((Object)((Component)newIssue.fields.components.get((int)1)).name, (Matcher)CoreMatchers.equalTo((Object)"comp2"));
        Assert.assertEquals((long)1L, (long)newIssue.fields.worklog.worklogs.size());
        Worklog worklog = (Worklog)newIssue.fields.worklog.worklogs.get(0);
        Assert.assertThat((Object)this.toDateTime(worklog.started), (Matcher)CoreMatchers.equalTo((Object)this.toDateTime("2011-07-05T11:05:00.000+0000")));
        Assert.assertThat((Object)worklog.timeSpent, (Matcher)CoreMatchers.equalTo((Object)"50m"));
    }

    @Test
    @Restore(value="TestCreateIssueWithRequiredSystemFields.xml")
    public void testCreateIssueWithBadNames() throws Exception {
        IssueUpdateRequest request = this.getSystemFieldsWithBadNames(new String[0]);
        IssueFields fields = request.fields();
        this.issueClient.loginAs("admin");
        ParsedResponse response = this.issueClient.getResponse(request);
        Assert.assertEquals((long)400L, (long)response.statusCode);
        Assert.assertEquals((Object)"Priority name 'BadPriority' is not valid", response.entity.errors.get("priority"));
        Assert.assertEquals((Object)"Component name 'comp1Bad' is not valid", response.entity.errors.get("components"));
        Assert.assertEquals((Object)"Version name 'v1Bad' is not valid", response.entity.errors.get("versions"));
        Assert.assertEquals((Object)"Version name 'v2Bad' is not valid", response.entity.errors.get("fixVersions"));
    }

    @Test
    @Restore(value="TestCreateIssueWithRequiredSystemFields.xml")
    public void testCreateSubtask() throws Exception {
        IssueFields fields = new IssueFields().parent(ResourceRef.withId((String)"10010")).project(ResourceRef.withId((String)"10000")).issueType(ResourceRef.withId((String)"5")).priority(ResourceRef.withId((String)"1")).reporter(ResourceRef.withName((String)"farnsworth")).assignee(ResourceRef.withName((String)"fry")).summary("a sub-task of my first issue").labels(Arrays.asList("abc", "def")).timeTracking(new TimeTracking("120", null)).securityLevel(ResourceRef.withId((String)"10000")).versions(new ResourceRef[]{ResourceRef.withId((String)"10000")}).environment("environment").description("description").dueDate("2011-03-11").fixVersions(new ResourceRef[]{ResourceRef.withId((String)"10001")}).components(new ResourceRef[]{ResourceRef.withId((String)"10000")});
        LinkedHashMap<String, List<FieldOperation>> updates = new LinkedHashMap<String, List<FieldOperation>>();
        updates.put("worklog", this.addWorkLog("2011-07-06T15:25:00.000+0000", "50m"));
        IssueUpdateRequest request = new IssueUpdateRequest().fields(fields).update(updates);
        IssueCreateResponse created = ((IssueClient)this.issueClient.loginAs("admin")).create(request);
        Issue newIssue = this.issueClient.get(created.key(), new Issue.Expand[0]);
        Assert.assertThat((Object)created.self, (Matcher)CoreMatchers.equalTo((Object)newIssue.self));
        Assert.assertThat((Object)newIssue.fields.parent, (Matcher)Matchers.not((Matcher)CoreMatchers.equalTo(null)));
        Assert.assertThat((Object)newIssue.fields.parent.id(), (Matcher)CoreMatchers.equalTo((Object)"10010"));
    }

    @Test
    @Restore(value="TestCreateIssueWithRequiredSystemFields.xml")
    public void testCreateSubtaskWrongParentProject() throws Exception {
        IssueFields fields = new IssueFields().parent(ResourceRef.withId((String)"10010")).project(ResourceRef.withId((String)"10001")).issueType(ResourceRef.withId((String)"5")).priority(ResourceRef.withId((String)"1")).reporter(ResourceRef.withName((String)"farnsworth")).assignee(ResourceRef.withName((String)"fry")).summary("a sub-task of my first issue").labels(Arrays.asList("abc", "def")).timeTracking(new TimeTracking("120", null)).environment("environment").description("description").dueDate("2011-03-11").components(new ResourceRef[]{ResourceRef.withId((String)"10000")});
        IssueUpdateRequest request = new IssueUpdateRequest().fields(fields);
        this.issueClient.loginAs("admin");
        ParsedResponse response = this.issueClient.getResponse(request);
        Assert.assertEquals((long)400L, (long)response.statusCode);
        Assert.assertEquals((Object)"Sub-tasks must be created in the same project as the parent.", response.entity.errors.get("project"));
    }

    @Test
    @Restore(value="TestCreateIssueWithRequiredSystemFields.xml")
    public void testCreateIssueWithProperties() throws Exception {
        IssueUpdateRequest request = this.getSystemFieldsByName(new String[0]);
        ImmutableMap obj1 = ImmutableMap.of((Object)"value", (Object)"value1");
        ImmutableMap obj2 = ImmutableMap.of((Object)"other", (Object)"value2");
        ImmutableList properties = ImmutableList.of((Object)new IssueUpdateRequest.IssueProperty("ipObj1", new JSONObject((Map<String, Object>)obj1).toString()), (Object)new IssueUpdateRequest.IssueProperty("ipObj2", new JSONObject((Map<String, Object>)obj2).toString()));
        request.properties((List)properties);
        this.issueClient.loginAs("admin");
        IssueCreateResponse createdIssue = this.issueClient.create(request);
        EntityPropertyClient propertyClient = new EntityPropertyClient((JIRAEnvironmentData)this.environmentData, "issue");
        EntityPropertyKeys propertyKeys = propertyClient.getKeys(createdIssue.key);
        Set keyNames = propertyKeys.keys.stream().map(epk -> epk.key).collect(Collectors.toSet());
        Assert.assertThat(keyNames, (Matcher)Matchers.is((Object)ImmutableSet.of((Object)"ipObj1", (Object)"ipObj2")));
        EntityProperty ip1 = propertyClient.get(createdIssue.key, "ipObj1");
        EntityProperty ip2 = propertyClient.get(createdIssue.key, "ipObj2");
        Assert.assertThat((Object)ip1.key, (Matcher)Matchers.is((Object)"ipObj1"));
        Assert.assertThat(ip1.value.entrySet(), (Matcher)Matchers.everyItem((Matcher)Matchers.isIn((Collection)obj1.entrySet())));
        Assert.assertThat((Object)ip2.key, (Matcher)Matchers.is((Object)"ipObj2"));
        Assert.assertThat(ip2.value.entrySet(), (Matcher)Matchers.everyItem((Matcher)Matchers.isIn((Collection)obj2.entrySet())));
    }

    @Test
    @Restore(value="TestCreateIssueWithRequiredSystemFields.xml")
    public void testCreateIssueWithPrioritySchemes() throws Exception {
        String invalidPriorityIdForScheme = "2";
        String validPriorityIdForScheme = "5";
        this.backdoor.darkFeatures().enableForSite(PRIORITIES_PER_PROJECT);
        long prioritySchemeId = this.backdoor.prioritySchemes().createPriorityScheme("Test priority scheme", "Description", (List<String>)ImmutableList.of((Object)"1", (Object)"3", (Object)"5"));
        this.backdoor.prioritySchemes().assignProject(prioritySchemeId, 10000L);
        IssueUpdateRequest requestInvalid = this.getRequiredSystemFields(new String[0]);
        requestInvalid.fields().priority(ResourceRef.withId((String)"2"));
        ParsedResponse responseInvalid = ((IssueClient)this.issueClient.loginAs("admin")).getResponse(requestInvalid);
        Assert.assertEquals((long)400L, (long)responseInvalid.statusCode);
        Assert.assertEquals((Object)"This priority is not available for this project.", responseInvalid.entity.errors.get("priority"));
        IssueUpdateRequest requestValid = this.getRequiredSystemFields(new String[0]);
        requestValid.fields().priority(ResourceRef.withId((String)"5"));
        IssueCreateResponse created = ((IssueClient)this.issueClient.loginAs("admin")).create(requestValid);
        Issue newIssue = this.issueClient.get(created.key(), new Issue.Expand[0]);
        Assert.assertThat((Object)created.self, (Matcher)CoreMatchers.equalTo((Object)newIssue.self));
        Assert.assertThat((Object)newIssue.fields.priority.id(), (Matcher)CoreMatchers.equalTo((Object)"5"));
    }

    @Test
    @Restore(value="TestCreateIssueWithRequiredSystemFields.xml")
    public void testCreateIssueWithUpdateHistory() {
        IssueUpdateRequest request = this.getSystemFieldsByName(new String[0]);
        this.issueClient.loginAs("admin");
        List recentProjectsBefore = (List)this.projectClient.getRecentProjects(1).readEntity(PROJECT_LIST_TYPE);
        IssueCreateResponse created = this.issueClient.create(request, true);
        Issue newIssue = this.issueClient.get(created.key(), new Issue.Expand[0]);
        List recentProjectsAfter = (List)this.projectClient.getRecentProjects(1).readEntity(PROJECT_LIST_TYPE);
        Assert.assertThat((Object)newIssue.fields.project.key, (Matcher)Matchers.is((Object)((ProjectJsonBean)recentProjectsAfter.get(0)).getKey()));
        Assert.assertThat((Object)recentProjectsBefore, (Matcher)Matchers.not((Object)recentProjectsAfter));
    }

    @Test
    @Restore(value="TestCreateIssueWithRequiredSystemFields.xml")
    public void testCreateIssueWithoutUpdateHistory() {
        IssueUpdateRequest request = this.getSystemFieldsByName(new String[0]);
        this.issueClient.loginAs("admin");
        List recentProjectsBefore = (List)this.projectClient.getRecentProjects(1).readEntity(PROJECT_LIST_TYPE);
        this.issueClient.create(request);
        List recentProjectsAfter = (List)this.projectClient.getRecentProjects(1).readEntity(PROJECT_LIST_TYPE);
        Assert.assertThat((Object)recentProjectsBefore, (Matcher)CoreMatchers.equalTo((Object)recentProjectsAfter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @SinceBuildRule.SinceBuild(buildNumber=816000)
    @RestoreDataCenterInstance(value="TestCreateIssueWithDefaultValueOfSystemFieldForBugsInAllProjects.xml")
    public void testCreateIssueWithDefaultValueOfDescriptionSystemFieldForBugIssueTypeInAllProjectsWhenFeatureIsOn() {
        try {
            this.backdoor.darkFeatures().enableForSite(DEFAULT_VALUES_FOR_SYSTEM_FIELDS);
            String defaultValueOfDescriptionSystemField = "Default value of description system field for all 'bug' issue types.";
            IssueCreateResponse bugInTestProjectWithCustomDescriptionCreateResponse = this.backdoor.issues().createIssue("TST", "Some summary for bug in Test Project", null, MAJOR_PRIORITY, "Bug");
            Issue bugInTestProjectWithCustomDescription = this.issueClient.get(bugInTestProjectWithCustomDescriptionCreateResponse.key, new Issue.Expand[0]);
            IssueCreateResponse bugInTestProjectCreateResponse = this.backdoor.issues().createIssue("TST", "Some summary for another bug in Test Project", "Custom description of bug in Test project", null, MAJOR_PRIORITY, "Bug");
            Issue bugInTestProjectWithDefaultDescription = this.issueClient.get(bugInTestProjectCreateResponse.key, new Issue.Expand[0]);
            IssueCreateResponse bugInPlanetHollywoodProjectCreateResponse = this.backdoor.issues().createIssue("PH", "Some summary for bug in Planet Hollywood project", "Custom description of bug in PH Project", null, MINOR_PRIORITY, "Bug");
            Issue bugInPlanetHollywoodProjectWithCustomDescription = this.issueClient.get(bugInPlanetHollywoodProjectCreateResponse.key, new Issue.Expand[0]);
            IssueCreateResponse taskInTestProjectWithCustomDescriptionCreateResponse = this.backdoor.issues().createIssue("TST", "Some summary for task", "Custom description of task in Test Project", null, TRIVIAL_PRIORITY, "Task");
            Issue taskInTestProjectWithCustomDescription = this.issueClient.get(taskInTestProjectWithCustomDescriptionCreateResponse.key, new Issue.Expand[0]);
            IssueCreateResponse taskInTestProjectCreateResponse = this.backdoor.issues().createIssue("TST", "Some summary for task in Test Project", null, BLOCKER_PRIORITY, "Task");
            Issue taskInTestProjectWithNoDescription = this.issueClient.get(taskInTestProjectCreateResponse.key, new Issue.Expand[0]);
            Assert.assertThat((Object)bugInTestProjectWithCustomDescription, this.hasDescription("Default value of description system field for all 'bug' issue types."));
            Assert.assertThat((Object)bugInTestProjectWithDefaultDescription, this.hasDescription("Custom description of bug in Test project"));
            Assert.assertThat((Object)bugInPlanetHollywoodProjectWithCustomDescription, this.hasDescription("Custom description of bug in PH Project"));
            Assert.assertThat((Object)taskInTestProjectWithCustomDescription, this.hasDescription("Custom description of task in Test Project"));
            Assert.assertThat((Object)taskInTestProjectWithNoDescription, this.hasDescription(null));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(DEFAULT_VALUES_FOR_SYSTEM_FIELDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @SinceBuildRule.SinceBuild(buildNumber=816000)
    @RestoreDataCenterInstance(value="TestCreateIssueWithDefaultValueOfSystemFieldForAllIssueTypesInOneProject.xml")
    public void testCreateIssueWithDefaultValueOfDescriptionSystemFieldForAllIssueTypesInPlanetHollywoodProjectWhenFeatureIsOn() {
        try {
            this.backdoor.darkFeatures().enableForSite(DEFAULT_VALUES_FOR_SYSTEM_FIELDS);
            String defaultValueOfDescriptionSystemField = "Default value of description system field for all issue types in Planet Hollywood project.";
            IssueCreateResponse bugInPlanetHollywoodProjectCreateResponse = this.backdoor.issues().createIssue("PH", "Some summary for bug in Planet Hollywood project", "Custom description of bug", null, MINOR_PRIORITY, "Bug");
            Issue bugInPlanetHollywoodProject = this.issueClient.get(bugInPlanetHollywoodProjectCreateResponse.key, new Issue.Expand[0]);
            IssueCreateResponse taskInPlanetHollywoodProjectCreateResponse = this.backdoor.issues().createIssue("PH", "Some summary for task in Planet Hollywood project", null, MINOR_PRIORITY, "Task");
            Issue taskInPlanetHollywoodProject = this.issueClient.get(taskInPlanetHollywoodProjectCreateResponse.key, new Issue.Expand[0]);
            IssueCreateResponse taskInTestProjectCreateResponse = this.backdoor.issues().createIssue("TST", "Some summary for task", "Some description of task in Test Project", null, TRIVIAL_PRIORITY, "Task");
            Issue taskInTestProject = this.issueClient.get(taskInTestProjectCreateResponse.key, new Issue.Expand[0]);
            IssueCreateResponse bugInTestProjectCreateResponse = this.backdoor.issues().createIssue("TST", "Some summary for bug in Test Project", null, MAJOR_PRIORITY, "Bug");
            Issue bugInTestProject = this.issueClient.get(bugInTestProjectCreateResponse.key, new Issue.Expand[0]);
            Assert.assertThat((Object)bugInPlanetHollywoodProject, this.hasDescription("Custom description of bug"));
            Assert.assertThat((Object)taskInPlanetHollywoodProject, this.hasDescription("Default value of description system field for all issue types in Planet Hollywood project."));
            Assert.assertThat((Object)taskInTestProject, this.hasDescription("Some description of task in Test Project"));
            Assert.assertThat((Object)bugInTestProject, this.hasDescription(null));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(DEFAULT_VALUES_FOR_SYSTEM_FIELDS);
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=816000)
    @Restore(value="TestCreateIssueWithDefaultValueOfSystemFieldForAllIssueTypesInOneProject.xml")
    public void testCreateIssueWithDefaultValueOfDescriptionSystemFieldForAllIssueTypesInPlanetHollywoodProjectWhenFeatureIsOff() {
        try {
            this.backdoor.darkFeatures().disableForSite(DEFAULT_VALUES_FOR_SYSTEM_FIELDS);
            IssueCreateResponse taskCreateResponse = this.backdoor.issues().createIssue("PH", "Some summary for task in Planet Hollywood project", null, MINOR_PRIORITY, "Task");
            Issue task = this.issueClient.get(taskCreateResponse.key, new Issue.Expand[0]);
            Assert.assertThat((Object)task, this.hasDescription(null));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(DEFAULT_VALUES_FOR_SYSTEM_FIELDS);
        }
    }

    private Matcher<Issue> hasDescription(final String descriptionValue) {
        return new TypeSafeMatcher<Issue>(){

            public void describeTo(Description description) {
                description.appendText("Issue with description=").appendValue((Object)descriptionValue);
            }

            protected boolean matchesSafely(Issue issue) {
                return Objects.equals(issue.fields.description, descriptionValue);
            }
        };
    }

    @Before
    public void setUpTest() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
        this.projectClient = new ProjectClient((JIRAEnvironmentData)this.environmentData);
    }

    private void assertNoLongerExistsError(WebResponse resp123) throws JSONException, IOException {
        JSONObject content = new JSONObject(resp123.getText());
        Assert.assertEquals((long)1L, (long)content.getJSONArray("errorMessages").length());
        Assert.assertEquals((Object)"Issue Does Not Exist", (Object)content.getJSONArray("errorMessages").getString(0));
    }

    private IssueUpdateRequest getRequiredSystemFields(String ... fieldsToExclude) {
        List<String> exclusions = Arrays.asList(fieldsToExclude);
        IssueFields fields = new IssueFields();
        LinkedHashMap<String, List<FieldOperation>> updates = new LinkedHashMap<String, List<FieldOperation>>();
        if (!exclusions.contains("project")) {
            fields.project(ResourceRef.withId((String)"10000"));
        }
        if (!exclusions.contains("issuetype")) {
            fields.issueType(ResourceRef.withId((String)"1"));
        }
        if (!exclusions.contains("priority")) {
            fields.priority(ResourceRef.withId((String)"1"));
        }
        if (!exclusions.contains("reporter")) {
            fields.reporter(ResourceRef.withName((String)"farnsworth"));
        }
        if (!exclusions.contains("assignee")) {
            fields.assignee(ResourceRef.withName((String)"fry"));
        }
        if (!exclusions.contains("summary")) {
            fields.summary("my first fields");
        }
        if (!exclusions.contains("labels")) {
            fields.labels(Arrays.asList("abc", "def"));
        }
        if (!exclusions.contains("timeTracking")) {
            fields.timeTracking(new TimeTracking("2h", null));
        }
        if (!exclusions.contains("securityLevel")) {
            fields.securityLevel(ResourceRef.withId((String)"10000"));
        }
        if (!exclusions.contains("versions")) {
            fields.versions(new ResourceRef[]{ResourceRef.withId((String)"10000")});
        }
        if (!exclusions.contains("environment")) {
            fields.environment("environment");
        }
        if (!exclusions.contains("description")) {
            fields.description("description");
        }
        if (!exclusions.contains("dueDate")) {
            fields.dueDate("2011-03-01");
        }
        if (!exclusions.contains("fixVersions")) {
            fields.fixVersions(new ResourceRef[]{ResourceRef.withId((String)"10001")});
        }
        if (!exclusions.contains("components")) {
            fields.components(new ResourceRef[]{ResourceRef.withId((String)"10000")});
        }
        if (!exclusions.contains("logWork")) {
            updates.put("worklog", this.addWorkLog("2011-07-05T11:05:00.000+0000", "50m"));
        }
        return new IssueUpdateRequest().fields(fields).update(updates);
    }

    private IssueUpdateRequest getSystemFieldsByName(String ... fieldsToExclude) {
        List<String> exclusions = Arrays.asList(fieldsToExclude);
        IssueFields fields = new IssueFields();
        LinkedHashMap<String, List<FieldOperation>> updates = new LinkedHashMap<String, List<FieldOperation>>();
        if (!exclusions.contains("project")) {
            fields.project(ResourceRef.withId((String)"10000"));
        }
        if (!exclusions.contains("issuetype")) {
            fields.issueType(ResourceRef.withId((String)"1"));
        }
        if (!exclusions.contains("priority")) {
            fields.priority(ResourceRef.withName((String)BLOCKER_PRIORITY));
        }
        if (!exclusions.contains("reporter")) {
            fields.reporter(ResourceRef.withName((String)"farnsworth"));
        }
        if (!exclusions.contains("assignee")) {
            fields.assignee(ResourceRef.withName((String)"fry"));
        }
        if (!exclusions.contains("summary")) {
            fields.summary("my first fields");
        }
        if (!exclusions.contains("labels")) {
            fields.labels(Arrays.asList("abc", "def"));
        }
        if (!exclusions.contains("timeTracking")) {
            fields.timeTracking(new TimeTracking("2h", null));
        }
        if (!exclusions.contains("securityLevel")) {
            fields.securityLevel(ResourceRef.withId((String)"10000"));
        }
        if (!exclusions.contains("versions")) {
            fields.versions(new ResourceRef[]{ResourceRef.withName((String)"v1")});
        }
        if (!exclusions.contains("environment")) {
            fields.environment("environment");
        }
        if (!exclusions.contains("description")) {
            fields.description("description");
        }
        if (!exclusions.contains("dueDate")) {
            fields.dueDate("2011-03-01");
        }
        if (!exclusions.contains("fixVersions")) {
            fields.fixVersions(new ResourceRef[]{ResourceRef.withName((String)"v2")});
        }
        if (!exclusions.contains("components")) {
            fields.components(new ResourceRef[]{ResourceRef.withName((String)"comp1")});
        }
        if (!exclusions.contains("logWork")) {
            updates.put("worklog", this.addWorkLog("2011-07-05T11:05:00.000+0000", "50m"));
        }
        return new IssueUpdateRequest().fields(fields).update(updates);
    }

    private IssueUpdateRequest getSystemFieldsByNameAndId(String ... fieldsToExclude) {
        List<String> exclusions = Arrays.asList(fieldsToExclude);
        IssueFields fields = new IssueFields();
        LinkedHashMap<String, List<FieldOperation>> updates = new LinkedHashMap<String, List<FieldOperation>>();
        if (!exclusions.contains("project")) {
            fields.project(ResourceRef.withKey((String)"TST"));
        }
        if (!exclusions.contains("issuetype")) {
            fields.issueType(ResourceRef.withName((String)"Bug"));
        }
        if (!exclusions.contains("priority")) {
            fields.priority(ResourceRef.withName((String)BLOCKER_PRIORITY));
        }
        if (!exclusions.contains("reporter")) {
            fields.reporter(ResourceRef.withName((String)"farnsworth"));
        }
        if (!exclusions.contains("assignee")) {
            fields.assignee(ResourceRef.withName((String)"fry"));
        }
        if (!exclusions.contains("summary")) {
            fields.summary("my first fields");
        }
        if (!exclusions.contains("labels")) {
            fields.labels(Arrays.asList("abc", "def"));
        }
        if (!exclusions.contains("timeTracking")) {
            fields.timeTracking(new TimeTracking("2h", null));
        }
        if (!exclusions.contains("securityLevel")) {
            fields.securityLevel(ResourceRef.withId((String)"10000"));
        }
        if (!exclusions.contains("versions")) {
            fields.versions(new ResourceRef[]{ResourceRef.withName((String)"v1"), ResourceRef.withName((String)"v2")});
        }
        if (!exclusions.contains("environment")) {
            fields.environment("environment");
        }
        if (!exclusions.contains("description")) {
            fields.description("description");
        }
        if (!exclusions.contains("dueDate")) {
            fields.dueDate("2011-03-01");
        }
        if (!exclusions.contains("fixVersions")) {
            fields.fixVersions(new ResourceRef[]{ResourceRef.withId((String)"10000"), ResourceRef.withName((String)"v2")});
        }
        if (!exclusions.contains("components")) {
            fields.components(new ResourceRef[]{ResourceRef.withName((String)"comp1"), ResourceRef.withName((String)"comp2")});
        }
        if (!exclusions.contains("logWork")) {
            updates.put("worklog", this.addWorkLog("2011-07-05T11:05:00.000+0000", "50m"));
        }
        return new IssueUpdateRequest().fields(fields).update(updates);
    }

    private IssueUpdateRequest getSystemFieldsWithBadNames(String ... fieldsToExclude) {
        List<String> exclusions = Arrays.asList(fieldsToExclude);
        IssueFields fields = new IssueFields();
        LinkedHashMap<String, List<FieldOperation>> updates = new LinkedHashMap<String, List<FieldOperation>>();
        if (!exclusions.contains("project")) {
            fields.project(ResourceRef.withId((String)"10000"));
        }
        if (!exclusions.contains("issuetype")) {
            fields.issueType(ResourceRef.withId((String)"1"));
        }
        if (!exclusions.contains("priority")) {
            fields.priority(ResourceRef.withName((String)"BadPriority"));
        }
        if (!exclusions.contains("reporter")) {
            fields.reporter(ResourceRef.withName((String)"farnsworth"));
        }
        if (!exclusions.contains("assignee")) {
            fields.assignee(ResourceRef.withName((String)"fry"));
        }
        if (!exclusions.contains("summary")) {
            fields.summary("my first fields");
        }
        if (!exclusions.contains("labels")) {
            fields.labels(Arrays.asList("abc", "def"));
        }
        if (!exclusions.contains("timeTracking")) {
            fields.timeTracking(new TimeTracking("120", null));
        }
        if (!exclusions.contains("securityLevel")) {
            fields.securityLevel(ResourceRef.withId((String)"10000"));
        }
        if (!exclusions.contains("versions")) {
            fields.versions(new ResourceRef[]{ResourceRef.withName((String)"v1Bad")});
        }
        if (!exclusions.contains("environment")) {
            fields.environment("environment");
        }
        if (!exclusions.contains("description")) {
            fields.description("description");
        }
        if (!exclusions.contains("dueDate")) {
            fields.dueDate("2011-03-01");
        }
        if (!exclusions.contains("fixVersions")) {
            fields.fixVersions(new ResourceRef[]{ResourceRef.withName((String)"v2Bad")});
        }
        if (!exclusions.contains("components")) {
            fields.components(new ResourceRef[]{ResourceRef.withName((String)"comp1Bad")});
        }
        if (!exclusions.contains("logWork")) {
            updates.put("worklog", this.addWorkLog("2011-07-05T11:05:00.000+0000", "50m"));
        }
        return new IssueUpdateRequest().fields(fields).update(updates);
    }

    private List<FieldOperation> addWorkLog(String started, String timeSpent) {
        Map<String, String> worklog = MapBuilder.newBuilder().add("started", started).add("timeSpent", timeSpent).toMap();
        return Arrays.asList(new FieldOperation().operation("add").value(worklog));
    }

    private IssueFields getRequiredCustomFields(String ... fieldsToExclude) {
        List<String> exclusions = Arrays.asList(fieldsToExclude);
        IssueFields fields = new IssueFields();
        if (!exclusions.contains("project")) {
            fields.project(ResourceRef.withId((String)"10000"));
        }
        if (!exclusions.contains("issuetype")) {
            fields.issueType(ResourceRef.withId((String)"1"));
        }
        if (!exclusions.contains("priority")) {
            fields.priority(ResourceRef.withId((String)"1"));
        }
        if (!exclusions.contains("reporter")) {
            fields.reporter(ResourceRef.withName((String)"farnsworth"));
        }
        if (!exclusions.contains("assignee")) {
            fields.assignee(ResourceRef.withName((String)"fry"));
        }
        if (!exclusions.contains("summary")) {
            fields.summary("custom fields test");
        }
        if (!exclusions.contains("customfield_10000")) {
            fields.customField(Long.valueOf(10000L), (Object)"1981-06-09");
        }
        if (!exclusions.contains("customfield_10001")) {
            fields.customField(Long.valueOf(10001L), (Object)"2011-07-06T15:25:00.000+1000");
        }
        HashMap<String, Object> parent = new HashMap<String, Object>();
        HashMap<String, String> child = new HashMap<String, String>();
        parent.put("id", "10000");
        parent.put("child", child);
        child.put("id", "10002");
        if (!exclusions.contains("customfield_10010")) {
            fields.customField(Long.valueOf(10010L), parent);
        }
        if (!exclusions.contains("customfield_10021")) {
            fields.customField(Long.valueOf(10021L), (Object)"this is a text field");
        }
        if (!exclusions.contains("customfield_10020")) {
            fields.customField(Long.valueOf(10020L), (Object)"this is a text area. big text.");
        }
        if (!exclusions.contains("customfield_10030")) {
            fields.customField(Long.valueOf(10030L), (Object)ResourceRef.withName((String)"jira-developers"));
        }
        if (!exclusions.contains("customfield_10031")) {
            fields.customField(Long.valueOf(10031L), (Object)new ResourceRef[]{ResourceRef.withName((String)"jira-administrators"), ResourceRef.withName((String)"jira-users")});
        }
        if (!exclusions.contains("customfield_10040")) {
            fields.customField(Long.valueOf(10040L), (Object)ResourceRef.withName((String)"v1"));
        }
        if (!exclusions.contains("customfield_10041")) {
            fields.customField(Long.valueOf(10041L), (Object)new ResourceRef[]{ResourceRef.withName((String)"v2"), ResourceRef.withName((String)"v1")});
        }
        return fields;
    }
}

