/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.webtests.EmailBaseFuncTestCase;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Notification;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.NotifyClient;
import com.icegreen.greenmail.store.FolderException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.EMAIL})
@LoginAs(user="admin")
@Restore(value="TestIssueResourceNotify.xml")
public final class TestIssueResourceNotify
extends EmailBaseFuncTestCase {
    private static final String HSP_1_KEY = "HSP-1";
    private static final String HSP_1_SUMMARY = "i think i'm being watched";
    public static final String NOTIFICATION_GROUP = "notification-group";
    public static final String JACK_EMAIL = "jack@example.com";
    private final Notification notification = new Notification().textBody("Text Body").htmlBody("<strong>Html Body</strong>");
    private NotifyClient notifyClient;

    @Test
    public void testNotificationUsingNotificationScheme() throws Exception {
        this.testNotification(this.notification, true, JACK_EMAIL, "fred@example.com", "scheme@example.com");
    }

    @Test
    public void testNotificationToUser() throws Exception {
        this.testNotification(this.notification.toUser("fred"), true, "fred@example.com");
    }

    @Test
    public void testNotificationToUserAsText() throws Exception {
        this.backdoor.userProfile().changeUserNotificationType("fred", "text");
        this.testNotification(this.notification.toUser("fred"), false, "fred@example.com");
    }

    @Test
    public void testNotificationToGroup() throws Exception {
        this.testNotification(this.notification.toGroup(NOTIFICATION_GROUP), true, "fred@example.com");
    }

    @Test
    public void testNotificationToReporter() throws Exception {
        this.testNotification(this.notification.toReporter(), true, JACK_EMAIL);
    }

    @Test
    public void testNotificationToAssignee() throws Exception {
        this.testNotification(this.notification.toAssignee(), true, "fred@example.com");
    }

    @Test
    public void testNotificationToWatchers() throws Exception {
        this.testNotification(this.notification.toWatchers(), true, JACK_EMAIL, "fred@example.com");
    }

    @Test
    public void testNotificationToVoters() throws Exception {
        this.testNotification(this.notification.toVoters(), true, "fred@example.com");
    }

    @Test
    public void testNotificationRestrictingByGroup() throws Exception {
        this.testNotification(this.notification.toWatchers().restrictToGroup(NOTIFICATION_GROUP), true, "fred@example.com");
    }

    @Test
    public void testNotificationRestrictingByPermissionId() throws Exception {
        this.backdoor.usersAndGroups().removeUserFromGroup("fred", "jira-users");
        this.testNotification(this.notification.toWatchers().restrictToPermission(10), true, JACK_EMAIL);
    }

    @Test
    public void testNotificationRestrictingByPermissionName() throws Exception {
        this.backdoor.usersAndGroups().removeUserFromGroup("fred", "jira-users");
        this.testNotification(this.notification.toWatchers().restrictToPermission("BROWSE"), true, JACK_EMAIL);
    }

    @Test
    public void testNotificationWithNonDefaultSubject() throws Exception {
        this.testNotification(this.notification.toUser("fred").subject("A non default subject"), true, "fred@example.com");
    }

    private void testNotification(Notification notification, boolean html, String ... mailboxes) throws Exception {
        ParsedResponse response = ((NotifyClient)this.notifyClient.loginAs("admin")).postResponse(HSP_1_KEY, notification);
        Assert.assertThat((Object)response.statusCode, (Matcher)IsEqual.equalTo((Object)Response.Status.NO_CONTENT.getStatusCode()));
        this.flushMailQueueAndWait(mailboxes.length);
        for (String mailbox : mailboxes) {
            this.checkMailBox(mailbox, notification, html);
        }
        Assert.assertThat((Object)this.mailService.getReceivedMessages().length, (Matcher)IsEqual.equalTo((Object)0));
    }

    @Test
    public void testNotificationOnNonExistingIssue() throws Exception {
        ParsedResponse response = ((NotifyClient)this.notifyClient.loginAs("admin")).postResponse("NO-1", this.notification);
        Assert.assertThat((Object)response.statusCode, (Matcher)IsEqual.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
    }

    @Test
    public void testNotificationWithNoBrowsePermissionOnIssue() throws Exception {
        ParsedResponse response = ((NotifyClient)this.notifyClient.loginAs("luser")).postResponse("MKY-1", this.notification);
        Assert.assertThat((Object)response.statusCode, (Matcher)IsEqual.equalTo((Object)Response.Status.FORBIDDEN.getStatusCode()));
    }

    @Test
    public void testNotificationWithNonExistingUser() throws Exception {
        ParsedResponse response = ((NotifyClient)this.notifyClient.loginAs("admin")).postResponse("MKY-1", this.notification.toUser("a-funky-user-name"));
        Assert.assertThat((Object)response.statusCode, (Matcher)IsEqual.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
    }

    @Test
    public void testNotificationWithNonExistingGroup() throws Exception {
        ParsedResponse response = ((NotifyClient)this.notifyClient.loginAs("admin")).postResponse("MKY-1", this.notification.toGroup("a-funky-group-name"));
        Assert.assertThat((Object)response.statusCode, (Matcher)IsEqual.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
    }

    @Test
    public void testNotificationWithNonExistingRestrictingGroup() throws Exception {
        ParsedResponse response = ((NotifyClient)this.notifyClient.loginAs("admin")).postResponse("MKY-1", this.notification.restrictToGroup("a-funky-group-name"));
        Assert.assertThat((Object)response.statusCode, (Matcher)IsEqual.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
    }

    @Test
    public void testNotificationWithNonExistingPermission() throws Exception {
        ParsedResponse response = ((NotifyClient)this.notifyClient.loginAs("admin")).postResponse("MKY-1", this.notification.restrictToPermission("a-funky-permission-name"));
        Assert.assertThat((Object)response.statusCode, (Matcher)IsEqual.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
    }

    private void checkMailBox(String email, Notification notification, boolean html) throws FolderException, MessagingException {
        EmailBaseFuncTestCase.MailBox mailBox = this.getMailBox(email);
        MimeMessage message = mailBox.awaitMessage();
        String expected = StringUtils.isNotBlank((CharSequence)notification.subject) ? "[JIRATEST] " + notification.subject : "[JIRATEST] (HSP-1) i think i'm being watched";
        Assert.assertEquals((Object)expected, (Object)message.getSubject());
        this.assertMessageAndType(message, html ? notification.htmlBody : notification.textBody, html);
        mailBox.clear();
    }

    @Before
    public void setUpTest() {
        this.notifyClient = new NotifyClient(this.getEnvironmentData());
        this.configureAndStartSmtpServer();
    }
}

