/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Vote;
import com.atlassian.jira.testkit.client.restclient.VotesClient;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@Restore(value="TestIssueResourceVoters.xml")
public class TestIssueResourceVoters
extends BaseJiraFuncTest {
    private static final String ISSUE_KEY = "TP-1";
    private static final String USER_NOT_SELECTED_ON_USER_PICKER = "admin";
    private static final String USER_SELECTED_ON_USER_PICKER = "test";
    private VotesClient votesClient;

    @Before
    public void setUp() {
        this.votesClient = new VotesClient((JIRAEnvironmentData)this.getEnvironmentData());
    }

    @Test
    public void testVotersCanNotBeReadByADifferentUserThanTheOneSpecifiedOnTheUserPickerCustomField() {
        this.votesClient.loginAs(USER_NOT_SELECTED_ON_USER_PICKER);
        Vote vote = this.votesClient.get(ISSUE_KEY);
        Assert.assertTrue((boolean)vote.voters.isEmpty());
    }

    @Test
    public void testVotersCanBeReadByTheUserThatIsSpecifiedOnTheUserPickerCustomField() {
        this.votesClient.loginAs(USER_SELECTED_ON_USER_PICKER);
        Vote vote = this.votesClient.get(ISSUE_KEY);
        Assert.assertThat((Object)vote.voters.size(), (Matcher)Is.is((Object)1));
    }
}

