/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.beans.IssueSecuritySchemeBean;
import com.atlassian.jira.testkit.beans.IssueSecurityType;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.IssueSecuritySchemeClient;
import com.atlassian.jira.testkit.client.restclient.IssueSecuritySchemes;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@RestoreBlankInstance
public class TestIssueSecuritySchemeResource
extends BaseJiraRestTest {
    private IssueSecuritySchemeClient client;

    @Before
    public void setup() {
        this.client = new IssueSecuritySchemeClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testListReturnsEmpty() throws Exception {
        ParsedResponse response = this.client.getAllSecuritySchemes();
        Assert.assertThat((Object)response.statusCode, this.isOK());
        IssueSecuritySchemes list = (IssueSecuritySchemes)response.body;
        Assert.assertThat((Object)list.getIssueSecuritySchemes(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testListReturnsOneScheme() throws Exception {
        IssueSecuritySchemeBean expectedScheme = new IssueSecuritySchemeBean(null, "A");
        expectedScheme.description = "a";
        this.backdoor.getTestkit().issueSecuritySchemes().createScheme(expectedScheme.name, expectedScheme.description);
        ParsedResponse response = this.client.getAllSecuritySchemes();
        Assert.assertThat((Object)response.statusCode, this.isOK());
        IssueSecuritySchemes list = (IssueSecuritySchemes)response.body;
        Assert.assertThat((Object)list.getIssueSecuritySchemes(), (Matcher)Matchers.contains(this.matchesWithoutID(expectedScheme)));
    }

    @Test
    public void testListForbiddenForNotAdmin() throws Exception {
        ParsedResponse response = this.asFred().getAllSecuritySchemes();
        Assert.assertThat((Object)response.statusCode, this.isForbidden());
    }

    @Test
    public void testGetReturnsSchemeWithLevels() throws Exception {
        IssueSecuritySchemeBean expectedScheme = this.getTestIssueSecuritySchemeBean();
        Long scheme = this.backdoor.getTestkit().issueSecuritySchemes().createScheme(expectedScheme.name, expectedScheme.description);
        for (IssueSecurityType level : expectedScheme.levels) {
            this.backdoor.getTestkit().issueSecuritySchemes().addSecurityLevel(scheme.longValue(), level.name, level.description);
        }
        ParsedResponse response = this.client.get(scheme.longValue());
        Assert.assertThat((Object)response.statusCode, this.isOK());
        IssueSecuritySchemeBean result = (IssueSecuritySchemeBean)response.body;
        Assert.assertThat((Object)result, this.matchesWithoutID(expectedScheme));
    }

    @Test
    public void testGetSuccessfulForNotAdminWithProjectAdminPermissions() {
        IssueSecuritySchemeBean expectedScheme = this.getTestIssueSecuritySchemeBean();
        Long scheme = this.backdoor.getTestkit().issueSecuritySchemes().createScheme(expectedScheme.name, expectedScheme.description);
        this.backdoor.permissionSchemes().addUserPermission(0L, ProjectPermissions.ADMINISTER_PROJECTS, "fred");
        long projectId = this.backdoor.project().addProject("name", "KEY", "admin");
        this.backdoor.project().setIssueSecurityScheme(projectId, scheme);
        for (IssueSecurityType level : expectedScheme.levels) {
            this.backdoor.getTestkit().issueSecuritySchemes().addSecurityLevel(scheme.longValue(), level.name, level.description);
        }
        ParsedResponse response = ((IssueSecuritySchemeClient)this.client.loginAs("fred")).get(scheme.longValue());
        Assert.assertThat((Object)response.statusCode, this.isOK());
        IssueSecuritySchemeBean result = (IssueSecuritySchemeBean)response.body;
        Assert.assertThat((Object)result, this.matchesWithoutID(expectedScheme));
    }

    @Test
    public void testGetForbiddenForNotAdmin() throws Exception {
        ParsedResponse response = this.asFred().get(0L);
        Assert.assertThat((Object)response.statusCode, this.isForbidden());
    }

    @Test
    public void testGettingSecuritySchemeForProject() {
        IssueSecuritySchemeBean expectedSecurityScheme = this.getTestIssueSecuritySchemeBean();
        Long scheme = this.backdoor.getTestkit().issueSecuritySchemes().createScheme(expectedSecurityScheme.name, expectedSecurityScheme.description);
        for (IssueSecurityType level : expectedSecurityScheme.levels) {
            this.backdoor.getTestkit().issueSecuritySchemes().addSecurityLevel(scheme.longValue(), level.name, level.description);
        }
        this.backdoor.permissionSchemes().addUserPermission(0L, ProjectPermissions.ADMINISTER_PROJECTS, "fred");
        long projectId = this.backdoor.project().addProject("name", "KEY", "admin");
        this.backdoor.project().setIssueSecurityScheme(projectId, scheme);
        ParsedResponse response = this.client.getForProject("KEY");
        Assert.assertThat((Object)response.statusCode, this.isOK());
        IssueSecuritySchemeBean securitySchemeBean = (IssueSecuritySchemeBean)response.body;
        Assert.assertThat((Object)securitySchemeBean, this.matchesWithoutID(expectedSecurityScheme));
    }

    @Test
    public void testNoSecuritySchemeForProject() throws Exception {
        ParsedResponse forProject = this.client.getForProject("MKY");
        Assert.assertThat((Object)forProject.statusCode, this.isNotFound());
        Assert.assertThat((Object)forProject.entity.errorMessages, (Matcher)Matchers.hasItem((Object)"Security level for project MKY does not exist."));
    }

    @Test
    public void testForbiddenForUsersWithoutAdministrativePermissionsOnProject() {
        ParsedResponse forProject = this.asFred().getForProject("MKY");
        Assert.assertThat((Object)forProject.statusCode, this.isForbidden());
    }

    @Test
    public void testProjectDoesNotExist() {
        ParsedResponse nonExistingProject = this.client.getForProject("MKY2");
        Assert.assertThat((Object)nonExistingProject.statusCode, this.isNotFound());
    }

    @Test
    public void testNoSecuritySchemeForProjectIdentifiedById() throws Exception {
        String projectId = this.backdoor.project().getProject((String)"MKY").id;
        ParsedResponse forProject = this.client.getForProject(projectId);
        Assert.assertThat((Object)forProject.statusCode, this.isNotFound());
        Assert.assertThat((Object)forProject.entity.errorMessages, (Matcher)Matchers.hasItem((Object)("Security level for project " + projectId + " does not exist.")));
    }

    private IssueSecuritySchemeBean getTestIssueSecuritySchemeBean() {
        IssueSecuritySchemeBean expectedScheme = new IssueSecuritySchemeBean(null, "A");
        expectedScheme.description = "a";
        expectedScheme.levels = this.createSecurityLevelTestList();
        return expectedScheme;
    }

    private List<IssueSecurityType> createSecurityLevelTestList() {
        IssueSecurityType securityLevel = new IssueSecurityType().name("level").description("desc");
        IssueSecurityType securityLevel2 = new IssueSecurityType().name("level").description("desc");
        return Arrays.asList(securityLevel, securityLevel2);
    }

    private Matcher<? super Integer> isOK() {
        return Matchers.is((Object)Response.Status.OK.getStatusCode());
    }

    private Matcher<? super Integer> isForbidden() {
        return Matchers.is((Object)Response.Status.FORBIDDEN.getStatusCode());
    }

    private Matcher<? super Integer> isNotFound() {
        return Matchers.is((Object)Response.Status.NOT_FOUND.getStatusCode());
    }

    private IssueSecuritySchemeClient asFred() {
        return (IssueSecuritySchemeClient)this.client.loginAs("fred");
    }

    private TypeSafeMatcher<IssueSecuritySchemeBean> matchesWithoutID(final IssueSecuritySchemeBean expected) {
        return new TypeSafeMatcher<IssueSecuritySchemeBean>(){

            protected boolean matchesSafely(IssueSecuritySchemeBean issueSecuritySchemeBean) {
                return new EqualsBuilder().append((Object)issueSecuritySchemeBean.name, (Object)expected.name).append((Object)issueSecuritySchemeBean.description, (Object)expected.description).isEquals() && this.levelsMatch(issueSecuritySchemeBean.levels);
            }

            public void describeTo(Description description) {
                description.appendText("Scheme: ").appendValue((Object)expected.name).appendValue((Object)expected.description).appendValueList("[", ",", "]", (Iterable)expected.levels);
            }

            private boolean levelsMatch(Collection<IssueSecurityType> levels) {
                if (levels == null) {
                    return expected.levels == null;
                }
                Iterable matchers = Iterables.transform(levels, (Function)new Function<IssueSecurityType, Matcher<? super IssueSecurityType>>(){

                    public Matcher<IssueSecurityType> apply(IssueSecurityType issueSecurityType) {
                        return TestIssueSecuritySchemeResource.this.levelMatchesWithoutId(issueSecurityType);
                    }
                });
                Matcher[] matcherArray = (Matcher[])Iterables.toArray((Iterable)matchers, Matcher.class);
                return IsIterableContainingInOrder.contains((Matcher[])matcherArray).matches((Object)expected.levels);
            }
        };
    }

    private TypeSafeMatcher<IssueSecurityType> levelMatchesWithoutId(final IssueSecurityType expected) {
        return new TypeSafeMatcher<IssueSecurityType>(){

            protected boolean matchesSafely(IssueSecurityType issueSecurityType) {
                return new EqualsBuilder().append((Object)expected.name, (Object)issueSecurityType.name).append((Object)expected.description, (Object)issueSecurityType.description).isEquals();
            }

            public void describeTo(Description description) {
                description.appendText("Level:").appendValue((Object)expected.name).appendValue((Object)expected.description);
            }
        };
    }
}

