/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.PrioritySchemeBean;
import com.atlassian.jira.testkit.client.restclient.PrioritySchemeClient;
import com.atlassian.jira.testkit.client.restclient.PrioritySchemeUpdateBean;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@Restore(value="TestPrioritySchemesWithSDProject.xml")
public class TestPrioritySchemeResourceWithServiceDesk
extends BaseJiraFuncTest {
    private PrioritySchemeClient prioritySchemeClient;
    private static final FeatureFlag PRIORITIES_PER_PROJECT = FeatureFlag.featureFlag((String)"jira.priorities.per.project");
    private static final FeatureFlag PRIORITIES_PER_PROJECT_JSD = FeatureFlag.featureFlag((String)"jira.priorities.per.project.jsd");
    private static final String SERVICE_DESK_PROJECT_KEY = "SDP";
    private static long SERVICE_DESK_PROJECT_ID;

    @Before
    public void setUpTest() {
        this.prioritySchemeClient = new PrioritySchemeClient((JIRAEnvironmentData)this.environmentData);
        this.backdoor.darkFeatures().enableForSite(PRIORITIES_PER_PROJECT);
        this.backdoor.darkFeatures().enableForSite(PRIORITIES_PER_PROJECT_JSD);
        SERVICE_DESK_PROJECT_ID = Long.valueOf(this.backdoor.project().getProject((String)SERVICE_DESK_PROJECT_KEY).id);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=77000)
    public void assignSDProjectShouldBeRejectedWhenJSDFlagOff() {
        this.backdoor.darkFeatures().disableForSite(PRIORITIES_PER_PROJECT_JSD);
        long prioritySchemeId = this.createPriorityScheme("Priority scheme name");
        ParsedResponse assignResponse = this.prioritySchemeClient.assign(prioritySchemeId, SERVICE_DESK_PROJECT_KEY, new PrioritySchemeBean.Expand[0]);
        MatcherAssert.assertThat((Object)assignResponse.statusCode, (Matcher)Matchers.equalTo((Object)400));
        MatcherAssert.assertThat((Object)assignResponse.entity.errorMessages, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{this.getSDUnsupportedError()}));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=77000)
    public void assignSDProjectShouldBeAllowedWhenJSDFlagOn() {
        ParsedResponse createResponse = this.prioritySchemeClient.createWithDefaultMapping(new PrioritySchemeUpdateBean(null, "Priority scheme for JSD", null, null, (List)ImmutableList.of((Object)"4", (Object)"1")));
        MatcherAssert.assertThat((Object)createResponse.statusCode, (Matcher)Matchers.equalTo((Object)201));
        ParsedResponse assignResponse = this.prioritySchemeClient.assign(((PrioritySchemeBean)createResponse.body).getId().longValue(), SERVICE_DESK_PROJECT_KEY, new PrioritySchemeBean.Expand[]{PrioritySchemeBean.Expand.projectKeys});
        MatcherAssert.assertThat((String)"Assigning priority scheme to JSD project was successful", (Object)createResponse.statusCode, (Matcher)Matchers.equalTo((Object)201));
        MatcherAssert.assertThat((String)"JSD priority scheme was assigned correctly", (Object)((PrioritySchemeBean)assignResponse.body).getName(), (Matcher)Matchers.equalTo((Object)"Priority scheme for JSD"));
        MatcherAssert.assertThat((String)"JSD project scheme contains expected priorities", (Object)((PrioritySchemeBean)assignResponse.body).getOptionIds(), (Matcher)Matchers.contains((Object[])new String[]{"4", "1"}));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=77000)
    public void unassignSDProjectShouldBeAllowed() {
        long prioritySchemeId = this.createPriorityScheme("Priority scheme with SD");
        this.backdoor.prioritySchemes().assignProject(prioritySchemeId, SERVICE_DESK_PROJECT_ID);
        ParsedResponse unassignResponse = this.prioritySchemeClient.unassign(prioritySchemeId, SERVICE_DESK_PROJECT_KEY, new PrioritySchemeBean.Expand[0]);
        MatcherAssert.assertThat((Object)unassignResponse.statusCode, (Matcher)Matchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)unassignResponse.entity, (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)((PrioritySchemeBean)unassignResponse.body).getId(), (Matcher)Matchers.equalTo((Object)prioritySchemeId));
    }

    private long createPriorityScheme(String name) {
        return this.backdoor.prioritySchemes().createPriorityScheme(name, "", (List<String>)ImmutableList.of((Object)"1"));
    }

    private String getSDUnsupportedError() {
        return this.backdoor.i18n().getText("admin.issuesettings.priorities.associate.error.sd", "en_US");
    }
}

