/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ProjectCategoryClient;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestProjectCategoryResource
extends BaseJiraRestTest {
    private static final String SELF = "self";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    public static final String CATEGORY_NAME = "category_one";
    public static final String CATEGORY_DESCRIPTION = "description of category one";
    public static final String CATEGORY_NAME_2 = "category_two";
    public static final String CATEGORY_DESCRIPTION_2 = "description of category two";
    public static final String BUSINESS = "business";
    private ProjectCategoryClient preferencesClient;

    @Before
    public void setUpTest() {
        this.preferencesClient = new ProjectCategoryClient(this.environmentData);
        this.backdoor.restoreBlankInstance();
    }

    @After
    public void tearDownTest() {
        this.preferencesClient.cleanUp();
    }

    @Test
    public void emptyAtFirstList() {
        Response response = this.preferencesClient.getAllCategories();
        Assert.assertThat((Object)response, this.hasStatus(Response.Status.OK));
        Assert.assertThat(this.getEntityCollection(response), (Matcher)Matchers.empty());
    }

    @Test
    public void retrievingNonExistingCategoryFails() {
        Response response = this.preferencesClient.getCategory("0");
        Assert.assertThat((Object)response, this.hasStatus(Response.Status.NOT_FOUND));
    }

    @Test
    public void createCategoryWorks() throws Exception {
        Response response = this.preferencesClient.createCategory(CATEGORY_NAME, CATEGORY_DESCRIPTION);
        Map<String, String> entity = this.getEntity(response);
        Assert.assertThat((Object)response, this.hasStatus(Response.Status.CREATED));
        Assert.assertThat(entity, (Matcher)Matchers.hasKey((Object)SELF));
        Assert.assertThat(entity, (Matcher)Matchers.hasKey((Object)ID));
        Assert.assertThat(entity, (Matcher)Matchers.hasEntry((Object)NAME, (Object)CATEGORY_NAME));
        Assert.assertThat(entity, (Matcher)Matchers.hasEntry((Object)DESCRIPTION, (Object)CATEGORY_DESCRIPTION));
    }

    @Test
    public void getCategoryWorks() throws Exception {
        String categoryId = this.withCreatedCategory(CATEGORY_NAME, CATEGORY_DESCRIPTION);
        Response response = this.preferencesClient.getCategory(categoryId);
        Map<String, String> entity = this.getEntity(response);
        Assert.assertThat((Object)response, this.hasStatus(Response.Status.OK));
        Assert.assertThat(entity, (Matcher)Matchers.hasKey((Object)SELF));
        Assert.assertThat(entity, (Matcher)Matchers.hasEntry((Object)ID, (Object)categoryId));
        Assert.assertThat(entity, (Matcher)Matchers.hasEntry((Object)NAME, (Object)CATEGORY_NAME));
        Assert.assertThat(entity, (Matcher)Matchers.hasEntry((Object)DESCRIPTION, (Object)CATEGORY_DESCRIPTION));
    }

    @Test
    public void deletingWorks() throws Exception {
        Response response = this.preferencesClient.createCategory(CATEGORY_NAME, CATEGORY_DESCRIPTION);
        Map<String, String> entity = this.getEntity(response);
        Response response2 = this.preferencesClient.deleteCategory(entity.get(ID));
        Assert.assertThat((Object)response2, this.hasStatus(Response.Status.NO_CONTENT));
    }

    @Test
    public void deletingNonExistentFails() throws Exception {
        Response response = this.preferencesClient.deleteCategory(ID);
        Assert.assertThat((Object)response, this.hasStatus(Response.Status.NOT_FOUND));
    }

    @Test
    public void listCategoriesWorks() throws Exception {
        String categoryId = this.withCreatedCategory(CATEGORY_NAME, CATEGORY_DESCRIPTION);
        this.withCreatedCategory(CATEGORY_NAME_2, CATEGORY_DESCRIPTION_2);
        Response listResponse = this.preferencesClient.getAllCategories();
        Assert.assertThat((Object)listResponse, this.hasStatus(Response.Status.OK));
        Collection<Object> listEntity = this.getEntityCollection(listResponse);
        Assert.assertThat(listEntity, (Matcher)Matchers.hasSize((int)2));
        this.assertDeleted(categoryId);
        Response listResponse2 = this.preferencesClient.getAllCategories();
        Assert.assertThat((Object)listResponse2, this.hasStatus(Response.Status.OK));
        Collection<Object> listEntity2 = this.getEntityCollection(listResponse2);
        Assert.assertThat(listEntity2, (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void testCannotCreateTwoCategoriesWithTheSameName() {
        this.withCreatedCategory(CATEGORY_NAME, CATEGORY_DESCRIPTION);
        Response createResponse = this.preferencesClient.createCategory(CATEGORY_NAME, CATEGORY_DESCRIPTION);
        Assert.assertThat((Object)createResponse.getStatus(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.CONFLICT.getStatusCode()));
    }

    @Test
    public void testProjectCategoryAnonymousAccess() {
        Response response = ((ProjectCategoryClient)this.preferencesClient.anonymous()).getAllCategories();
        Assert.assertThat((Object)response.getStatus(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.UNAUTHORIZED.getStatusCode()));
    }

    @Test
    public void testProjectCategoryAccessibleByUser() {
        this.withCreatedCategory(CATEGORY_NAME, CATEGORY_DESCRIPTION);
        this.withCreatedCategory(CATEGORY_NAME_2, CATEGORY_DESCRIPTION_2);
        Response response = ((ProjectCategoryClient)this.preferencesClient.loginAs("fred")).getAllCategories();
        Assert.assertThat((Object)response, this.hasStatus(Response.Status.OK));
        Collection<Object> listEntity = this.getEntityCollection(response);
        Assert.assertThat(listEntity, (Matcher)Matchers.hasSize((int)2));
    }

    private Map<String, String> getEntity(Response response) {
        return (Map)response.readEntity(Map.class);
    }

    private Collection<Object> getEntityCollection(Response response) {
        return (Collection)response.readEntity(Collection.class);
    }

    private String withCreatedCategory(String name, String description) {
        Response response = this.preferencesClient.createCategory(name, description);
        Map<String, String> entity = this.getEntity(response);
        Assert.assertThat((Object)response, this.hasStatus(Response.Status.CREATED));
        return entity.get(ID);
    }

    private void assertDeleted(String categoryId) {
        Response response = this.preferencesClient.deleteCategory(categoryId);
        Assert.assertThat((Object)response, this.hasStatus(Response.Status.NO_CONTENT));
    }

    private Matcher<Response> hasStatus(final Response.Status status) {
        return new TypeSafeMatcher<Response>(){

            public void describeTo(Description description) {
                description.appendValue((Object)status);
            }

            protected boolean matchesSafely(Response response) {
                return response.getStatus() == status.getStatusCode();
            }
        };
    }
}

