/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.matchers.RegexMatchers;
import com.atlassian.jira.rest.v2.admin.workflowscheme.WorkflowSchemeBean;
import com.atlassian.jira.testkit.beans.WorkflowSchemeData;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Errors;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.testkit.client.restclient.ProjectClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ProjectWorkflowSchemeClient;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@Restore(value="TestProjectRoleResource.xml")
public class TestProjectWorkflowSchemeResource
extends BaseJiraRestTest {
    @Inject
    private com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData;
    private ProjectWorkflowSchemeClient projectWorkflowSchemeClient;
    private ProjectClient projectClient;

    @Before
    public void setUp() {
        this.projectClient = new ProjectClient((JIRAEnvironmentData)this.environmentData);
        this.projectWorkflowSchemeClient = new ProjectWorkflowSchemeClient(this.environmentData);
    }

    @Test
    public void shouldGetProjectWorkflowScheme() {
        Project givenProject = (Project)this.projectClient.getProjects().stream().findFirst().get();
        Response workflowSchemeIdResponse = this.projectWorkflowSchemeClient.getWorkflowSchemeForProject(givenProject.id);
        Response workflowSchemeKeyResponse = this.projectWorkflowSchemeClient.getWorkflowSchemeForProject(givenProject.key);
        Assert.assertThat((Object)workflowSchemeIdResponse.getStatusInfo(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.OK));
        Assert.assertThat((Object)workflowSchemeKeyResponse.getStatusInfo(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.OK));
        WorkflowSchemeBean workflowSchemeId = (WorkflowSchemeBean)workflowSchemeIdResponse.readEntity(WorkflowSchemeBean.class);
        this.assertThatWorkflowScheme(workflowSchemeId);
        WorkflowSchemeBean workflowSchemeKey = (WorkflowSchemeBean)workflowSchemeKeyResponse.readEntity(WorkflowSchemeBean.class);
        this.assertThatWorkflowScheme(workflowSchemeKey);
        WorkflowSchemeData workflowSchemeFromBackdoor = this.backdoor.workflowSchemes().getWorkflowSchemeByProjectName(givenProject.name);
        Assert.assertEquals((Object)workflowSchemeFromBackdoor.getId(), (Object)workflowSchemeId.getId());
        Assert.assertEquals((Object)workflowSchemeFromBackdoor.getName(), (Object)workflowSchemeId.getName());
    }

    @Test
    public void shouldGetErrorWhenProjectNotExist() {
        Response response = this.projectWorkflowSchemeClient.getWorkflowSchemeForProject("UNKNOWN");
        Assert.assertThat((Object)response.getStatusInfo(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.NOT_FOUND));
        this.assertResponseContainsAnyOfErrorMessages(response, "No project could be found with key");
    }

    @Test
    public void shouldGetErrorWhenRequestProjectWorkflowSchemeWithImproperKey() {
        Response response = this.projectWorkflowSchemeClient.getWorkflowSchemeForProject("!@#$^!@#$^!@#$^!@#$^!@#$^!@#$");
        Assert.assertThat((Object)response.getStatusInfo(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.NOT_FOUND));
        this.assertResponseContainsAnyOfErrorMessages(response, "No project could be found with key");
    }

    @Test
    public void shouldReturnErrorWhenUserDoesntHavePermissionsToSeeWorkflowScheme() {
        Project givenProject = (Project)this.projectClient.getProjects().stream().findFirst().get();
        Response response = ((ProjectWorkflowSchemeClient)this.projectWorkflowSchemeClient.loginAs("fred", "fred")).getWorkflowSchemeForProject(givenProject.id);
        Assert.assertThat((Object)response.getStatusInfo(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.FORBIDDEN));
        this.assertResponseContainsAnyOfErrorMessages(response, "You do not have permission to see the workflow scheme for the passed project");
    }

    @Test
    public void shouldReturnErrorWhenUserIsNotAuthorized() {
        Project givenProject = (Project)this.projectClient.getProjects().stream().findFirst().get();
        Response response = ((ProjectWorkflowSchemeClient)this.projectWorkflowSchemeClient.loginAs("fuzik", "guzik")).getWorkflowSchemeForProject(givenProject.id);
        Assert.assertThat((Object)response.getStatusInfo(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.UNAUTHORIZED));
    }

    @Test
    public void shouldReturnErrorWhenUserIsNotAdmin() {
        Project givenProject = (Project)this.projectClient.getProjects().stream().findFirst().get();
        Response response = ((ProjectWorkflowSchemeClient)this.projectWorkflowSchemeClient.anonymous()).getWorkflowSchemeForProject(givenProject.id);
        Assert.assertThat((Object)response.getStatusInfo(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.UNAUTHORIZED));
    }

    private void assertThatWorkflowScheme(WorkflowSchemeBean workflowSchemeId) {
        Assert.assertThat((Object)workflowSchemeId.getId(), (Matcher)CoreMatchers.equalTo((Object)10000L));
        Assert.assertThat((Object)workflowSchemeId.getName(), (Matcher)CoreMatchers.equalTo((Object)"classic"));
        Assert.assertThat((Object)workflowSchemeId.getDescription(), (Matcher)CoreMatchers.equalTo((Object)"classic"));
        Assert.assertThat((Object)workflowSchemeId.getDefaultWorkflow(), (Matcher)CoreMatchers.equalTo((Object)"classic default workflow"));
        Assert.assertTrue((boolean)workflowSchemeId.getIssueTypeMappings().isEmpty());
        Assert.assertFalse((boolean)workflowSchemeId.isDraft());
        Assert.assertThat((Object)workflowSchemeId.getIssueTypes().entrySet().size(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(1))));
    }

    void assertResponseContainsAnyOfErrorMessages(Response response, String ... errorMessageRegexp) {
        Errors errors = (Errors)response.readEntity(Errors.class);
        Iterable regexpMatchers = Iterables.transform(Arrays.asList(errorMessageRegexp), input -> RegexMatchers.regexMatches((String)input));
        Assert.assertThat((Object)ImmutableList.builder().addAll((Iterable)errors.errorMessages).addAll(errors.errors.values()).build(), (Matcher)Matchers.hasItem((Matcher)Matchers.anyOf((Iterable)regexpMatchers)));
    }
}

