/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.rest.internal.v2.retranslatekeys.ReTranslateKeysInternalResource;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.ReTranslateKeysClient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.REFERENCE_PLUGIN})
@Restore(value="TestReTranslateKeysInternalResource.zip")
public class TestReTranslateKeysInternalResource
extends BaseJiraRestTest {
    private static final String SERVICE_ENABLED_PROPERTY_KEY = "com.atlassian.jira.retranslatekeys.enabled";
    private static final String reference_awesome_key = "reference.retranslate.test.awesome";
    private static final String reference_awesome_translation = "Everything Is Awesome!";
    private static final String reference_chinese_key = "reference.retranslate.test.chinese";
    private static final String reference_chinese_translation = "\u8c01\u90fd\u4e0d\u660e\u767d";
    private static final String reference_really_awesome_key = "reference.retranslate.test.really.awesome";
    private static final String reference_really_awesome_translation = "Really Awesome";
    private ReTranslateKeysClient client;

    @Before
    public void setUp() throws Exception {
        this.client = new ReTranslateKeysClient(this.environmentData);
        this.backdoor.systemProperties().setProperty(SERVICE_ENABLED_PROPERTY_KEY, Boolean.TRUE.toString());
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=802000)
    public void whenUsingEndpoints_RejectNonAdminUsers() {
        String entityOrTableName = "blah_table";
        String fieldOrColumnName = "blah_column";
        String throwawayKey = "not.an.important.key";
        String nonAdminUser = "foobar";
        String nonAdminPassword = "foobar";
        this.expectErrorResponses(401, () -> ((ReTranslateKeysClient)this.client.anonymous()).getDryRunResults("blah_table", "blah_column", "not.an.important.key"), () -> ((ReTranslateKeysClient)this.client.anonymous()).performTranslations("blah_table", "blah_column", "not.an.important.key"));
        this.expectErrorResponses(403, () -> ((ReTranslateKeysClient)this.client.loginAs("foobar", "foobar")).getDryRunResults("blah_table", "blah_column", "not.an.important.key"), () -> ((ReTranslateKeysClient)this.client.loginAs("foobar", "foobar")).performTranslations("blah_table", "blah_column", "not.an.important.key"));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=802000)
    public void whenUsingEndpoints_RejectWhenNotEnabled() {
        this.backdoor.systemProperties().unsetProperty(SERVICE_ENABLED_PROPERTY_KEY);
        String entityOrTableName = "blah_table";
        String fieldOrColumnName = "blah_column";
        String throwawayKey = "not.an.important.key";
        this.expectErrorResponses(403, () -> this.asAdmin().getDryRunResults("blah_table", "blah_column", "not.an.important.key"), () -> this.asAdmin().performTranslations("blah_table", "blah_column", "not.an.important.key"));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=802000)
    public void afterReplacingBadCFName_ExpectNoEntriesWhenCallingDryRun() {
        String entityName = "FieldScreen";
        String fieldName = "name";
        this.pingAndExpect(() -> this.asAdmin().getDryRunResults("FieldScreen", "name", reference_awesome_key), 200, reference_awesome_translation);
        this.pingAndExpect(() -> this.asAdmin().performTranslations("FieldScreen", "name", reference_awesome_key), 200, reference_awesome_translation);
        this.pingAndExpect(() -> this.asAdmin().performTranslations("FieldScreen", "name", reference_awesome_key), 200, Collections.emptyList());
        this.pingAndExpect(() -> this.asAdmin().getDryRunResults("FieldScreen", "name", reference_awesome_key), 200, Collections.emptyList());
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=802000)
    public void whenUsingAKeyWithoutATranslation_ExpectError() {
        String entityName = "FieldScreen";
        String fieldName = "name";
        String keyWithoutTranslation = "e";
        this.expectErrorResponses(400, () -> this.asAdmin().getDryRunResults("FieldScreen", "name", "e"), () -> this.asAdmin().performTranslations("FieldScreen", "name", "e"));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=802000)
    public void whenACustomFieldKeyTranslationIsInChinese_ExpectChineseInResponse() {
        String entityName = "FieldScreen";
        String fieldName = "description";
        this.pingAndExpect(() -> this.asAdmin().getDryRunResults("FieldScreen", "description", reference_chinese_key), 200, reference_chinese_translation);
        this.pingAndExpect(() -> this.asAdmin().performTranslations("FieldScreen", "description", reference_chinese_key), 200, reference_chinese_translation);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=802000)
    public void fixTempo_TableTeam_ColumnName() {
        String tableName = "AO_AEFED0_TEAM";
        String columnName = "NAME";
        this.pingAndExpect(() -> this.asAdmin().getDryRunResults("AO_AEFED0_TEAM", "NAME", reference_really_awesome_key), 200, reference_really_awesome_translation);
        this.pingAndExpect(() -> this.asAdmin().performTranslations("AO_AEFED0_TEAM", "NAME", reference_really_awesome_key), 200, reference_really_awesome_translation);
        this.pingAndExpect(() -> this.asAdmin().performTranslations("AO_AEFED0_TEAM", "NAME", reference_really_awesome_key), 200, Collections.emptyList());
        this.pingAndExpect(() -> this.asAdmin().getDryRunResults("AO_AEFED0_TEAM", "NAME", reference_really_awesome_key), 200, Collections.emptyList());
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=802000)
    public void fixTempo_TableTeamV2_ColumnName() {
        String tableName = "AO_AEFED0_TEAM_V2";
        String columnName = "NAME";
        this.pingAndExpect(() -> this.asAdmin().getDryRunResults("AO_AEFED0_TEAM_V2", "NAME", reference_really_awesome_key), 200, reference_really_awesome_translation);
        this.pingAndExpect(() -> this.asAdmin().performTranslations("AO_AEFED0_TEAM_V2", "NAME", reference_really_awesome_key), 200, reference_really_awesome_translation);
        this.pingAndExpect(() -> this.asAdmin().performTranslations("AO_AEFED0_TEAM_V2", "NAME", reference_really_awesome_key), 200, Collections.emptyList());
        this.pingAndExpect(() -> this.asAdmin().getDryRunResults("AO_AEFED0_TEAM_V2", "NAME", reference_really_awesome_key), 200, Collections.emptyList());
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=802000)
    public void whenAKeyIsFoundInAColumnButNoTranslationExists_ExpectError() {
        String tableName = "AO_AEFED0_TEAM";
        String columnName = "NAME";
        String keyWithoutTranslation = "t";
        this.expectErrorResponses(400, () -> this.asAdmin().getDryRunResults("AO_AEFED0_TEAM", "NAME", "t"), () -> this.asAdmin().performTranslations("AO_AEFED0_TEAM", "NAME", "t"));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=802000)
    public void whenMultipleRowsHaveTheKeyInTheSameColumn_ExpectAllToBeTranslated() {
        String tableName = "AO_60DB71_COLUMN";
        String columnName = "NAME";
        List<String> expectedTranslations = Arrays.asList("Everything Is Awesome! FAIL", "La Chanson de Roland was the first Everything Is Awesome! poem", "This is going to be Everything Is Awesome!!", reference_awesome_translation, "    Everything Is Awesome!     ");
        this.pingAndExpect(() -> this.asAdmin().getDryRunResults("AO_60DB71_COLUMN", "NAME", reference_awesome_key), 200, expectedTranslations);
        this.pingAndExpect(() -> this.asAdmin().performTranslations("AO_60DB71_COLUMN", "NAME", reference_awesome_key), 200, expectedTranslations);
        this.pingAndExpect(() -> this.asAdmin().performTranslations("AO_60DB71_COLUMN", "NAME", reference_awesome_key), 200, Collections.emptyList());
        this.pingAndExpect(() -> this.asAdmin().getDryRunResults("AO_60DB71_COLUMN", "NAME", reference_awesome_key), 200, Collections.emptyList());
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=802000)
    public void whenMultipleColumnsInASingleRowHaveTheKey_ExpectOnlyTheTargetColumnToBeTranslated() {
        String tableName = "AO_60DB71_QUICKFILTER";
        String descriptionColumn = "DESCRIPTION";
        String longQueryColumn = "LONG_QUERY";
        String nameColumn = "NAME";
        this.pingAndExpect(() -> this.asAdmin().getDryRunResults("AO_60DB71_QUICKFILTER", "DESCRIPTION", reference_awesome_key), 200, "yyEverything Is Awesome!x1");
        this.pingAndExpect(() -> this.asAdmin().getDryRunResults("AO_60DB71_QUICKFILTER", "LONG_QUERY", reference_awesome_key), 200, reference_awesome_translation);
        this.pingAndExpect(() -> this.asAdmin().getDryRunResults("AO_60DB71_QUICKFILTER", "NAME", reference_awesome_key), 200, "also an Everything Is Awesome!");
        this.pingAndExpect(() -> this.asAdmin().performTranslations("AO_60DB71_QUICKFILTER", "DESCRIPTION", reference_awesome_key), 200, "yyEverything Is Awesome!x1");
        this.pingAndExpect(() -> this.asAdmin().getDryRunResults("AO_60DB71_QUICKFILTER", "DESCRIPTION", reference_awesome_key), 200, Collections.emptyList());
        this.pingAndExpect(() -> this.asAdmin().getDryRunResults("AO_60DB71_QUICKFILTER", "LONG_QUERY", reference_awesome_key), 200, reference_awesome_translation);
        this.pingAndExpect(() -> this.asAdmin().getDryRunResults("AO_60DB71_QUICKFILTER", "NAME", reference_awesome_key), 200, "also an Everything Is Awesome!");
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=802000)
    public void whenKeyInAOTableTranslatesToChinese_ExpectChineseResponse() {
        String tableName = "AO_60DB71_SWIMLANE";
        String columnName = "NAME";
        this.pingAndExpect(() -> this.asAdmin().getDryRunResults("AO_60DB71_SWIMLANE", "NAME", reference_chinese_key), 200, reference_chinese_translation);
        this.pingAndExpect(() -> this.asAdmin().performTranslations("AO_60DB71_SWIMLANE", "NAME", reference_chinese_key), 200, reference_chinese_translation);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=802000)
    public void whenUnknownTableIsSpecified_ExpectValidationErrorResponse() {
        String expectedErrorMsg = "Unrecognized table name ";
        String someKey = "some.key";
        this.expectErrorResponses(400, "Unrecognized table name ", () -> this.asAdmin().getDryRunResults("AO_UNKNOWN", "NAME", "some.key"), () -> this.asAdmin().performTranslations("AO_UNKNOWN", "NAME", "some.key"));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=802000)
    public void whenUnkownColumnIsSpecified_ExpectValidationErrorResponse() {
        String expectedErrorMsg = "Unrecognized column name ";
        String validTable = "AO_60DB71_SWIMLANE";
        String someKey = "some.key";
        this.expectErrorResponses(400, "Unrecognized column name ", () -> this.asAdmin().getDryRunResults("AO_60DB71_SWIMLANE", "LE_NOM", "some.key"), () -> this.asAdmin().performTranslations("AO_60DB71_SWIMLANE", "NOMBRE", "some.key"));
    }

    @SafeVarargs
    private final void expectErrorResponses(int expectedErrorCode, String expectedErrorMsgFragment, Supplier<ParsedResponse<?>> ... badRequests) {
        Assert.assertTrue((String)"why are you making assertions on an empty list of requests?  = _ =", (badRequests.length > 0 ? 1 : 0) != 0);
        Arrays.asList(badRequests).forEach(ping -> Assert.assertEquals((long)expectedErrorCode, (long)((ParsedResponse)ping.get()).statusCode));
    }

    @SafeVarargs
    private final void expectErrorResponses(int expectedErrorCode, Supplier<ParsedResponse<?>> ... badRequests) {
        this.expectErrorResponses(expectedErrorCode, "", badRequests);
    }

    private void pingAndExpect(Supplier<ParsedResponse<List<ReTranslateKeysInternalResource.BeforeAfterBean>>> restCall, int expectedStatusCode, String expectedTranslation) {
        this.pingAndExpect(restCall, expectedStatusCode, Arrays.asList(expectedTranslation));
    }

    private void pingAndExpect(Supplier<ParsedResponse<List<ReTranslateKeysInternalResource.BeforeAfterBean>>> restCall, int expectedStatusCode, Collection<String> expectedTranslations) {
        ParsedResponse<List<ReTranslateKeysInternalResource.BeforeAfterBean>> results = restCall.get();
        Assert.assertEquals((long)expectedStatusCode, (long)results.statusCode);
        Assert.assertEquals((long)expectedTranslations.size(), (long)((List)results.body).size());
        List translations = ((List)results.body).stream().map(ReTranslateKeysInternalResource.BeforeAfterBean::getTranslation).collect(Collectors.toList());
        Assert.assertTrue((boolean)translations.containsAll(expectedTranslations));
        Assert.assertTrue((boolean)expectedTranslations.containsAll(translations));
    }

    private ReTranslateKeysClient asAdmin() {
        return (ReTranslateKeysClient)this.client.loginAs("admin", "admin");
    }
}

