/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import com.atlassian.jira.webtests.ztests.indexing.ReindexIssueClient;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@Restore(value="TestEditIssue.xml")
public class TestReindexIssue
extends BaseJiraFuncTest {
    private ReindexIssueClient reindexIssueClient;

    @Before
    public void setUp() {
        this.reindexIssueClient = new ReindexIssueClient(this.environmentData);
    }

    @Test
    public void testReindexIssueByKey() {
        this.backdoor.indexing().deindex("MKY-1");
        SearchResult result = this.backdoor.search().getSearch(new SearchRequest().jql("issuekey = 'MKY-1'"));
        Assert.assertEquals((String)"Should not find issue.", Collections.emptyList(), (Object)result.issues);
        ParsedResponse<?> response = this.reindexIssueClient.reindexIssue("MKY-1");
        Assert.assertEquals((String)"Wrong status code.", (long)200L, (long)response.statusCode);
        result = this.backdoor.search().getSearch(new SearchRequest().jql("issuekey = 'MKY-1'"));
        Assert.assertEquals((String)"Issue not found.", (long)1L, (long)result.issues.size());
    }

    @Test
    public void testReindexIssueById() {
        this.backdoor.indexing().deindex("MKY-1");
        SearchResult result = this.backdoor.search().getSearch(new SearchRequest().jql("issuekey = 'MKY-1'"));
        Assert.assertEquals((String)"Should not find issue.", Collections.emptyList(), (Object)result.issues);
        ParsedResponse<?> response = this.reindexIssueClient.reindexIssue("10001");
        Assert.assertEquals((String)"Wrong status code.", (long)200L, (long)response.statusCode);
        result = this.backdoor.search().getSearch(new SearchRequest().jql("issuekey = 'MKY-1'"));
        Assert.assertEquals((String)"Issue not found.", (long)1L, (long)result.issues.size());
    }

    @Test
    public void testReindexMultipleIssues() {
        this.backdoor.indexing().deindex("MKY-1");
        this.backdoor.indexing().deindex("MKY-2");
        SearchResult result = this.backdoor.search().getSearch(new SearchRequest().jql("issuekey = 'MKY-1'"));
        Assert.assertEquals((String)"Should not find issue.", Collections.emptyList(), (Object)result.issues);
        result = this.backdoor.search().getSearch(new SearchRequest().jql("issuekey = 'MKY-2'"));
        Assert.assertEquals((String)"Should not find issue.", Collections.emptyList(), (Object)result.issues);
        ParsedResponse<?> response = this.reindexIssueClient.reindexIssue("MKY-1", "MKY-2");
        Assert.assertEquals((String)"Wrong status code.", (long)200L, (long)response.statusCode);
        result = this.backdoor.search().getSearch(new SearchRequest().jql("issuekey = 'MKY-1'"));
        Assert.assertEquals((String)"Issue not found.", (long)1L, (long)result.issues.size());
        result = this.backdoor.search().getSearch(new SearchRequest().jql("issuekey = 'MKY-2'"));
        Assert.assertEquals((String)"Issue not found.", (long)1L, (long)result.issues.size());
    }

    @Test
    public void testReindexIssueNotFound() {
        ParsedResponse<?> response = this.reindexIssueClient.reindexIssue("GALAH");
        Assert.assertEquals((String)"Wrong status code.", (long)404L, (long)response.statusCode);
    }
}

