/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.RemoteIssueLinkCreateOrUpdateRequest;
import com.atlassian.jira.rest.api.issue.RemoteIssueLinkCreateOrUpdateResponse;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.RemoteIssueLink;
import com.google.inject.Inject;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.ObjectUtils;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@Restore(value="TestRemoteIssueLinkResource.xml")
public class TestRemoteIssueLinkResource
extends BaseJiraFuncTest {
    private static final String ISSUE_KEY = "HSP-1";
    private static final String ANOTHER_ISSUE_KEY = "HSP-2";
    private static final String THIRD_ISSUE_KEY = "HSP-3";
    private static final String ISSUE_THAT_DOES_NOT_EXIST = "HSP-999";
    private static final String LINK_ID_THAT_DOES_NOT_EXIST = "-1";
    private static final String BLANK = "    ";
    private static final String INVALID_URI = "this is not a valid URI";
    private static int BAD_REQUEST = Response.Status.BAD_REQUEST.getStatusCode();
    private static int CREATED = Response.Status.CREATED.getStatusCode();
    private static int FORBIDDEN = Response.Status.FORBIDDEN.getStatusCode();
    private static int NOT_FOUND = Response.Status.NOT_FOUND.getStatusCode();
    private static int NO_CONTENT = Response.Status.NO_CONTENT.getStatusCode();
    @Inject
    Administration administration;
    private IssueClient issueClient;

    @Test
    public void testCreate() {
        this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest());
    }

    @Test
    public void testCreateReturnsLocationHeader() {
        Response response = this.issueClient.createOrUpdateRemoteIssueLinkAndGetClientResponse(ISSUE_KEY, this.populatedCreateOrUpdateRequest());
        Assert.assertEquals((long)CREATED, (long)response.getStatus());
        RemoteIssueLinkCreateOrUpdateResponse entity = (RemoteIssueLinkCreateOrUpdateResponse)response.readEntity(RemoteIssueLinkCreateOrUpdateResponse.class);
        URI expectedLocation = URI.create(this.environmentData.getBaseUrl() + "/rest/api/2/issue/" + ISSUE_KEY + "/remotelink/" + entity.id().toString());
        Assert.assertEquals((Object)expectedLocation, (Object)response.getLocation());
    }

    @Test
    public void testCreateAndThenUpdate() {
        Long createId = this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest()).id();
        Long updateId = this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest()).id();
        Assert.assertEquals((Object)createId, (Object)updateId);
    }

    @Test
    public void testMultipleCreatesWithoutGlobalId() {
        RemoteIssueLinkCreateOrUpdateRequest request = this.populatedCreateOrUpdateRequest().globalId(null);
        Long id1 = this.createOrUpdateExpectingSuccess(ISSUE_KEY, request).id();
        Long id2 = this.createOrUpdateExpectingSuccess(ISSUE_KEY, request).id();
        Assert.assertFalse((boolean)id1.equals(id2));
    }

    @Test
    public void testCreateWithoutNonRequiredFields() {
        RemoteIssueLinkCreateOrUpdateRequest request = this.populatedCreateOrUpdateRequest().globalId(null).summary(null).iconUrl(null).iconTitle(null).relationship(null).resolved(null).statusIconUrl(null).statusIconTitle(null).statusIconLink(null).applicationType(null).applicationName(null);
        this.createOrUpdateExpectingSuccess(ISSUE_KEY, request);
    }

    @Test
    public void testCreateWithBlankNonRequiredFields() {
        RemoteIssueLinkCreateOrUpdateRequest request = this.populatedCreateOrUpdateRequest().globalId(BLANK).summary(BLANK).iconUrl("").iconTitle(BLANK).relationship(BLANK).statusIconUrl("").statusIconTitle(BLANK).statusIconLink("").applicationType(BLANK).applicationName(BLANK);
        this.createOrUpdateExpectingSuccess(ISSUE_KEY, request);
    }

    @Test
    public void testCreateWithoutRequiredFields() {
        this.createOrUpdateExpectingFailure(ISSUE_KEY, this.populatedCreateOrUpdateRequest().title(null), BAD_REQUEST, "title");
        this.createOrUpdateExpectingFailure(ISSUE_KEY, this.populatedCreateOrUpdateRequest().url(null), BAD_REQUEST, "url");
    }

    @Test
    public void testCreateWithBlankRequiredFields() {
        this.createOrUpdateExpectingFailure(ISSUE_KEY, this.populatedCreateOrUpdateRequest().title(BLANK), BAD_REQUEST, "title");
        this.createOrUpdateExpectingFailure(ISSUE_KEY, this.populatedCreateOrUpdateRequest().url(BLANK), BAD_REQUEST, "url");
    }

    @Test
    public void testCreateWithInvalidIssue() {
        this.createOrUpdateExpectingFailure(ISSUE_THAT_DOES_NOT_EXIST, this.populatedCreateOrUpdateRequest(), NOT_FOUND, new String[0]);
    }

    @Test
    public void testCreateWithInvalidUrls() {
        this.createOrUpdateExpectingFailure(ISSUE_KEY, this.populatedCreateOrUpdateRequest().url(INVALID_URI), BAD_REQUEST, "url");
        this.createOrUpdateExpectingFailure(ISSUE_KEY, this.populatedCreateOrUpdateRequest().iconUrl(INVALID_URI), BAD_REQUEST, "iconUrl");
        this.createOrUpdateExpectingFailure(ISSUE_KEY, this.populatedCreateOrUpdateRequest().statusIconUrl(INVALID_URI), BAD_REQUEST, "statusIconUrl");
        this.createOrUpdateExpectingFailure(ISSUE_KEY, this.populatedCreateOrUpdateRequest().statusIconLink(INVALID_URI), BAD_REQUEST, "statusIconLink");
    }

    @Test
    public void testCreateWhenLinkingDisabled() {
        this.administration.issueLinking().disable();
        this.createOrUpdateExpectingFailure(ISSUE_KEY, this.populatedCreateOrUpdateRequest(), FORBIDDEN, new String[0]);
    }

    @Test
    public void testUpdate() {
        String linkId = this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest()).id().toString();
        this.updateExpectingSuccess(ISSUE_KEY, linkId, this.populatedCreateOrUpdateRequest());
    }

    @Test
    public void testUpdateWithoutNonRequiredFields() {
        String linkId = this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest()).id().toString();
        RemoteIssueLinkCreateOrUpdateRequest request = this.populatedCreateOrUpdateRequest().globalId(null).summary(null).iconUrl(null).iconTitle(null).relationship(null).resolved(null).statusIconUrl(null).statusIconTitle(null).statusIconLink(null).applicationType(null).applicationName(null);
        this.updateExpectingSuccess(ISSUE_KEY, linkId, request);
    }

    @Test
    public void testUpdateWithBlankNonRequiredFields() {
        String linkId = this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest()).id().toString();
        RemoteIssueLinkCreateOrUpdateRequest request = this.populatedCreateOrUpdateRequest().globalId(BLANK).summary(BLANK).iconUrl("").iconTitle(BLANK).relationship(BLANK).statusIconUrl("").statusIconTitle(BLANK).statusIconLink("").applicationType(BLANK).applicationName(BLANK);
        this.updateExpectingSuccess(ISSUE_KEY, linkId, request);
    }

    @Test
    public void testUpdateWithoutRequiredFields() {
        String linkId = this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest()).id().toString();
        this.updateExpectingFailure(ISSUE_KEY, linkId, this.populatedCreateOrUpdateRequest().title(null), BAD_REQUEST, "title");
        this.updateExpectingFailure(ISSUE_KEY, linkId, this.populatedCreateOrUpdateRequest().url(null), BAD_REQUEST, "url");
    }

    @Test
    public void testUpdateWithBlankRequiredFields() {
        String linkId = this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest()).id().toString();
        this.updateExpectingFailure(ISSUE_KEY, linkId, this.populatedCreateOrUpdateRequest().title(BLANK), BAD_REQUEST, "title");
        this.updateExpectingFailure(ISSUE_KEY, linkId, this.populatedCreateOrUpdateRequest().url(BLANK), BAD_REQUEST, "url");
    }

    @Test
    public void testUpdateWithInvalidIssue() {
        String linkId = this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest()).id().toString();
        this.updateExpectingFailure(ISSUE_THAT_DOES_NOT_EXIST, linkId, this.populatedCreateOrUpdateRequest(), NOT_FOUND, new String[0]);
    }

    @Test
    public void testUpdateWithInvalidLinkId() {
        this.updateExpectingFailure(ISSUE_KEY, LINK_ID_THAT_DOES_NOT_EXIST, this.populatedCreateOrUpdateRequest(), NOT_FOUND, new String[0]);
    }

    @Test
    public void testUpdateWithInvalidUrls() {
        String linkId = this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest()).id().toString();
        this.updateExpectingFailure(ISSUE_KEY, linkId, this.populatedCreateOrUpdateRequest().url(INVALID_URI), BAD_REQUEST, "url");
        this.updateExpectingFailure(ISSUE_KEY, linkId, this.populatedCreateOrUpdateRequest().iconUrl(INVALID_URI), BAD_REQUEST, "iconUrl");
        this.updateExpectingFailure(ISSUE_KEY, linkId, this.populatedCreateOrUpdateRequest().statusIconUrl(INVALID_URI), BAD_REQUEST, "statusIconUrl");
        this.updateExpectingFailure(ISSUE_KEY, linkId, this.populatedCreateOrUpdateRequest().statusIconLink(INVALID_URI), BAD_REQUEST, "statusIconLink");
    }

    @Test
    public void testUpdateWhenLinkingDisabled() {
        String linkId = this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest()).id().toString();
        this.administration.issueLinking().disable();
        this.updateExpectingFailure(ISSUE_KEY, linkId, this.populatedCreateOrUpdateRequest(), FORBIDDEN, new String[0]);
    }

    @Test
    public void testDelete() {
        String id = this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest()).id().toString();
        this.deleteExpectingSuccess(ISSUE_KEY, id);
    }

    @Test
    public void testDeleteIdDoesNotExist() {
        this.deleteExpectingFailure(ISSUE_KEY, LINK_ID_THAT_DOES_NOT_EXIST, NOT_FOUND, new String[0]);
    }

    @Test
    public void testDeleteIdNotNumeric() {
        this.deleteExpectingFailure(ISSUE_KEY, "99a", BAD_REQUEST, new String[0]);
    }

    @Test
    public void testDeleteWhenLinkingDisabled() {
        String id = this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest()).id().toString();
        this.administration.issueLinking().disable();
        this.deleteExpectingFailure(ISSUE_KEY, id, FORBIDDEN, new String[0]);
    }

    @Test
    public void testDeleteByGlobalId() {
        String globalId = UUID.randomUUID().toString();
        this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest().globalId(globalId)).id().toString();
        this.deleteByGlobalIdExpectingSuccess(ISSUE_KEY, globalId);
    }

    @Test
    public void testDeleteByGlobalIdDeletesMany() {
        this.deleteByGlobalIdExpectingSuccess(THIRD_ISSUE_KEY, "example.org");
    }

    @Test
    public void testDeleteByGlobalIdWhenGlobalIdDoesNotExist() {
        String globalId = UUID.randomUUID().toString();
        this.deleteByGlobalIdExpectingFailure(ISSUE_KEY, globalId, NOT_FOUND, new String[0]);
    }

    @Test
    public void testDeleteByGlobalIdWhenLinkingDisabled() {
        String globalId = UUID.randomUUID().toString();
        this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest().globalId(globalId));
        this.administration.issueLinking().disable();
        this.deleteByGlobalIdExpectingFailure(ISSUE_KEY, globalId, FORBIDDEN, new String[0]);
    }

    @Test
    public void testGetWhenDoesNotExist() {
        ParsedResponse response = this.issueClient.getRemoteIssueLinkResponse(ISSUE_KEY, LINK_ID_THAT_DOES_NOT_EXIST);
        this.assertFailure(response, NOT_FOUND, new String[0]);
    }

    @Test
    public void testGetWhenLinkingDisabled() {
        String id = this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest()).id().toString();
        this.administration.issueLinking().disable();
        ParsedResponse response = this.issueClient.getRemoteIssueLinkResponse(ISSUE_KEY, id);
        this.assertFailure(response, FORBIDDEN, new String[0]);
    }

    @Test
    public void testGetForIssue() {
        RemoteIssueLinkCreateOrUpdateRequest request1 = this.populatedCreateOrUpdateRequest();
        RemoteIssueLinkCreateOrUpdateRequest request2 = this.populatedCreateOrUpdateRequest("6789");
        RemoteIssueLinkCreateOrUpdateRequest request3 = this.populatedCreateOrUpdateRequest("999");
        RemoteIssueLinkCreateOrUpdateResponse response1 = this.createOrUpdateExpectingSuccess(ISSUE_KEY, request1);
        RemoteIssueLinkCreateOrUpdateResponse response2 = this.createOrUpdateExpectingSuccess(ISSUE_KEY, request2);
        this.createOrUpdateExpectingSuccess(ANOTHER_ISSUE_KEY, request3);
        List linksAfter = this.issueClient.getRemoteIssueLinks(ISSUE_KEY);
        Assert.assertEquals((long)2L, (long)linksAfter.size());
        if (response1.id().equals(((RemoteIssueLink)linksAfter.get((int)0)).id)) {
            this.assertRequestEqualsLink(request1, (RemoteIssueLink)linksAfter.get(0));
        } else if (response1.id().equals(((RemoteIssueLink)linksAfter.get((int)1)).id)) {
            this.assertRequestEqualsLink(request1, (RemoteIssueLink)linksAfter.get(1));
        } else {
            Assert.fail((String)"The remote issue link was not found in the links for issue query");
        }
        if (response2.id().equals(((RemoteIssueLink)linksAfter.get((int)0)).id)) {
            this.assertRequestEqualsLink(request2, (RemoteIssueLink)linksAfter.get(0));
        } else if (response2.id().equals(((RemoteIssueLink)linksAfter.get((int)1)).id)) {
            this.assertRequestEqualsLink(request2, (RemoteIssueLink)linksAfter.get(1));
        } else {
            Assert.fail((String)"The remote issue link was not found in the links for issue query");
        }
    }

    @Test
    public void testGetForIssueWhenLinkingDisabled() {
        this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest());
        this.administration.issueLinking().disable();
        ParsedResponse response = this.issueClient.getRemoteIssueLinksResponse(ISSUE_KEY);
        this.assertFailure(response, FORBIDDEN, new String[0]);
    }

    @Test
    public void testGetByGlobalId() {
        String globalId = "url=http://www.blah.com&id=99999";
        Long id = this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest().globalId("url=http://www.blah.com&id=99999")).id();
        this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest());
        this.createOrUpdateExpectingSuccess(ANOTHER_ISSUE_KEY, this.populatedCreateOrUpdateRequest().globalId("url=http://www.blah.com&id=99999"));
        RemoteIssueLink found = this.issueClient.getRemoteIssueLinkByGlobalId(ISSUE_KEY, "url=http://www.blah.com&id=99999");
        Assert.assertEquals((Object)id, (Object)found.id);
        Assert.assertEquals((Object)"url=http://www.blah.com&id=99999", (Object)found.globalId);
    }

    private RemoteIssueLinkCreateOrUpdateResponse createOrUpdateExpectingSuccess(String issueKey, RemoteIssueLinkCreateOrUpdateRequest request) {
        RemoteIssueLinkCreateOrUpdateResponse response = this.issueClient.createOrUpdateRemoteIssueLink(issueKey, request);
        Assert.assertNotNull((Object)response.id());
        Assert.assertEquals((Object)(this.environmentData.getBaseUrl() + "/rest/api/2/issue/" + issueKey + "/remotelink/" + response.id().toString()), (Object)response.self());
        this.assertExists(issueKey, response.id(), request);
        return response;
    }

    private ParsedResponse createOrUpdateExpectingFailure(String issueKey, RemoteIssueLinkCreateOrUpdateRequest request, int statusCode, String ... erroneousFields) {
        ParsedResponse response = this.issueClient.createOrUpdateRemoteIssueLinkAndGetResponse(issueKey, request);
        this.assertFailure(response, statusCode, erroneousFields);
        return response;
    }

    private ParsedResponse updateExpectingSuccess(String issueKey, String linkId, RemoteIssueLinkCreateOrUpdateRequest request) {
        ParsedResponse response = this.issueClient.updateRemoteIssueLink(issueKey, linkId, request);
        Assert.assertEquals((long)NO_CONTENT, (long)response.statusCode);
        this.assertExists(issueKey, new Long(linkId), request);
        return response;
    }

    private ParsedResponse updateExpectingFailure(String issueKey, String linkId, RemoteIssueLinkCreateOrUpdateRequest request, int statusCode, String ... erroneousFields) {
        ParsedResponse response = this.issueClient.updateRemoteIssueLink(issueKey, linkId, request);
        this.assertFailure(response, statusCode, erroneousFields);
        return response;
    }

    private ParsedResponse deleteExpectingSuccess(String issueKey, String remoteIssueLinkId) {
        ParsedResponse response = this.issueClient.deleteRemoteIssueLink(issueKey, remoteIssueLinkId);
        this.assertNotExists(issueKey, remoteIssueLinkId);
        return response;
    }

    private ParsedResponse deleteExpectingFailure(String issueKey, String remoteIssueLinkId, int statusCode, String ... erroneousFields) {
        ParsedResponse response = this.issueClient.deleteRemoteIssueLink(issueKey, remoteIssueLinkId);
        this.assertFailure(response, statusCode, erroneousFields);
        return response;
    }

    private ParsedResponse deleteByGlobalIdExpectingSuccess(String issueKey, String globalId) {
        ParsedResponse response = this.issueClient.deleteRemoteIssueLinkByGlobalId(issueKey, globalId);
        List remoteIssueLinks = this.issueClient.getRemoteIssueLinks(issueKey);
        Assert.assertThat((Object)remoteIssueLinks, (Matcher)Matchers.not((Matcher)Matchers.hasItem(TestRemoteIssueLinkResource.withGlobalId(globalId))));
        return response;
    }

    private ParsedResponse deleteByGlobalIdExpectingFailure(String issueKey, String globalId, int statusCode, String ... erroneousFields) {
        ParsedResponse response = this.issueClient.deleteRemoteIssueLinkByGlobalId(issueKey, globalId);
        this.assertFailure(response, statusCode, erroneousFields);
        return response;
    }

    private void assertExists(String issueKey, Long remoteIssueLinkId, RemoteIssueLinkCreateOrUpdateRequest request) {
        RemoteIssueLink found = this.issueClient.getRemoteIssueLink(issueKey, remoteIssueLinkId.toString());
        Assert.assertEquals((Object)remoteIssueLinkId, (Object)found.id);
        this.assertRequestEqualsLink(request, found);
    }

    private void assertNotExists(String issueKey, String remoteIssueLinkId) {
        ParsedResponse response = this.issueClient.getRemoteIssueLinkResponse(issueKey, remoteIssueLinkId);
        Assert.assertEquals((long)NOT_FOUND, (long)response.statusCode);
    }

    private void assertRequestEqualsLink(RemoteIssueLinkCreateOrUpdateRequest request, RemoteIssueLink remoteIssueLink) {
        Assert.assertEquals((Object)request.globalId(), (Object)remoteIssueLink.globalId);
        Assert.assertEquals((Object)request.title(), (Object)remoteIssueLink.object.title);
        Assert.assertEquals((Object)request.summary(), (Object)remoteIssueLink.object.summary);
        Assert.assertEquals((Object)request.url(), (Object)remoteIssueLink.object.url);
        Assert.assertEquals((Object)request.iconUrl(), (Object)remoteIssueLink.object.icon.url16x16);
        Assert.assertEquals((Object)request.iconTitle(), (Object)remoteIssueLink.object.icon.title);
        Assert.assertEquals((Object)request.relationship(), (Object)remoteIssueLink.relationship);
        Assert.assertEquals((Object)request.resolved(), (Object)remoteIssueLink.object.status.resolved);
        Assert.assertEquals((Object)request.statusIconUrl(), (Object)remoteIssueLink.object.status.icon.url16x16);
        Assert.assertEquals((Object)request.statusIconTitle(), (Object)remoteIssueLink.object.status.icon.title);
        Assert.assertEquals((Object)request.statusIconLink(), (Object)remoteIssueLink.object.status.icon.link);
        Assert.assertEquals((Object)request.applicationType(), (Object)remoteIssueLink.application.type);
        Assert.assertEquals((Object)request.applicationName(), (Object)remoteIssueLink.application.name);
    }

    private void assertFailure(ParsedResponse response, int statusCode, String ... erroneousFields) {
        Assert.assertEquals((long)statusCode, (long)response.statusCode);
        for (String erroneousField : erroneousFields) {
            Assert.assertTrue((boolean)response.entity.errors.containsKey(erroneousField));
        }
    }

    private RemoteIssueLinkCreateOrUpdateRequest populatedCreateOrUpdateRequest() {
        return this.populatedCreateOrUpdateRequest("12345");
    }

    private RemoteIssueLinkCreateOrUpdateRequest populatedCreateOrUpdateRequest(String remoteId) {
        return new RemoteIssueLinkCreateOrUpdateRequest().globalId("url=http://www.remoteapplication.com&id=" + remoteId).title("Ticket #" + remoteId).summary("Summary of the ticket goes here").url("http://www.remoteapplication.com/ticket/" + remoteId).iconUrl("http://www.remoteapplication.com/images/ticket.gif").iconTitle("Ticket").relationship("relates to").resolved(Boolean.valueOf(false)).statusIconUrl("http://www.remoteapplication.com/images/status.gif").statusIconTitle("Status").statusIconLink("http://www.remoteapplication.com/blah").applicationType("com.mycompany.myhelpdesksystem").applicationName("My Company IT Helpdesk");
    }

    @Before
    public void setUp() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
    }

    static Matcher<RemoteIssueLink> withGlobalId(String globalId) {
        return new RemoteIssueLinkGlobalIdIsEqual(globalId);
    }

    private static class RemoteIssueLinkGlobalIdIsEqual
    extends BaseMatcher<RemoteIssueLink> {
        private final String globalId;

        public RemoteIssueLinkGlobalIdIsEqual(String globalId) {
            this.globalId = globalId;
        }

        public boolean matches(Object o) {
            RemoteIssueLink link = (RemoteIssueLink)o;
            return ObjectUtils.equals((Object)link.globalId, (Object)this.globalId);
        }

        public void describeTo(Description desc) {
            desc.appendText("{globalId is ").appendValue((Object)this.globalId).appendText("}");
        }
    }
}

