/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestSettingsResource
extends BaseJiraFuncTest {
    private SettingsResourceClient client;

    @Before
    public void setUp() {
        this.client = new SettingsResourceClient(this.getEnvironmentData());
    }

    @After
    public void websudoDisable() {
        this.backdoor.websudo().disable();
    }

    @Test
    public void testBaseUrlWithWebsudoEnabled() {
        this.backdoor.websudo().enable();
        ParsedResponse response = this.client.getBaseUrlResponse();
        Assert.assertEquals((long)401L, (long)response.statusCode);
    }

    @Test
    public void testBaseUrlWithWebsudoDisabled() {
        ParsedResponse response = this.client.getBaseUrlResponse();
        Assert.assertEquals((long)204L, (long)response.statusCode);
    }

    @Test
    public void testColumnsWithWebsudoEnabled() {
        this.backdoor.websudo().enable();
        ParsedResponse response = this.client.getColumnsResponse();
        Assert.assertEquals((long)401L, (long)response.statusCode);
    }

    @Test
    public void testColumnsWithWebsudoDisabled() {
        ParsedResponse response = this.client.getColumnsResponse();
        Assert.assertEquals((long)200L, (long)response.statusCode);
    }

    @Test
    public void testUpdateColumnsWithWebsudoEnabled() {
        this.backdoor.websudo().enable();
        ParsedResponse response = this.client.updateColumnsResponse();
        Assert.assertEquals((long)401L, (long)response.statusCode);
    }

    @Test
    public void testUpdateColumnsWithWebsudoDisabled() {
        ParsedResponse response = this.client.updateColumnsResponse();
        Assert.assertEquals((long)200L, (long)response.statusCode);
    }

    public static class SettingsResourceClient
    extends RestApiClient<SettingsResourceClient> {
        public SettingsResourceClient(JIRAEnvironmentData environmentData) {
            super(environmentData);
        }

        public ParsedResponse getBaseUrlResponse() {
            WebTarget webTarget = this.createResource().path("settings").path("baseUrl");
            return this.toResponse(() -> (Response)webTarget.request().put(Entity.json((Object)"https://example.com"), Response.class));
        }

        public ParsedResponse getColumnsResponse() {
            WebTarget webTarget = this.createResource().path("settings").path("columns");
            return this.toResponse(() -> (Response)webTarget.request().get(Response.class));
        }

        public ParsedResponse updateColumnsResponse() {
            WebTarget updateColumnsResource = this.createResource().path("settings").path("columns");
            return this.toResponse(() -> (Response)updateColumnsResource.request().put(Entity.form((Form)new Form()), Response.class));
        }
    }
}

