/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.FuncTestUrlHelper;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.Status;
import com.atlassian.jira.testkit.client.restclient.StatusClient;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@Restore(value="TestStatusResource.xml")
public class TestStatusResource
extends BaseJiraRestTest {
    private static final String STATUS_ID = "10000";
    private static final String STATUS_NAME = "Insane";
    private static final String STATUS_NAME_TRANSLATED = "NotStarted";
    private StatusClient statusClient;
    @Inject
    private FuncTestUrlHelper urlHelper;

    @Before
    public void setUpTest() {
        this.statusClient = new StatusClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testStatusReturned() throws Exception {
        Status status = this.statusClient.get(STATUS_ID);
        Assert.assertEquals((Object)this.urlHelper.getBaseUrlPlus("rest/api/2/status/10000"), (Object)status.self());
        Assert.assertEquals((Object)"Custom status", (Object)status.description());
        Assert.assertEquals((Object)this.urlHelper.getBaseUrlPlus("images/icons/statuses/generic.png"), (Object)status.iconUrl());
        Assert.assertEquals((Object)STATUS_NAME, (Object)status.name());
        Assert.assertEquals((Object)STATUS_ID, (Object)status.id());
        status = this.statusClient.get(STATUS_NAME);
        Assert.assertEquals((Object)this.urlHelper.getBaseUrlPlus("rest/api/2/status/10000"), (Object)status.self());
        Assert.assertEquals((Object)"Custom status", (Object)status.description());
        Assert.assertEquals((Object)this.urlHelper.getBaseUrlPlus("images/icons/statuses/generic.png"), (Object)status.iconUrl());
        Assert.assertEquals((Object)STATUS_NAME, (Object)status.name());
        Assert.assertEquals((Object)STATUS_ID, (Object)status.id());
        status = this.statusClient.get(STATUS_NAME_TRANSLATED);
        Assert.assertEquals((Object)this.urlHelper.getBaseUrlPlus("rest/api/2/status/1"), (Object)status.self());
        Assert.assertEquals((Object)"Translated version of Open", (Object)status.description());
        Assert.assertEquals((Object)this.urlHelper.getBaseUrlPlus("images/icons/statuses/open.png"), (Object)status.iconUrl());
        Assert.assertEquals((Object)STATUS_NAME_TRANSLATED, (Object)status.name());
        Assert.assertEquals((Object)"1", (Object)status.id());
        status = this.statusClient.get("Open");
        Assert.assertEquals((Object)this.urlHelper.getBaseUrlPlus("rest/api/2/status/1"), (Object)status.self());
        Assert.assertEquals((Object)"Translated version of Open", (Object)status.description());
        Assert.assertEquals((Object)this.urlHelper.getBaseUrlPlus("images/icons/statuses/open.png"), (Object)status.iconUrl());
        Assert.assertEquals((Object)STATUS_NAME_TRANSLATED, (Object)status.name());
        Assert.assertEquals((Object)"1", (Object)status.id());
    }

    @Test
    public void testAllStatuses() throws Exception {
        List statuses = this.statusClient.get();
        Assert.assertEquals((long)6L, (long)statuses.size());
        this.assertStatusesContain(statuses, "1");
        this.assertStatusesContain(statuses, "3");
        this.assertStatusesContain(statuses, "4");
        this.assertStatusesContain(statuses, "5");
        this.assertStatusesContain(statuses, "6");
        this.assertStatusesContain(statuses, STATUS_ID);
    }

    private void assertStatusesContain(List<Status> statuses, String id) {
        for (Status status : statuses) {
            if (!status.id().equals(id)) continue;
            return;
        }
        Assert.fail((String)("Status " + id + " not in list"));
    }

    @Test
    public void testStatusFilteredByPermissions() throws Exception {
        ParsedResponse response = ((StatusClient)this.statusClient.loginAs("fred")).getResponse(STATUS_ID);
        Assert.assertEquals((long)404L, (long)response.statusCode);
        response = ((StatusClient)this.statusClient.loginAs("fred")).getResponse(STATUS_NAME);
        Assert.assertEquals((long)404L, (long)response.statusCode);
        List statuses = this.statusClient.get();
        Assert.assertEquals((long)5L, (long)statuses.size());
        this.assertStatusesContain(statuses, "1");
        this.assertStatusesContain(statuses, "3");
        this.assertStatusesContain(statuses, "4");
        this.assertStatusesContain(statuses, "5");
        this.assertStatusesContain(statuses, "6");
    }

    @Test
    public void testStatusDoesntExist() throws Exception {
        ParsedResponse resp123 = this.statusClient.getResponse("123");
        Assert.assertEquals((long)404L, (long)resp123.statusCode);
        Assert.assertEquals((Object)"The status with id '123' does not exist", resp123.entity.errorMessages.get(0));
        ParsedResponse respAbc = this.statusClient.getResponse("abc");
        Assert.assertEquals((long)404L, (long)respAbc.statusCode);
        Assert.assertEquals((Object)"The status with id 'abc' does not exist", respAbc.entity.errorMessages.get(0));
    }
}

