/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@RestoreBlankInstance
public class TestUserResourceForCreateUpdateDelete
extends BaseJiraRestTest {
    private static final String SELF = "self";
    private static final String NAME = "name";
    private static final String KEY = "key";
    private static final String PASSWORD = "password";
    private static final String EMAIL_ADDRESS = "emailAddress";
    private static final String DISPLAY_NAME = "displayName";
    private static final String ACTIVE = "active";
    private static final String KEY_VALUE = "charlie";
    private static final String NAME_VALUE = "Charlie";
    private static final String PASSWORD_VALUE = "abracadabra";
    private static final String EMAIL_ADDRESS_VALUE = "charlie@localhost";
    private static final String DISPLAY_NAME_VALUE = "Charlie of Atlassian";
    private static final String NAME_CHANGED_VALUE = "Charlie2";
    private static final String EMAIL_ADDRESS_CHANGED_VALUE = "charlie2@localhost";
    private static final String DISPLAY_NAME_CHANGED_VALUE = "Charlie of Atlassian II";
    private static final String REST_URL = "/rest/api/2/user?";
    private UserClient userClient;

    @Before
    public void setUpTest() {
        this.userClient = new UserClient(this.environmentData);
    }

    @Test
    public void testHappyPathUseCase() {
        this.thereIsNoUser(KEY_VALUE);
        String createdUserKey = this.createUser();
        this.updateUser(createdUserKey);
        this.changeUserPassword(createdUserKey);
        this.deactivate(createdUserKey);
        this.activate(createdUserKey);
        this.removeExistingUser(createdUserKey);
        this.removeNotExistingUser(createdUserKey);
    }

    private String createUser() {
        Response responseCreate = this.userClient.createUser(NAME_VALUE, PASSWORD_VALUE, EMAIL_ADDRESS_VALUE, DISPLAY_NAME_VALUE);
        Assert.assertThat((Object)responseCreate.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.CREATED.getStatusCode()));
        String createResult = (String)((List)responseCreate.getStringHeaders().get((Object)"Location")).get(0);
        Assert.assertThat((Object)createResult, (Matcher)Matchers.startsWith((String)this.getJiraExperimentalApiUserPath()));
        String createdUserKey = this.verifyCreatedUserAndReturnKey(responseCreate);
        responseCreate.close();
        Response responseRead = this.userClient.getUser(createdUserKey);
        Assert.assertThat((Object)responseRead.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.OK.getStatusCode()));
        this.verifyCreatedUserAndReturnKey(responseRead);
        responseRead.close();
        return createdUserKey;
    }

    private String verifyCreatedUserAndReturnKey(Response responseCreate) {
        UserBean userBean = this.getMapEntity(responseCreate);
        Assert.assertThat((Object)userBean, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)userBean.getName(), (Matcher)Matchers.equalTo((Object)NAME_VALUE));
        Assert.assertThat((Object)userBean.getEmailAddress(), (Matcher)Matchers.equalTo((Object)EMAIL_ADDRESS_VALUE));
        Assert.assertThat((Object)userBean.getDisplayName(), (Matcher)Matchers.equalTo((Object)DISPLAY_NAME_VALUE));
        Assert.assertThat((Object)userBean.getSelf().toString(), (Matcher)Matchers.startsWith((String)this.getJiraExperimentalApiUserPath()));
        return userBean.getKey();
    }

    private String getJiraExperimentalApiUserPath() {
        return this.environmentData.getBaseUrl() + REST_URL;
    }

    private void updateUser(String userKey) {
        Response responseUpdate = this.userClient.updateUser(userKey, NAME_CHANGED_VALUE, EMAIL_ADDRESS_CHANGED_VALUE, DISPLAY_NAME_CHANGED_VALUE);
        Assert.assertThat((Object)responseUpdate.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.OK.getStatusCode()));
        UserBean userBean = this.getMapEntity(responseUpdate);
        responseUpdate.close();
        Assert.assertThat((Object)userBean, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)userBean.getName(), (Matcher)Matchers.equalTo((Object)NAME_CHANGED_VALUE));
        Assert.assertThat((Object)userBean.getEmailAddress(), (Matcher)Matchers.equalTo((Object)EMAIL_ADDRESS_CHANGED_VALUE));
        Assert.assertThat((Object)userBean.getDisplayName(), (Matcher)Matchers.equalTo((Object)DISPLAY_NAME_CHANGED_VALUE));
        Assert.assertThat((Object)userBean.getSelf().toString(), (Matcher)Matchers.startsWith((String)this.getJiraExperimentalApiUserPath()));
    }

    private void deactivate(String userKey) {
        this.verifyStatus(userKey, false);
    }

    private void activate(String userKey) {
        this.verifyStatus(userKey, true);
    }

    private void verifyStatus(String userKey, boolean active) {
        Response responseUpdate = this.userClient.updateStatus(userKey, active);
        Assert.assertThat((Object)responseUpdate.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.OK.getStatusCode()));
        UserBean userBean = this.getMapEntity(responseUpdate);
        responseUpdate.close();
        Assert.assertThat((Object)userBean, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)userBean.isActive(), (Matcher)Matchers.is((Object)active));
    }

    private void changeUserPassword(String userKey) {
        Response response = this.userClient.changePassword(userKey, "hocuspocus");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.NO_CONTENT.getStatusCode()));
        response.close();
    }

    private void removeExistingUser(String userKey) {
        Response response = this.userClient.deleteUser(userKey);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.NO_CONTENT.getStatusCode()));
        response.close();
        this.thereIsNoUser(userKey);
    }

    private void thereIsNoUser(String userKey) {
        Response response = this.userClient.getUser(userKey);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
        response.close();
    }

    private void removeNotExistingUser(String userKey) {
        Response response = this.userClient.deleteUser(userKey);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
        response.close();
    }

    private UserBean getMapEntity(Response responseRead) {
        return (UserBean)responseRead.readEntity(UserBean.class);
    }

    private class UserClient
    extends RestApiClient<UserClient> {
        private static final String USER_PATH = "user";
        private static final String PASSWORD_PATH = "password";
        private final Set<Response> responses;

        protected UserClient(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
            super((JIRAEnvironmentData)environmentData);
            this.responses = Sets.newHashSet();
        }

        protected WebTarget createResource() {
            return this.resourceRoot(TestUserResourceForCreateUpdateDelete.this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("api").path("2");
        }

        private Response createUser(String name, String password, String emailAddress, String displayName) {
            WebTarget webTarget = this.createResource().path(USER_PATH);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)TestUserResourceForCreateUpdateDelete.NAME, (Object)name);
            builder.put((Object)"password", (Object)password);
            builder.put((Object)TestUserResourceForCreateUpdateDelete.EMAIL_ADDRESS, (Object)emailAddress);
            builder.put((Object)TestUserResourceForCreateUpdateDelete.DISPLAY_NAME, (Object)displayName);
            Response response = (Response)webTarget.request(new String[]{"application/json"}).post(Entity.json((Object)builder.build()), Response.class);
            this.responses.add(response);
            return response;
        }

        private Response getUser(String key) {
            Preconditions.checkNotNull((Object)key);
            WebTarget webTarget = this.createResource().path(USER_PATH).queryParam(TestUserResourceForCreateUpdateDelete.KEY, new Object[]{key});
            Response response = (Response)webTarget.request().get(Response.class);
            this.responses.add(response);
            return response;
        }

        private Response updateUser(String key, String name, String emailAddress, String displayName) {
            Preconditions.checkNotNull((Object)key);
            WebTarget webTarget = this.createResource().path(USER_PATH).queryParam(TestUserResourceForCreateUpdateDelete.KEY, new Object[]{key});
            ImmutableMap.Builder builder = ImmutableMap.builder();
            if (name != null) {
                builder.put((Object)TestUserResourceForCreateUpdateDelete.NAME, (Object)name);
            }
            if (emailAddress != null) {
                builder.put((Object)TestUserResourceForCreateUpdateDelete.EMAIL_ADDRESS, (Object)emailAddress);
            }
            if (displayName != null) {
                builder.put((Object)TestUserResourceForCreateUpdateDelete.DISPLAY_NAME, (Object)displayName);
            }
            Response response = (Response)webTarget.request(new String[]{"application/json"}).put(Entity.json((Object)builder.build()), Response.class);
            this.responses.add(response);
            return response;
        }

        private Response updateStatus(String key, boolean active) {
            WebTarget webTarget = this.createResource().path(USER_PATH).queryParam(TestUserResourceForCreateUpdateDelete.KEY, new Object[]{key});
            ImmutableMap.Builder parameters = ImmutableMap.builder();
            parameters.put((Object)TestUserResourceForCreateUpdateDelete.ACTIVE, (Object)active);
            Response response = (Response)webTarget.request(new String[]{"application/json"}).put(Entity.json((Object)parameters.build()), Response.class);
            this.responses.add(response);
            return response;
        }

        private Response changePassword(String key, String password) {
            Preconditions.checkNotNull((Object)key);
            WebTarget webTarget = this.createResource().path("user/password").queryParam(TestUserResourceForCreateUpdateDelete.KEY, new Object[]{key});
            ImmutableMap.Builder builder = ImmutableMap.builder();
            if (password != null) {
                builder.put((Object)"password", (Object)password);
            }
            Response response = (Response)webTarget.request(new String[]{"application/json"}).put(Entity.json((Object)builder.build()), Response.class);
            this.responses.add(response);
            return response;
        }

        private Response deleteUser(String key) {
            Preconditions.checkNotNull((Object)key);
            WebTarget webTarget = this.createResource().path(USER_PATH).queryParam(TestUserResourceForCreateUpdateDelete.KEY, new Object[]{key});
            Response delete = (Response)webTarget.request().delete(Response.class);
            this.responses.add(delete);
            return delete;
        }

        private void close() {
            for (Response response : this.responses) {
                response.close();
            }
        }
    }
}

