/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.webtests.LicenseKeys;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import junit.framework.TestCase;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.USERS_AND_GROUPS})
public class TestViewUserResource
extends BaseJiraRestTest {
    private ManualClient manualClient;
    private final String BOB_USERNAME = "bob";
    private final String KEVIN_USERNAME = "kevin";
    private final String FRED_USERNAME = "fred";
    private final String ADMIN_USERNAME = "admin";
    private final String CORE_GROUP = "jira-users";
    private final String TEST_GROUP = "test-group";
    private final String SOFTWARE_GROUP = "jira-software-group";
    private static final String ENGLISH_LOCALE = "en_US";
    private final Matcher<ApplicationSelection> JIRA_REFERENCE_MATCHER = TestViewUserResource.applicationSelectionMatcher("jira-reference", false, false);
    private final Matcher<ApplicationSelection> JIRA_SERVICE_DESK_MATCHER = TestViewUserResource.applicationSelectionMatcher("jira-servicedesk", false, false);

    @Before
    public void setUpInstance() {
        this.backdoor.restoreBlankInstance(LicenseKeys.MULTI_ROLE_DC);
        this.backdoor.applicationRoles().putRole("jira-servicedesk", new String[0]);
        this.backdoor.applicationRoles().putRole("jira-reference", new String[0]);
        this.backdoor.usersAndGroups().addGroup("jira-software-group");
        this.backdoor.applicationRoles().putRoleWithDefaultsSelectedByDefault("jira-software", false, TestViewUserResource.groups("jira-software-group"), TestViewUserResource.groups("jira-software-group"));
        this.backdoor.usersAndGroups().addUser("bob");
        this.backdoor.usersAndGroups().addUserToGroup("bob", "jira-software-group");
        this.backdoor.usersAndGroups().addGroup("test-group");
        this.backdoor.applicationRoles().putRoleAndSetDefault("jira-func-test", "test-group");
        this.backdoor.usersAndGroups().addUser("kevin");
        this.backdoor.usersAndGroups().addUserToGroup("kevin", "test-group");
        this.manualClient = new ManualClient(this.environmentData);
    }

    @Test
    public void shouldAddBobToApplicationAndReturnHisCurrentStatus() {
        UserApplicationUpdateBean userApplicationUpdateBean = this.manualClient.addUserToApplication("bob", "jira-func-test");
        MatcherAssert.assertThat(userApplicationUpdateBean.getSelectableApplications(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{TestViewUserResource.applicationSelectionMatcher("jira-func-test", true, true), TestViewUserResource.applicationSelectionMatcher("jira-core", true, false), TestViewUserResource.applicationSelectionMatcher("jira-software", true, true), this.JIRA_REFERENCE_MATCHER, this.JIRA_SERVICE_DESK_MATCHER}));
        MatcherAssert.assertThat(userApplicationUpdateBean.getUserGroups(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{TestViewUserResource.groupViewMatcher("test-group"), TestViewUserResource.groupViewMatcher("jira-software-group")}));
    }

    @Test
    public void shouldChangeFredApplicationAccessAndReturnHisCurrentStatus() {
        UserApplicationUpdateBean userApplicationUpdateBean = this.manualClient.addUserToApplication("fred", "jira-func-test");
        MatcherAssert.assertThat(userApplicationUpdateBean.getSelectableApplications(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{TestViewUserResource.applicationSelectionMatcher("jira-func-test", true, true), TestViewUserResource.applicationSelectionMatcher("jira-core", true, true), TestViewUserResource.applicationSelectionMatcher("jira-software", true, false), this.JIRA_REFERENCE_MATCHER, this.JIRA_SERVICE_DESK_MATCHER}));
        MatcherAssert.assertThat(userApplicationUpdateBean.getUserGroups(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{TestViewUserResource.groupViewMatcher("test-group"), TestViewUserResource.groupViewMatcher("jira-users")}));
        userApplicationUpdateBean = this.manualClient.removeUserFromApplication("fred", "jira-core");
        MatcherAssert.assertThat(userApplicationUpdateBean.getSelectableApplications(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{TestViewUserResource.applicationSelectionMatcher("jira-func-test", true, true), TestViewUserResource.applicationSelectionMatcher("jira-core", true, false), TestViewUserResource.applicationSelectionMatcher("jira-software", true, false), this.JIRA_REFERENCE_MATCHER, this.JIRA_SERVICE_DESK_MATCHER}));
        MatcherAssert.assertThat(userApplicationUpdateBean.getUserGroups(), (Matcher)Matchers.contains(TestViewUserResource.groupViewMatcher("test-group")));
    }

    @Test
    public void shouldRemoveKevinFromApplicationAndReturnHisCurrentStatus() {
        UserApplicationUpdateBean userApplicationUpdateBean = this.manualClient.removeUserFromApplication("kevin", "jira-func-test");
        MatcherAssert.assertThat(userApplicationUpdateBean.getSelectableApplications(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{TestViewUserResource.applicationSelectionMatcher("jira-func-test", true, false), TestViewUserResource.applicationSelectionMatcher("jira-core", true, false), TestViewUserResource.applicationSelectionMatcher("jira-software", true, false), this.JIRA_REFERENCE_MATCHER, this.JIRA_SERVICE_DESK_MATCHER}));
        MatcherAssert.assertThat(userApplicationUpdateBean.getUserGroups(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldNotRemoveAdminFromCoreAndReturnHisCurrentStatus() {
        UserApplicationUpdateBean errorResponse = this.manualClient.removeUserFromApplicationWithAnError("admin", "jira-core", Response.Status.BAD_REQUEST);
        List<String> errorMessages = errorResponse.getErrorMessages();
        MatcherAssert.assertThat((Object)ImmutableSet.of((Object)this.backdoor.i18n().getText("admin.errors.application.cannot.remove.application.last.admin.group", ENGLISH_LOCALE)), (Matcher)Matchers.containsInAnyOrder((Object[])errorMessages.toArray()));
    }

    private static Matcher<ApplicationSelection> applicationSelectionMatcher(final String key, final boolean selectable, final boolean selected) {
        return new TypeSafeMatcher<ApplicationSelection>(){

            protected boolean matchesSafely(ApplicationSelection item) {
                return item.selected == selected && item.selectable == selectable && StringUtils.equals((CharSequence)key, (CharSequence)item.getKey());
            }

            public void describeTo(Description description) {
                description.appendText("ApplicationSelection with key ").appendValue((Object)key).appendText(", ").appendText(selectable ? "" : "non ").appendText("selectable and ").appendText(selected ? "" : "not ").appendText("selected");
            }
        };
    }

    private static Matcher<GroupView> groupViewMatcher(final String name) {
        return new TypeSafeMatcher<GroupView>(){

            protected boolean matchesSafely(GroupView item) {
                return StringUtils.equals((CharSequence)item.getName(), (CharSequence)name);
            }

            public void describeTo(Description description) {
                description.appendText("GroupView with name ").appendValue((Object)name);
            }
        };
    }

    private static Iterable<String> groups(String ... groups) {
        return ImmutableSet.copyOf((Object[])groups);
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    static class GroupView {
        private String name;

        GroupView() {
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "GroupView{name='" + this.name + '\'' + '}';
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    static class ApplicationSelection {
        private String key;
        private boolean selectable;
        private boolean selected;

        ApplicationSelection() {
        }

        public String getKey() {
            return this.key;
        }

        public boolean isSelectable() {
            return this.selectable;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public String toString() {
            return "ApplicationSelection{key='" + this.key + '\'' + ", selectable=" + this.selectable + ", selected=" + this.selected + '}';
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    static class UserApplicationUpdateBean {
        private List<String> errorMessages;
        private boolean isEditable;
        private List<ApplicationSelection> selectableApplications;
        private List<GroupView> userGroups;

        UserApplicationUpdateBean() {
        }

        public List<String> getErrorMessages() {
            return this.errorMessages;
        }

        public boolean isEditable() {
            return this.isEditable;
        }

        public List<ApplicationSelection> getSelectableApplications() {
            return this.selectableApplications;
        }

        public List<GroupView> getUserGroups() {
            return this.userGroups;
        }
    }

    final class ManualClient
    extends RestApiClient<ManualClient> {
        protected ManualClient(JIRAEnvironmentData environmentData) {
            super(environmentData);
        }

        protected WebTarget createResource() {
            return this.resourceRoot(TestViewUserResource.this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("internal").path("2").path("viewuser");
        }

        private Invocation.Builder applicationAccessResource(String username, String applicationKey) {
            return this.createResource().path("application").path(applicationKey).queryParam("username", new Object[]{username}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        }

        public UserApplicationUpdateBean addUserToApplication(String username, String applicationKey) {
            return (UserApplicationUpdateBean)this.applicationAccessResource(username, applicationKey).post(null, UserApplicationUpdateBean.class);
        }

        public UserApplicationUpdateBean removeUserFromApplication(String username, String applicationKey) {
            return (UserApplicationUpdateBean)this.applicationAccessResource(username, applicationKey).delete(UserApplicationUpdateBean.class);
        }

        public UserApplicationUpdateBean removeUserFromApplicationWithAnError(String username, String applicationKey, Response.Status expectedResponseStatus) {
            Response response = (Response)this.applicationAccessResource(username, applicationKey).delete(Response.class);
            TestCase.assertEquals((Object)expectedResponseStatus, (Object)response.getStatusInfo());
            return (UserApplicationUpdateBean)response.readEntity(UserApplicationUpdateBean.class);
        }
    }
}

