/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client;

import com.atlassian.jira.issue.fields.rest.json.beans.AssociateProjectsBean;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeSchemeCreateUpdateBean;
import com.atlassian.jira.rest.v2.issue.IssueTypeSchemeBean;
import com.atlassian.jira.rest.v2.issue.IssueTypeSchemeListBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.Project;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

public class IssueTypeSchemeClient
extends RestApiClient<IssueTypeSchemeClient> {
    public IssueTypeSchemeClient(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
        super((JIRAEnvironmentData)environmentData);
    }

    public ParsedResponse<IssueTypeSchemeBean> createIssueTypeScheme(IssueTypeSchemeCreateUpdateBean bean) {
        return this.toResponse(() -> (Response)this.createResource().path("issuetypescheme").request().post(Entity.json((Object)bean), Response.class), IssueTypeSchemeBean.class);
    }

    public ParsedResponse<IssueTypeSchemeListBean> getAllIssueTypeSchemes() {
        return this.getAllIssueTypeSchemes(true, true);
    }

    public ParsedResponse<IssueTypeSchemeListBean> getAllIssueTypeSchemes(boolean expandDefault, boolean expandIssueTypes) {
        return this.toResponse(() -> (Response)this.createResource().path("issuetypescheme").request().get(Response.class), IssueTypeSchemeListBean.class);
    }

    public ParsedResponse<IssueTypeSchemeBean> getIssueTypeScheme(long id) {
        return this.getIssueTypeScheme(id, true, true);
    }

    public ParsedResponse<IssueTypeSchemeBean> getIssueTypeScheme(long id, boolean expandDefault, boolean expandIssueTypes) {
        return this.toResponse(() -> {
            WebTarget webTarget = this.createResource().path("issuetypescheme").path(Long.toString(id));
            String expands = "";
            if (expandDefault) {
                expands = "defaultIssueType";
            }
            if (expandIssueTypes) {
                if (!expands.isEmpty()) {
                    expands = expands + ",";
                }
                expands = expands + "issueTypes";
            }
            if (!expands.isEmpty()) {
                webTarget = webTarget.queryParam("expand", new Object[]{expands});
            }
            return (Response)webTarget.request().get(Response.class);
        }, IssueTypeSchemeBean.class);
    }

    public ParsedResponse<IssueTypeSchemeBean> updateIssueTypeScheme(long schemeId, IssueTypeSchemeCreateUpdateBean bean) {
        return this.toResponse(() -> (Response)this.createResource().path("issuetypescheme").path(Long.toString(schemeId)).request().put(Entity.json((Object)bean), Response.class), IssueTypeSchemeBean.class);
    }

    public ParsedResponse<?> deleteIssueTypeScheme(long schemeId) {
        return this.toResponse(() -> (Response)this.createResource().path("issuetypescheme").path(Long.toString(schemeId)).request().delete(Response.class));
    }

    public ParsedResponse<?> addProjectAssociatonsToScheme(long schemeId, String ... projKeyOrIds) {
        AssociateProjectsBean associateProjectsBean = new AssociateProjectsBean();
        associateProjectsBean.setIdsOrKeys(Arrays.asList(projKeyOrIds));
        return this.toResponse(() -> (Response)this.createResource().path("issuetypescheme").path(Long.toString(schemeId)).path("associations").request().post(Entity.json((Object)associateProjectsBean), Response.class));
    }

    public ParsedResponse<List<Project>> getProjectsAssociatedWithIssueTypeScheme(long schemeId) {
        return this.toResponse(() -> (Response)this.createResource().path("issuetypescheme").path(Long.toString(schemeId)).path("associations").request().get(Response.class), Project.PROJECTS_TYPE);
    }

    public ParsedResponse<?> setProjectAssociatonsForScheme(long schemeId, String ... projKeyOrIds) {
        AssociateProjectsBean associateProjectsBean = new AssociateProjectsBean();
        associateProjectsBean.setIdsOrKeys(Arrays.asList(projKeyOrIds));
        return this.toResponse(() -> (Response)this.createResource().path("issuetypescheme").path(Long.toString(schemeId)).path("associations").request().put(Entity.json((Object)associateProjectsBean), Response.class));
    }

    public ParsedResponse<?> unassignProjectFromScheme(long schemeId, String projKeyOrId) {
        return this.toResponse(() -> (Response)this.createResource().path("issuetypescheme").path(Long.toString(schemeId)).path("associations").path(projKeyOrId).request().delete(Response.class));
    }

    public ParsedResponse<?> unassignAllProjectsFromScheme(long schemeId) {
        return this.toResponse(() -> (Response)this.createResource().path("issuetypescheme").path(Long.toString(schemeId)).path("associations").request().delete(Response.class));
    }
}

