/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ipd;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
public class IpdLogEntry {
    private final LocalDateTime timestamp;
    @Nullable
    private final String objectName;
    @Nullable
    private final Map<String, String> tags;
    private final String label;
    private final Map<String, String> attributes;

    public IpdLogEntry(@JsonProperty(value="timestamp") String timestamp, @JsonProperty(value="label") String label, @JsonProperty(value="tags") @Nullable Map<String, String> tags, @JsonProperty(value="ObjectName") @Nullable String objectName, @JsonProperty(value="attributes") Map<String, String> attributes) {
        this.timestamp = LocalDateTime.ofEpochSecond(Long.parseLong(timestamp), 0, ZonedDateTime.now(ZoneId.systemDefault()).getOffset());
        this.objectName = objectName;
        this.tags = tags;
        this.label = label;
        this.attributes = attributes;
    }

    @Nonnull
    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    @Nonnull
    public String getLabel() {
        return this.label;
    }

    @Nonnull
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Nullable
    public String getObjectName() {
        return this.objectName;
    }

    @Nullable
    public Map<String, String> getTags() {
        return this.tags;
    }
}

