/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ipd;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class IpdMetricName {
    public static final IpdMetricName MAIL_QUEUE_ITEMS = new IpdMetricName("mail.queue.numItems", EnumSet.of(IpdMeasureType.LAST_VALUE, IpdMeasureType.STATS));
    public static final IpdMetricName MAIL_QUEUE_ERRORS = new IpdMetricName("mail.queue.numErrors", EnumSet.of(IpdMeasureType.LAST_VALUE, IpdMeasureType.STATS));
    public static final IpdMetricName MAIL_QUEUE_ITEMS_ADDED = new IpdMetricName("mail.queue.numItemsAddedPerMin", EnumSet.of(IpdMeasureType.LAST_VALUE, IpdMeasureType.STATS));
    public static final IpdMetricName MAIL_QUEUE_ERRORS_ADDED = new IpdMetricName("mail.queue.numErrorsAddedPerMin", EnumSet.of(IpdMeasureType.LAST_VALUE, IpdMeasureType.STATS));
    public static final IpdMetricName MAIL_QUEUE_ITEMS_PROCESSED = new IpdMetricName("mail.queue.numItemsProcessedPerMin", EnumSet.of(IpdMeasureType.LAST_VALUE, IpdMeasureType.STATS));
    public static final IpdMetricName MAIL_QUEUE_EMAILS_SENT = new IpdMetricName("mail.queue.numEmailsSentPerMin", EnumSet.of(IpdMeasureType.LAST_VALUE, IpdMeasureType.STATS));
    public static final IpdMetricName MAIL_JOB_RUNNING = new IpdMetricName("mail.queue.jobRunning", EnumSet.of(IpdMeasureType.LAST_VALUE));
    public static final IpdMetricName DB_CONNECTION_LATENCY = new IpdMetricName("db.connection.latency", EnumSet.of(IpdMeasureType.STATS, IpdMeasureType.LAST_VALUE));
    public static final IpdMetricName DB_CONNECTION_STATE = new IpdMetricName("db.connection.state", EnumSet.of(IpdMeasureType.LAST_VALUE));
    public static final IpdMetricName DB_CONNECTION_FAILURES = new IpdMetricName("db.connection.failures", EnumSet.of(IpdMeasureType.COUNTER));
    public static final IpdMetricName DB_CONNECTION_POOL_IDLE = new IpdMetricName("db.connection.pool.numIdle", EnumSet.of(IpdMeasureType.STATS, IpdMeasureType.LAST_VALUE));
    public static final IpdMetricName DB_CONNECTION_POOL_ACTIVE = new IpdMetricName("db.connection.pool.numActive", EnumSet.of(IpdMeasureType.STATS, IpdMeasureType.LAST_VALUE));
    public static final IpdMetricName HTTP_CONNECTION_SESSIONS_ACTIVE = new IpdMetricName("http.connection.sessions.active", EnumSet.of(IpdMeasureType.STATS, IpdMeasureType.LAST_VALUE));
    public static final IpdMetricName HTTP_CONNECTION_SESSIONS_RECENT = new IpdMetricName("http.connection.sessions.recent", EnumSet.of(IpdMeasureType.LAST_VALUE));
    public static final IpdMetricName HTTP_REQUESTS = new IpdMetricName("http.requests", EnumSet.of(IpdMeasureType.STATS, IpdMeasureType.LAST_VALUE));
    public static final IpdMetricName HTTP_CONNECTION_POOL_ACTIVE = new IpdMetricName("http.connection.pool.numActive", EnumSet.of(IpdMeasureType.LAST_VALUE));
    public static final IpdMetricName HTTP_CONNECTION_POOL_IDLE = new IpdMetricName("http.connection.pool.numIdle", EnumSet.of(IpdMeasureType.LAST_VALUE));
    public static final IpdMetricName HTTP_CONNECTION_POOL_MAX = new IpdMetricName("http.connection.pool.numMax", EnumSet.of(IpdMeasureType.LAST_VALUE));
    public static final IpdMetricName MAIL_OUTGOING_CONNECTION = new IpdMetricName("mail.outgoing.connection.state", EnumSet.of(IpdMeasureType.CUSTOM));
    public static final IpdMetricName USR_DIR_CONNECTION_STATE = new IpdMetricName("user.directory.connection.state", EnumSet.of(IpdMeasureType.CUSTOM));
    public static final IpdMetricName USR_DIR_CONNECTION_LATENCY = new IpdMetricName("user.directory.connection.latency", EnumSet.of(IpdMeasureType.LAST_VALUE, IpdMeasureType.STATS));
    public static final IpdMetricName HOME_LOCAL_SYNTHETIC = new IpdMetricName("home.local.write.latency.synthetic", EnumSet.of(IpdMeasureType.LAST_VALUE, IpdMeasureType.STATS));
    public static final IpdMetricName INDEXWRITER_LATENCY = new IpdMetricName("home.local.write.latency.indexwriter", EnumSet.of(IpdMeasureType.STATS));
    public static final List<IpdMetricName> REGULAR_IPD_METRIC_NAMES = ImmutableList.of((Object)DB_CONNECTION_LATENCY, (Object)DB_CONNECTION_STATE, (Object)DB_CONNECTION_FAILURES, (Object)DB_CONNECTION_POOL_IDLE, (Object)DB_CONNECTION_POOL_ACTIVE, (Object)HTTP_CONNECTION_SESSIONS_ACTIVE, (Object)HTTP_CONNECTION_SESSIONS_RECENT, (Object)HTTP_REQUESTS, (Object)HTTP_CONNECTION_POOL_ACTIVE, (Object)HTTP_CONNECTION_POOL_IDLE, (Object)HTTP_CONNECTION_POOL_MAX, (Object)MAIL_QUEUE_ITEMS, (Object[])new IpdMetricName[]{MAIL_QUEUE_ERRORS, MAIL_QUEUE_ITEMS_ADDED, MAIL_QUEUE_ERRORS_ADDED, MAIL_QUEUE_ITEMS_PROCESSED, MAIL_QUEUE_EMAILS_SENT, MAIL_JOB_RUNNING, MAIL_OUTGOING_CONNECTION, HOME_LOCAL_SYNTHETIC});
    public static final List<IpdMetricName> IRREGULAR_IPD_METRIC_NAMES = ImmutableList.of((Object)INDEXWRITER_LATENCY);
    public static final List<IpdMetricName> ON_DEMAND_IPD_METRIC_NAMES = ImmutableList.of((Object)MAIL_JOB_RUNNING);
    private String statisticsName = null;
    private String lastValueName = null;
    private String counterName = null;
    private String customName = null;

    public IpdMetricName(String baseName, Set<IpdMeasureType> measureTypes) {
        if (measureTypes.contains((Object)IpdMeasureType.STATS)) {
            this.statisticsName = baseName + ".statistics";
        }
        if (measureTypes.contains((Object)IpdMeasureType.LAST_VALUE)) {
            this.lastValueName = baseName + ".value";
        }
        if (measureTypes.contains((Object)IpdMeasureType.COUNTER)) {
            this.counterName = baseName + ".counter";
        }
        if (measureTypes.contains((Object)IpdMeasureType.CUSTOM)) {
            this.customName = baseName + ".custom";
        }
    }

    @Nullable
    public String getStatisticsName() {
        return this.statisticsName;
    }

    @Nullable
    public String getLastValueName() {
        return this.lastValueName;
    }

    @Nullable
    public String getCounterName() {
        return this.counterName;
    }

    @Nullable
    public String getCustomName() {
        return this.customName;
    }

    public static enum IpdMeasureType {
        STATS,
        LAST_VALUE,
        COUNTER,
        CUSTOM;

    }
}

