/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ipd;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLoggerImpl;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ipd.BaseInProductDiagnosticsTest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.testcontainers.shaded.org.awaitility.Awaitility;
import org.testcontainers.shaded.org.awaitility.core.ConditionTimeoutException;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.METRICS})
public class TestIpdEmittingStatisticMetrics
extends BaseInProductDiagnosticsTest {
    @Before
    public void before() {
        super.setUp();
        this.enableIPDFeature();
        this.enableIpdWipFeature();
    }

    @After
    public void after() {
        this.disableIPDFeature();
        this.disableIpdWipFeature();
    }

    @Test
    public void testEmittedStatisticsToJMX() {
        FuncTestLoggerImpl log = new FuncTestLoggerImpl();
        List<String> notFoundMetricNames = this.findMetrics(jmxObjectName -> {
            Map<String, Object> jmxObjAndVal = this.getJmxObjectWithValue((String)jmxObjectName);
            return jmxObjAndVal != null;
        });
        ((ListAssert)Assertions.assertThat(notFoundMetricNames).withFailMessage(String.format("Metrics should be emitted to JMX. Not emitted metrics: [%s]", String.join((CharSequence)",", notFoundMetricNames)), new Object[0])).isEmpty();
        this.disableIpdWipFeature();
        this.disableIPDFeature();
        List<String> foundMetricNames = this.findMetrics(jmxObjectName -> {
            Map<String, Object> jmxObjAndVal = this.getJmxObjectWithValue((String)jmxObjectName);
            return jmxObjAndVal == null;
        });
        ((ListAssert)Assertions.assertThat(foundMetricNames).withFailMessage(String.format("Metrics shouldn't be present in JMX after disabling FF. Present metrics: [%s]", String.join((CharSequence)",", foundMetricNames)), new Object[0])).isEmpty();
    }

    List<String> findMetrics(Function<String, Boolean> predicateFunction) {
        ArrayList<String> timedOutMetricNames = new ArrayList<String>();
        for (String lastValueMetricName : TestIpdEmittingStatisticMetrics.getStatsMetrics().collect(Collectors.toList())) {
            String jmxObjectName = this.getMetricObjectName(lastValueMetricName);
            try {
                Awaitility.await().atMost(70L, TimeUnit.SECONDS).pollInterval(5L, TimeUnit.SECONDS).pollDelay(1L, TimeUnit.SECONDS).until(() -> (Boolean)predicateFunction.apply(jmxObjectName));
            }
            catch (ConditionTimeoutException e) {
                timedOutMetricNames.add(lastValueMetricName);
            }
        }
        return timedOutMetricNames;
    }
}

