/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ipd;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.MailTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ipd.BaseInProductDiagnosticsTest;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.METRICS})
@LoginAs(user="admin")
@Restore(value="TestCommentNotifications.xml")
public class TestIpdMailQueueItems
extends BaseInProductDiagnosticsTest {
    @Before
    public void before() {
        this.enableIPDFeature();
        this.enableIpdWipFeature();
    }

    @After
    public void after() {
        this.disableIPDFeature();
        this.disableIpdWipFeature();
    }

    @Test
    @MailTest
    public void mailQueueItemsEmittedToJMX() {
        this.backdoor.mailServers().flushMailQueue();
        this.navigation.issue().addComment("TEST-1", "[~admin] [~fred]");
        this.backdoor.getIpdControl().measure();
        String objectName = this.getMetricObjectName("mail.queue.numItems.value");
        Map<String, Object> metricsValue = this.getJmxObjectWithValue(objectName);
        Assertions.assertThat(metricsValue).containsEntry((Object)"Value", (Object)1.0);
    }
}

