/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest.util;

import com.atlassian.jira.testkit.client.restclient.EntityPropertyKeys;
import java.util.concurrent.Callable;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;

public class PropertyAssertions {
    private PropertyAssertions() {
    }

    public static void assertWebApplicationException(Callable<Void> callable, Response.Status expectedStatus) {
        PropertyAssertions.assertWebApplicationException(callable, expectedStatus, null);
    }

    public static void assertWebApplicationException(Callable<Void> callable, Response.Status expectedStatus, String contentSubstring) {
        try {
            callable.call();
            Assert.fail((String)("Expected WebApplicationException with status " + expectedStatus.toString()));
        }
        catch (WebApplicationException e) {
            MatcherAssert.assertThat((Object)e.getResponse().getStatus(), (Matcher)Matchers.is((Object)expectedStatus.getStatusCode()));
            if (contentSubstring != null) {
                MatcherAssert.assertThat((Object)e.getResponse().readEntity(String.class), (Matcher)Matchers.containsString((String)contentSubstring));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Matcher<EntityPropertyKeys.EntityPropertyKey> propertyKey(final String propertyKey) {
        return new TypeSafeMatcher<EntityPropertyKeys.EntityPropertyKey>(){

            protected boolean matchesSafely(EntityPropertyKeys.EntityPropertyKey issuePropertyKey) {
                return issuePropertyKey.key.equals(propertyKey) && issuePropertyKey.self.endsWith(propertyKey);
            }

            public void describeTo(Description description) {
                description.appendText("List does not contain property with key").appendValue((Object)propertyKey);
            }
        };
    }
}

