/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.backdoor.webhooks.WebHookRegistrationClient;
import com.atlassian.jira.functest.framework.navigation.BulkChangeWizard;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.issue.fields.rest.json.beans.CommentJsonBean;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.Dates;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.CommentClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.Visibility;
import com.atlassian.jira.testkit.client.util.JsonMatchers;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks.HttpResponseTester;
import com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks.WebHookResponseData;
import com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks.WebHookTester;
import com.google.gson.Gson;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.WEBHOOKS, Category.REFERENCE_PLUGIN})
public class TestCommentWebHook
extends BaseJiraFuncTest {
    private static final long DEFAULT_SCHEME_ID = 0L;
    private static final String COMMENT_CREATED_WEBHOOK_ID = "comment_created";
    private static final String COMMENT_UPDATED_WEBHOOK_ID = "comment_updated";
    private static final String COMMENT_DELETED_WEBHOOK_ID = "comment_deleted";
    private static final int ONE_SECOND_IN_MILLIS = 1000;
    private CommentClient commentClient;
    @Rule
    public WebHookTester webHooks = new WebHookTester();

    @Before
    public void setUpTest() {
        this.backdoor.restoreBlankInstance();
        this.commentClient = new CommentClient((JIRAEnvironmentData)this.environmentData);
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.ADD_COMMENTS);
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.EDIT_ALL_COMMENTS);
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.DELETE_ALL_COMMENTS);
    }

    @Test
    public void testCommentCreatedWebHook() throws JSONException {
        this.webHooks.registerWebHook(COMMENT_CREATED_WEBHOOK_ID);
        Pair<ParsedResponse<Comment>, IssueCreateResponse> issueWithComment = this.createIssueWithComment();
        WebHookResponseData webHookResponse = this.webHooks.getWebHookResponse();
        JSONObject jsonObject = webHookResponse.asJsonObject();
        this.assertHasWebHookEvent(jsonObject, COMMENT_CREATED_WEBHOOK_ID);
        Assert.assertThat((Object)this.webHookResponseAsCommentBean(webHookResponse), this.isComment((Comment)issueWithComment.first().body));
    }

    @Test
    public void testCommentCreatedWithRoleVisibility() throws JSONException {
        this.webHooks.registerWebHook(COMMENT_CREATED_WEBHOOK_ID);
        IssueCreateResponse issue = this.createTestIssue();
        Comment comment = new Comment();
        comment.body = "comment body";
        comment.visibility = new Visibility("group", "jira-administrators");
        ParsedResponse commentResponse = this.commentClient.post(issue.key, comment);
        WebHookResponseData webHookResponseData = this.webHooks.getWebHookResponse();
        JSONObject jsonObject = webHookResponseData.asJsonObject();
        this.assertHasWebHookEvent(jsonObject, COMMENT_CREATED_WEBHOOK_ID);
        CommentJsonBean commentFromWebHook = this.webHookResponseAsCommentBean(webHookResponseData);
        Assert.assertThat((Object)commentFromWebHook, this.isComment((Comment)commentResponse.body));
        Assert.assertThat((Object)commentFromWebHook, (Matcher)Matchers.both((Matcher)Matchers.hasProperty((String)"visibility", (Matcher)Matchers.hasProperty((String)"type", (Matcher)Matchers.hasToString((Matcher)Matchers.equalTo((Object)comment.visibility.type))))).and(Matchers.hasProperty((String)"visibility", (Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.equalTo((Object)comment.visibility.value)))));
    }

    @Test
    public void testCommentCreatedWebHookAndIssueUpdatedAreBothTriggered() throws Exception {
        this.webHooks.registerWebHook(COMMENT_CREATED_WEBHOOK_ID);
        HttpResponseTester issueUpdatedWebHookTester = this.createIssueUpdatedWebHookTester();
        Pair<ParsedResponse<Comment>, IssueCreateResponse> issueWithComment = this.createIssueWithComment();
        WebHookResponseData commentWebHookResponse = this.webHooks.getWebHookResponse();
        WebHookResponseData issueUpdatedWebHookResponse = issueUpdatedWebHookTester.getResponseData();
        this.assertHasWebHookEvent(commentWebHookResponse.asJsonObject(), COMMENT_CREATED_WEBHOOK_ID);
        this.assertHasWebHookEvent(issueUpdatedWebHookResponse.asJsonObject(), "jira:issue_updated");
        CommentJsonBean commentBean = this.webHookResponseAsCommentBean(commentWebHookResponse);
        Assert.assertThat((Object)commentBean, this.isComment((Comment)issueWithComment.first().body));
        CommentJsonBean commentFromIssueUpdated = this.getCommentFromIssueUpdatedWebHook(issueUpdatedWebHookResponse);
        Assert.assertThat((Object)commentFromIssueUpdated, this.isComment((Comment)issueWithComment.first().body));
    }

    @Test
    public void testUriVariableDuringIssueCreatedWebHook() throws Exception {
        WebHookRegistrationClient.Registration registration = new WebHookRegistrationClient.Registration();
        registration.name = "Comment Issue Web Hook";
        registration.events = new String[]{COMMENT_CREATED_WEBHOOK_ID};
        registration.path = "/issueKey=${issue.key}&commentId=${comment.id}";
        this.webHooks.getResponseTester().registerWebhook(registration);
        IssueCreateResponse issue = this.createTestIssue();
        Comment comment = new Comment();
        comment.body = "This is a sample comment which should trigger webhook";
        ParsedResponse commentResponse = this.commentClient.post(issue.key, comment);
        WebHookResponseData webHookResponseData = this.webHooks.getResponseTester().getResponseData();
        Assert.assertThat((Object)webHookResponseData.getUri().toString(), (Matcher)Matchers.both((Matcher)Matchers.containsString((String)((Comment)commentResponse.body).id)).and(Matchers.containsString((String)issue.key)));
    }

    @Test
    public void testCommentUpdatedWebHook() throws JSONException {
        this.webHooks.registerWebHook(COMMENT_UPDATED_WEBHOOK_ID);
        Pair<ParsedResponse<Comment>, IssueCreateResponse> issueWithComment = this.createIssueWithComment();
        ParsedResponse<Comment> updatedComment = this.updateComment(issueWithComment.second(), (Comment)issueWithComment.first().body);
        WebHookResponseData webHookResponse = this.webHooks.getWebHookResponse();
        this.assertHasWebHookEvent(webHookResponse.asJsonObject(), COMMENT_UPDATED_WEBHOOK_ID);
        Assert.assertThat((Object)this.webHookResponseAsCommentBean(webHookResponse), this.isComment((Comment)updatedComment.body));
    }

    @Test
    public void testCommentUpdatedWebHookIsTriggeredWithIssueUpdateWebHook() throws Exception {
        this.webHooks.registerWebHook(COMMENT_UPDATED_WEBHOOK_ID);
        HttpResponseTester issueUpdatedWebHookTester = this.createIssueUpdatedWebHookTester();
        Pair<ParsedResponse<Comment>, IssueCreateResponse> issueWithComment = this.createIssueWithComment();
        WebHookResponseData issueUpdateResponseWithCommentCreated = issueUpdatedWebHookTester.getResponseData();
        this.assertHasWebHookEvent(issueUpdateResponseWithCommentCreated.asJsonObject(), "jira:issue_updated");
        Assert.assertThat((Object)this.getCommentFromIssueUpdatedWebHook(issueUpdateResponseWithCommentCreated), this.isComment((Comment)issueWithComment.first().body));
        ParsedResponse<Comment> updatedComment = this.updateComment(issueWithComment.second(), (Comment)issueWithComment.first().body);
        WebHookResponseData issueUpdatedWebHookWithCommentUpdated = issueUpdatedWebHookTester.getResponseData();
        this.assertHasWebHookEvent(issueUpdatedWebHookWithCommentUpdated.asJsonObject(), "jira:issue_updated");
        Assert.assertThat((Object)this.getCommentFromIssueUpdatedWebHook(issueUpdatedWebHookWithCommentUpdated), this.isComment((Comment)updatedComment.body));
        WebHookResponseData webHookResponse = this.webHooks.getWebHookResponse();
        this.assertHasWebHookEvent(webHookResponse.asJsonObject(), COMMENT_UPDATED_WEBHOOK_ID);
        Assert.assertThat((Object)this.webHookResponseAsCommentBean(webHookResponse), this.isComment((Comment)updatedComment.body));
    }

    @Test
    @LoginAs(user="admin")
    public void testCommentCreateWebHookTriggeredDuringBulkUpdate() throws Exception {
        HttpResponseTester bulkChangeTester = new HttpResponseTester(this.environmentData, 10);
        bulkChangeTester.start();
        WebHookRegistrationClient.Registration registration = new WebHookRegistrationClient.Registration();
        registration.name = "Comment Issue Web Hook";
        registration.events = new String[]{COMMENT_CREATED_WEBHOOK_ID};
        registration.path = "/issueKey=${issue.key}&commentId=${comment.id}";
        bulkChangeTester.registerWebhook(registration);
        Supplier<IntStream> testCount = () -> IntStream.range(0, 10);
        List createdIssues = testCount.get().mapToObj(i -> this.createTestIssue()).collect(Collectors.toList());
        String commentBody = "Bulk comment";
        this.navigation.login("admin");
        this.navigation.issueNavigator().displayAllIssues();
        BulkChangeWizard wizard = this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES).selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.EDIT).checkActionForField("comment").setFieldValue("comment", commentBody).finaliseFields().complete().waitForBulkChangeCompletion();
        Assert.assertEquals((Object)((Object)wizard.getState()), (Object)((Object)BulkChangeWizard.WizardState.COMPLETE));
        List webHookResponsesForBulkEdit = testCount.get().mapToObj(i -> {
            try {
                return bulkChangeTester.getResponseData();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        Collector collector = Collectors.toList();
        Matcher allResponsesNotNullMatcher = Matchers.contains(testCount.get().mapToObj(e -> Matchers.notNullValue()).collect(collector));
        Assert.assertThat(webHookResponsesForBulkEdit, (Matcher)allResponsesNotNullMatcher);
        List webHookReceiveUrls = webHookResponsesForBulkEdit.stream().map(response -> response.getUri().toString()).collect(Collectors.toList());
        List commentJsonBeans = webHookResponsesForBulkEdit.stream().map(this::webHookResponseAsCommentBean).collect(Collectors.toList());
        Matcher urlMatchers = Matchers.hasItem((Matcher)Matchers.anyOf((Iterable)createdIssues.stream().map(issue -> Matchers.containsString((String)issue.key)).collect(Collectors.toList())));
        Assert.assertThat(webHookReceiveUrls, (Matcher)urlMatchers);
        Matcher allCommentJsonHaveProperBody = Matchers.contains(testCount.get().mapToObj(e -> Matchers.hasProperty((String)"body", (Matcher)Matchers.equalTo((Object)commentBody))).collect(Collectors.toList()));
        Assert.assertThat(commentJsonBeans, (Matcher)allCommentJsonHaveProperBody);
        bulkChangeTester.stop();
    }

    @Test
    public void testCommentDeletedWithFFOff() throws JSONException {
        this.backdoor.darkFeatures().disableForSite(FeatureFlag.featureFlag((String)JiraFeatureFlagRegistrar.FIXED_COMMENT_DELETION_NOTIFICATIONS.featureKey()));
        this.testCommentDeletedInternal();
    }

    @Test
    public void testCommentDeletedWithFFOn() throws JSONException {
        this.backdoor.darkFeatures().enableForSite(FeatureFlag.featureFlag((String)JiraFeatureFlagRegistrar.FIXED_COMMENT_DELETION_NOTIFICATIONS.featureKey()));
        this.testCommentDeletedInternal();
    }

    private void testCommentDeletedInternal() throws JSONException {
        this.webHooks.registerWebHook(COMMENT_DELETED_WEBHOOK_ID);
        Pair<ParsedResponse<Comment>, IssueCreateResponse> issueWithComment = this.createIssueWithComment();
        this.commentClient.delete(issueWithComment.second().key, ((Comment)issueWithComment.first().body).id);
        WebHookResponseData webHookResponse = this.webHooks.getWebHookResponse();
        this.assertHasWebHookEvent(webHookResponse.asJsonObject(), COMMENT_DELETED_WEBHOOK_ID);
        Assert.assertThat((Object)this.webHookResponseAsCommentBean(webHookResponse), this.isComment((Comment)issueWithComment.first().body));
    }

    @Test
    public void testCommentDeletedTriggersIssueUpdateAndCommentDeletedWithFFOff() throws InterruptedException, JSONException {
        this.backdoor.darkFeatures().disableForSite(FeatureFlag.featureFlag((String)JiraFeatureFlagRegistrar.FIXED_COMMENT_DELETION_NOTIFICATIONS.featureKey()));
        this.testCommentDeletedTriggersIssueUpdateAndCommentDeletedInternal();
    }

    @Test
    public void testCommentDeletedTriggersIssueUpdateAndCommentDeletedWithFFOn() throws InterruptedException, JSONException {
        this.backdoor.darkFeatures().enableForSite(FeatureFlag.featureFlag((String)JiraFeatureFlagRegistrar.FIXED_COMMENT_DELETION_NOTIFICATIONS.featureKey()));
        this.testCommentDeletedTriggersIssueUpdateAndCommentDeletedInternal();
    }

    private void testCommentDeletedTriggersIssueUpdateAndCommentDeletedInternal() throws InterruptedException, JSONException {
        this.webHooks.registerWebHook(COMMENT_DELETED_WEBHOOK_ID);
        HttpResponseTester issueUpdatedWebHookTester = this.createIssueUpdatedWebHookTester();
        Pair<ParsedResponse<Comment>, IssueCreateResponse> issueWithComment = this.createIssueWithComment();
        WebHookResponseData commentCreateWebHookResponse = issueUpdatedWebHookTester.getResponseData();
        this.assertHasWebHookEvent(commentCreateWebHookResponse.asJsonObject(), "jira:issue_updated");
        Assert.assertThat((Object)this.webHookResponseAsCommentBean(commentCreateWebHookResponse), this.isComment((Comment)issueWithComment.first().body));
        this.commentClient.delete(issueWithComment.second().key, ((Comment)issueWithComment.first().body).id);
        WebHookResponseData issueUpdateByCommentDeletionResponse = issueUpdatedWebHookTester.getResponseData();
        this.assertHasWebHookEvent(issueUpdateByCommentDeletionResponse.asJsonObject(), "jira:issue_updated");
        WebHookResponseData webHookResponse = this.webHooks.getWebHookResponse();
        this.assertHasWebHookEvent(webHookResponse.asJsonObject(), COMMENT_DELETED_WEBHOOK_ID);
        Assert.assertThat((Object)this.webHookResponseAsCommentBean(webHookResponse), this.isComment((Comment)issueWithComment.first().body));
    }

    @Test
    public void testCommentDeletedWebHooksTriggeredWhenIssueDeleted() throws JSONException, IOException, InterruptedException {
        HttpResponseTester deleteTester = new HttpResponseTester(this.environmentData, 2);
        deleteTester.start();
        WebHookRegistrationClient.Registration registration = new WebHookRegistrationClient.Registration();
        registration.name = "Comment Issue Web Hook";
        registration.events = new String[]{COMMENT_DELETED_WEBHOOK_ID};
        registration.path = "/issueKey=${issue.key}&commentId=${comment.id}";
        deleteTester.registerWebhook(registration);
        Pair<ParsedResponse<Comment>, IssueCreateResponse> issueWithComment = this.createIssueWithComment();
        Comment secondComment = new Comment();
        secondComment.body = "Second comment";
        ParsedResponse secondCommentResponse = this.commentClient.post(issueWithComment.second().key, secondComment);
        this.backdoor.issues().deleteIssue(issueWithComment.second().key, true);
        WebHookResponseData firstCommentDeletedWebHookResponse = deleteTester.getResponseData();
        WebHookResponseData secondCommentDeletedWebHookResponse = deleteTester.getResponseData();
        this.assertHasWebHookEvent(firstCommentDeletedWebHookResponse.asJsonObject(), COMMENT_DELETED_WEBHOOK_ID);
        this.assertHasWebHookEvent(secondCommentDeletedWebHookResponse.asJsonObject(), COMMENT_DELETED_WEBHOOK_ID);
        Assert.assertThat((Object)this.webHookResponseAsCommentBean(firstCommentDeletedWebHookResponse), (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{this.isComment((Comment)issueWithComment.first().body), this.isComment((Comment)secondCommentResponse.body)}));
        Assert.assertThat((Object)this.webHookResponseAsCommentBean(secondCommentDeletedWebHookResponse), (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{this.isComment((Comment)issueWithComment.first().body), this.isComment((Comment)secondCommentResponse.body)}));
        deleteTester.stop();
    }

    @Test
    public void testWebHookListenerRegisteredWithModuleDescriptorReceivesCommentCreated() throws JSONException {
        Pair<ParsedResponse<Comment>, IssueCreateResponse> issueWithComment = this.createIssueWithComment();
        WebHookResponseData webHookResponse = this.webHooks.getWebHookResponseFromReferencePlugin(COMMENT_CREATED_WEBHOOK_ID);
        this.assertHasWebHookEvent(webHookResponse.asJsonObject(), COMMENT_CREATED_WEBHOOK_ID);
        Assert.assertThat((Object)this.webHookResponseAsCommentBean(webHookResponse), this.isComment((Comment)issueWithComment.first().body));
    }

    @Test
    public void testWebHookListenerRegisteredWithModuleDescriptorReceivesCommentUpdated() throws JSONException {
        Pair<ParsedResponse<Comment>, IssueCreateResponse> issueWithComment = this.createIssueWithComment();
        ParsedResponse<Comment> updatedComment = this.updateComment(issueWithComment.second(), (Comment)issueWithComment.first().body);
        WebHookResponseData webHookResponse = this.webHooks.getWebHookResponseFromReferencePlugin(COMMENT_UPDATED_WEBHOOK_ID);
        this.assertHasWebHookEvent(webHookResponse.asJsonObject(), COMMENT_UPDATED_WEBHOOK_ID);
        Assert.assertThat((Object)this.webHookResponseAsCommentBean(webHookResponse), this.isComment((Comment)updatedComment.body));
    }

    @Test
    public void testWebHookListenerRegisteredWithModuleDescriptorReceivesCommentDelete() throws JSONException {
        Pair<ParsedResponse<Comment>, IssueCreateResponse> issueWithComment = this.createIssueWithComment();
        this.commentClient.delete(issueWithComment.second().key, ((Comment)issueWithComment.first().body).id);
        WebHookResponseData webHookResponse = this.webHooks.getWebHookResponseFromReferencePlugin(COMMENT_DELETED_WEBHOOK_ID);
        this.assertHasWebHookEvent(webHookResponse.asJsonObject(), COMMENT_DELETED_WEBHOOK_ID);
        Assert.assertThat((Object)this.webHookResponseAsCommentBean(webHookResponse), this.isComment((Comment)issueWithComment.first().body));
    }

    private CommentJsonBean getCommentFromIssueUpdatedWebHook(WebHookResponseData issueUpdatedWebHookResponse) throws JSONException {
        return (CommentJsonBean)new Gson().fromJson(issueUpdatedWebHookResponse.asJsonObject().get("comment").toString(), CommentJsonBean.class);
    }

    private CommentJsonBean webHookResponseAsCommentBean(WebHookResponseData webHookResponse) {
        try {
            return webHookResponse.asBean(CommentJsonBean.class, "comment");
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private Pair<ParsedResponse<Comment>, IssueCreateResponse> createIssueWithComment() {
        IssueCreateResponse issue = this.createTestIssue();
        Comment comment = new Comment();
        comment.body = "This is a sample comment which should trigger webhook";
        return Pair.of(this.commentClient.post(issue.key, comment), issue);
    }

    private ParsedResponse<Comment> updateComment(IssueCreateResponse issue, Comment comment) {
        Comment commentToUpdate = new Comment();
        commentToUpdate.body = "Updated comment body";
        commentToUpdate.visibility = comment.visibility;
        commentToUpdate.id = comment.id;
        return this.commentClient.put(issue.key, commentToUpdate);
    }

    private void assertHasWebHookEvent(JSONObject jsonObject, String webHookId) {
        Assert.assertThat((Object)jsonObject, (Matcher)JsonMatchers.hasField((String)"webhookEvent").equalTo((Object)webHookId));
    }

    private HttpResponseTester createIssueUpdatedWebHookTester() {
        HttpResponseTester issueUpdatedTester = HttpResponseTester.createTester(this.getEnvironmentData());
        WebHookRegistrationClient.Registration registration = new WebHookRegistrationClient.Registration();
        registration.events = new String[]{"jira:issue_updated"};
        registration.name = "Issue updated webhook";
        issueUpdatedTester.registerWebhook(registration);
        return issueUpdatedTester;
    }

    private IssueCreateResponse createTestIssue() {
        return this.backdoor.issues().createIssue("HSP", "Issue with comments");
    }

    private Matcher<? super CommentJsonBean> isComment(Comment comment) {
        return Matchers.allOf((Matcher)Matchers.hasProperty((String)"id", (Matcher)Matchers.equalTo((Object)String.valueOf(comment.id))), (Matcher)Matchers.hasProperty((String)"body", (Matcher)Matchers.equalTo((Object)comment.body)), (Matcher)Matchers.hasProperty((String)"updated", TestCommentWebHook.equalWithOneSecondPrecision(Dates.fromTimeString((String)comment.updated))), (Matcher)Matchers.hasProperty((String)"created", TestCommentWebHook.equalWithOneSecondPrecision(Dates.fromTimeString((String)comment.created))), (Matcher)Matchers.hasProperty((String)"author", (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)comment.author.name))));
    }

    private static Matcher<Date> equalWithOneSecondPrecision(final Date date) {
        return new TypeSafeMatcher<Date>(){

            protected boolean matchesSafely(Date item) {
                return Math.abs(date.getTime() - item.getTime()) < 1000L;
            }

            public void describeTo(Description description) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                description.appendText(format.format(date));
            }
        };
    }
}

