/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.plugins.webhooks.serializer.bean.IssueLinkBean;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.LinkIssueClient;
import com.atlassian.jira.testkit.client.restclient.LinkRequest;
import com.atlassian.jira.testkit.client.util.JsonMatchers;
import com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks.WebHookResponseData;
import com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks.WebHookTester;
import com.google.gson.Gson;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.json.JSONException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.WEBHOOKS, Category.REFERENCE_PLUGIN})
@RestoreBlankInstance
public class TestIssueLinkWebHook
extends BaseJiraFuncTest {
    private static final String ISSUE_LINK_CREATED_WEBHOOK_ID = "issuelink_created";
    private static final String ISSUE_LINK_DELETED_WEBHOOK_ID = "issuelink_deleted";
    private static final String PROJECT_KEY = "HSP";
    private static final String BLOCKER = "Blocker";
    private LinkIssueClient linkIssueClient;
    @Rule
    public WebHookTester webHooks = new WebHookTester();

    @Before
    public void setUp() {
        this.backdoor.issueLinking().enable();
        this.linkIssueClient = new LinkIssueClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testCreateLinkSendsLinkCreatedWebhook() throws InterruptedException, JSONException {
        this.webHooks.registerWebHook(ISSUE_LINK_CREATED_WEBHOOK_ID);
        IssueLinkBean expectedIssueLinkBean = this.createTwoIssuesAndLinkOneAsBlockingTheOther();
        WebHookResponseData webHookResponse = this.webHooks.getWebHookResponse();
        IssueLinkBean actualIssueLink = TestIssueLinkWebHook.extractIssueLinkBean(webHookResponse);
        Assert.assertThat((Object)webHookResponse, this.causedByEvent(ISSUE_LINK_CREATED_WEBHOOK_ID));
        Assert.assertThat((Object)actualIssueLink.getDestinationIssueId(), (Matcher)Matchers.equalTo((Object)expectedIssueLinkBean.getDestinationIssueId()));
        Assert.assertThat((Object)actualIssueLink.getSourceIssueId(), (Matcher)Matchers.equalTo((Object)expectedIssueLinkBean.getSourceIssueId()));
        Assert.assertThat((Object)actualIssueLink.issueLinkType().getName(), (Matcher)Matchers.equalTo((Object)BLOCKER));
    }

    @Test
    public void testDeleteLinkSendsLinkDeletedWebhook() throws JSONException {
        this.webHooks.registerWebHook(ISSUE_LINK_DELETED_WEBHOOK_ID);
        this.webHooks.registerWebHook(ISSUE_LINK_CREATED_WEBHOOK_ID);
        this.createTwoIssuesAndLinkOneAsBlockingTheOther();
        WebHookResponseData createWebhookResponse = this.webHooks.getWebHookResponse();
        Assert.assertThat((Object)createWebhookResponse, this.causedByEvent(ISSUE_LINK_CREATED_WEBHOOK_ID));
        IssueLinkBean toBeDeletedIssueLink = TestIssueLinkWebHook.extractIssueLinkBean(createWebhookResponse);
        this.linkIssueClient.deleteIssueLink(String.valueOf(toBeDeletedIssueLink.getId()));
        WebHookResponseData deleteWebhookResponse = this.webHooks.getWebHookResponse();
        IssueLinkBean deletedIssueLink = TestIssueLinkWebHook.extractIssueLinkBean(deleteWebhookResponse);
        Assert.assertThat((Object)deleteWebhookResponse, this.causedByEvent(ISSUE_LINK_DELETED_WEBHOOK_ID));
        Assert.assertThat((Object)deletedIssueLink, (Matcher)Matchers.equalTo((Object)toBeDeletedIssueLink));
    }

    private static IssueLinkBean extractIssueLinkBean(WebHookResponseData webhookResponse) throws JSONException {
        return (IssueLinkBean)new Gson().fromJson(webhookResponse.asJsonObject().get("issueLink").toString(), IssueLinkBean.class);
    }

    Matcher<? super WebHookResponseData> causedByEvent(final String eventId) {
        return new TypeSafeMatcher<WebHookResponseData>(){

            protected boolean matchesSafely(WebHookResponseData item) {
                try {
                    return JsonMatchers.hasField((String)"webhookEvent").equalTo((Object)eventId).matches((Object)item.asJsonObject());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return false;
                }
            }

            public void describeTo(Description description) {
                description.appendValue((Object)eventId);
            }
        };
    }

    private IssueLinkBean createTwoIssuesAndLinkOneAsBlockingTheOther() {
        IssueCreateResponse sourceIssue = this.backdoor.issues().createIssue(PROJECT_KEY, "Source");
        IssueCreateResponse destinationIssue = this.backdoor.issues().createIssue(PROJECT_KEY, "Destination");
        this.backdoor.issueLinking().createIssueLinkType(BLOCKER, "blocking", "blocked by");
        LinkRequest linkIssuesRequest = new LinkRequest().inwardIssue(ResourceRef.withKey((String)sourceIssue.key())).outwardIssue(ResourceRef.withKey((String)destinationIssue.key())).type(ResourceRef.withName((String)BLOCKER));
        this.linkIssueClient.linkIssues(linkIssuesRequest);
        return new IssueLinkBean(null, Long.valueOf(Long.parseLong(sourceIssue.id())), Long.valueOf(Long.parseLong(destinationIssue.id())), null, null, Boolean.valueOf(false));
    }
}

