/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.UserBean;
import com.atlassian.jira.testkit.client.restclient.UserClient;
import com.atlassian.jira.testkit.client.util.JsonMatchers;
import com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks.WebHookTester;
import com.google.common.base.Supplier;
import org.hamcrest.Matcher;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.WEBHOOKS, Category.REFERENCE_PLUGIN})
public class TestUserWebHook
extends BaseJiraFuncTest {
    public static final String USER_NAME = "user";
    public static final String USER_PASSWORD = "pass";
    public static final String DISPLAY_NAME = "User";
    public static final String EMAIL = "user@atlassian.com";
    public static final UserBean INITIAL_USER = UserBean.builder().setName("user").setDisplayName("User").setEmailAddress("user@atlassian.com").setPassword("pass").build();
    private UserClient userClient;
    @Rule
    public WebHookTester webHooks = new WebHookTester();

    @Before
    public void setUpTest() {
        this.backdoor.restoreBlankInstance();
        this.userClient = new UserClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.deleteUser();
    }

    @Test
    public void testWebhookIsSentForCreatedUserWhenListenerIsPersisted() throws Exception {
        this.webHooks.registerWebHook("user_created");
        this.createUser();
        this.assertUserCreatedWebHookReceived(this.webHooks.getWebHookResponseSupplier());
    }

    @Test
    public void testWebhookIsSentForCreatedUserWhenListenerComesFromModuleDescriptor() throws Exception {
        this.createUser();
        this.assertUserCreatedWebHookReceived(this.webHooks.receiveWebhook("user_created"));
    }

    @Test
    public void testWebhookIsSentForDeletedUserWhenListenerIsPersisted() throws Exception {
        this.webHooks.registerWebHook("user_deleted");
        this.createUser();
        this.assertWebHookNotReceived(this.webHooks.getWebHookResponseSupplier());
        String userKey = this.backdoor.usersAndGroups().getUserByName(USER_NAME).getKey();
        this.deleteUser();
        this.assertUserDeletedWebHookReceived(this.webHooks.getWebHookResponseSupplier(), userKey);
    }

    @Test
    public void testUriVariablesAreCorrectlyProvidedForUserCreatedWebHook() throws Exception {
        this.createUser();
        String userKey = this.backdoor.usersAndGroups().getUserByName(USER_NAME).getKey();
        JSONObject parameters = this.webHooks.getUrlParametersOfReceivedWebHook("user_created");
        Assert.assertThat((Object)parameters, (Matcher)JsonMatchers.hasField((String)"created_user_name").equalTo((Object)USER_NAME));
        Assert.assertThat((Object)parameters, (Matcher)JsonMatchers.hasField((String)"created_user_key").equalTo((Object)userKey));
    }

    @Test
    public void testUriVariablesAreCorrectlyProvidedForUserDeletedWebHook() throws Exception {
        this.createUser();
        String userKey = this.backdoor.usersAndGroups().getUserByName(USER_NAME).getKey();
        this.deleteUser();
        JSONObject parameters = this.webHooks.getUrlParametersOfReceivedWebHook("user_deleted");
        Assert.assertThat((Object)parameters, (Matcher)JsonMatchers.hasField((String)"deleted_user_name").equalTo((Object)USER_NAME));
        Assert.assertThat((Object)parameters, (Matcher)JsonMatchers.hasField((String)"deleted_user_key").equalTo((Object)userKey));
    }

    @Test
    public void testUserUpdatedWebhookIsSentWhenEmailIsChanged() throws Exception {
        this.createDefaultUserAndRegisterPersistentListenerForUserUpdatedWebhook();
        this.userClient.updateEmail(USER_NAME, "new@email.com");
        this.assertWebhookUpdatedReceived(INITIAL_USER.but().setEmailAddress("new@email.com"));
    }

    @Test
    public void testUserUpdatedWebhookIsSentWhenDisplayNameIsChanged() throws Exception {
        this.createDefaultUserAndRegisterPersistentListenerForUserUpdatedWebhook();
        this.userClient.updateDisplayName(USER_NAME, "newDisplayName");
        this.assertWebhookUpdatedReceived(INITIAL_USER.but().setDisplayName("newDisplayName"));
    }

    @Test
    public void testUserUpdatedWebhookIsSentWhenNameIsChanged() throws Exception {
        this.createDefaultUserAndRegisterPersistentListenerForUserUpdatedWebhook();
        this.userClient.updateName(USER_NAME, "newName");
        this.assertWebhookUpdatedReceived(INITIAL_USER.but().setName("newName"));
    }

    @Test
    public void testCorrectParametersAreSentForUserUpdatedWebhook() throws Exception {
        this.createUser();
        String userKey = this.backdoor.usersAndGroups().getUserByName(USER_NAME).getKey();
        this.userClient.updateName(USER_NAME, "newName");
        JSONObject updateParameters = this.webHooks.getUrlParametersOfReceivedWebHook("user_updated");
        Assert.assertThat((Object)updateParameters, (Matcher)JsonMatchers.hasField((String)"updated_user_key").equalTo((Object)userKey));
        Assert.assertThat((Object)updateParameters, (Matcher)JsonMatchers.hasField((String)"updated_user_name").equalTo((Object)"newName"));
        this.deleteUser();
    }

    private void createDefaultUserAndRegisterPersistentListenerForUserUpdatedWebhook() {
        this.createUser();
        this.webHooks.registerWebHook("user_updated");
    }

    private void createUser() {
        this.backdoor.usersAndGroups().addUser(USER_NAME, USER_PASSWORD, DISPLAY_NAME, EMAIL);
    }

    private void deleteUser() {
        this.backdoor.usersAndGroups().deleteUser(USER_NAME);
    }

    private void assertUserCreatedWebHookReceived(Supplier<String> receivedWebhook) throws JSONException {
        this.assertUserWebhookReceived(receivedWebhook, "user_created", INITIAL_USER);
    }

    private void assertWebhookUpdatedReceived(UserBean.Builder expectedUser) throws JSONException {
        this.assertUserWebhookReceived(this.webHooks.receiveWebhook("user_updated"), "user_updated", expectedUser.build());
        this.assertUserWebhookReceived(this.webHooks.getWebHookResponseSupplier(), "user_updated", expectedUser.build());
    }

    private void assertUserWebhookReceived(Supplier<String> receivedWebhook, String webhookName, UserBean expectedPayload) throws JSONException {
        String userKey = this.backdoor.usersAndGroups().getUserByName(expectedPayload.name).getKey();
        JSONObject json = new JSONObject((String)receivedWebhook.get());
        Assert.assertThat((Object)json, (Matcher)JsonMatchers.hasField((String)"timestamp"));
        Assert.assertThat((Object)json, (Matcher)JsonMatchers.hasField((String)"webhookEvent").equalTo((Object)webhookName));
        Assert.assertThat((Object)json, (Matcher)JsonMatchers.hasField((String)"user.name").equalTo((Object)expectedPayload.name));
        Assert.assertThat((Object)json, (Matcher)JsonMatchers.hasField((String)"user.key").equalTo((Object)userKey));
        Assert.assertThat((Object)json, (Matcher)JsonMatchers.hasField((String)"user.displayName").equalTo((Object)expectedPayload.displayName));
        Assert.assertThat((Object)json, (Matcher)JsonMatchers.hasField((String)"user.emailAddress").equalTo((Object)expectedPayload.emailAddress));
    }

    private void assertUserDeletedWebHookReceived(Supplier<String> receivedWebhook, String userKey) throws JSONException {
        JSONObject json = new JSONObject((String)receivedWebhook.get());
        Assert.assertThat((Object)json, (Matcher)JsonMatchers.hasField((String)"timestamp"));
        Assert.assertThat((Object)json, (Matcher)JsonMatchers.hasField((String)"webhookEvent").equalTo((Object)"user_deleted"));
        Assert.assertThat((Object)json, (Matcher)JsonMatchers.hasField((String)"user.name").equalTo((Object)USER_NAME));
        Assert.assertThat((Object)json, (Matcher)JsonMatchers.hasField((String)"user.key").equalTo((Object)userKey));
    }

    private void assertWebHookNotReceived(Supplier<String> receivedWebhook) throws JSONException {
        String webhook;
        try {
            webhook = (String)receivedWebhook.get();
        }
        catch (NullPointerException npe) {
            return;
        }
        Assert.assertTrue((String)("Didn't expect to receive this webhook: " + webhook), (boolean)false);
    }
}

