/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.backdoor.webhooks.WebHookRegistrationClient;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.IssueTransitionsMeta;
import com.atlassian.jira.testkit.client.restclient.TransitionsClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks.HttpResponseTester;
import com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks.WebHookResponseData;
import com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks.WebHookTester;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.WEBHOOKS, Category.REFERENCE_PLUGIN})
public class TestWebHookPostFunction
extends BaseJiraFuncTest {
    private TransitionsClient transitionsClient;
    @Rule
    public WebHookTester webHooks = new WebHookTester();

    @Before
    public void setUpTest() {
        this.transitionsClient = new TransitionsClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testFiringWebHookPostFunction() throws IOException, InterruptedException {
        this.backdoor.restoreDataFromResource("TestWebHookPostFunction.zip");
        HttpResponseTester homosapienTester = new HttpResponseTester(this.environmentData);
        HttpResponseTester monkeyTester = new HttpResponseTester(this.environmentData);
        homosapienTester.start();
        monkeyTester.start();
        WebHookRegistrationClient client = new WebHookRegistrationClient(this.environmentData);
        WebHookRegistrationClient.RegistrationResponse homosapienWebHook = client.getWebHook("1");
        WebHookRegistrationClient.Registration homosapienWebHookRegistration = new WebHookRegistrationClient.Registration();
        homosapienWebHookRegistration.setFilterForIssueSection(homosapienWebHook.getFilterForIssueSection());
        homosapienWebHookRegistration.name = homosapienWebHook.name;
        homosapienWebHookRegistration.url = homosapienTester.getPath();
        client.update("1", homosapienWebHookRegistration);
        WebHookRegistrationClient.RegistrationResponse monkeyWebHook = client.getWebHook("2");
        WebHookRegistrationClient.Registration monkeyWebHookRegistration = new WebHookRegistrationClient.Registration();
        monkeyWebHookRegistration.setFilterForIssueSection(monkeyWebHook.getFilterForIssueSection());
        monkeyWebHookRegistration.name = monkeyWebHook.name;
        monkeyWebHookRegistration.url = monkeyTester.getPath();
        client.update("2", monkeyWebHookRegistration);
        IssueCreateResponse hsp1 = this.backdoor.issues().createIssue("HSP", "HSP issue");
        this.startProgress(hsp1);
        WebHookResponseData monkeyTesterResponseData = monkeyTester.getResponseData();
        Assert.assertNull((Object)monkeyTesterResponseData);
        WebHookResponseData homosapienTesterResponseData = homosapienTester.getResponseData();
        Assert.assertNotNull((Object)homosapienTesterResponseData);
        this.stopProgress(hsp1);
        Assert.assertNull((Object)monkeyTester.getResponseData());
        Assert.assertNotNull((Object)homosapienTester.getResponseData());
        IssueCreateResponse monkey1 = this.backdoor.issues().createIssue("MKY", "MKY issue");
        this.startProgress(monkey1);
        monkeyTesterResponseData = monkeyTester.getResponseData();
        Assert.assertNotNull((Object)monkeyTesterResponseData);
        homosapienTesterResponseData = homosapienTester.getResponseData();
        Assert.assertNull((Object)homosapienTesterResponseData);
        this.resolveIssue(monkey1);
        monkeyTesterResponseData = monkeyTester.getResponseData();
        Assert.assertNotNull((Object)monkeyTesterResponseData);
        homosapienTesterResponseData = homosapienTester.getResponseData();
        Assert.assertNull((Object)homosapienTesterResponseData);
        this.closeIssue(monkey1);
        homosapienTesterResponseData = homosapienTester.getResponseData();
        Assert.assertNull((Object)homosapienTesterResponseData);
        homosapienTester.stop();
        monkeyTester.stop();
    }

    private void startProgress(IssueCreateResponse issueCreateResponse) {
        IssueTransitionsMeta issueTransitionsMeta = this.transitionsClient.get(issueCreateResponse.id());
        IssueUpdateRequest transition = TestWebHookPostFunction.getTransitionByName(issueTransitionsMeta, "Start Progress");
        this.transitionsClient.postResponse(issueCreateResponse.key(), transition);
    }

    private void stopProgress(IssueCreateResponse issueCreateResponse) {
        IssueTransitionsMeta issueTransitionsMeta = this.transitionsClient.get(issueCreateResponse.id());
        IssueUpdateRequest transition = TestWebHookPostFunction.getTransitionByName(issueTransitionsMeta, "Stop Progress");
        this.transitionsClient.postResponse(issueCreateResponse.key(), transition);
    }

    private void resolveIssue(IssueCreateResponse issueCreateResponse) {
        IssueTransitionsMeta issueTransitionsMeta = this.transitionsClient.get(issueCreateResponse.id());
        IssueUpdateRequest transition = TestWebHookPostFunction.getTransitionByName(issueTransitionsMeta, "Resolve Issue");
        this.transitionsClient.postResponse(issueCreateResponse.key(), transition);
    }

    private void closeIssue(IssueCreateResponse issueCreateResponse) {
        IssueTransitionsMeta issueTransitionsMeta = this.transitionsClient.get(issueCreateResponse.id());
        IssueUpdateRequest transition = TestWebHookPostFunction.getTransitionByName(issueTransitionsMeta, "Close Issue");
        this.transitionsClient.postResponse(issueCreateResponse.key(), transition);
    }

    private static IssueUpdateRequest getTransitionByName(IssueTransitionsMeta issueTransitionsMeta, String transitionName) {
        for (IssueTransitionsMeta.Transition transition : issueTransitionsMeta.transitions) {
            if (!transition.name.equals(transitionName)) continue;
            IssueUpdateRequest issueUpdateRequest = new IssueUpdateRequest();
            issueUpdateRequest.transition(ResourceRef.withId((String)String.valueOf(transition.id)));
            issueUpdateRequest.fields(new IssueFields());
            return issueUpdateRequest;
        }
        return null;
    }
}

