/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.assertions.WebHookAssert;
import com.atlassian.jira.functest.framework.backdoor.webhooks.WebHookRegistrationClient;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.User;
import com.atlassian.jira.testkit.client.restclient.UserClient;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.WEBHOOKS, Category.REFERENCE_PLUGIN})
public class TestWebHookRegistration
extends BaseJiraFuncTest {
    private WebHookRegistrationClient client;
    private static final Function<WebHookRegistrationClient.RegistrationResponse, String> ID_FUNCTION = input -> new File(input.self).getName();

    @Before
    public void setUpTest() {
        this.client = new WebHookRegistrationClient(this.environmentData);
        this.backdoor.restoreBlankInstance();
    }

    @Test
    public void testCreateReadDelete() throws Exception {
        WebHookRegistrationClient client = new WebHookRegistrationClient(this.environmentData);
        WebHookRegistrationClient.Registration registration = new WebHookRegistrationClient.Registration();
        registration.name = "New Web Hook";
        registration.url = "http://localhost:12343/hook/" + Math.random();
        registration.events = new String[]{"jira:issue_updated"};
        registration.setFilterForIssueSection("type = Bug");
        WebHookRegistrationClient.RegistrationResponse expectedResponse = new WebHookRegistrationClient.RegistrationResponse(registration);
        expectedResponse.lastUpdatedUser = "admin";
        expectedResponse.excludeBody = false;
        UserClient uc = new UserClient((JIRAEnvironmentData)this.environmentData);
        expectedResponse.lastUpdatedDisplayName = uc.get((String)expectedResponse.lastUpdatedUser, (User.Expand[])new User.Expand[0]).displayName;
        expectedResponse.lastUpdated = System.currentTimeMillis();
        WebHookRegistrationClient.RegistrationResponse registeredResponse = client.register(registration);
        String id = new File(registeredResponse.self).getName();
        expectedResponse.self = this.environmentData.getBaseUrl().toString() + "/rest/webhooks/1.0/webhook/" + id;
        Assert.assertThat((Object)registeredResponse.self, (Matcher)Matchers.startsWith((String)this.environmentData.getBaseUrl().toString()));
        Assert.assertEquals((Object)expectedResponse, (Object)registeredResponse);
        WebTarget webTarget = client.createResource(registeredResponse.self);
        List<WebHookRegistrationClient.RegistrationResponse> allWebHooks = client.getAllWebHooks();
        ImmutableListMultimap index = Multimaps.index(allWebHooks, ID_FUNCTION);
        Assert.assertTrue((boolean)index.containsKey((Object)id));
        WebHookRegistrationClient.Registration fromAll = (WebHookRegistrationClient.Registration)Iterables.getOnlyElement((Iterable)index.get((Object)id));
        Assert.assertEquals((Object)expectedResponse, (Object)fromAll);
        WebHookRegistrationClient.RegistrationResponse webHook = client.getWebHook(id);
        Assert.assertEquals((Object)expectedResponse, (Object)webHook);
        WebHookRegistrationClient.Registration webHook2 = (WebHookRegistrationClient.Registration)webTarget.request().get(WebHookRegistrationClient.RegistrationResponse.class);
        Assert.assertEquals((Object)expectedResponse, (Object)webHook2);
        webTarget.request().delete();
        Response noWebHook = (Response)webTarget.request().get(Response.class);
        Assert.assertEquals((long)404L, (long)noWebHook.getStatus());
        noWebHook.close();
        List<WebHookRegistrationClient.RegistrationResponse> allWebHooksAfterDelete = client.getAllWebHooks();
        ImmutableListMultimap indexAfter = Multimaps.index(allWebHooksAfterDelete, ID_FUNCTION);
        Assert.assertFalse((boolean)indexAfter.containsKey((Object)id));
    }

    @Test
    public void testRegisterVersionWebHook() throws Exception {
        WebHookRegistrationClient client = new WebHookRegistrationClient(this.environmentData);
        WebHookRegistrationClient.Registration registration = new WebHookRegistrationClient.Registration();
        registration.name = "New Web Hook";
        registration.url = "http://localhost:12343/hook/" + Math.random();
        registration.events = new String[]{"jira:version_released"};
        registration.setFilterForIssueSection("project = HSP");
        WebHookRegistrationClient.RegistrationResponse expectedResponse = new WebHookRegistrationClient.RegistrationResponse(registration);
        expectedResponse.lastUpdatedUser = "admin";
        UserClient uc = new UserClient((JIRAEnvironmentData)this.environmentData);
        expectedResponse.lastUpdatedDisplayName = uc.get((String)expectedResponse.lastUpdatedUser, (User.Expand[])new User.Expand[0]).displayName;
        expectedResponse.lastUpdated = System.currentTimeMillis();
        expectedResponse.excludeBody = false;
        WebHookRegistrationClient.RegistrationResponse registeredResponse = client.register(registration);
        String id = new File(registeredResponse.self).getName();
        expectedResponse.self = this.environmentData.getBaseUrl().toString() + "/rest/webhooks/1.0/webhook/" + id;
        Assert.assertThat((Object)registeredResponse.self, (Matcher)Matchers.startsWith((String)this.environmentData.getBaseUrl().toString()));
        Assert.assertEquals((Object)expectedResponse, (Object)registeredResponse);
        WebTarget resource = client.createResource(registeredResponse.self);
        List<WebHookRegistrationClient.RegistrationResponse> allWebHooks = client.getAllWebHooks();
        ImmutableListMultimap index = Multimaps.index(allWebHooks, ID_FUNCTION);
        Assert.assertTrue((boolean)index.containsKey((Object)id));
        WebHookRegistrationClient.Registration fromAll = (WebHookRegistrationClient.Registration)Iterables.getOnlyElement((Iterable)index.get((Object)id));
        Assert.assertEquals((Object)expectedResponse, (Object)fromAll);
        WebHookRegistrationClient.RegistrationResponse webHook = client.getWebHook(id);
        Assert.assertEquals((Object)expectedResponse, (Object)webHook);
        WebHookRegistrationClient.Registration webHook2 = (WebHookRegistrationClient.Registration)resource.request().get(WebHookRegistrationClient.RegistrationResponse.class);
        Assert.assertEquals((Object)expectedResponse, (Object)webHook2);
        resource.request().delete();
        Response noWebHook = (Response)resource.request().get(Response.class);
        Assert.assertEquals((long)404L, (long)noWebHook.getStatus());
        noWebHook.close();
        List<WebHookRegistrationClient.RegistrationResponse> allWebHooksAfterDelete = client.getAllWebHooks();
        ImmutableListMultimap indexAfter = Multimaps.index(allWebHooksAfterDelete, ID_FUNCTION);
        Assert.assertFalse((boolean)indexAfter.containsKey((Object)id));
    }

    @Test
    public void testUpdate() throws InvocationTargetException, IllegalAccessException {
        String hookUpdateUrl;
        String genericTestHookUrl;
        this.backdoor.usersAndGroups().addUserEvenIfUserExists("new_admin", "new_admin", "New Admin", "newadmin@example.com");
        this.backdoor.usersAndGroups().addUserToGroup("new_admin", "jira-administrators");
        WebHookRegistrationClient.Registration registration = new WebHookRegistrationClient.Registration();
        registration.name = "Test Web Hook";
        registration.url = "http://localhost:12343/hook/" + Math.random();
        registration.events = new String[]{"jira:issue_updated"};
        registration.setFilterForIssueSection("type = Bug");
        WebHookRegistrationClient.RegistrationResponse registeredResponse = this.client.register(registration);
        String id = new File(registeredResponse.self).getName();
        this.client.update(id, registration);
        WebHookRegistrationClient.RegistrationResponse response = this.client.getWebHook(id);
        Assert.assertEquals((Object)this.expectedResponse(registration, id), (Object)response);
        registration.name = "New Name Web Hook";
        WebHookRegistrationClient.RegistrationResponse updateResponse = ((WebHookRegistrationClient)this.client.loginAs("new_admin")).update(id, registration);
        Assert.assertEquals((Object)this.expectedResponse(registration, id, "new_admin"), (Object)updateResponse);
        response = this.client.getWebHook(id);
        Assert.assertEquals((Object)this.expectedResponse(registration, id, "new_admin"), (Object)response);
        response.name = "Changed with reused object";
        Response put = (Response)this.client.createResource(registeredResponse.self).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)new WebHookRegistrationClient.Registration(response)), Response.class);
        Assert.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)put.getStatusInfo().getFamily());
        put.close();
        response = this.client.getWebHook(id);
        Assert.assertEquals((Object)"Changed with reused object", (Object)response.name);
        registration.url = genericTestHookUrl = "http://localhost:12343/genericTestHook" + Math.random();
        ((WebHookRegistrationClient)this.client.loginAs("admin")).update(id, registration);
        response = this.client.getWebHook(id);
        Assert.assertEquals((Object)this.expectedResponse(registration, id), (Object)response);
        registration.events = new String[]{"jira:issue_updated"};
        this.client.update(id, registration);
        response = this.client.getWebHook(id);
        Assert.assertEquals((Object)this.expectedResponse(registration, id), (Object)response);
        this.client.update(id, registration);
        response = this.client.getWebHook(id);
        Assert.assertEquals((Object)this.expectedResponse(registration, id), (Object)response);
        WebHookRegistrationClient.Registration invalidRegistration = new WebHookRegistrationClient.Registration();
        invalidRegistration.name = "Test Web Hook 2";
        invalidRegistration.url = hookUpdateUrl = "http://localhost:12343/hookUpdate/" + Math.random();
        invalidRegistration.events = new String[]{"jira:issue_updated"};
        WebHookRegistrationClient.RegistrationResponse registeredOtherResponse = this.client.register(invalidRegistration);
        String otherId = new File(registeredOtherResponse.self).getName();
        invalidRegistration.url = genericTestHookUrl;
        invalidRegistration.events = new String[]{"jira:issue_updated"};
        invalidRegistration.filters = updateResponse.filters;
        invalidRegistration.excludeBody = updateResponse.excludeBody;
        WebHookAssert.assertWebApplicationException(Response.Status.CONFLICT, () -> {
            this.client.updateStatus(otherId, invalidRegistration);
            return null;
        });
        invalidRegistration.url = hookUpdateUrl;
        invalidRegistration.events = new String[]{"jira:issue_updated"};
        WebHookRegistrationClient.RegistrationResponse registrationResponse = this.client.update(otherId, invalidRegistration);
        Assert.assertEquals((Object)this.expectedResponse(invalidRegistration, otherId), (Object)registrationResponse);
    }

    @Test
    public void testDeleteWebHookWithAssociatedTransition() {
        this.backdoor.restoreDataFromResource("TestWebHookPostFunction.zip");
        Assert.assertNotNull((Object)this.client.getWebHook("1"));
        Assert.assertNotNull((Object)this.client.getWebHook("2"));
        WebHookAssert.assertWebApplicationException(Response.Status.CONFLICT, () -> {
            this.client.delete("1");
            return null;
        });
        WebHookAssert.assertWebApplicationException(Response.Status.CONFLICT, () -> {
            Assert.assertNotNull((Object)this.client.getWebHook("2"));
            this.client.delete("2");
            return null;
        });
    }

    private WebHookRegistrationClient.RegistrationResponse expectedResponse(WebHookRegistrationClient.Registration registration, String id) throws InvocationTargetException, IllegalAccessException {
        return this.expectedResponse(registration, id, "admin");
    }

    private WebHookRegistrationClient.RegistrationResponse expectedResponse(WebHookRegistrationClient.Registration registration, String id, String username) throws InvocationTargetException, IllegalAccessException {
        WebHookRegistrationClient.RegistrationResponse expectedResponse = new WebHookRegistrationClient.RegistrationResponse(registration);
        expectedResponse.lastUpdatedUser = username;
        UserClient uc = new UserClient((JIRAEnvironmentData)this.environmentData);
        expectedResponse.lastUpdatedDisplayName = uc.get((String)expectedResponse.lastUpdatedUser, (User.Expand[])new User.Expand[0]).displayName;
        expectedResponse.lastUpdated = System.currentTimeMillis();
        expectedResponse.self = this.environmentData.getBaseUrl().toString() + "/rest/webhooks/1.0/webhook/" + id;
        expectedResponse.excludeBody = false;
        return expectedResponse;
    }
}

