/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.backdoor.webhooks.WebHookRegistrationClient;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.JSONObjectContains;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.atlassian.jira.testkit.client.util.JsonMatchers;
import com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks.HttpResponseTester;
import com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks.WebHookResponseData;
import com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks.WebHookTester;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.WEBHOOKS, Category.REFERENCE_PLUGIN})
public class TestWebHookResponse
extends BaseJiraFuncTest {
    private WebHookRegistrationClient client;
    @Rule
    public WebHookTester webHooks = new WebHookTester();

    @Before
    public void setUpTest() {
        this.backdoor.restoreBlankInstance();
        this.client = new WebHookRegistrationClient(this.environmentData);
    }

    @Test
    public void testRemoteNotificationOnCommentIssueEvent() throws IOException, InterruptedException, JSONException {
        WebHookRegistrationClient.Registration registration = new WebHookRegistrationClient.Registration();
        registration.name = "Comment Issue Web Hook";
        registration.events = new String[]{"jira:issue_updated"};
        this.webHooks.getResponseTester().registerWebhook(registration);
        this.backdoor.issues().createIssue("HSP", "This is first issue");
        this.backdoor.issues().commentIssue("HSP-1", "My comments");
        JSONObject event = new JSONObject(this.webHooks.getResponseTester().getResponseData().getJson());
        Assert.assertThat((Object)event, (Matcher)JsonMatchers.hasField((String)"issue"));
        Assert.assertThat((Object)event.getJSONObject("issue"), (Matcher)JsonMatchers.hasField((String)"fields"));
        Assert.assertThat((Object)event.getJSONObject("issue").getJSONObject("fields"), (Matcher)JsonMatchers.hasField((String)"comment"));
        JSONObject commentBlock = event.getJSONObject("issue").getJSONObject("fields").getJSONObject("comment");
        Assert.assertEquals((Object)1, (Object)commentBlock.get("total"));
        JSONObject comment = commentBlock.getJSONArray("comments").getJSONObject(0);
        Assert.assertThat((Object)comment, (Matcher)new JSONObjectContains("id", "body", "created", "updated", "self", "author", "updateAuthor", "visibility"));
        Assert.assertEquals((Object)"10000", (Object)comment.get("id"));
        Assert.assertEquals((Object)"My comments", (Object)comment.get("body"));
        Assert.assertThat((Object)comment.getString("self"), (Matcher)Matchers.endsWith((String)"rest/api/2/issue/10000/comment/10000"));
    }

    @Test
    public void testEventNotSentAfterRemovingWebHook() throws IOException, InterruptedException {
        WebHookRegistrationClient.Registration registration = new WebHookRegistrationClient.Registration();
        registration.name = "Comment Issue Web Hook";
        registration.events = new String[]{"jira:issue_updated"};
        String uri = this.webHooks.getResponseTester().registerWebhook((WebHookRegistrationClient.Registration)registration).self;
        this.client.delete(new File(uri).getName());
        this.backdoor.issues().createIssue("HSP", "This is first issue");
        this.backdoor.issues().commentIssue("HSP-1", "My comments");
        Assert.assertNull((Object)this.webHooks.getResponseTester().getResponseData());
    }

    @Test
    public void testFilteringOut() throws IOException, InterruptedException {
        WebHookRegistrationClient.Registration registration = new WebHookRegistrationClient.Registration();
        registration.name = "Comment Issue Web Hook";
        registration.events = new String[]{"jira:issue_updated"};
        registration.setFilterForIssueSection("project = MKY");
        this.webHooks.getResponseTester().registerWebhook(registration);
        this.backdoor.issues().createIssue("HSP", "This is first issue");
        this.backdoor.issues().commentIssue("HSP-1", "My comments");
        Assert.assertNull((Object)this.webHooks.getResponseTester().getResponseData());
    }

    @Test
    public void testFiltering() throws InterruptedException, JSONException {
        WebHookRegistrationClient.Registration registration = new WebHookRegistrationClient.Registration();
        registration.name = "Comment Issue Web Hook";
        registration.events = new String[]{"jira:issue_updated"};
        registration.setFilterForIssueSection("project = MKY");
        this.webHooks.getResponseTester().registerWebhook(registration);
        this.backdoor.issues().createIssue("MKY", "This is first mky issue");
        this.backdoor.issues().commentIssue("MKY-1", "My sample comment");
        JSONObject event = new JSONObject(this.webHooks.getResponseTester().getResponseData().getJson());
        Assert.assertThat((Object)event, (Matcher)JsonMatchers.hasField((String)"issue.fields.comment"));
        JSONObject commentBlock = event.getJSONObject("issue").getJSONObject("fields").getJSONObject("comment");
        Assert.assertEquals((Object)1, (Object)commentBlock.get("total"));
        JSONObject comment = commentBlock.getJSONArray("comments").getJSONObject(0);
        Assert.assertThat((Object)comment, (Matcher)new JSONObjectContains("id", "body", "created", "updated", "self", "author", "updateAuthor", "visibility"));
        Assert.assertEquals((Object)"10000", (Object)comment.get("id"));
        Assert.assertEquals((Object)"My sample comment", (Object)comment.get("body"));
        Assert.assertThat((Object)comment.getString("self"), (Matcher)Matchers.endsWith((String)"rest/api/2/issue/10000/comment/10000"));
        Assert.assertNull((Object)this.webHooks.getResponseTester().getResponseData());
        this.backdoor.issues().createIssue("HSP", "This is hsp issue, no webhook for this");
        this.backdoor.issues().commentIssue("HSP-1", "No webhook triggered for this update");
        Assert.assertNull((Object)this.webHooks.getResponseTester().getResponseData());
    }

    @Test
    public void testWebHookDisabling() throws IOException, InterruptedException, JSONException {
        WebHookRegistrationClient.Registration registration = new WebHookRegistrationClient.Registration();
        registration.name = "Comment Issue Web Hook";
        registration.events = new String[]{"jira:issue_updated"};
        String uri = this.webHooks.getResponseTester().registerWebhook((WebHookRegistrationClient.Registration)registration).self;
        this.backdoor.issues().createIssue("HSP", "This is first issue");
        this.backdoor.issues().commentIssue("HSP-1", "My comments");
        JSONObject event = new JSONObject(this.webHooks.getResponseTester().getResponseData().getJson());
        Assert.assertThat((Object)event, (Matcher)JsonMatchers.hasField((String)"issue.fields.comment"));
        JSONObject commentBlock = event.getJSONObject("issue").getJSONObject("fields").getJSONObject("comment");
        Assert.assertEquals((Object)1, (Object)commentBlock.get("total"));
        JSONObject comment = commentBlock.getJSONArray("comments").getJSONObject(0);
        Assert.assertThat((Object)comment, (Matcher)new JSONObjectContains("id", "body", "created", "updated", "self", "author", "updateAuthor", "visibility"));
        Assert.assertEquals((Object)"10000", (Object)comment.get("id"));
        Assert.assertEquals((Object)"My comments", (Object)comment.get("body"));
        Assert.assertThat((Object)comment.getString("self"), (Matcher)Matchers.endsWith((String)"rest/api/2/issue/10000/comment/10000"));
        WebHookRegistrationClient client = new WebHookRegistrationClient(this.environmentData);
        String id = new File(uri).getName();
        client.disable(id);
        this.backdoor.issues().commentIssue("HSP-1", "Second comment");
        Assert.assertNull((Object)this.webHooks.getResponseTester().getResponseData());
        client.enable(id);
        this.backdoor.issues().commentIssue("HSP-1", "Third comment");
        JSONObject issueCommentedEvent = new JSONObject(this.webHooks.getResponseTester().getResponseData().getJson());
        Assert.assertThat((Object)issueCommentedEvent, (Matcher)JsonMatchers.hasField((String)"issue.fields.comment"));
        JSONObject issueCommentedEventCommentBlock = issueCommentedEvent.getJSONObject("issue").getJSONObject("fields").getJSONObject("comment");
        Assert.assertEquals((Object)3, (Object)issueCommentedEventCommentBlock.get("total"));
        JSONObject issueCommentedEventComment = issueCommentedEventCommentBlock.getJSONArray("comments").getJSONObject(2);
        Assert.assertThat((Object)issueCommentedEventComment, (Matcher)new JSONObjectContains("id", "body", "created", "updated", "self", "author", "updateAuthor", "visibility"));
        Assert.assertEquals((Object)"10002", (Object)issueCommentedEventComment.get("id"));
        Assert.assertEquals((Object)"Third comment", (Object)issueCommentedEventComment.get("body"));
        Assert.assertThat((Object)issueCommentedEventComment.getString("self"), (Matcher)Matchers.endsWith((String)"rest/api/2/issue/10000/comment/10002"));
    }

    @Test
    public void testDisabledWebHookNotPublishAfterEdit() throws IOException, InterruptedException, JSONException {
        HttpResponseTester enabledWebHookTester = HttpResponseTester.createTester(this.environmentData);
        this.webHooks.addToCleanupList(enabledWebHookTester);
        WebHookRegistrationClient.Registration enabledListener = new WebHookRegistrationClient.Registration();
        enabledListener.name = "Canary Webhook";
        enabledListener.events = new String[]{"jira:issue_updated", "jira:issue_created"};
        enabledWebHookTester.registerWebhook(enabledListener);
        WebHookRegistrationClient.Registration disabledWebHook = new WebHookRegistrationClient.Registration();
        disabledWebHook.name = "Comment Issue Web Hook";
        disabledWebHook.events = new String[]{"jira:issue_updated"};
        String uri = this.webHooks.getResponseTester().registerWebhook((WebHookRegistrationClient.Registration)disabledWebHook).self;
        String id = new File(uri).getName();
        this.client.disable(id);
        this.backdoor.issues().createIssue("HSP", "This is first issue");
        String response1 = enabledWebHookTester.getResponseData().getJson();
        Assert.assertNotNull((Object)response1);
        Assert.assertEquals((Object)"jira:issue_created", (Object)new JSONObject(response1).get("webhookEvent"));
        this.backdoor.issues().commentIssue("HSP-1", "My comments");
        String response2 = enabledWebHookTester.getResponseData().getJson();
        Assert.assertNotNull((Object)response2);
        Assert.assertEquals((Object)"jira:issue_updated", (Object)new JSONObject(response2).get("webhookEvent"));
        Assert.assertNull((Object)this.webHooks.getResponseTester().getResponseData());
    }

    @Test
    public void testExcludeIssueBodyInResponse() throws IOException, InterruptedException {
        WebHookRegistrationClient.Registration registration = new WebHookRegistrationClient.Registration();
        registration.name = "Comment Issue Web Hook";
        registration.events = new String[]{"jira:issue_updated"};
        registration.excludeBody = true;
        this.webHooks.getResponseTester().registerWebhook(registration);
        this.backdoor.issues().createIssue("HSP", "This is first issue");
        this.backdoor.issues().commentIssue("HSP-1", "My comments");
        String response = this.webHooks.getResponseTester().getResponseData().getJson();
        Assert.assertTrue((boolean)StringUtils.isEmpty((CharSequence)response));
    }

    @Test
    public void testWithIssueDeletedEvent() throws IOException, InterruptedException, JSONException {
        WebHookRegistrationClient.Registration registration = new WebHookRegistrationClient.Registration();
        registration.name = "Issue Deleted Web Hook";
        String webhookEventId = "jira:issue_deleted";
        registration.events = new String[]{"jira:issue_deleted"};
        this.webHooks.getResponseTester().registerWebhook(registration);
        IssueCreateResponse createdIssue = this.backdoor.issues().createIssue("HSP", "This is first issue");
        this.backdoor.issues().deleteIssue(createdIssue.key(), true);
        JSONObject event = new JSONObject(this.webHooks.getResponseTester().getResponseData().getJson());
        Assert.assertEquals((Object)"jira:issue_deleted", (Object)event.get("webhookEvent"));
        Assert.assertThat((Object)event, (Matcher)JsonMatchers.hasField((String)"user"));
        Assert.assertEquals((Object)"admin", (Object)event.getJSONObject("user").get("name"));
        Assert.assertThat((Object)event, (Matcher)JsonMatchers.hasField((String)"issue"));
        Assert.assertEquals((Object)createdIssue.id(), (Object)event.getJSONObject("issue").get("id"));
    }

    @Test
    public void testWithIssueDeletedEventAndJqlFilteringWithMatch() throws IOException, InterruptedException, JSONException {
        WebHookRegistrationClient.Registration registration = new WebHookRegistrationClient.Registration();
        registration.name = "Issue Deleted Web Hook";
        String webhookEventId = "jira:issue_deleted";
        registration.events = new String[]{"jira:issue_deleted"};
        registration.setFilterForIssueSection("summary ~ \"SomeSummaryToMatch\"");
        this.webHooks.getResponseTester().registerWebhook(registration);
        IssueCreateResponse createdIssue = this.backdoor.issues().createIssue("HSP", "SomeSummaryToMatch");
        this.backdoor.issues().deleteIssue(createdIssue.key, true);
        JSONObject event = new JSONObject(this.webHooks.getResponseTester().getResponseData().getJson());
        Assert.assertEquals((Object)"jira:issue_deleted", (Object)event.get("webhookEvent"));
        Assert.assertThat((Object)event, (Matcher)JsonMatchers.hasField((String)"user"));
        Assert.assertEquals((Object)"admin", (Object)event.getJSONObject("user").get("name"));
        Assert.assertThat((Object)event, (Matcher)JsonMatchers.hasField((String)"issue"));
        Assert.assertEquals((Object)createdIssue.id(), (Object)event.getJSONObject("issue").get("id"));
    }

    @Test
    public void testWithIssueDeletedEventAndJqlFilteringWithoutMatch() throws IOException, InterruptedException {
        WebHookRegistrationClient.Registration registration = new WebHookRegistrationClient.Registration();
        registration.name = "Issue Deleted Web Hook";
        String webhookEventId = "jira:issue_deleted";
        registration.events = new String[]{"jira:issue_deleted"};
        registration.setFilterForIssueSection("summary ~ \"SomeSummaryToMatch\"");
        this.webHooks.getResponseTester().registerWebhook(registration);
        IssueCreateResponse createdIssue = this.backdoor.issues().createIssue("HSP", "ShouldNotMatch");
        this.backdoor.issues().deleteIssue(createdIssue.key, true);
        Assert.assertNull((String)"Expected that webhook won't be triggered.", (Object)this.webHooks.getResponseTester().getResponseData());
    }

    @Test
    public void testWebHookWithWhiteSpaceInUrl() throws InterruptedException, JSONException {
        WebHookRegistrationClient.Registration registration = new WebHookRegistrationClient.Registration();
        String webhookEventId = "jira:issue_created";
        registration.name = "Comment Issue Web Hook";
        registration.events = new String[]{"jira:issue_created"};
        registration.path = "project%20${issue.key}";
        this.webHooks.getResponseTester().registerWebhook(registration);
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "SomeSummaryToMatch");
        WebHookResponseData webHookResponse = this.webHooks.getResponseTester().getResponseData();
        JSONObject event = new JSONObject(webHookResponse.getJson());
        Assert.assertThat((Object)webHookResponse.getUri().getRawPath(), (Matcher)Matchers.endsWith((String)("project%20" + issue.key())));
        Assert.assertEquals((Object)"jira:issue_created", (Object)event.get("webhookEvent"));
        Assert.assertThat((Object)event, (Matcher)JsonMatchers.hasField((String)"user"));
        Assert.assertEquals((Object)"admin", (Object)event.getJSONObject("user").get("name"));
        Assert.assertThat((Object)event, (Matcher)JsonMatchers.hasField((String)"issue"));
        Assert.assertEquals((Object)issue.id(), (Object)event.getJSONObject("issue").get("id"));
    }

    @Test
    public void testVersionWebhookFires() throws Exception {
        WebHookRegistrationClient.Registration registration = new WebHookRegistrationClient.Registration();
        registration.name = "Version Updated Web Hook";
        registration.events = new String[]{"jira:version_created"};
        this.webHooks.getResponseTester().registerWebhook(registration);
        Version createdVersion = this.webHooks.getVersionControl().createVersion("TestVer", "A Test version", "HSP");
        this.checkVersionWebhook("TestVer", createdVersion.id, "jira:version_created");
        Assert.assertNull((Object)this.webHooks.getResponseTester().getResponseData());
        this.backdoor.issues().createIssue("HSP", "This is hsp issue, no webhook for this");
        this.backdoor.issues().commentIssue("HSP-1", "No webhook triggered for this update");
        Assert.assertNull((Object)this.webHooks.getResponseTester().getResponseData());
    }

    @Test
    public void testVersionUnreleasedWebHookFires() throws Exception {
        WebHookRegistrationClient.Registration registration1 = new WebHookRegistrationClient.Registration();
        registration1.name = "Version Released Web Hook 1";
        registration1.events = new String[]{"jira:version_unreleased"};
        this.webHooks.getResponseTester().registerWebhook(registration1);
        Version createdVersion1 = this.webHooks.getVersionControl().createVersion("TestVer3", "A Test version", "HSP");
        this.webHooks.getVersionControl().releaseVersion(createdVersion1.id);
        Assert.assertNull((Object)this.webHooks.getResponseTester().getResponseData());
        this.webHooks.getVersionControl().unreleaseVersion(createdVersion1.id);
        this.checkVersionWebhook("TestVer3", createdVersion1.id, "jira:version_unreleased");
        Assert.assertNull((Object)this.webHooks.getResponseTester().getResponseData());
    }

    private void checkVersionWebhook(String name, long versionId, String eventName) throws Exception {
        JSONObject event = new JSONObject(this.webHooks.getResponseTester().getResponseData().getJson());
        Assert.assertThat((Object)event, (Matcher)JsonMatchers.hasField((String)"version.name"));
        Assert.assertEquals((Object)name, (Object)event.getJSONObject("version").get("name"));
        Assert.assertThat((Object)event, (Matcher)JsonMatchers.hasField((String)"webhookEvent"));
        Assert.assertEquals((Object)eventName, (Object)event.get("webhookEvent"));
        Assert.assertThat((Object)event.getJSONObject("version"), (Matcher)JsonMatchers.hasField((String)"id"));
        Assert.assertEquals((Object)versionId, (Object)event.getJSONObject("version").getLong("id"));
    }
}

