/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks;

import com.atlassian.jira.project.version.Version;
import java.net.URI;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class VersionBean {
    private URI self;
    private String id;
    private String description;
    private String name;
    private boolean archived;
    private boolean released;
    private Date startDate;
    private boolean startDateSet = false;
    private Date releaseDate;
    private boolean releaseDateSet = false;
    private boolean overdue;
    private String userStartDate;
    private String userReleaseDate;
    private Long projectId;
    private URI moveUnfixedIssuesTo;

    public Long getProjectId() {
        return this.projectId;
    }

    public String getUserStartDate() {
        return this.userStartDate;
    }

    public String getUserReleaseDate() {
        return this.userReleaseDate;
    }

    public boolean getOverdue() {
        return this.overdue;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public boolean isStartDateSet() {
        return this.startDateSet;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public boolean isReleaseDateSet() {
        return this.releaseDateSet;
    }

    public boolean isReleased() {
        return this.released;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public URI getSelf() {
        return this.self;
    }

    public URI getMoveUnfixedIssuesTo() {
        return this.moveUnfixedIssuesTo;
    }

    public void setSelf(URI self) {
        this.self = self;
    }

    public void setId(Long id) {
        this.id = id == null ? null : id.toString();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    public void setReleased(boolean released) {
        this.released = released;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
        this.startDateSet = true;
    }

    public void setReleaseDate(Date releaseDate) {
        this.releaseDate = releaseDate;
        this.releaseDateSet = true;
    }

    public void setOverdue(boolean overdue) {
        this.overdue = overdue;
    }

    public void setUserStartDate(String userStartDate) {
        this.userStartDate = userStartDate;
    }

    public void setUserReleaseDate(String userReleaseDate) {
        this.userReleaseDate = userReleaseDate;
    }

    public void setMoveUnfixedIssuesTo(URI moveUnfixedIssuesTo) {
        this.moveUnfixedIssuesTo = moveUnfixedIssuesTo;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public VersionBean() {
    }

    private VersionBean(Long id, Long projectId, URI self, String name, String description, boolean archived, boolean released, Date startDate, boolean startDateSet, String userStartDate, Date releaseDate, boolean releaseDateSet, String userReleaseDate, boolean overdue) {
        this.id = id == null ? null : id.toString();
        this.self = self;
        this.description = description;
        this.name = name;
        this.archived = archived;
        this.released = released;
        this.startDate = startDate;
        this.startDateSet = startDateSet;
        this.userStartDate = userStartDate;
        this.releaseDate = releaseDate;
        this.releaseDateSet = releaseDateSet;
        this.userReleaseDate = userReleaseDate;
        this.overdue = overdue;
        this.projectId = projectId;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionBean that = (VersionBean)o;
        if (this.archived != that.archived) {
            return false;
        }
        if (this.overdue != that.overdue) {
            return false;
        }
        if (this.releaseDateSet != that.releaseDateSet) {
            return false;
        }
        if (this.released != that.released) {
            return false;
        }
        if (this.startDateSet != that.startDateSet) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.moveUnfixedIssuesTo != null ? !this.moveUnfixedIssuesTo.equals(that.moveUnfixedIssuesTo) : that.moveUnfixedIssuesTo != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.projectId != null ? !this.projectId.equals(that.projectId) : that.projectId != null) {
            return false;
        }
        if (this.releaseDate != null ? !this.releaseDate.equals(that.releaseDate) : that.releaseDate != null) {
            return false;
        }
        if (this.self != null ? !this.self.equals(that.self) : that.self != null) {
            return false;
        }
        if (this.startDate != null ? !this.startDate.equals(that.startDate) : that.startDate != null) {
            return false;
        }
        if (this.userReleaseDate != null ? !this.userReleaseDate.equals(that.userReleaseDate) : that.userReleaseDate != null) {
            return false;
        }
        return !(this.userStartDate != null ? !this.userStartDate.equals(that.userStartDate) : that.userStartDate != null);
    }

    public int hashCode() {
        int result = this.self != null ? this.self.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.archived ? 1 : 0);
        result = 31 * result + (this.released ? 1 : 0);
        result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
        result = 31 * result + (this.startDateSet ? 1 : 0);
        result = 31 * result + (this.releaseDate != null ? this.releaseDate.hashCode() : 0);
        result = 31 * result + (this.releaseDateSet ? 1 : 0);
        result = 31 * result + (this.overdue ? 1 : 0);
        result = 31 * result + (this.userStartDate != null ? this.userStartDate.hashCode() : 0);
        result = 31 * result + (this.userReleaseDate != null ? this.userReleaseDate.hashCode() : 0);
        result = 31 * result + (this.projectId != null ? this.projectId.hashCode() : 0);
        result = 31 * result + (this.moveUnfixedIssuesTo != null ? this.moveUnfixedIssuesTo.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private URI self;
        private Long id;
        private String description;
        private String name;
        private boolean archived;
        private boolean released;
        private Date startDate;
        private boolean startDateSet;
        private Date releaseDate;
        private boolean releaseDateSet;
        private boolean overdue;
        private String userStartDate;
        private String userReleaseDate;
        private Long projectId;
        private String expand;

        public URI getSelf() {
            return this.self;
        }

        public Builder setSelf(URI self) {
            this.self = self;
            return this;
        }

        public Builder setVersion(Version version) {
            this.id = version.getId();
            this.name = version.getName();
            this.description = StringUtils.stripToNull((String)version.getDescription());
            this.startDate = version.getStartDate();
            this.releaseDate = version.getReleaseDate();
            this.archived = version.isArchived();
            this.released = version.isReleased();
            return this;
        }

        public Long getId() {
            return this.id;
        }

        public Builder setId(Long id) {
            this.id = id;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public boolean isArchived() {
            return this.archived;
        }

        public Builder setArchived(boolean archived) {
            this.archived = archived;
            return this;
        }

        public boolean isReleased() {
            return this.released;
        }

        public Builder setReleased(boolean released) {
            this.released = released;
            return this;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public Builder setStartDate(Date startDate) {
            this.startDate = startDate;
            this.startDateSet = true;
            return this;
        }

        public Date getReleaseDate() {
            return this.releaseDate;
        }

        public Builder setReleaseDate(Date releaseDate) {
            this.releaseDate = releaseDate;
            this.releaseDateSet = true;
            return this;
        }

        public boolean getOverdue() {
            return this.overdue;
        }

        public Builder setOverdue(boolean overdue) {
            this.overdue = overdue;
            return this;
        }

        public String getUserStartDate() {
            return this.userStartDate;
        }

        public Builder setUserStartDate(String userStartDate) {
            this.userStartDate = userStartDate;
            return this;
        }

        public String getUserReleaseDate() {
            return this.userReleaseDate;
        }

        public Builder setUserReleaseDate(String userReleaseDate) {
            this.userReleaseDate = userReleaseDate;
            return this;
        }

        public Builder setProjectId(Long projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder setExpand(String expand) {
            this.expand = expand;
            return this;
        }

        public VersionBean build() {
            return new VersionBean(this.id, this.projectId, this.self, this.name, this.description, this.archived, this.released, this.startDate, this.startDateSet, this.userStartDate, this.releaseDate, this.releaseDateSet, this.userReleaseDate, this.overdue);
        }
    }
}

