/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.comment;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.permission.ProjectPermissions;
import com.google.common.collect.Iterables;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;

public abstract class TestAddComment
extends BaseJiraFuncTest {
    private final String commentLinkid;
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    TestAddComment(String commentLinkid) {
        this.commentLinkid = commentLinkid;
    }

    @Test
    @RestoreBlankInstance
    public void testCannotAddCommentWithoutIssue() {
        this.navigation.gotoPage(this.page.addXsrfToken("/secure/AddComment.jspa"));
        this.tester.assertTitleEquals("Error - jWebTest JIRA installation");
        this.textAssertions.assertTextPresent(new CssLocator(this.tester, "#content .aui-message-error"), "The issue no longer exists.");
    }

    @Test
    @Restore(value="TestAddComment.xml")
    public void testCommentVisiblityOrdering() {
        String FIRST_GROUP_NAME = "a group";
        String LAST_GROUP_NAME = "z group";
        this.administration.usersAndGroups().addGroup("a group");
        this.administration.usersAndGroups().addGroup("z group");
        this.administration.usersAndGroups().addUserToGroup("admin", "a group");
        this.administration.usersAndGroups().addUserToGroup("admin", "z group");
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.clickLink(this.commentLinkid);
        this.tester.setWorkingForm("comment-add");
        String[] commentLevels = this.tester.getDialog().getOptionLabelsFromSelectList("commentLevel");
        Assert.assertEquals((long)9L, (long)commentLevels.length);
        Assert.assertEquals((Object)"All Users", (Object)commentLevels[0]);
        Assert.assertEquals((Object)"Administrators", (Object)commentLevels[1]);
        Assert.assertEquals((Object)"Developers", (Object)commentLevels[2]);
        Assert.assertEquals((Object)"Users", (Object)commentLevels[3]);
        Assert.assertEquals((Object)"a group", (Object)commentLevels[4]);
        Assert.assertEquals((Object)"jira-administrators", (Object)commentLevels[5]);
        Assert.assertEquals((Object)"jira-developers", (Object)commentLevels[6]);
        Assert.assertEquals((Object)"jira-users", (Object)commentLevels[7]);
        Assert.assertEquals((Object)"z group", (Object)commentLevels[8]);
    }

    @Test
    @Restore(value="TestAddComment.xml")
    public void testAddInvalidComment() {
        this.navigation.issue().gotoIssue("HSP-1");
        this.addComment("All Users", "");
        this.tester.assertTextPresent("Comment body can not be empty!");
        this.navigation.issue().gotoIssue("HSP-1");
        this.addComment("All Users", "     ");
        this.tester.assertTextPresent("Comment body can not be empty!");
    }

    @Test
    @Restore(value="TestBlankInstancePlusAFewUsers.xml")
    public void testAddCommentWithVisibility() {
        String allUsersComment = "This is a comment assigned to all users";
        String jiraUsersGroupComment = "this comment visible to jira-users group";
        String jiraUsersRoleComment = "this is a comment visible to Users role";
        String jiraDevelopersGroupComment = "this is a comment visible to jira-developers group";
        String jiraDevelopersRoleComment = "this is a comment visible to Developers role";
        String jiraAdminsGroupComment = "this is a comment visible to jira-admin group";
        String jiraAdminsRoleComment = "this is a comment visible to Administrators role";
        this.navigation.issue().gotoIssue("HSP-5");
        this.addComment("All Users", allUsersComment);
        this.addComment("jira-users", jiraUsersGroupComment);
        this.addComment("Users", jiraUsersRoleComment);
        this.addComment("jira-developers", jiraDevelopersGroupComment);
        this.addComment("Developers", jiraDevelopersRoleComment);
        this.addComment("jira-administrators", jiraAdminsGroupComment);
        this.addComment("Administrators", jiraAdminsRoleComment);
        List<String> userComments = Arrays.asList(allUsersComment, jiraUsersRoleComment, jiraUsersGroupComment);
        List<String> devComments = Arrays.asList(jiraDevelopersGroupComment, jiraDevelopersRoleComment);
        List<String> adminComments = Arrays.asList(jiraAdminsGroupComment, jiraAdminsRoleComment);
        this.checkCommentVisibility("fred", "HSP-5", userComments, Iterables.concat(devComments, adminComments));
        this.checkCommentVisibility("admin", "HSP-5", Iterables.concat((Iterable)Iterables.concat(userComments, devComments), adminComments), null);
        this.checkCommentVisibility("devman", "HSP-5", Iterables.concat(devComments, userComments), adminComments);
        this.checkCommentVisibility("onlyadmin", "HSP-5", Iterables.concat(adminComments, userComments), devComments);
    }

    private void checkCommentVisibility(String username, String issueKey, Iterable<String> expectedVisible, Iterable<String> expectedNotVisible) {
        if (expectedVisible != null) {
            this.assertions.comments(expectedVisible).areVisibleTo(username, issueKey);
        }
        if (expectedNotVisible != null) {
            this.assertions.comments(expectedNotVisible).areNotVisibleTo(username, issueKey);
        }
    }

    @Test
    @Restore(value="TestAddComment.xml")
    public void testAddCommentErrorWhenLoggedOut() {
        this.navigation.logout();
        String theComment = "comment with html <input type=\"input\" id=\"invalid\"/>";
        this.page.getFreshXsrfToken();
        this.navigation.gotoPage(this.page.addXsrfToken("/secure/AddComment.jspa?id=10000&comment=" + theComment));
        this.tester.assertTextPresent("It seems that you have tried to perform an operation which you are not permitted to perform.");
    }

    @Test
    @Restore(value="TestAddComment.xml")
    public void testAddCommentErrorWhenNoPermission() {
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.ADD_COMMENTS, "jira-users");
        String theComment = "comment with html <input type=\"input\" id=\"invalid\"/>";
        this.navigation.gotoPage(this.page.addXsrfToken("/secure/AddComment.jspa?id=10000&comment=" + theComment));
        this.tester.assertTextPresent("Administrator, you do not have the permission to comment on this issue.");
    }

    @Test
    @Restore(value="TestAddComment.xml")
    public void testAddCommentErrorWhenIssueDoesNotExist() {
        this.navigation.issue().deleteIssue("HSP-1");
        String theComment = "comment with html <input type=\"input\" id=\"invalid\"/>";
        this.navigation.gotoPage(this.page.addXsrfToken("/secure/AddComment.jspa?id=10000&comment=" + theComment));
        this.tester.assertTextPresent("The issue no longer exists.");
        this.tester.assertTextNotPresent(theComment);
        this.tester.assertTextPresent("The issue no longer exists.");
    }

    private void addComment(String visibleTo, String comment) {
        this.tester.clickLink(this.commentLinkid);
        this.tester.selectOption("commentLevel", visibleTo);
        this.tester.setFormElement("comment", comment);
        this.tester.submit();
    }

    @Test
    @Restore(value="TestAddComment.xml")
    public void testAddCommentWithGroupButNotLoggedIn() throws Exception {
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        String key = this.navigation.issue().createIssue("homosapien", "Bug", "Test Issue");
        this.navigation.issue().gotoIssue(key);
        this.tester.assertTextPresent("Test Issue");
        String id = this.navigation.issue().getId(key);
        this.navigation.gotoPage(this.page.addXsrfToken("/secure/AddComment.jspa?id=" + id + "&comment=Hello"));
        this.tester.assertTextPresent("Test Issue");
        this.tester.assertTextPresent("Hello");
        this.tester.assertTextNotPresent("Ahoj");
        this.navigation.gotoPage(this.page.addXsrfToken("/secure/AddComment.jspa?id=" + id + "&comment=Ahoj&commentLevel=group%3Ajira-users"));
        this.tester.assertTextPresent("Test Issue");
        this.tester.assertTextPresent("Hello");
        this.tester.assertTextPresent("Ahoj");
        this.addBrowseProjectPermissionToAnonymous();
        this.addCreateCommentPermissionToAnonymous();
        this.administration.timeTracking().enable(TimeTracking.Mode.MODERN);
        this.navigation.logout();
        this.page.getFreshXsrfToken();
        this.navigation.gotoPage(this.page.addXsrfToken("/secure/AddComment.jspa?id=" + id + "&comment=Hola&commentLevel=group%3Ajira-users"));
        this.tester.assertTextNotPresent("NullPointerException");
        this.tester.assertTextPresent("You cannot add a comment for specific groups or roles, as your session has expired. Please log in and try again.");
    }

    @Test
    @Restore(value="TestAddComment.xml")
    public void testAddCommentCheckUpdatedDate() throws ParseException {
        this.navigation.issue().gotoIssue("HSP-1");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "created-val"), "14/Aug/06 4:26 PM");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "updated-val"), "14/Aug/06 4:26 PM");
        String commentText = "This is my first test comment!";
        this.tester.assertTextNotPresent("This is my first test comment!");
        this.tester.clickLink(this.commentLinkid);
        this.tester.setFormElement("comment", "This is my first test comment!");
        this.tester.submit();
        this.tester.assertTextPresent("This is my first test comment!");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "created-val"), "14/Aug/06 4:26 PM");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "updated-val"), "Just now");
    }

    @Test
    @Restore(value="TestAddComment.xml")
    public void testAddTooLongComment() {
        this.backdoor.advancedSettings().setTextFieldCharacterLengthLimit(10L);
        this.navigation.issue().gotoIssue("HSP-1");
        this.addComment("All Users", "This is too long comment");
        this.tester.assertTextPresent("The entered text is too long. It exceeds the allowed limit of 10 characters.");
    }

    @Test
    @Restore(value="TestAddComment.xml")
    public void testAddCommentWithTextLengthLimitOn() {
        this.backdoor.advancedSettings().setTextFieldCharacterLengthLimit(10L);
        this.navigation.issue().gotoIssue("HSP-1");
        String correctCommentBody = "AllGood";
        this.addComment("All Users", "AllGood");
        this.assertions.comments(Collections.singletonList("AllGood")).areVisibleTo("admin", "HSP-1");
    }

    private void addBrowseProjectPermissionToAnonymous() {
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.BROWSE_PROJECTS);
    }

    private void addCreateCommentPermissionToAnonymous() {
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.ADD_COMMENTS);
    }
}

