/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.comment;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.COMMENTS})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestSearchComment
extends BaseJiraFuncTest {
    private static final String ISSUE_KEY = "HSP-1";
    private static final String PROJECT_KEY = "HSP";

    @After
    public void tearDown() {
        this.backdoor.systemProperties().unsetProperty("jira.safeguards.indexing.issue.comments");
    }

    @Test
    public void testSearchingForCommentsThatAreOverTheIndexingLimit() {
        this.backdoor.issues().createIssue(PROJECT_KEY, "Test issue");
        this.backdoor.systemProperties().setProperty("jira.safeguards.indexing.issue.comments", "5");
        List<String> comments = IntStream.range(0, 10).mapToObj(number -> "comment" + number).collect(Collectors.toList());
        comments.forEach(comment -> this.backdoor.issues().commentIssue(ISSUE_KEY, comment));
        this.backdoor.indexing().reindexAll();
        comments.stream().limit(5L).forEach(comment -> {
            SearchResult searchResult = this.backdoor.search().postSearch(new SearchRequest().jql(String.format("project = %s AND comment ~ %s", PROJECT_KEY, comment)));
            MatcherAssert.assertThat((Object)searchResult.issues, (Matcher)Matchers.empty());
        });
        comments.stream().skip(5L).forEach(comment -> {
            SearchResult searchResult = this.backdoor.search().postSearch(new SearchRequest().jql(String.format("project = %s AND comment ~ %s", PROJECT_KEY, comment)));
            MatcherAssert.assertThat((Object)searchResult.issues, (Matcher)Matchers.hasSize((int)1));
            MatcherAssert.assertThat((Object)((Issue)searchResult.issues.get((int)0)).key, (Matcher)Matchers.is((Object)ISSUE_KEY));
        });
    }
}

