/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.admin.CustomFields;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.CUSTOM_FIELDS, Category.FIELDS, Category.SECURITY})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestCustomFieldOptionsXss
extends BaseJiraFuncTest {
    private static final String RAW_OPTION_TEMPLATE = "<div><b>%s</b></div>";
    private static final String HTML_OPTION_TEMPLATE = "<div><b>%s</b></div>";
    private static final String ESCAPED_OPTION_TEMPLATE = "&lt;div&gt;&lt;b&gt;%s&lt;/b&gt;&lt;/div&gt;";
    private static final Iterable<String> CUSTOM_FIELD_TYPES = ImmutableList.of((Object)CustomFields.builtInCustomFieldKey("select"), (Object)CustomFields.builtInCustomFieldKey("radiobuttons"), (Object)CustomFields.builtInCustomFieldKey("multicheckboxes"), (Object)CustomFields.builtInCustomFieldKey("multiselect"));
    private static final Map<String, List<String>> SEARCHERS = ImmutableMap.builder().put((Object)CustomFields.builtInCustomFieldKey("multiselectsearcher"), TestCustomFieldOptionsXss.toBuiltInCustomFieldKeys("select", "radiobuttons", "multicheckboxes")).put((Object)CustomFields.builtInCustomFieldKey("cascadingselectsearcher"), TestCustomFieldOptionsXss.toBuiltInCustomFieldKeys("cascadingselect")).build();

    private static List<String> toBuiltInCustomFieldKeys(String ... keys) {
        return Arrays.stream(keys).map(CustomFields::builtInCustomFieldKey).collect(Collectors.toList());
    }

    private static String optionValue(String fieldId) {
        return String.format("<div><b>%s</b></div>", fieldId);
    }

    private static String optionValueHtml(String fieldId) {
        return String.format("<div><b>%s</b></div>", fieldId);
    }

    private static String optionValueEscaped(String fieldId) {
        return String.format(ESCAPED_OPTION_TEMPLATE, fieldId);
    }

    @Before
    public void setUp() throws Exception {
        this.backdoor.applicationProperties().setOption("jira.custom.field.html.enabled", true);
    }

    @Test
    public void testCustomFieldDescriptionsCanBeRenderedAsRawHtmlOrWikiMarkup() throws Exception {
        for (String type : CUSTOM_FIELD_TYPES) {
            this.testSingleCustomFieldDescriptionOnCustomFieldsScreen(type);
        }
    }

    @Test
    public void testCustomFieldDescriptionsCanBeRenderedAsRawHtmlOrWikiMarkUpInIssueNavigator() throws Exception {
        for (Map.Entry<String, List<String>> entry : SEARCHERS.entrySet()) {
            this.testSingleCustomFieldDescriptionOnIssueNavigatorScreen(entry.getValue(), entry.getKey());
        }
    }

    private void testSingleCustomFieldDescriptionOnIssueNavigatorScreen(List<String> customFieldTypes, String customFieldSearcher) {
        for (String customFieldType : customFieldTypes) {
            this.testSingleCustomFieldDescriptionOnIssueNavigatorScreen(customFieldType, customFieldSearcher);
        }
    }

    private void testSingleCustomFieldDescriptionOnIssueNavigatorScreen(String customFieldType, String customFieldSearcher) {
        String fieldId = this.backdoor.customFields().createCustomField(customFieldType + "-name", "description" + customFieldType, customFieldType, customFieldSearcher);
        this.backdoor.customFields().addOption(fieldId, TestCustomFieldOptionsXss.optionValue(customFieldType));
        this.backdoor.applicationProperties().setOption("jira.custom.field.html.enabled", true);
        this.tester.gotoPage("secure/QueryComponentRendererEdit!Default.jspa?fieldId=" + fieldId + "&decorator=none&jqlContext=");
        Assert.assertTrue((String)("HTML in Custom Fields is enabled so the options should be rendered as raw HTML for " + customFieldSearcher), (boolean)this.getPageSource().contains(TestCustomFieldOptionsXss.optionValueHtml(customFieldType)));
        this.backdoor.applicationProperties().setOption("jira.custom.field.html.enabled", false);
        this.tester.gotoPage("secure/QueryComponentRendererEdit!Default.jspa?fieldId=" + fieldId + "&decorator=none&jqlContext=");
        Assert.assertTrue((String)("HTML in Custom Fields is disabled so the optons should be escaped for " + customFieldSearcher), (boolean)this.getPageSource().contains(TestCustomFieldOptionsXss.optionValueEscaped(customFieldType)));
        Assert.assertFalse((String)("HTML in Custom Fields is disabled so the optons should be escaped for " + customFieldSearcher), (boolean)this.getPageSource().contains(TestCustomFieldOptionsXss.optionValueHtml(customFieldType)));
        this.backdoor.customFields().deleteCustomField(fieldId);
    }

    private void testSingleCustomFieldDescriptionOnCustomFieldsScreen(String customFieldType) {
        String fieldId = this.backdoor.customFields().createCustomField(customFieldType + "-name", "description" + customFieldType, customFieldType, null);
        this.backdoor.customFields().addOption(fieldId, TestCustomFieldOptionsXss.optionValue(customFieldType));
        this.backdoor.applicationProperties().setOption("jira.custom.field.html.enabled", true);
        this.goToConfigureCustomFields(fieldId);
        Assert.assertTrue((String)("HTML in Custom Fields is enabled so the options should be rendered as raw HTML for " + customFieldType), (boolean)this.getPageSource().contains(TestCustomFieldOptionsXss.optionValueHtml(customFieldType)));
        this.backdoor.applicationProperties().setOption("jira.custom.field.html.enabled", false);
        this.goToConfigureCustomFields(fieldId);
        Assert.assertTrue((String)("HTML in Custom Fields is disabled so the options should be escaped for " + customFieldType), (boolean)this.getPageSource().contains(TestCustomFieldOptionsXss.optionValueEscaped(customFieldType)));
        Assert.assertFalse((String)("HTML in Custom Fields is disabled so the options should be escaped for " + customFieldType), (boolean)this.getPageSource().contains(TestCustomFieldOptionsXss.optionValueHtml(customFieldType)));
        this.backdoor.customFields().deleteCustomField(fieldId);
    }

    private void goToConfigureCustomFields(String customFieldId) {
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=" + CustomFieldUtils.getCustomFieldId((String)customFieldId));
    }

    private String getPageSource() {
        return this.tester.getDialog().getResponseText();
    }
}

