/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.DevMode;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.LicenseKeys;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.CUSTOM_FIELDS, Category.FIELDS})
@LoginAs(user="admin")
@DevMode(enabled=false)
public class TestEditCustomFieldDescription
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testEditFieldConfigurations() throws Exception {
        this.administration.restoreDataWithLicense("TestEditCustomFieldDescription.xml", LicenseKeys.COMMERCIAL.getLicenseString());
        this.assertFieldDescription("homosapien", "Bug", "The default description of MY TEXT FIELD");
        this.assertFieldDescription("monkey", "Bug", "A customised description for Monkey");
        this.navigation.gotoPage("/secure/admin/EditCustomField!default.jspa?id=10000");
        this.tester.setFormElement("description", "A new description");
        this.tester.submit("Update");
        this.assertFieldDescription("homosapien", "Bug", "A new description");
        this.assertFieldDescription("monkey", "Bug", "A customised description for Monkey");
        this.editDescription("Default Field Configuration", "A newer description");
        this.assertFieldDescription("homosapien", "Bug", "A newer description");
        this.assertFieldDescription("monkey", "Bug", "A customised description for Monkey");
        this.editDescription("Field Configuration 1", "Fantastic new description");
        this.assertFieldDescription("homosapien", "Bug", "A newer description");
        this.assertFieldDescription("monkey", "Bug", "Fantastic new description");
        this.editDescription("Field Configuration 1", "");
        this.assertFieldDescription("homosapien", "Bug", "A newer description");
        this.assertNoFieldDescription("monkey", "Bug", "Fantastic new description");
        this.navigation.gotoAdminSection(Navigation.AdminSection.FIELD_CONFIGURATION);
        this.tester.clickLink("copy-Default Field Configuration");
        this.tester.setFormElement("fieldLayoutName", "Copy of Default Field Configuration");
        this.tester.submit("Copy");
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Non Standard Field Configuration Scheme").addAssociation(Data.IssueTypes.Bug.id(), "Copy of Default Field Configuration");
        this.editDescription("Copy of Default Field Configuration", "The newest description");
        this.editDescription("Field Configuration 1", "Something completely different");
        this.assertFieldDescription("homosapien", "Bug", "A newer description");
        this.assertFieldDescription("monkey", "Bug", "The newest description");
        this.assertFieldDescription("monkey", "Task", "Something completely different");
        this.editDescription("Default Field Configuration", "");
        this.assertFieldDescription("homosapien", "Bug", "A new description");
    }

    private void editDescription(String fieldConfigName, String description) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.FIELD_CONFIGURATION);
        this.tester.clickLink("configure-" + fieldConfigName);
        this.tester.clickLink("edit_12");
        this.tester.setFormElement("description", description);
        this.tester.submit("Update");
    }

    private void assertFieldDescription(String projectName, String issueType, String description) {
        String key = this.navigation.issue().createIssue(projectName, issueType, "Summary");
        this.navigation.issue().viewIssue(key);
        this.tester.clickLink("edit-issue");
        this.textAssertions.assertTextSequence(new WebPageLocator(this.tester), new String[]{"MY TEXT FIELD", description});
    }

    private void assertNoFieldDescription(String projectName, String issueType, String oldDescription) {
        String key = this.navigation.issue().createIssue(projectName, issueType, "Summary");
        this.navigation.issue().viewIssue(key);
        this.tester.clickLink("edit-issue");
        this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), "MY TEXT FIELD");
        this.textAssertions.assertTextNotPresent(new WebPageLocator(this.tester), oldDescription);
    }

    private static class Data {
        private Data() {
        }

        static class IssueTypes {
            IssueTypes() {
            }

            static class Bug {
                Bug() {
                }

                static String id() {
                    return "1";
                }
            }
        }
    }
}

