/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HttpUnitConfiguration;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.admin.CustomFields;
import com.atlassian.jira.functest.framework.backdoor.search.AutoCompleteField;
import com.atlassian.jira.functest.framework.backdoor.search.JqlAutoCompleteControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.CUSTOM_FIELDS})
@RestoreBlankInstance
@HttpUnitConfiguration(enableScripting=true)
@LoginAs(user="admin")
public class TestMultiGroupSelector
extends BaseJiraFuncTest {
    public static final String MULTGROUP_PICKER_CF_NAME = "mypickerofmultigroups";
    public static final String INVALID_GROUP_NAME = "invalid_group_name";
    public static final String ISSUE_SUMMARY = "This is my summary";
    private String multigroupPickerId = null;

    @Before
    public void setUp() {
        String customFieldId = this.backdoor.customFields().createCustomField(MULTGROUP_PICKER_CF_NAME, "", CustomFields.builtInCustomFieldKey("multigrouppicker"), CustomFields.builtInCustomFieldKey("grouppickersearcher"));
        this.multigroupPickerId = CustomFields.numericCfId(customFieldId);
        this.backdoor.screens().addFieldToScreen("Default Screen", MULTGROUP_PICKER_CF_NAME);
    }

    @Test
    public void testCreateIssueWithMultiGroupPicker() throws SAXException {
        this.navigation.issue().goToCreateIssueForm(null, null);
        this.tester.setFormElement("summary", ISSUE_SUMMARY);
        this.tester.assertLinkPresent("customfield_" + this.multigroupPickerId + "-trigger");
        this.tester.setFormElement("customfield_" + this.multigroupPickerId, "invalid_group_name, invalid_group_name");
        this.tester.submit("Create");
        this.tester.assertTextPresent("Could not find group names: invalid_group_name, invalid_group_name");
        this.tester.setFormElement("customfield_" + this.multigroupPickerId, "jira-users, jira-developers");
        this.tester.submit("Create");
        this.tester.assertTextPresent(ISSUE_SUMMARY);
        this.tester.assertTextPresent(MULTGROUP_PICKER_CF_NAME);
        this.tester.assertTextPresent("jira-users");
        this.tester.assertTextPresent("jira-developers");
    }

    @Test
    public void testIssueNavWithMultiGroupPicker() {
        this.navigation.issue().goToCreateIssueForm(null, null);
        this.tester.setWorkingForm("issue-create");
        this.tester.setFormElement("summary", ISSUE_SUMMARY);
        this.tester.setFormElement("customfield_" + this.multigroupPickerId, "jira-users, jira-developers");
        this.tester.submit("Create");
        this.tester.clickLink("find_link");
        Iterable<AutoCompleteField> jqlFieldz = new JqlAutoCompleteControl(this.environmentData).getJqlFieldz();
        Assert.assertThat(jqlFieldz, (Matcher)Matchers.hasItem((Matcher)Matchers.hasProperty((String)"displayName", (Matcher)Matchers.containsString((String)MULTGROUP_PICKER_CF_NAME))));
        this.navigation.issueNavigator().createSearch("mypickerofmultigroups = jira-users");
        this.tester.assertTextPresent("HSP-1");
        this.navigation.issueNavigator().createSearch("mypickerofmultigroups = jira-developers");
        this.tester.assertTextPresent("HSP-1");
    }
}

