/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.CUSTOM_FIELDS})
@LoginAs(user="admin")
public class TestMultiSelectCustomFieldOptions
extends BaseJiraFuncTest {
    private static final String CUSTOM_FIELD_ID = "10004";
    private static final String OPTION_00 = "10015";
    private static final String OPTION_01 = "10016";
    private static final String OPTION_02 = "10017";
    private static final String OPTION_03 = "10018";
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        this.administration.restoreData("TestSelectCustomFieldOptions.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    @Test
    public void testEditOptions() throws SAXException {
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_00, "Honda");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_01, "Kawasaki");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_02, "Yamaha");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_03, "Suzuki");
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10004");
        this.tester.assertTextPresent("Honda");
        this.tester.assertTextPresent("Kawasaki");
        this.tester.assertTextPresent("Yamaha");
        this.tester.assertTextPresent("Suzuki");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_00, "Fiat");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_01, "Lambretta");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_02, "Vespa");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_03, "Aprilia");
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10004");
        this.tester.assertTextPresent("Fiat");
        this.tester.assertTextPresent("Lambretta");
        this.tester.assertTextPresent("Vespa");
        this.tester.assertTextPresent("Aprilia");
    }

    @Test
    public void testDefaultShowsUpdatedOption() throws SAXException {
        this.administration.customFields().setDefaultValue(CUSTOM_FIELD_ID, OPTION_00);
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10004");
        this.locator.id("customfield_10004-value-default").getText().contains("option 00");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_00, "Fiat");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_01, "Lambretta");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_02, "Vespa");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_03, "Aprilia");
        this.locator.id("customfield_10004-value-default").getText().contains("Honda");
    }

    @Test
    public void testDisable() throws SAXException {
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10004");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"option 00", "(disabled)"});
        this.administration.customFields().enableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10004");
        this.tester.assertTextNotPresent("(disabled)");
    }

    @Test
    public void testSearchNewValues() throws SAXException {
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_00, "Honda");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_01, "Kawasaki");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_02, "Yamaha");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_03, "Suzuki");
        this.locator.id("customfield_10004-value-default").getText().contains("Honda");
        this.administration.reIndex();
        this.createSearchAndAssertIssues("MultiSelectField = Honda ORDER BY key ASC", "HSP-10", "HSP-11", "HSP-12");
        this.createSearchAndAssertIssues("MultiSelectField = Kawasaki ORDER BY key ASC", "HSP-12");
    }

    @Test
    public void testDisabledNotValidForCreate() throws SAXException {
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.assertOptionsEqual("customfield_10004", new String[]{"None", "option 01", "option 02", "option 03"});
        this.administration.customFields().enableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.assertOptionsEqual("customfield_10004", new String[]{"None", "option 00", "option 01", "option 02", "option 03"});
    }

    @Test
    public void testDisabledNotValidForEdit() throws SAXException {
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_01);
        this.navigation.issue().gotoEditIssue("HSP-11");
        this.tester.assertOptionsEqual("customfield_10004", new String[]{"None", "option 00", "option 02", "option 03"});
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issue().gotoEditIssue("HSP-11");
        this.tester.assertOptionsEqual("customfield_10004", new String[]{"None", "option 00", "option 02", "option 03"});
        this.administration.customFields().enableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.administration.customFields().enableOptions(CUSTOM_FIELD_ID, OPTION_01);
        this.navigation.issue().gotoEditIssue("HSP-11");
        this.tester.assertOptionsEqual("customfield_10004", new String[]{"None", "option 00", "option 01", "option 02", "option 03"});
    }

    @Test
    public void testDisabledValidForSearch() throws SAXException {
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issueNavigator().gotoNewMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.gotoPage("secure/QueryComponentRendererEdit!Default.jspa?fieldId=customfield_10004&decorator=none&jqlContext=");
        this.tester.assertTextPresent("option 00");
        this.tester.assertTextPresent("option 01");
        this.tester.assertTextPresent("option 02");
        this.tester.assertTextPresent("option 03");
    }

    private void createSearchAndAssertIssues(String jqlQuery, String ... keys) {
        this.navigation.issueNavigator().createSearch(jqlQuery);
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults(keys);
    }
}

