/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.EditIssueFieldVisibility;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.CUSTOM_FIELDS})
@LoginAs(user="admin")
public class TestSelectCustomFieldOptions
extends BaseJiraFuncTest {
    private static final String CUSTOM_FIELD_ID = "10007";
    private static final String CUSTOM_FIELD_NAME = "SelectList";
    private static final String OPTION_00 = "10022";
    private static final String OPTION_01 = "10023";
    private static final String OPTION_02 = "10024";
    private static final String FIELD_CONFIGURATION_NAME_ONE = "Default Field Configuration";
    private static final String ERROR_403_MESSAGE = "HTTPError403";
    @Inject
    private EditIssueFieldVisibility editIssueFieldVisibility;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private HtmlPage page;

    @Before
    public void setUp() {
        this.administration.restoreData("TestSelectCustomFieldOptions.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    @Test
    public void testEditOptions() throws SAXException {
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_00, "Honda");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_01, "Kawasaki");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_02, "Yamaha");
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10007");
        this.tester.assertTextPresent("Honda");
        this.tester.assertTextPresent("Kawasaki");
        this.tester.assertTextPresent("Yamaha");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_00, "Fiat");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_01, "Lambretta");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_02, "Vespa");
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10007");
        this.tester.assertTextPresent("Fiat");
        this.tester.assertTextPresent("Lambretta");
        this.tester.assertTextPresent("Vespa");
    }

    @Test
    public void testDefaultShowsUpdatedOption() throws SAXException {
        this.administration.customFields().setDefaultValue(CUSTOM_FIELD_ID, OPTION_00);
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10007");
        this.locator.id("customfield_10007-value-default").getText().contains("option 00");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_00, "Honda");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_01, "Kawasaki");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_02, "Yamaha");
        this.locator.id("customfield_10007-value-default").getText().contains("Honda");
    }

    @Test
    public void testDisable() throws SAXException {
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10007");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"option 00", "(disabled)"});
        this.administration.customFields().enableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10007");
        this.tester.assertTextNotPresent("(disabled)");
    }

    @Test
    public void testSearchNewValues() throws SAXException {
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_00, "Honda");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_01, "Kawasaki");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_02, "Yamaha");
        this.locator.id("customfield_10007-value-default").getText().contains("Honda");
        this.administration.reIndex();
        this.createSearchAndAssertIssues("SelectList = Honda ORDER BY key ASC", "HSP-11");
        this.createSearchAndAssertIssues("SelectList = Kawasaki ORDER BY key ASC", "HSP-10", "HSP-12");
    }

    @Test
    public void testDisabledNotValidForCreate() throws SAXException {
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.assertOptionsEqual("customfield_10007", new String[]{"None", "option 01", "option 02"});
        this.administration.customFields().enableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.assertOptionsEqual("customfield_10007", new String[]{"None", "option 00", "option 01", "option 02"});
    }

    @Test
    public void testDisabledNotValidForEdit() throws SAXException {
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issue().gotoEditIssue("HSP-10");
        this.tester.assertOptionsEqual("customfield_10007", new String[]{"None", "option 01", "option 02"});
        this.navigation.issue().gotoEditIssue("HSP-11");
        this.tester.assertOptionsEqual("customfield_10007", new String[]{"None", "option 00", "option 01", "option 02"});
        this.administration.customFields().enableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issue().gotoEditIssue("HSP-10");
        this.tester.assertOptionsEqual("customfield_10007", new String[]{"None", "option 00", "option 01", "option 02"});
    }

    @Test
    public void testDisabledValidForSearch() throws SAXException {
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issueNavigator().gotoNewMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.gotoPage("secure/QueryComponentRendererEdit!Default.jspa?fieldId=customfield_10007&decorator=none&jqlContext=");
        this.tester.assertTextPresent("option 00");
        this.tester.assertTextPresent("option 01");
        this.tester.assertTextPresent("option 02");
    }

    @Test
    public void testRequiredFieldWithDefaultValue() throws SAXException {
        this.administration.customFields().setDefaultValue(CUSTOM_FIELD_ID, OPTION_00);
        this.editIssueFieldVisibility.setRequiredFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, CUSTOM_FIELD_NAME);
        this.navigation.issue().gotoEditIssue("HSP-11");
        this.tester.assertOptionsEqual("customfield_10007", new String[]{"option 00", "option 01", "option 02"});
    }

    @Test
    public void testRequiredFieldWithNoDefaultValue() throws SAXException {
        this.administration.customFields().setDefaultValue(CUSTOM_FIELD_ID, "-1");
        this.editIssueFieldVisibility.setRequiredFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, CUSTOM_FIELD_NAME);
        this.navigation.issue().gotoEditIssue("HSP-11");
        this.tester.assertOptionsEqual("customfield_10007", new String[]{"None", "option 00", "option 01", "option 02"});
    }

    @Test
    public void testRestoreDefaultNotXsrfable() {
        this.administration.restoreBlankInstance();
        this.tester.gotoPage("/secure/admin/RestoreDefaults.jspa");
        this.tester.assertTextPresent(ERROR_403_MESSAGE);
    }

    @Test
    public void testRestoreDefaultWorksWithToken() {
        this.administration.restoreBlankInstance();
        this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/IssueFieldRequire.jspa?require=0"));
        this.tester.assertTextInElement("require_0", "Optional");
        this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/RestoreDefaults.jspa"));
        this.tester.assertTextNotPresent(ERROR_403_MESSAGE);
        this.tester.assertTextInElement("require_0", "Required");
    }

    private void createSearchAndAssertIssues(String jqlQuery, String ... keys) {
        this.navigation.issueNavigator().createSearch(jqlQuery);
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults(keys);
    }
}

