/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Dashboard;
import com.atlassian.jira.functest.framework.FunctTestConstants;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.sharing.GroupTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.ProjectTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.SharedEntityInfo;
import com.atlassian.jira.functest.framework.sharing.SimpleTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermissionUtils;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.json.JSONException;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.DASHBOARDS})
@LoginAs(user="admin")
public class TestEditPortalPageSharing
extends BaseJiraFuncTest {
    private static final SharedEntityInfo PAGE_FRED_PRIVATE = new SharedEntityInfo(10010L, "PrivateFredDashboard", "This is private to fred and should not be visible to anyone else.", true, TestSharingPermissionUtils.createPrivatePermissions());
    private static final SharedEntityInfo PAGE_FRED_PUBLIC = new SharedEntityInfo(10011L, "PublicFredDashboard", "This is a dashboard page that can be seen by everyone.", true, TestSharingPermissionUtils.createPublicPermissions());
    private static final SharedEntityInfo PAGE_EXISTS = new SharedEntityInfo(10012L, "Exists", null, true, TestSharingPermissionUtils.createPrivatePermissions());
    private static final SharedEntityInfo PAGE_ADMINNOTFAVOURITE = new SharedEntityInfo(10013L, "AdminNotFavourite", null, false, TestSharingPermissionUtils.createPublicPermissions());
    private static final SharedEntityInfo PAGE_ADMINFAVOURITE = new SharedEntityInfo(10014L, "AdminFavourite", null, true, TestSharingPermissionUtils.createPublicPermissions());
    private static final int PROJECT_HIDDENFROMFRED_ID = 10010;
    private static final int PROJECT_HOMOSAPIEN_ID = 10000;
    private static final String PROJECT_HOMOSAPIEN_NAME = "homosapien";
    private static final int PERMISSION_CREATE_SHARED = 22;
    private static final int USERS_ROLE_ID = 10000;
    private static final int ROLE_ADMIN_ID = 10002;
    private static final String USERS_ROLE_NAME = "Users";
    private static final String GROUP_JIRA_USERS = "jira-users";
    private static final String GROUP_JIRA_DEVELOPERS = "jira-developers";
    private static final String GROUP_SHARINGUSERS = "sharing_users";
    private static final String USER_FRED = "fred";
    private static final String GROUP_JIRA_ADMINISTRATORS = "jira-administrators";
    @Inject
    private Administration administration;

    private static Set<TestSharingPermission> createProjectPermission(long projectId, String projectName) {
        return Collections.singleton(new ProjectTestSharingPermission(projectId, projectName));
    }

    private static Set<TestSharingPermission> createProjectPermission(long projectId, String projectName, long roleId, String roleName) {
        return Collections.singleton(new ProjectTestSharingPermission(projectId, roleId, projectName, roleName));
    }

    @Before
    public void setUpTest() {
        this.administration.restoreData("BaseProfessionalPortalPage.xml");
    }

    @Test
    public void testSharingStateCorrect() {
        this.validatePermissions(PAGE_EXISTS);
        this.validatePermissions(PAGE_ADMINFAVOURITE);
        this.validatePermissions(PAGE_ADMINNOTFAVOURITE);
        this.navigation.login(USER_FRED);
        this.validatePermissions(PAGE_FRED_PUBLIC);
        this.validatePermissions(PAGE_FRED_PRIVATE);
    }

    @Test
    public void testSharingStateCorrectComplex() {
        this.navigation.login(USER_FRED);
        HashSet<TestSharingPermission> permissions = new HashSet<TestSharingPermission>();
        permissions.add(new ProjectTestSharingPermission(10000L, 10000L, PROJECT_HOMOSAPIEN_NAME, USERS_ROLE_NAME));
        permissions.add(new ProjectTestSharingPermission(10000L, PROJECT_HOMOSAPIEN_NAME));
        permissions.add(new GroupTestSharingPermission(GROUP_JIRA_USERS));
        SharedEntityInfo page = new SharedEntityInfo("testSharingStateCorrectComplex", null, true, permissions);
        Dashboard dashboard = this.navigation.dashboard();
        dashboard.addPage(page, null);
        dashboard.navigateToFavourites();
        Long id = dashboard.getDashboardPageId(page.getName(), new XPathLocator(this.tester, Dashboard.Table.FAVOURITE.toXPath()));
        page.setId(id);
        this.validatePermissions(page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCorrectComplexShareWhenHasAdminPermissionsAndFeatureFlagIsEnabled() {
        try {
            this.backdoor.darkFeatures().enableForSite(FunctTestConstants.ADMINS_CAN_SHARE_FILTERS_AND_DASHBOARDS_WITH_ALL_GROUPS_AND_ROLES);
            HashSet<TestSharingPermission> permissions = new HashSet<TestSharingPermission>();
            permissions.add(new ProjectTestSharingPermission(10000L, 10000L, PROJECT_HOMOSAPIEN_NAME, USERS_ROLE_NAME));
            permissions.add(new ProjectTestSharingPermission(10000L, PROJECT_HOMOSAPIEN_NAME));
            permissions.add(new GroupTestSharingPermission(GROUP_SHARINGUSERS));
            SharedEntityInfo page = new SharedEntityInfo("testSharingStateIncorrectComplex", null, true, permissions);
            Dashboard dashboard = this.navigation.dashboard();
            dashboard.addPage(page, null);
            dashboard.navigateToFavourites();
            Long id = dashboard.getDashboardPageId(page.getName(), new XPathLocator(this.tester, Dashboard.Table.FAVOURITE.toXPath()));
            page.setId(id);
            this.validatePermissions(page);
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_SHARE_FILTERS_AND_DASHBOARDS_WITH_ALL_GROUPS_AND_ROLES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncorrectProjectShareWhenHasAdminPermissionsAndFeatureFlagIsDisabled() {
        try {
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.ADMINS_CAN_SHARE_FILTERS_AND_DASHBOARDS_WITH_ALL_GROUPS_AND_ROLES);
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            SharedEntityInfo page = new SharedEntityInfo(PAGE_EXISTS);
            page.setSharingPermissions(Collections.singleton(new ProjectTestSharingPermission(10000L, 10000L, PROJECT_HOMOSAPIEN_NAME, USERS_ROLE_NAME)));
            Dashboard dashboard = this.navigation.dashboard();
            dashboard.addPage(page, null);
            dashboard.navigateToFavourites();
            Long id = dashboard.getDashboardPageId(page.getName(), new XPathLocator(this.tester, Dashboard.Table.FAVOURITE.toXPath()));
            page.setId(id);
            this._testPageNotEdited(page, PAGE_EXISTS, "You do not have permission to share with Project: 'homosapien' Role: [Unknown Role].");
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_SHARE_FILTERS_AND_DASHBOARDS_WITH_ALL_GROUPS_AND_ROLES);
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncorrectGroupShareWhenHasAdminPermissionsAndFeatureFlagIsDisabled() {
        try {
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.ADMINS_CAN_SHARE_FILTERS_AND_DASHBOARDS_WITH_ALL_GROUPS_AND_ROLES);
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            this.backdoor.usersAndGroups().removeUserFromGroup("admin", GROUP_JIRA_DEVELOPERS);
            SharedEntityInfo page = new SharedEntityInfo(PAGE_EXISTS);
            page.setSharingPermissions(Collections.singleton(new GroupTestSharingPermission(GROUP_JIRA_DEVELOPERS)));
            Dashboard dashboard = this.navigation.dashboard();
            dashboard.addPage(page, null);
            dashboard.navigateToFavourites();
            Long id = dashboard.getDashboardPageId(page.getName(), new XPathLocator(this.tester, Dashboard.Table.FAVOURITE.toXPath()));
            page.setId(id);
            this._testPageNotEdited(page, PAGE_EXISTS, "Group: 'jira-developers' does not exist, or you do not have permission to share it.");
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_SHARE_FILTERS_AND_DASHBOARDS_WITH_ALL_GROUPS_AND_ROLES);
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        }
    }

    @Test
    public void testEditWithGlobalShare() {
        SharedEntityInfo page = new SharedEntityInfo(PAGE_EXISTS);
        page.setSharingPermissions(TestSharingPermissionUtils.createPublicPermissions());
        this._testPageEditedCorrectly(page, EasyList.build((Object)page, (Object)PAGE_ADMINFAVOURITE));
    }

    @Test
    public void testEditWithPrivateShare() {
        SharedEntityInfo page = new SharedEntityInfo(PAGE_ADMINFAVOURITE);
        page.setSharingPermissions(TestSharingPermissionUtils.createPrivatePermissions());
        this._testPageEditedCorrectly(page, EasyList.build((Object)PAGE_EXISTS, (Object)page));
    }

    @Test
    public void testEditWithGroupShare() {
        SharedEntityInfo page = new SharedEntityInfo(PAGE_EXISTS);
        page.setSharingPermissions(Collections.singleton(new GroupTestSharingPermission(GROUP_JIRA_ADMINISTRATORS)));
        this._testPageEditedCorrectly(page, EasyList.build((Object)page, (Object)PAGE_ADMINFAVOURITE));
    }

    @Test
    public void testEditWithSingleProjectShare() {
        SharedEntityInfo page = new SharedEntityInfo(PAGE_EXISTS);
        page.setSharingPermissions(Collections.singleton(new ProjectTestSharingPermission(10000L, PROJECT_HOMOSAPIEN_NAME)));
        this._testPageEditedCorrectly(page, EasyList.build((Object)page, (Object)PAGE_ADMINFAVOURITE));
    }

    @Test
    public void testEditWithProjectAndRoleShare() {
        this.navigation.login(USER_FRED);
        SharedEntityInfo page = new SharedEntityInfo(PAGE_FRED_PRIVATE);
        page.setSharingPermissions(Collections.singleton(new ProjectTestSharingPermission(10000L, 10000L, PROJECT_HOMOSAPIEN_NAME, USERS_ROLE_NAME)));
        this._testPageEditedCorrectly(page, EasyList.build((Object)page, (Object)PAGE_FRED_PUBLIC));
    }

    @Test
    public void testEditWithMultipleShares() {
        this.navigation.login(USER_FRED);
        HashSet<TestSharingPermission> permissions = new HashSet<TestSharingPermission>();
        permissions.add(new ProjectTestSharingPermission(10000L, 10000L, PROJECT_HOMOSAPIEN_NAME, USERS_ROLE_NAME));
        permissions.add(new ProjectTestSharingPermission(10000L, PROJECT_HOMOSAPIEN_NAME));
        permissions.add(new GroupTestSharingPermission(GROUP_JIRA_USERS));
        SharedEntityInfo page = new SharedEntityInfo(PAGE_FRED_PRIVATE);
        page.setSharingPermissions(permissions);
        this._testPageEditedCorrectly(page, EasyList.build((Object)page, (Object)PAGE_FRED_PUBLIC));
    }

    @Test
    public void testEditWhereGroupDoesNotExist() {
        SharedEntityInfo page = new SharedEntityInfo(PAGE_EXISTS);
        page.setSharingPermissions(Collections.singleton(new GroupTestSharingPermission("thisGroupDoesNotExistInTheTestDataOrElseItWasVeryLucky")));
        this._testPageNotEdited(page, PAGE_EXISTS, "Group: 'thisGroupDoesNotExistInTheTestDataOrElseItWasVeryLucky' does not exist, or you do not have permission to share it.");
    }

    @Test
    public void testEditWhereYouAreNotAMemberOfGroupFFisDisabled() {
        this.backdoor.darkFeatures().disableForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        try {
            this.navigation.login(USER_FRED);
            SharedEntityInfo page = new SharedEntityInfo(PAGE_FRED_PRIVATE);
            page.setSharingPermissions(Collections.singleton(new GroupTestSharingPermission(GROUP_JIRA_DEVELOPERS)));
            this._testPageNotEdited(page, PAGE_FRED_PRIVATE, "Group: 'jira-developers' does not exist, or you do not have permission to share it.");
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        }
    }

    @Test
    public void testEditWhereYouAreNotAMemberOfGroup() {
        this.backdoor.darkFeatures().enableForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        try {
            this.navigation.login(USER_FRED);
            SharedEntityInfo page = new SharedEntityInfo(PAGE_FRED_PRIVATE);
            page.setSharingPermissions(Collections.singleton(new GroupTestSharingPermission(GROUP_JIRA_DEVELOPERS)));
            this._testPageEditedCorrectly(page, Lists.newArrayList((Object[])new SharedEntityInfo[]{page, PAGE_FRED_PUBLIC}));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        }
    }

    @Test
    public void testEditWhereGroupNameIsEmpty() {
        SharedEntityInfo page = new SharedEntityInfo(PAGE_EXISTS);
        page.setSharingPermissions(Collections.singleton(new GroupTestSharingPermission("")));
        this._testPageNotEdited(page, PAGE_EXISTS, "Group permission is not valid: Invalid group name ''.");
    }

    @Test
    public void testCanEditProjectDoesNotExist() {
        this.navigation.login(USER_FRED);
        SharedEntityInfo page = new SharedEntityInfo(PAGE_FRED_PRIVATE.getId(), "testCanEditProjectDoesNotExist", null, true, TestEditPortalPageSharing.createProjectPermission(100L, null));
        this._testPageNotEdited(page, PAGE_FRED_PRIVATE, "Selected project does not exist.");
    }

    @Test
    public void testCanEditProjectCantSee() {
        try {
            this.backdoor.darkFeatures().enableForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            this.navigation.login(USER_FRED);
            SharedEntityInfo page = new SharedEntityInfo(PAGE_FRED_PRIVATE.getId(), "testCanEditProjectCantSee", null, true, TestEditPortalPageSharing.createProjectPermission(10010L, null));
            this._testPageEditedCorrectly(page, Lists.newArrayList((Object[])new SharedEntityInfo[]{page, PAGE_FRED_PUBLIC}));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        }
    }

    @Test
    public void testCantEditProjectCantSee() {
        try {
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            this.navigation.login(USER_FRED);
            SharedEntityInfo page = new SharedEntityInfo(PAGE_FRED_PRIVATE.getId(), "testCanEditProjectCantSee", null, true, TestEditPortalPageSharing.createProjectPermission(10010L, null));
            this._testPageNotEdited(page, PAGE_FRED_PRIVATE, "You do not have permission to share with Project: [Unknown Project].");
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        }
    }

    @Test
    public void testCanEditRoleDoesNotExist() {
        this.navigation.login(USER_FRED);
        SharedEntityInfo page = new SharedEntityInfo(PAGE_FRED_PRIVATE.getId(), "testCanEditRoleDoesNotExist", null, true, TestEditPortalPageSharing.createProjectPermission(10000L, null, 123L, null));
        this._testPageNotEdited(page, PAGE_FRED_PRIVATE, "Selected role does not exist.");
    }

    @Test
    public void testCantEditRoleCantSee() {
        try {
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            this.navigation.login(USER_FRED);
            SharedEntityInfo page = new SharedEntityInfo(PAGE_FRED_PRIVATE.getId(), "testCanEditRoleCantSee", null, true, TestEditPortalPageSharing.createProjectPermission(10000L, PROJECT_HOMOSAPIEN_NAME, 10002L, null));
            this._testPageNotEdited(page, PAGE_FRED_PRIVATE, "You do not have permission to share with Project: 'homosapien' Role: [Unknown Role].");
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        }
    }

    @Test
    public void testCanEditRoleCantSee() {
        try {
            this.backdoor.darkFeatures().enableForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            this.navigation.login(USER_FRED);
            SharedEntityInfo page = new SharedEntityInfo(PAGE_FRED_PRIVATE.getId(), "testCanEditRoleCantSee", null, true, TestEditPortalPageSharing.createProjectPermission(10000L, PROJECT_HOMOSAPIEN_NAME, 10002L, null));
            this._testPageEditedCorrectly(page, Lists.newArrayList((Object[])new SharedEntityInfo[]{page, PAGE_FRED_PUBLIC}));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        }
    }

    @Test
    public void testCantEditBadShareType() {
        SharedEntityInfo page = new SharedEntityInfo(PAGE_EXISTS);
        page.setSharingPermissions(Collections.singleton(new SimpleTestSharingPermission("badType")));
        this._testPageNotEdited(page, PAGE_EXISTS, "Share permission of type 'badType' is unknown.");
    }

    @Test
    public void testCantEditBadRoleNumber() {
        try {
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.ADMINS_CAN_SHARE_FILTERS_AND_DASHBOARDS_WITH_ALL_GROUPS_AND_ROLES);
            SharedEntityInfo page = new SharedEntityInfo(PAGE_EXISTS);
            page.setSharingPermissions(Collections.singleton(new SimpleTestSharingPermission("project", String.valueOf(10000), "abcroleid")));
            this._testPageNotEdited(page, PAGE_EXISTS, "Project permission is not valid: Invalid role identifier 'abcroleid'.");
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_SHARE_FILTERS_AND_DASHBOARDS_WITH_ALL_GROUPS_AND_ROLES);
        }
    }

    @Test
    public void testUserCantSaveSharesWithoutPermission() {
        this.administration.removeGlobalPermission(22, GROUP_SHARINGUSERS);
        SharedEntityInfo page = new SharedEntityInfo(PAGE_EXISTS);
        page.setSharingPermissions(TestSharingPermissionUtils.createPublicPermissions());
        SharedEntityInfo pageWithoutPermissions = new SharedEntityInfo(PAGE_EXISTS);
        pageWithoutPermissions.setSharingPermissions(null);
        this._testPageNotEdited(page, pageWithoutPermissions, "You do not have permission to share. All shares are invalid.");
    }

    @Test
    public void testUserCantSeeSharingOptionsWithoutPermission() {
        this.administration.removeGlobalPermission(22, GROUP_SHARINGUSERS);
        SharedEntityInfo page = new SharedEntityInfo(PAGE_EXISTS);
        page.setName("testUserCantSeeSharingOptionsWithoutPermission");
        page.setDescription("Description of testUserCantSeeSharingOptionsWithoutPermission");
        this.gotoEditPage(page);
        this.tester.assertTextNotPresent("Shares:");
        XPathLocator locator = new XPathLocator(this.tester, "//div[@id = 'share_div']");
        Assert.assertNull((Object)locator.getNode());
        this._testPageEditedCorrectly(page, EasyList.build((Object)page, (Object)PAGE_ADMINFAVOURITE));
    }

    @Test
    public void testEditWhenSharingPermissionhasBeenRemoved() {
        this.administration.removeGlobalPermission(22, GROUP_SHARINGUSERS);
        SharedEntityInfo page = new SharedEntityInfo(PAGE_ADMINFAVOURITE);
        page.setName("testUserCantSeeSharingOptionsWithoutPermission");
        page.setDescription("Description of testUserCantSeeSharingOptionsWithoutPermission");
        page.setSharingPermissions(TestSharingPermissionUtils.createPrivatePermissions());
        this._testPageEditedCorrectly(page, EasyList.build((Object)PAGE_EXISTS, (Object)page));
    }

    private void validatePermissions(SharedEntityInfo page) {
        this.gotoEditPage(page);
        Assert.assertEquals(page.getSharingPermissions(), (Object)this.parsePermissions());
    }

    private void _testPageEditedCorrectly(SharedEntityInfo page, List expectedPageList) {
        this.navigation.dashboard().editPage(page);
        this.assertions.getDashboardAssertions().assertDashboardPages(expectedPageList, Dashboard.Table.FAVOURITE);
    }

    private void _testPageNotEdited(SharedEntityInfo page, String expectedText) {
        this.navigation.dashboard().editPage(page);
        if (this.backdoor.darkFeatures().isGlobalEnabled("com.atlassian.jira.sharedEntityEditRights")) {
            this.assertions.getJiraFormAssertions().assertFormErrMsg(expectedText);
        } else {
            this.assertions.getJiraFormAssertions().assertAuiFieldErrMsg(expectedText);
        }
    }

    private void _testPageNotEdited(SharedEntityInfo page, SharedEntityInfo oldPage, String expectedText) {
        this._testPageNotEdited(page, expectedText);
        this.gotoEditPage(page);
        this.validateEditPageLooksLike(oldPage);
    }

    private void gotoEditPage(SharedEntityInfo page) {
        this.tester.gotoPage("secure/EditPortalPage!default.jspa?pageId=" + page.getId());
    }

    private void validateEditPageLooksLike(SharedEntityInfo page) {
        this.tester.assertFormElementEquals("portalPageName", page.getName());
        this.tester.assertFormElementEquals("portalPageDescription", page.getDescription());
        this.tester.assertFormElementEquals("favourite", String.valueOf(page.isFavourite()));
        Assert.assertEquals(page.getSharingPermissions(), (Object)this.parsePermissions());
    }

    private Set parsePermissions() {
        XPathLocator xpath = new XPathLocator(this.tester, "//span[@id='shares_data_editors']");
        String value = xpath.getText();
        try {
            return TestSharingPermissionUtils.parsePermissions(value);
        }
        catch (JSONException e) {
            Assert.fail((String)("Unable to parse shares: " + e.getMessage()));
            return null;
        }
    }
}

