/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard.management;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.parser.dashboard.DashboardItem;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.DASHBOARDS})
@LoginAs(user="admin")
@Restore(value="TestSharedDashboards.xml")
public class TestDeleteSharedDashboardsByAdmins
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;

    @Test
    public void testAnAdminIsAbleToDeleteDashboardsSharedWithAGroupHeDoesNotBelongTo() {
        ImmutableList expectedDashboardItems = ImmutableList.of((Object)new DashboardItem.Builder().id(10015L).name("Shared Dashboard with group jira-developers owned by developer").owner("Developer (developer)").build());
        List<DashboardItem> actualDashboardItems = this.administration.sharedDashboards().goTo().searchAll().deleteDashboard(10015L).dashboards().list();
        Assert.assertNotNull(actualDashboardItems);
        Assert.assertTrue((actualDashboardItems.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Iterables.all((Iterable)expectedDashboardItems, (Predicate)Predicates.not((Predicate)Predicates.in(actualDashboardItems))));
    }

    @Test
    public void testAnAdminIsAbleToDeleteDashboardsSharedWithAGroupHeBelongsTo() {
        ImmutableList expectedDashboardItems = ImmutableList.of((Object)new DashboardItem.Builder().id(10014L).name("Shared Dashboard with Anyone owned by developer").owner("Developer (developer)").build(), (Object)new DashboardItem.Builder().id(10010L).name("Shared Dashboard with group jira-administrators owned by admin").owner("Administrator (admin)").build(), (Object)new DashboardItem.Builder().id(10018L).name("Shared Dashboard with group jira-users owned by fred").owner("Fred Normal (fred)").build());
        List<DashboardItem> actualDashboardItems = this.administration.sharedDashboards().goTo().searchAll().deleteDashboard(10014L).deleteDashboard(10010L).deleteDashboard(10018L).dashboards().list();
        Assert.assertNotNull(actualDashboardItems);
        Assert.assertTrue((actualDashboardItems.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Iterables.all((Iterable)expectedDashboardItems, (Predicate)Predicates.not((Predicate)Predicates.in(actualDashboardItems))));
    }

    @Test
    public void testAnAdminIsAbleToDeleteDashboardsSharedWithARoleHeIsNotPartOf() {
        ImmutableList expectedDashboardItems = ImmutableList.of((Object)new DashboardItem.Builder().id(10016L).name("Shared Dashboard with role Developers on homosapiens owned by developer").owner("Developer (developer)").build());
        List<DashboardItem> actualDashboardItems = this.administration.sharedDashboards().goTo().searchAll().deleteDashboard(10016L).dashboards().list();
        Assert.assertNotNull(actualDashboardItems);
        Assert.assertTrue((actualDashboardItems.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Iterables.all((Iterable)expectedDashboardItems, (Predicate)Predicates.not((Predicate)Predicates.in(actualDashboardItems))));
    }

    @Test
    public void testAnAdminIsAbleToDeleteDashboardsSharedWithARoleHeIsPartOf() {
        ImmutableList expectedDashboardItems = ImmutableList.of((Object)new DashboardItem.Builder().id(10019L).name("Shared Dashboard with role Users on homosapien owned by fred").owner("Fred Normal (fred)").build(), (Object)new DashboardItem.Builder().id(10013L).name("Shared Dashboard with all roles on Monkey owned by developer").owner("Developer (developer)").build());
        List<DashboardItem> actualDashboardItems = this.administration.sharedDashboards().goTo().searchAll().deleteDashboard(10019L).deleteDashboard(10013L).dashboards().list();
        Assert.assertNotNull(actualDashboardItems);
        Assert.assertTrue((actualDashboardItems.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Iterables.all((Iterable)expectedDashboardItems, (Predicate)Predicates.not((Predicate)Predicates.in(actualDashboardItems))));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=811000)
    public void testAnAdminIsAbleToDeletePrivateDashboard() {
        ImmutableList expectedDashboardItems = ImmutableList.of((Object)new DashboardItem.Builder().id(10012L).name("Private Dasboard owned by developer").owner("Developer (developer)").build());
        List<DashboardItem> actualDashboardItems = this.administration.sharedDashboards().goTo().searchAll().deleteDashboard(10012L).dashboards().list();
        Assert.assertNotNull(actualDashboardItems);
        Assert.assertTrue((actualDashboardItems.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Iterables.all((Iterable)expectedDashboardItems, (Predicate)Predicates.not((Predicate)Predicates.in(actualDashboardItems))));
    }
}

