/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard.reports;

import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.dashboard.reports.AbstractConfigureReportFieldTestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Element;
import org.w3c.dom.html.HTMLInputElement;

@WebTest(value={Category.FUNC_TEST, Category.REPORTS})
@LoginAs(user="admin")
public class TestConfigureReportDateField
extends AbstractConfigureReportFieldTestCase {
    @Test
    public void fieldExists() {
        this.tester.assertFormElementPresent("aDate");
    }

    @Test
    public void defaultValueIsEmpty() {
        HTMLInputElement element = (HTMLInputElement)this.tester.getDialog().getElement("date_aDate");
        Assert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void fieldLabelRendered() {
        this.textAssertions.assertTextPresent("A date");
    }

    @Test
    public void fieldDescriptionRendered() {
        this.textAssertions.assertTextPresent("This is a date field");
    }

    @Test
    public void validationErrorsRendered() {
        this.tester.gotoPage("/secure/ConfigureReport.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.dev.func-test-plugin:fieldtest-report&aString=fail");
        this.textAssertions.assertTextPresent(new XPathLocator(this.fieldContainer(), "*[@class='errMsg']"), "This date field has an error");
    }

    @Test
    public void valueIsSubmittedToReportBean() {
        this.tester.setFormElement("aDate", "1977-01-09");
        this.tester.submit();
        this.textAssertions.assertTextPresent(new XPathLocator(this.tester, "//tr[th = 'aDate']/td"), "1977-01-09");
    }

    private Element fieldContainer() {
        return (Element)new XPathLocator(this.tester, "//div[@class = 'field-group'][descendant::input[@name = 'aDate']]").getNode();
    }
}

