/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard.reports;

import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.dashboard.reports.AbstractConfigureReportFieldTestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Element;
import org.w3c.dom.html.HTMLInputElement;

@WebTest(value={Category.FUNC_TEST, Category.REPORTS})
@LoginAs(user="admin")
public class TestConfigureReportStringField
extends AbstractConfigureReportFieldTestCase {
    private Element fieldContainer() {
        return (Element)new XPathLocator(this.tester, "//div[@class = 'field-group'][input[@id = 'aString']]").getNode();
    }

    @Test
    public void fieldExists() {
        this.tester.assertFormElementPresent("aString");
    }

    @Test
    public void defaultValueIsFilledIn() {
        HTMLInputElement element = (HTMLInputElement)this.tester.getDialog().getElement("aString");
        Assert.assertThat((Object)element.getValue(), (Matcher)Matchers.is((Object)"Galah"));
    }

    @Test
    public void fieldLabelRendered() {
        this.textAssertions.assertTextPresent(new XPathLocator(this.fieldContainer(), "label"), "A string");
    }

    @Test
    public void fieldDescriptionRendered() {
        this.textAssertions.assertTextPresent(new XPathLocator(this.fieldContainer(), "descendant::label[@for='aString']"), "This is a string field");
    }

    @Test
    public void validationErrorsRendered() {
        this.tester.gotoPage("/secure/ConfigureReport.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.dev.func-test-plugin:fieldtest-report&aString=fail");
        this.textAssertions.assertTextPresent(new XPathLocator(this.fieldContainer(), "*[@class='errMsg']"), "This string field has an error");
    }

    @Test
    public void valueIsSubmittedToReportBean() {
        this.tester.setFormElement("aString", "MyStringValue");
        this.tester.submit();
        this.textAssertions.assertTextPresent(new XPathLocator(this.tester, "//tr[th = 'aString']/td"), "MyStringValue");
    }
}

