/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard.reports;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.LabelAssertions;
import com.atlassian.jira.functest.framework.assertions.TableAssertions;
import com.atlassian.jira.functest.framework.labels.Labels;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.meterware.httpunit.WebTable;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REPORTS})
@LoginAs(user="admin")
public class TestSingleLevelGroupByReportByLabels
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;

    @Test
    public void testSeveralIssuesWithSharedAndDistinctLabels() {
        this.administration.restoreDataAndLogin("TestSeveralIssuesWithSharedAndDistinctLabels.xml", "admin");
        String ID_BUG_WITH_NO_LABEL = "10000";
        String ID_IMPROVEMENT_WITH_NO_LABEL = "10001";
        String ID_BUG_WITH_LABEL_A = "10002";
        String ID_BUG_WITH_LABEL_B = "10003";
        String ID_BUG_WITH_LABELS_A_AND_B = "10004";
        String ID_IMPROVEMENT_WITH_LABEL_C = "10005";
        String ID_IMPROVEMENT_WITH_LABEL_A = "10006";
        String ID_IMPROVEMENT_WITH_LABEL_B = "10007";
        String ID_IMPROVEMENT_WITH_LABELS_B_AND_C = "10008";
        String KEY_BUG_WITH_NO_LABEL = "KEY-1";
        String KEY_IMPROVEMENT_WITH_NO_LABEL = "KEY-2";
        String KEY_BUG_WITH_LABEL_A = "KEY-3";
        String KEY_BUG_WITH_LABEL_B = "KEY-4";
        String KEY_BUG_WITH_LABELS_A_AND_B = "KEY-5";
        String KEY_IMPROVEMENT_WITH_LABEL_C = "KEY-6";
        String KEY_IMPROVEMENT_WITH_LABEL_A = "KEY-7";
        String KEY_IMPROVEMENT_WITH_LABEL_B = "KEY-8";
        String KEY_IMPROVEMENT_WITH_LABELS_B_AND_C = "KEY-9";
        Labels LABELS_NONE = new Labels(true, false, false, new String[0]);
        Labels LABELS_A = new Labels(true, true, true, "A");
        Labels LABELS_B = new Labels(true, true, true, "B");
        Labels LABELS_C = new Labels(true, true, true, "C");
        Labels LABELS_A_AND_B = new Labels(true, true, true, "A", "B");
        Labels LABELS_B_AND_C = new Labels(true, true, true, "B", "C");
        LabelAssertions labelAssertions = this.assertions.getLabelAssertions();
        this.navigation.issue().viewIssue("KEY-1");
        labelAssertions.assertSystemLabels("10000", LABELS_NONE);
        this.navigation.issue().viewIssue("KEY-2");
        labelAssertions.assertSystemLabels("10001", LABELS_NONE);
        this.navigation.issue().viewIssue("KEY-3");
        labelAssertions.assertSystemLabels("10002", LABELS_A);
        this.navigation.issue().viewIssue("KEY-4");
        labelAssertions.assertSystemLabels("10003", LABELS_B);
        this.navigation.issue().viewIssue("KEY-5");
        labelAssertions.assertSystemLabels("10004", LABELS_A_AND_B);
        this.navigation.issue().viewIssue("KEY-6");
        labelAssertions.assertSystemLabels("10005", LABELS_C);
        this.navigation.issue().viewIssue("KEY-7");
        labelAssertions.assertSystemLabels("10006", LABELS_A);
        this.navigation.issue().viewIssue("KEY-8");
        labelAssertions.assertSystemLabels("10007", LABELS_B);
        this.navigation.issue().viewIssue("KEY-9");
        labelAssertions.assertSystemLabels("10008", LABELS_B_AND_C);
        long PROJECT_ID = 10010L;
        String REPORT_KEY = "com.atlassian.jira.jira-core-reports-plugin:singlelevelgroupby";
        long FILTER_ID = 10000L;
        String MAPPER = "labels";
        this.navigation.runReport(10010L, "com.atlassian.jira.jira-core-reports-plugin:singlelevelgroupby", 10000L, "labels");
        TableAssertions tableAssertions = this.assertions.getTableAssertions();
        WebTable webTable = tableAssertions.getWebTable("single_groupby_report_table");
        tableAssertions.assertTableCellHasText(webTable, 1, 0, "Label: A");
        tableAssertions.assertTableCellHasText(webTable, 2, 1, "KEY-7");
        tableAssertions.assertTableCellHasText(webTable, 3, 1, "KEY-5");
        tableAssertions.assertTableCellHasText(webTable, 4, 1, "KEY-3");
        tableAssertions.assertTableCellHasText(webTable, 5, 0, "Label: B");
        tableAssertions.assertTableCellHasText(webTable, 6, 1, "KEY-9");
        tableAssertions.assertTableCellHasText(webTable, 7, 1, "KEY-8");
        tableAssertions.assertTableCellHasText(webTable, 8, 1, "KEY-5");
        tableAssertions.assertTableCellHasText(webTable, 9, 1, "KEY-4");
        tableAssertions.assertTableCellHasText(webTable, 10, 0, "Label: C");
        tableAssertions.assertTableCellHasText(webTable, 11, 1, "KEY-9");
        tableAssertions.assertTableCellHasText(webTable, 12, 1, "KEY-6");
        this.tester.assertTextNotPresent("KEY-1");
        this.tester.assertTextNotPresent("KEY-2");
    }

    @Test
    public void testXss() throws Exception {
        this.administration.restoreBlankInstance();
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "Label XSS test issue");
        String xss = "<script>alert(1)</script>";
        this.backdoor.issues().addLabel(issue.key(), "<script>alert(1)</script>");
        String filter = this.backdoor.searchRequests().createFilter("admin", "project = HSP", "all HSP", "Everything in the Homosapien project");
        this.navigation.runReport(10000L, "com.atlassian.jira.jira-core-reports-plugin:singlelevelgroupby", Long.parseLong(filter), "labels");
        this.tester.assertTextNotPresent("<script>alert(1)</script>");
    }
}

