/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.EmailBaseFuncTestCase;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.EMAIL})
@LoginAs(user="admin")
public class TestBulkHeaders
extends EmailBaseFuncTestCase {
    @Test
    @Restore(value="TestIssueNotifications.xml")
    public void testBulkHeadersPresent() throws InterruptedException, MessagingException {
        this.configureAndStartSmtpServerWithNotify();
        String issueId = "COW-1";
        this.navigation.issue().viewIssue("COW-1");
        this.tester.clickLink("delete-issue");
        this.tester.submit("Delete");
        this.flushMailQueueAndWait(2);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        Assert.assertEquals((long)2L, (long)mimeMessages.length);
        for (MimeMessage msg : mimeMessages) {
            String[] prec = msg.getHeader("Precedence");
            String[] auto = msg.getHeader("Auto-Submitted");
            Assert.assertEquals((Object)"bulk", (Object)prec[0]);
            Assert.assertEquals((Object)"auto-generated", (Object)auto[0]);
        }
    }

    @Test
    @Restore(value="TestStripBulk.xml")
    public void testBulkHeadersNotPresent() throws InterruptedException, MessagingException {
        this.configureAndStartSmtpServerWithNotify();
        String issueId = "MKY-1";
        this.navigation.issue().viewIssue("MKY-1");
        this.tester.clickLink("delete-issue");
        this.tester.submit("Delete");
        this.flushMailQueueAndWait(3);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        Assert.assertEquals((long)3L, (long)mimeMessages.length);
        for (MimeMessage msg : mimeMessages) {
            Assert.assertNull((Object)msg.getHeader("Precedence"));
            Assert.assertNull((Object)msg.getHeader("Auto-Submitted"));
        }
    }
}

