/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BulkOperationProgress;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.EmailBaseFuncTestCase;
import com.atlassian.jira.webtests.util.issue.IssueInlineEdit;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.EMAIL})
@LoginAs(user="admin")
@Restore(value="TestCurrentAssigneeNotifications.xml")
public class TestCurrentAssigneeNotifications
extends EmailBaseFuncTestCase {
    public static final String HOMER = "homer";
    @Inject
    private BulkOperationProgress bulkOperationProgress;
    @Inject
    private LocatorFactory locator;
    @Inject
    private WorkflowUtil workflowUtil;

    @Before
    public void disableFrotherAssigneeField() {
        this.backdoor.darkFeatures().enableForSite("no.frother.assignee.field");
    }

    @Before
    public void restoreDataAndConfigureSmtp() {
        this.configureAndStartSmtpServer();
        this.backdoor.darkFeatures().enableForSite("no.frother.assignee.field");
    }

    @After
    public void enableFrotherAssigneeField() {
        this.backdoor.darkFeatures().disableForSite("no.frother.assignee.field");
    }

    @Test
    public void testAssignIssueSendsEmailToNewAndOldAssignees() throws Exception {
        this.navigation.issue().assignIssue("HSP-1", "This has been re-assigned", HOMER);
        this.assertHomerAndBartsEmails(1, 1);
    }

    @Test
    public void testAssignIssueTriggersIssueAssignedEvent() throws Exception {
        this.navigation.issue().assignIssue("HSP-1", "This has been re-assigned", HOMER);
        this.assertEmailSentToUserListeningOnlyToIssueAssignedEvents();
    }

    @Test
    public void testEditIssueChangingAssigneeSendsEmailToNewAndOldAssignees() throws Exception {
        this.editIssueAndChangeAssignee("HSP-1", "This has been re-assigned", HOMER);
        this.assertHomerAndBartsEmails(1, 1);
    }

    @Test
    public void testEditIssueChangingAssigneeTriggersIssueAssignedEvent() throws Exception {
        this.editIssueAndChangeAssignee("HSP-1", "This has been re-assigned", HOMER);
        this.assertEmailSentToUserListeningOnlyToIssueAssignedEvents();
    }

    @Test
    public void testTransitionIssueChangingAssigneeSendsEmailToNewAndOldAssignees() throws Exception {
        this.workflowIssueAndChangeAssignee("HSP-1", HOMER);
        this.assertHomerAndBartsEmails(1, 1);
    }

    @Test
    public void testTransitionIssueChangingAssigneeTriggersIssueAssignedEvent() throws Exception {
        this.workflowIssueAndChangeAssignee("HSP-1", HOMER);
        this.assertEmailSentToUserListeningOnlyToIssueAssignedEvents();
    }

    @Test
    public void testBulkEditIssueChangingAssigneeSendsEmailToNewAndOldAssignees() throws Exception {
        this.bulkEditHSP_1(HOMER);
        this.assertHomerAndBartsEmails(1, 1);
    }

    @Test
    public void testBulkEditIssueChangingAssigneeTriggersIssueAssignedEvent() throws Exception {
        this.bulkEditHSP_1(HOMER);
        this.assertEmailSentToUserListeningOnlyToIssueAssignedEvents();
    }

    @Test
    public void testBulkTransitionIssueChangingAssigneeSendsEmailToNewAndOldAssignees() throws Exception {
        this.bulkTransitionHSP_1(HOMER);
        this.assertHomerAndBartsEmails(1, 1);
    }

    @Test
    public void testBulkTransitionIssueChangingAssigneeTriggersIssueAssignedEvent() throws Exception {
        this.bulkTransitionHSP_1(HOMER);
        this.assertEmailSentToUserListeningOnlyToIssueAssignedEvents();
    }

    @Test
    public void testInlineEditingAssigneeSendsEmailToNewAndOldAssignees() throws Exception {
        this.inlineAssign("HSP-1", "10000", HOMER);
        this.assertHomerAndBartsEmails(1, 1);
    }

    @Test
    public void testInlineEditingAssigneeTriggersIssueAssignedEvent() throws Exception {
        this.inlineAssign("HSP-1", "10000", HOMER);
        this.assertEmailSentToUserListeningOnlyToIssueAssignedEvents();
    }

    private void inlineAssign(String issueKey, String issueId, String newAssignee) throws Exception {
        this.navigation.issue().gotoIssue(issueKey);
        IssueInlineEdit inlineEdit = new IssueInlineEdit(this.locator, this.tester, this.environmentData);
        inlineEdit.inlineEditField(issueId, "assignee", newAssignee);
    }

    private void bulkEditHSP_1(String newAssigneeName) {
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.edit.operation.name");
        this.tester.submit("Next");
        this.tester.checkCheckbox("actions", "assignee");
        this.tester.selectOption("assignee", newAssigneeName);
        this.tester.checkCheckbox("sendBulkNotification", "true");
        this.tester.submit("Next");
        this.tester.submit("Confirm");
        this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage();
    }

    private void bulkTransitionHSP_1(String newAssigneeName) {
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.workflowtransition.operation.name");
        this.tester.submit("Next");
        this.tester.checkCheckbox("wftransition", "jira_5_5");
        this.tester.submit("Next");
        this.tester.checkCheckbox("actions", "resolution");
        this.tester.selectOption("resolution", "Won't Fix");
        this.tester.checkCheckbox("actions", "assignee");
        this.tester.selectOption("assignee", newAssigneeName);
        this.tester.checkCheckbox("sendBulkNotification", "true");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage();
    }

    private void editIssueAndChangeAssignee(String issueKey, String commentStr, String newAssigneeName) {
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("edit-issue");
        this.tester.selectOption("assignee", newAssigneeName);
        this.tester.setFormElement("comment", commentStr);
        this.tester.submit("Update");
    }

    private void workflowIssueAndChangeAssignee(String issueKey, String newAssigneeName) {
        this.navigation.issue().viewIssue(issueKey);
        this.workflowUtil.clickAction("action_id_5");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.selectOption("resolution", "Won't Fix");
        this.tester.selectOption("assignee", newAssigneeName);
        this.tester.submit("Transition");
    }

    private void assertHomerAndBartsEmails(int expectedHomerEmailCount, int expectedBartEmailCount) throws MessagingException, InterruptedException, IOException {
        this.flushMailQueueAndWaitForRecipients(5000, "homer@localhost", "bart@localhost");
        this.assertHomerWasAssignedEmails("homer@localhost", expectedHomerEmailCount);
        this.assertHomerWasAssignedEmails("bart@localhost", expectedBartEmailCount);
    }

    private void assertHomerWasAssignedEmails(String emailAddress, int expectedEmailCount) throws MessagingException, IOException {
        List<MimeMessage> messagesForRecipient = this.getMessagesForRecipient(emailAddress);
        Assert.assertEquals((long)expectedEmailCount, (long)messagesForRecipient.size());
        Iterator<MimeMessage> iterator = messagesForRecipient.iterator();
        while (iterator.hasNext()) {
            MimeMessage msg;
            MimeMessage message = msg = iterator.next();
            String subject = message.getSubject();
            Assert.assertTrue((boolean)subject.contains("HSP-1"));
            this.assertEmailBodyContains(message, "HSP-1");
            this.assertEmailBodyContains(message, "Assignee:");
            this.assertEmailBodyContainsLine(message, ".*diffremovedchars.*bart.*");
            this.assertEmailBodyContainsLine(message, ".*diffaddedchars.*homer.*");
        }
    }

    private void assertEmailSentToUserListeningOnlyToIssueAssignedEvents() throws Exception {
        this.flushMailQueueAndWaitForRecipients(5000, "test@test.com");
        List<MimeMessage> messagesForRecipient = this.getMessagesForRecipient("test@test.com");
        Assert.assertThat((Object)messagesForRecipient.size(), (Matcher)Matchers.is((Object)1));
    }
}

