/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.EmailBaseFuncTestCase;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import javax.inject.Inject;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.EMAIL})
@LoginAs(user="admin")
@Restore(value="TestNotificationEmails.xml")
public class TestNotificationEmails
extends EmailBaseFuncTestCase {
    private static final String ADMIN_ONLY_KEY = "HSP-1";
    private static final String ADMIN_ONLY_SUMMARY = "Admin Not Watched";
    private static final String BOTH_KEY = "HSP-2";
    private static final String BOTH_SUMMARY = "Admin Watched by Fred";
    private static final String EMAIL_PREFIX = "JIRATEST";
    private static final String EDIT_ISSUE_COMMENT = "Edit issue comment.";
    private static final String COMMENT_ON_ISSUE_COMMENT = "Comment on the issue comment.";
    private static final String ASSIGN_ISSUE_COMMENT = "I am assigning this issue to myself.";
    private static final String RESOLVE_ISSUE_COMMENT = "I resolved the issue.";
    private static final String REOPEN_ISSUE_COMMENT = "I reopened the issue.";
    private static final String ADMIN_EMAIL = "admin@example.com";
    private static final String GROUP_PRIVATE = "GROUP PRIVATE: ";
    private static final String ROLE_PRIVATE = "ROLE PRIVATE: ";
    private static final String GROUPS_ADMINS = "jira-administrators";
    private static final String ROLE_ADMINS = "Administrators";
    private static final String UNASSIGNED = "Unassigned";
    @Inject
    protected TextAssertions textAssertions;
    @Inject
    private WorkflowUtil workflowUtil;

    @Before
    public void disableFrotherAssigneeField() {
        this.backdoor.darkFeatures().enableForSite("no.frother.assignee.field");
    }

    @After
    public void enableFrotherAssigneeField() {
        this.backdoor.darkFeatures().disableForSite("no.frother.assignee.field");
    }

    @Before
    public void startSmtpServer() {
        super.configureAndStartSmtpServerWithNotify();
    }

    @Before
    public void setUpUSerNotificationType() {
        this.backdoor.userProfile().changeUserNotificationType("admin", "text");
    }

    @Test
    public void testEmailHasCommentsWhenEditIssue() throws Exception {
        EmailBaseFuncTestCase.MailBox adminFolder = this.getMailBox(ADMIN_EMAIL);
        EmailBaseFuncTestCase.MailBox fredFolder = this.getMailBox("fred@example.com");
        this.navigation.issue().gotoIssue(ADMIN_ONLY_KEY);
        this.updateIssue(EDIT_ISSUE_COMMENT, null, null);
        MimeMessage message = adminFolder.awaitMessage();
        this.textAssertions.assertTextSequence(message.getSubject(), EMAIL_PREFIX, ADMIN_ONLY_KEY, ADMIN_ONLY_SUMMARY);
        this.textAssertions.assertTextSequence(message.getFrom()[0].toString(), "Administrator", "jiratest@atlassian.com");
        this.assertMessageAndType(message, EDIT_ISSUE_COMMENT, false);
        this.navigation.issue().gotoIssue(BOTH_KEY);
        this.updateIssue(EDIT_ISSUE_COMMENT, null, null);
        message = adminFolder.awaitMessage();
        this.textAssertions.assertTextSequence(message.getSubject(), EMAIL_PREFIX, BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, EDIT_ISSUE_COMMENT, false);
        message = fredFolder.awaitMessage();
        this.textAssertions.assertTextSequence(message.getSubject(), EMAIL_PREFIX, BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, EDIT_ISSUE_COMMENT, true);
        String comment = this.createGroupComment(EDIT_ISSUE_COMMENT);
        this.navigation.issue().gotoIssue(BOTH_KEY);
        this.updateIssue(comment, GROUPS_ADMINS, "Blocker");
        message = adminFolder.awaitMessage();
        this.textAssertions.assertTextSequence(message.getSubject(), EMAIL_PREFIX, BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, comment, false);
        Assert.assertNull((Object)fredFolder.nextMessage());
        comment = this.createRoleComment(EDIT_ISSUE_COMMENT);
        this.navigation.issue().gotoIssue(BOTH_KEY);
        this.updateIssue(comment, ROLE_ADMINS, "Minor");
        message = adminFolder.awaitMessage();
        this.textAssertions.assertTextSequence(message.getSubject(), EMAIL_PREFIX, BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, comment, false);
        Assert.assertNull((Object)fredFolder.nextMessage());
    }

    @Test
    public void testEmailHasCommentWhenAddingComment() throws Exception {
        EmailBaseFuncTestCase.MailBox adminFolder = this.getMailBox(ADMIN_EMAIL);
        EmailBaseFuncTestCase.MailBox fredFolder = this.getMailBox("fred@example.com");
        this.addIssueComment(ADMIN_ONLY_KEY, COMMENT_ON_ISSUE_COMMENT, null);
        MimeMessage message = adminFolder.awaitMessage();
        this.textAssertions.assertTextSequence(message.getSubject(), EMAIL_PREFIX, ADMIN_ONLY_KEY, ADMIN_ONLY_SUMMARY);
        this.assertMessageAndType(message, COMMENT_ON_ISSUE_COMMENT, false);
        Assert.assertNull((Object)fredFolder.nextMessage());
        this.addIssueComment(BOTH_KEY, COMMENT_ON_ISSUE_COMMENT, null);
        message = adminFolder.awaitMessage();
        this.textAssertions.assertTextSequence(message.getSubject(), EMAIL_PREFIX, BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, COMMENT_ON_ISSUE_COMMENT, false);
        message = fredFolder.awaitMessage();
        this.textAssertions.assertTextSequence(message.getSubject(), EMAIL_PREFIX, BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, COMMENT_ON_ISSUE_COMMENT, true);
        String comment = this.createGroupComment(COMMENT_ON_ISSUE_COMMENT);
        this.addIssueComment(BOTH_KEY, comment, GROUPS_ADMINS);
        message = adminFolder.awaitMessage();
        this.textAssertions.assertTextSequence(message.getSubject(), EMAIL_PREFIX, BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, comment, false);
        Assert.assertNull((Object)fredFolder.nextMessage());
        comment = this.createRoleComment(COMMENT_ON_ISSUE_COMMENT);
        this.addIssueComment(BOTH_KEY, comment, ROLE_ADMINS);
        message = adminFolder.awaitMessage();
        this.textAssertions.assertTextSequence(message.getSubject(), EMAIL_PREFIX, BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, comment, false);
        Assert.assertNull((Object)fredFolder.nextMessage());
    }

    @Test
    public void testEmailHasCommentWhenAssigningIssue() throws Exception {
        EmailBaseFuncTestCase.MailBox adminFolder = this.getMailBox(ADMIN_EMAIL);
        EmailBaseFuncTestCase.MailBox fredFolder = this.getMailBox("fred@example.com");
        this.assignIssue(ADMIN_ONLY_KEY, "Administrator", ASSIGN_ISSUE_COMMENT, null);
        MimeMessage message = adminFolder.awaitMessage();
        this.textAssertions.assertTextSequence(message.getSubject(), EMAIL_PREFIX, ADMIN_ONLY_KEY, ADMIN_ONLY_SUMMARY);
        this.assertMessageAndType(message, ASSIGN_ISSUE_COMMENT, false);
        Assert.assertNull((Object)fredFolder.nextMessage());
        this.assignIssue(BOTH_KEY, "Administrator", ASSIGN_ISSUE_COMMENT, null);
        message = adminFolder.awaitMessage();
        this.textAssertions.assertTextSequence(message.getSubject(), EMAIL_PREFIX, BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, ASSIGN_ISSUE_COMMENT, false);
        message = fredFolder.awaitMessage();
        this.textAssertions.assertTextSequence(message.getSubject(), EMAIL_PREFIX, BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, ASSIGN_ISSUE_COMMENT, true);
        String comment = this.createGroupComment(ASSIGN_ISSUE_COMMENT);
        this.assignIssue(BOTH_KEY, UNASSIGNED, comment, GROUPS_ADMINS);
        message = adminFolder.awaitMessage();
        this.textAssertions.assertTextSequence(message.getSubject(), EMAIL_PREFIX, BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, comment, false);
        Assert.assertNull((Object)fredFolder.nextMessage());
        comment = this.createRoleComment(ASSIGN_ISSUE_COMMENT);
        this.assignIssue(BOTH_KEY, "Administrator", comment, ROLE_ADMINS);
        message = adminFolder.awaitMessage();
        this.textAssertions.assertTextSequence(message.getSubject(), EMAIL_PREFIX, BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, comment, false);
        Assert.assertNull((Object)fredFolder.nextMessage());
    }

    @Test
    public void testEmailHasCommentWhenTransitioningAnIssue() throws Exception {
        EmailBaseFuncTestCase.MailBox adminFolder = this.getMailBox(ADMIN_EMAIL);
        EmailBaseFuncTestCase.MailBox fredFolder = this.getMailBox("fred@example.com");
        this.resolveIssue(ADMIN_ONLY_KEY, RESOLVE_ISSUE_COMMENT, null);
        MimeMessage message = adminFolder.awaitMessage();
        this.textAssertions.assertTextSequence(message.getSubject(), EMAIL_PREFIX, ADMIN_ONLY_KEY, ADMIN_ONLY_SUMMARY);
        this.assertMessageAndType(message, RESOLVE_ISSUE_COMMENT, false);
        Assert.assertNull((Object)fredFolder.nextMessage());
        this.resolveIssue(BOTH_KEY, RESOLVE_ISSUE_COMMENT, null);
        message = adminFolder.awaitMessage();
        this.textAssertions.assertTextSequence(message.getSubject(), EMAIL_PREFIX, BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, RESOLVE_ISSUE_COMMENT, false);
        message = fredFolder.awaitMessage();
        this.textAssertions.assertTextSequence(message.getSubject(), EMAIL_PREFIX, BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, RESOLVE_ISSUE_COMMENT, true);
        String comment = this.createGroupComment(REOPEN_ISSUE_COMMENT);
        this.reopenIssue(BOTH_KEY, comment, GROUPS_ADMINS);
        message = adminFolder.awaitMessage();
        this.textAssertions.assertTextSequence(message.getSubject(), EMAIL_PREFIX, BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, comment, false);
        message = fredFolder.awaitMessage();
        this.textAssertions.assertTextSequence(message.getSubject(), EMAIL_PREFIX, BOTH_KEY, BOTH_SUMMARY);
        this.assertNotMessageAndType(message, comment, true);
        comment = this.createRoleComment(RESOLVE_ISSUE_COMMENT);
        this.resolveIssue(BOTH_KEY, comment, ROLE_ADMINS);
        message = adminFolder.awaitMessage();
        this.textAssertions.assertTextSequence(message.getSubject(), EMAIL_PREFIX, BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, comment, false);
        message = fredFolder.awaitMessage();
        this.textAssertions.assertTextSequence(message.getSubject(), EMAIL_PREFIX, BOTH_KEY, BOTH_SUMMARY);
        this.assertNotMessageAndType(message, comment, true);
    }

    private void updateIssue(String comment, String security, String priority) throws InterruptedException {
        this.tester.clickLink("edit-issue");
        this.tester.setWorkingForm("issue-edit");
        this.tester.setFormElement("comment", comment);
        if (StringUtils.isNotBlank((CharSequence)priority)) {
            this.tester.selectOption("priority", priority);
        }
        if (StringUtils.isNotBlank((CharSequence)security)) {
            this.tester.selectOption("commentLevel", security);
        }
        this.tester.clickButton("issue-edit-submit");
        this.flushMailQueueAndWait(1);
    }

    private void addIssueComment(String key, String comment, String security) throws InterruptedException {
        this.navigation.issue().addComment(key, comment, security);
        this.flushMailQueueAndWait(1);
    }

    private void assignIssue(String key, String username, String comment, String security) throws InterruptedException {
        this.navigation.issue().gotoIssue(key);
        this.tester.clickLink("assign-issue");
        this.tester.selectOption("assignee", username);
        if (comment != null) {
            this.tester.setFormElement("comment", comment);
        }
        if (security != null) {
            this.tester.selectOption("commentLevel", security);
        }
        this.tester.clickButton("assign-issue-submit");
        this.flushMailQueueAndWait(1);
    }

    private void reopenIssue(String key, String comment, String security) throws InterruptedException {
        this.doWorkflow(key, 3, comment, security);
    }

    private void resolveIssue(String key, String comment, String security) throws InterruptedException {
        this.doWorkflow(key, 5, comment, security);
    }

    private void doWorkflow(String key, int id, String comment, String security) throws InterruptedException {
        this.navigation.issue().gotoIssue(key);
        this.workflowUtil.clickAction("action_id_" + id);
        this.tester.setWorkingForm("issue-workflow-transition");
        if (comment != null) {
            this.tester.setFormElement("comment", comment);
        }
        if (security != null) {
            this.tester.selectOption("commentLevel", security);
        }
        this.tester.submit("Transition");
        this.flushMailQueueAndWait(1);
    }

    private String createGroupComment(String comment) {
        return GROUP_PRIVATE + comment;
    }

    private String createRoleComment(String comment) {
        return ROLE_PRIVATE + comment;
    }
}

