/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.EmailBaseFuncTestCase;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.EMAIL})
@LoginAs(user="admin")
public class TestOutgoingMailSettings
extends EmailBaseFuncTestCase {
    @Inject
    private Administration administration;

    @Test
    public void testDisablingEmailOnDataRestoreIsAppliedEvenWhenItIsEnabledInTheXmlBackupFile() {
        this.administration.restoreData(Backups.OUTGOING_EMAIL_ENABLED, Administration.OutgoingMailSettings.DISABLE);
        Assert.assertTrue((boolean)this.administration.mailServers().Smtp().isDisabled());
    }

    @After
    public void tearDown() {
        this.backdoor.applicationProperties().setOption("jira.mail.send.disabled", false);
    }

    public static class Backups {
        private static String OUTGOING_EMAIL_ENABLED = "TestOutgoingMailSettings/outgoing-mail-enabled.xml";
    }
}

