/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.jira.functest.framework.BaseJiraEmailTest;
import com.atlassian.jira.functest.framework.FunctTestConstants;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.MimeMessageMatchers;
import com.atlassian.jira.functest.rule.MailTest;
import com.atlassian.jira.testkit.client.log.FuncTestLoggerImpl;
import com.atlassian.jira.webtests.ztests.email.ShareClient;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import javax.mail.internet.MimeMessage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@RestoreBlankInstance
@WebTest(value={Category.FUNC_TEST, Category.EMAIL})
public class TestShareEmails
extends BaseJiraEmailTest
implements FunctTestConstants {
    private FuncTestLoggerImpl logger = new FuncTestLoggerImpl(1);
    private ShareClient shareClient;
    private String issueKey;

    public void log(Object logData) {
        this.logger.log(logData);
    }

    @Before
    public void setUpTest() {
        this.backdoor.applicationProperties().enableGlobalSharing();
        this.issueKey = this.backdoor.issues().createIssue(10000L, "Issue 1", "admin").key();
        this.shareClient = new ShareClient(this.getEnvironmentData());
        this.backdoor.usersAndGroups().addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
        this.backdoor.userProfile().changeUserNotificationType("bob", "text");
        this.backdoor.userProfile().changeUserNotificationType("fred", "html");
    }

    @Test
    @MailTest
    public void testAll() throws Exception {
        this.logger.log((Object)"Running _testShareIssue");
        this._testShareIssue();
        this.logger.log((Object)"Running _testShareSavedSearch");
        this._testShareSavedSearch();
        this.logger.log((Object)"Running _testShareJqlSearch");
        this._testShareJqlSearch();
    }

    public void _testShareIssue() throws Exception {
        HashSet usernames = Sets.newHashSet((Object[])new String[]{"fred", "bob"});
        HashSet emails = Sets.newHashSet((Object[])new String[]{"fake@example.com"});
        String comment = "I thought you should know";
        this.shareClient.shareIssue(this.issueKey, usernames, emails, comment);
        Collection<MimeMessage> mimeMessages = this.mailHelper.flushMailQueueAndWait(3);
        this.mailHelper.clearOutgoingMailQueue();
        MimeMessage message = this.mailHelper.getMessageForAddress(mimeMessages, "fred@example.com");
        Assert.assertThat((Object)message, MimeMessageMatchers.withSubjectEqualTo("[JIRATEST] Administrator shared \"HSP-1: Issue 1\" with you"));
        Assert.assertThat((Object)message, MimeMessageMatchers.hasHtmlContentType());
        Assert.assertThat((Object)message, MimeMessageMatchers.withSubjectEqualTo("[JIRATEST] Administrator shared \"HSP-1: Issue 1\" with you"));
        Assert.assertThat((Object)message, MimeMessageMatchers.containsString("shared</strong> an issue with you"));
        Assert.assertThat((Object)message, MimeMessageMatchers.containsString(comment));
        Assert.assertThat((Object)message, MimeMessageMatchers.withBodyMatching("/browse/HSP-1\".*>HSP-1</a>"));
        message = this.mailHelper.getMessageForAddress(mimeMessages, "bob@stuff.com.com");
        Assert.assertThat((Object)message, MimeMessageMatchers.hasTextContentType());
        Assert.assertThat((Object)message, MimeMessageMatchers.withSubjectEqualTo("[JIRATEST] Administrator shared \"HSP-1: Issue 1\" with you"));
        Assert.assertThat((Object)message, MimeMessageMatchers.containsString("Administrator shared an issue with you"));
        Assert.assertThat((Object)message, MimeMessageMatchers.containsString("/browse/HSP-1"));
        Assert.assertThat((Object)message, MimeMessageMatchers.containsString(comment));
        Assert.assertThat((Object)message, MimeMessageMatchers.containsString("Key: HSP-1"));
        Assert.assertThat((Object)message, MimeMessageMatchers.containsString("Project: homosapien"));
        message = this.mailHelper.getMessageForAddress(mimeMessages, "fake@example.com");
        Assert.assertThat((Object)message, MimeMessageMatchers.hasHtmlContentType());
    }

    public void _testShareSavedSearch() throws Exception {
        String searchJql = "project = HSP";
        String searchName = "Funky Homosapiens";
        String searchDescription = "Find those dudes!";
        String jsonShareString = "[{\"type\":\"global\"}]";
        String filterId = this.backdoor.searchRequests().createFilter("admin", searchJql, searchName, searchDescription, jsonShareString);
        HashSet usernames = Sets.newHashSet((Object[])new String[]{"fred", "bob"});
        HashSet emails = Sets.newHashSet((Object[])new String[]{"fake@example.com"});
        String comment = "I thought you should know";
        this.shareClient.shareSavedSearch(filterId, usernames, emails, comment);
        Collection<MimeMessage> mimeMessages = this.mailHelper.flushMailQueueAndWait(3);
        this.mailHelper.clearOutgoingMailQueue();
        MimeMessage message = this.mailHelper.getMessageForAddress(mimeMessages, "fred@example.com");
        Assert.assertThat((Object)message, MimeMessageMatchers.withSubjectEqualTo("[JIRATEST] Administrator shared the filter \"Funky Homosapiens\" with you"));
        Assert.assertThat((Object)message, MimeMessageMatchers.containsString("Administrator</a>"));
        Assert.assertThat((Object)message, MimeMessageMatchers.containsString("<b>shared</b> a filter with you"));
        Assert.assertThat((Object)message, MimeMessageMatchers.containsString("I thought you should know"));
        Assert.assertThat((Object)message, MimeMessageMatchers.withBodyMatching("/issues/\\?filter=" + filterId + "\" style=\".*\">" + searchName));
        message = this.mailHelper.getMessageForAddress(mimeMessages, "bob@stuff.com.com");
        Assert.assertThat((Object)message, MimeMessageMatchers.hasTextContentType());
        Assert.assertThat((Object)message, MimeMessageMatchers.withSubjectEqualTo("[JIRATEST] Administrator shared the filter \"Funky Homosapiens\" with you"));
        Assert.assertThat((Object)message, MimeMessageMatchers.containsString("Administrator shared a filter with you"));
        Assert.assertThat((Object)message, MimeMessageMatchers.containsString("I thought you should know"));
        Assert.assertThat((Object)message, MimeMessageMatchers.containsString("/issues/?filter=" + filterId));
        message = this.mailHelper.getMessageForAddress(mimeMessages, "fake@example.com");
        Assert.assertThat((Object)message, MimeMessageMatchers.hasHtmlContentType());
        Assert.assertThat((Object)message, MimeMessageMatchers.withSubjectEqualTo("[JIRATEST] Administrator shared a search result with you"));
        Assert.assertThat((Object)message, MimeMessageMatchers.containsString("Administrator</a>"));
        Assert.assertThat((Object)message, MimeMessageMatchers.containsString("<b>shared</b> a search result with you"));
        Assert.assertThat((Object)message, MimeMessageMatchers.containsString("I thought you should know"));
        Assert.assertThat((Object)message, MimeMessageMatchers.withBodyMatching("/issues/\\?jql=project\\+%3D\\+HSP\""));
    }

    public void _testShareJqlSearch() throws Exception {
        String searchJql = "project = HSP";
        HashSet usernames = Sets.newHashSet((Object[])new String[]{"fred", "bob"});
        String comment = "I thought you should know";
        this.shareClient.shareSearchQuery(searchJql, usernames, null, comment);
        Collection<MimeMessage> mimeMessages = this.mailHelper.flushMailQueueAndWait(2);
        this.mailHelper.clearOutgoingMailQueue();
        MimeMessage message = this.mailHelper.getMessageForAddress(mimeMessages, "fred@example.com");
        Assert.assertThat((Object)message, MimeMessageMatchers.hasHtmlContentType());
        Assert.assertThat((Object)message, MimeMessageMatchers.withSubjectEqualTo("[JIRATEST] Administrator shared a search result with you"));
        Assert.assertThat((Object)message, MimeMessageMatchers.containsString("Administrator</a>"));
        Assert.assertThat((Object)message, MimeMessageMatchers.containsString("<b>shared</b> a search result with you"));
        Assert.assertThat((Object)message, MimeMessageMatchers.containsString("I thought you should know"));
        Assert.assertThat((Object)message, MimeMessageMatchers.withBodyMatching("/issues/\\?jql=project\\+%3D\\+HSP\" style=\".*\">View search results"));
        message = this.mailHelper.getMessageForAddress(mimeMessages, "bob@stuff.com.com");
        Assert.assertThat((Object)message, MimeMessageMatchers.hasTextContentType());
        Assert.assertThat((Object)message, MimeMessageMatchers.withSubjectEqualTo("[JIRATEST] Administrator shared a search result with you"));
        Assert.assertThat((Object)message, MimeMessageMatchers.containsString("Administrator shared a search result with you"));
        Assert.assertThat((Object)message, MimeMessageMatchers.containsString(comment));
        Assert.assertThat((Object)message, MimeMessageMatchers.containsString("/issues/?jql=project+%3D+HSP"));
    }
}

