/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.favourite;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Dashboard;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Parser;
import com.atlassian.jira.functest.framework.parser.filter.FilterItem;
import com.atlassian.jira.functest.framework.parser.filter.FilterList;
import com.atlassian.jira.functest.framework.sharing.SharedEntityInfo;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
@Restore(value="TestAdjustFavourite.xml")
@LoginAs(user="admin")
public class TestAdjustFavourite
extends BaseJiraFuncTest {
    private static final String TYPE_DASHBOARD = "PortalPage";
    private static final String TYPE_FILTER = "SearchRequest";
    private static final String USER_FRED = "fred";
    private static final long ID_FILTER_PUBLIC = 10000L;
    private static final long ID_FILTER_PRIVATE = 10001L;
    private static final long ID_DASHBOARD_PUBLIC = 10011L;
    private static final long ID_DASHBOARD_PRIVATE = 10012L;
    @Inject
    private Parser parse;
    @Inject
    private HtmlPage page;

    private static String encode(String data) {
        try {
            return URLEncoder.encode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testAddFavourite() {
        this.navigation.logout();
        this.navigation.login(USER_FRED);
        this.addFavourite(TYPE_FILTER, 10000L);
        this.assertions.getJiraFormAssertions().assertNoErrorsPresent();
        this.assertFilterIsFavourite(10000L);
        this.addFavourite(TYPE_DASHBOARD, 10011L);
        this.assertions.getJiraFormAssertions().assertNoErrorsPresent();
        this.assertDashboardIsFavourite(10011L);
    }

    @Test
    public void testTestRedirect() {
        String expectedUrl = "ManageFilters.jspa?filterView=popular";
        this.addFavourite(TYPE_FILTER, 10000L, expectedUrl);
        String actualUrl = this.tester.getDialog().getResponse().getURL().toExternalForm();
        Assert.assertTrue((String)("Expected to get redirected to '" + expectedUrl + "' but we ended up at '" + actualUrl + "'."), (boolean)actualUrl.endsWith(expectedUrl));
        expectedUrl = "MyJiraHome.jspa";
        this.addFavourite(TYPE_DASHBOARD, 10011L);
        actualUrl = this.tester.getDialog().getResponse().getURL().toExternalForm();
        Assert.assertTrue((String)("Expected to get redirected to '" + expectedUrl + " but we ended up at " + actualUrl + "'."), (boolean)actualUrl.endsWith(expectedUrl));
    }

    @Test
    public void testCantAddFavouriteUserCantSee() {
        this.navigation.logout();
        this.navigation.login(USER_FRED);
        this.addFavourite(TYPE_DASHBOARD, 10012L);
        this.assertions.getJiraFormAssertions().assertFormErrMsg("Unable to find the requested entity, it does not exist or you don't have permission to see it.");
        this.addFavourite(TYPE_FILTER, 10001L);
        this.assertions.getJiraFormAssertions().assertFormErrMsg("Unable to find the requested entity, it does not exist or you don't have permission to see it.");
    }

    @Test
    public void testCantAddFavouriteThatDoesNotExist() {
        this.navigation.logout();
        this.navigation.login(USER_FRED);
        this.addFavourite(TYPE_DASHBOARD, 9839054L);
        this.assertions.getJiraFormAssertions().assertFormErrMsg("Unable to find the requested entity, it does not exist or you don't have permission to see it.");
        this.addFavourite(TYPE_FILTER, 547485934L);
        this.assertions.getJiraFormAssertions().assertFormErrMsg("Unable to find the requested entity, it does not exist or you don't have permission to see it.");
    }

    @Test
    public void testBadParameters() {
        this.navigation.logout();
        this.navigation.login(USER_FRED);
        this.addFavourite(TYPE_DASHBOARD, -1L);
        this.assertions.getJiraFormAssertions().assertFormErrMsg("No entity was specified.");
        this.addFavourite(null, 10012L);
        this.assertions.getJiraFormAssertions().assertFormErrMsg("No entity type was specified.");
        this.addFavourite("FHDJS", 10012L);
        this.assertions.getJiraFormAssertions().assertFormErrMsg("The entity type 'FHDJS' is not known to the system.");
    }

    private void addFavourite(String entityType, long entityId) {
        this.addFavourite(entityType, entityId, null);
    }

    private void addFavourite(String entityType, long entityId, String returnUrl) {
        StringBuilder buffer = new StringBuilder(this.page.addXsrfToken("/secure/AddFavourite.jspa?ignore=me"));
        if (StringUtils.isNotBlank((CharSequence)entityType)) {
            buffer.append("&entityType=").append(entityType);
        }
        if (entityId >= 0L) {
            buffer.append("&entityId=").append(entityId);
        }
        if (StringUtils.isNotBlank((CharSequence)returnUrl)) {
            buffer.append("&returnUrl=").append(TestAdjustFavourite.encode(returnUrl));
        }
        this.tester.gotoPage(buffer.toString());
    }

    private void assertDashboardIsFavourite(long pageId) {
        this.navigation.dashboard().navigateToFavourites();
        SharedEntityInfo info = new SharedEntityInfo(pageId, null, null, true, null);
        this.assertions.getDashboardAssertions().assertDashboardPages(Collections.singletonList(info), Dashboard.Table.FAVOURITE);
    }

    private void assertFilterIsFavourite(long filterId) {
        this.navigation.manageFilters().favouriteFilters();
        FilterList list = this.parse.filter().parseFilterList("mf_favourites");
        for (FilterItem filterItem : list.getFilterItems()) {
            if (filterItem.getId() != filterId) continue;
            return;
        }
        Assert.fail((String)("Expected filter '" + filterId + "' to be a favourite but it does not appear to be."));
    }
}

