/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.fields;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.EditIssueFieldVisibility;
import com.atlassian.jira.functest.framework.FieldLayoutSchemes;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.google.common.collect.Lists;
import com.meterware.httpunit.WebTable;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.util.ArrayList;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.FIELDS, Category.SCHEMES})
@LoginAs(user="admin")
public class TestFieldConfigurationSchemes
extends BaseJiraFuncTest {
    private static final String FIELD_CONFIGURATION_NAME_ONE = "Test Field Configuration One";
    @Inject
    private FieldLayoutSchemes fieldLayoutSchemes;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private EditIssueFieldVisibility editIssueFieldVisibility;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;

    @Test
    @RestoreBlankInstance
    public void testAssociateFieldConfigurationSchemeWhenNoSchemeExists() {
        String name = "New testAssociateFieldLayoutSchemeWhenNoSchemeExists Scheme";
        this.tester.gotoPage("/secure/admin/SelectFieldLayoutScheme!default.jspa?projectId=10000");
        this.tester.clickLink("add-new-scheme");
        this.tester.setFormElement("fieldLayoutSchemeName", "New testAssociateFieldLayoutSchemeWhenNoSchemeExists Scheme");
        this.tester.submit("Add");
        this.tester.assertLinkPresent("add-issue-type-field-configuration-association");
        Assert.assertEquals((Object)"New testAssociateFieldLayoutSchemeWhenNoSchemeExists Scheme", (Object)this.locator.xpath("//span[@data-scheme-field='name']").getText());
    }

    @Test
    @RestoreBlankInstance
    public void testFieldConfigurationSchemes() {
        this.administration.project().addProject("neanderthal", "NDT", "admin");
        this.editIssueFieldVisibility.resetFields();
        String issueKey = this.backdoor.issues().createIssue("HSP", "test for field layout schemes", "admin", "Major", "Bug").key();
        this.backdoor.issues().setIssueFields(issueKey, new IssueFields().description("test description for field layout schemes").environment("test environment 2"));
        this.fieldSchemesAddScheme();
        this.fieldSchemesAddDuplicateScheme();
        this.fieldSchemesAddInvalidScheme();
        this.fieldSchemesAssociateWithProject();
        this.fieldSchemesCreateIssueWithFieldConfigurationSchemeHidden();
        this.fieldSchemesCreateIssueWithFieldLayoutSchemeRequired();
        this.checkNavigatorFields();
        this.fieldSchemesEditIssueWithFieldConfigurationSchemeHidden(issueKey);
        this.fieldSchemesEditIssueWithFieldLayoutSchemeRequired(issueKey);
        String issueKey2 = this.backdoor.issues().createIssue("HSP", "test for field layout schemes", "admin", "Major", "Bug").key();
        this.backdoor.issues().setIssueFields(issueKey2, new IssueFields().description("test description for field layout schemes").environment("test environment 2").components(new ResourceRef[]{ResourceRef.withName((String)"New Component 1")}).versions(new ResourceRef[]{ResourceRef.withName((String)"New Version 1")}).fixVersions(new ResourceRef[]{ResourceRef.withName((String)"New Version 1")}));
        this.fieldSchemeMoveIssueWithFieldSchemeHidden(issueKey);
        this.fieldSchemeMoveIssueWithFieldSchemeRequired(issueKey);
        this.fieldSchemeCreateSubTaskWithFieldSchemeHidden(issueKey);
        this.fieldSchemeCreateSubTaskWithFieldSchemeRequired(issueKey);
        this.fieldSchemesDeleteScheme();
        this.navigation.issue().deleteIssue(issueKey);
        this.navigation.issue().deleteIssue(issueKey2);
    }

    private void fieldSchemesAddScheme() {
        this.logger.log((Object)"Field Configuration Scheme: Adding a scheme");
        this.fieldLayoutSchemes.addFieldLayoutScheme("New Field Layout Scheme", "field layout scheme for testing");
        this.tester.assertTextPresent("New Field Layout Scheme");
    }

    private void fieldSchemesDeleteScheme() {
        this.logger.log((Object)"Field Configuration Scheme: Deleting a scheme");
        this.fieldLayoutSchemes.deleteFieldLayoutScheme("New Field Layout Scheme");
        this.tester.assertLinkNotPresentWithText("New Field Layout Scheme");
        this.tester.assertLinkNotPresentWithText("field layout scheme for testing");
    }

    private void fieldSchemesAddDuplicateScheme() {
        this.logger.log((Object)"Field Configuration Scheme: Adding a scheme with a duplicate name");
        this.fieldLayoutSchemes.addFieldLayoutScheme("New Field Layout Scheme", "field layout scheme for testing");
        this.tester.assertTextPresent("A field configuration scheme with this name already exists.");
    }

    private void fieldSchemesAddInvalidScheme() {
        this.logger.log((Object)"Field Configuration Scheme: Adding a scheme with a duplicate name");
        this.fieldLayoutSchemes.addFieldLayoutScheme("", "");
        this.tester.assertTextPresent("The field configuration scheme name must not be empty.");
    }

    private void fieldSchemesAssociateWithProject() {
        this.logger.log((Object)"Field Configuration Scheme: associate a scheme to an issue type in a project");
        this.fieldLayoutSchemes.associateFieldLayoutScheme("NDT", "New Field Layout Scheme");
        this.tester.assertTextPresent("New Field Layout Scheme");
        this.fieldLayoutSchemes.associateWithDefaultFieldLayout("NDT");
        this.tester.assertTextNotPresent("New Field Layout Scheme");
    }

    private void fieldSchemesCreateIssueWithFieldLayoutSchemeRequired() {
        this.logger.log((Object)"Create Issue: Attempt to create with issue field configuration");
        this.fieldLayoutSchemes.addFieldLayoutSchemeEntry("Bug", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.fieldLayoutSchemes.associateFieldLayoutScheme("HSP", "New Field Layout Scheme");
        this.editIssueFieldVisibility.setRequiredFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.editIssueFieldVisibility.setRequiredFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.editIssueFieldVisibility.setRequiredFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.setFormElement("summary", "test summary");
        this.tester.submit();
        this.tester.assertTextPresent("CreateIssueDetails.jspa");
        this.tester.assertTextPresent("Component/s is required");
        this.tester.assertTextPresent("Affects Version/s is required");
        this.tester.assertTextPresent("Fix Version/s is required");
        this.fieldLayoutSchemes.associateWithDefaultFieldLayout("HSP");
        this.removeFieldConfigurationSchemeEntry("Bug", "New Field Layout Scheme");
        this.editIssueFieldVisibility.setOptionalFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.editIssueFieldVisibility.setOptionalFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.editIssueFieldVisibility.setOptionalFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
    }

    private void fieldSchemesCreateIssueWithFieldConfigurationSchemeHidden() {
        this.fieldLayoutSchemes.copyFieldLayout(FIELD_CONFIGURATION_NAME_ONE);
        this.fieldLayoutSchemes.addFieldLayoutSchemeEntry("Bug", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.fieldLayoutSchemes.associateFieldLayoutScheme("HSP", "New Field Layout Scheme");
        this.editIssueFieldVisibility.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.editIssueFieldVisibility.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.editIssueFieldVisibility.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        this.logger.log((Object)"Create Issue: Test the creation of am issue using hidden fields");
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.assertFormElementNotPresent("components");
        this.tester.assertFormElementNotPresent("versions");
        this.tester.assertFormElementNotPresent("fixVersions");
        this.editIssueFieldVisibility.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.editIssueFieldVisibility.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.editIssueFieldVisibility.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        this.fieldLayoutSchemes.associateWithDefaultFieldLayout("HSP");
        this.removeFieldConfigurationSchemeEntry("Bug", "New Field Layout Scheme");
    }

    private void removeFieldConfigurationSchemeEntry(String issueTypeName, String schemeName) {
        this.fieldLayoutSchemes.gotoFieldLayoutSchemes();
        this.tester.clickLinkWithText(schemeName);
        this.tester.assertTextInTable("scheme_entries", issueTypeName);
        try {
            WebTable table = this.tester.getDialog().getResponse().getTableWithID("scheme_entries");
            for (int i = 0; i < table.getRowCount(); ++i) {
                String cellAsText = table.getCellAsText(i, 0);
                if (!TextUtils.stringSet((String)cellAsText) || !cellAsText.contains(issueTypeName)) continue;
                table.getTableCell(i, 2).getLinkWith("Delete").click();
            }
        }
        catch (IOException | SAXException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    private void fieldSchemesEditIssueWithFieldConfigurationSchemeHidden(String issueKey) {
        this.fieldLayoutSchemes.addFieldLayoutSchemeEntry("Bug", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.fieldLayoutSchemes.associateFieldLayoutScheme("HSP", "New Field Layout Scheme");
        this.editIssueFieldVisibility.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.editIssueFieldVisibility.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.editIssueFieldVisibility.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        this.logger.log((Object)"Edit Issue: Test the updating of an issue using hidden fields");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("edit-issue");
        this.tester.assertFormElementNotPresent("components");
        this.tester.assertFormElementNotPresent("versions");
        this.tester.assertFormElementNotPresent("fixVersions");
        this.editIssueFieldVisibility.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.editIssueFieldVisibility.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.editIssueFieldVisibility.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        this.fieldLayoutSchemes.associateWithDefaultFieldLayout("HSP");
        this.removeFieldConfigurationSchemeEntry("Bug", "New Field Layout Scheme");
    }

    private void assertSearcherFields(boolean presenceFlag) {
        String presenceString;
        String json = this.tester.getDialog().getElement("criteriaJson").getTextContent();
        String[] searchers = json.split("},");
        ArrayList fieldsToCheck = Lists.newArrayList((Object[])new String[]{"\"id\":\"priority\"", "\"id\":\"resolution\"", "\"id\":\"duedate\""});
        if (presenceFlag) {
            fieldsToCheck.add("\"id\":\"assignee\"");
            presenceString = "\"isShown\":true";
        } else {
            presenceString = "\"isShown\":false";
        }
        int count = 0;
        for (int index = 0; count < fieldsToCheck.size() && index < searchers.length; ++index) {
            String s = searchers[index];
            if (!s.contains((CharSequence)fieldsToCheck.get(count))) continue;
            Assert.assertThat((Object)s, (Matcher)Matchers.containsString((String)presenceString));
            ++count;
        }
        Assert.assertEquals((long)fieldsToCheck.size(), (long)count);
    }

    private void assertHiddenFieldsAreNotPresent(String ... fields) {
        String json = this.tester.getDialog().getElement("criteriaJson").getTextContent();
        for (String field : fields) {
            Assert.assertFalse((String)String.format("Field '%s' is hidden and shouldn't be present", field), (boolean)json.contains("\"" + field + "\""));
        }
    }

    private void checkNavigatorFields() {
        this.logger.log((Object)"Check Issue Navigator display for hidden/visible fields");
        this.administration.subtasks().enable();
        this.fieldLayoutSchemes.addFieldLayoutSchemeEntry("Bug", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.fieldLayoutSchemes.associateFieldLayoutScheme("HSP", "New Field Layout Scheme");
        this.editIssueFieldVisibility.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Assignee");
        this.editIssueFieldVisibility.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Due Date");
        this.editIssueFieldVisibility.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Priority");
        this.editIssueFieldVisibility.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Resolution");
        this.navigation.issueNavigator().displayAllIssues();
        this.assertSearcherFields(true);
        this.fieldLayoutSchemes.associateFieldLayoutScheme("NDT", "New Field Layout Scheme");
        this.fieldLayoutSchemes.associateFieldLayoutScheme("MKY", "New Field Layout Scheme");
        this.fieldLayoutSchemes.addFieldLayoutSchemeEntry("New Feature", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.fieldLayoutSchemes.addFieldLayoutSchemeEntry("Improvement", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.fieldLayoutSchemes.addFieldLayoutSchemeEntry("Task", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.fieldLayoutSchemes.addFieldLayoutSchemeEntry("Sub-task", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.navigation.issueNavigator().displayAllIssues();
        this.assertHiddenFieldsAreNotPresent("Assignee", "Due Date", "Priority", "Resolution");
        this.editIssueFieldVisibility.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Assignee");
        this.editIssueFieldVisibility.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Due Date");
        this.editIssueFieldVisibility.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Priority");
        this.editIssueFieldVisibility.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Resolution");
        this.navigation.issueNavigator().displayAllIssues();
        this.assertSearcherFields(true);
        this.fieldLayoutSchemes.associateWithDefaultFieldLayout("HSP");
        this.fieldLayoutSchemes.associateWithDefaultFieldLayout("NDT");
        this.fieldLayoutSchemes.associateWithDefaultFieldLayout("MKY");
        this.removeFieldConfigurationSchemeEntry("Bug", "New Field Layout Scheme");
        this.removeFieldConfigurationSchemeEntry("New Feature", "New Field Layout Scheme");
        this.removeFieldConfigurationSchemeEntry("Improvement", "New Field Layout Scheme");
        this.removeFieldConfigurationSchemeEntry("Task", "New Field Layout Scheme");
        this.removeFieldConfigurationSchemeEntry("Sub-task", "New Field Layout Scheme");
        this.administration.subtasks().disable();
    }

    private void fieldSchemesEditIssueWithFieldLayoutSchemeRequired(String issueKey) {
        this.logger.log((Object)"Edit Issue: Attempt to edit an issue with issue field configuration");
        this.fieldLayoutSchemes.addFieldLayoutSchemeEntry("Bug", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.fieldLayoutSchemes.associateFieldLayoutScheme("HSP", "New Field Layout Scheme");
        this.editIssueFieldVisibility.setRequiredFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.editIssueFieldVisibility.setRequiredFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.editIssueFieldVisibility.setRequiredFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("edit-issue");
        this.tester.assertTextPresent("Edit Issue");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Component/s is required");
        this.tester.assertTextPresent("Affects Version/s is required");
        this.tester.assertTextPresent("Fix Version/s is required");
        this.fieldLayoutSchemes.associateWithDefaultFieldLayout("HSP");
        this.removeFieldConfigurationSchemeEntry("Bug", "New Field Layout Scheme");
        this.editIssueFieldVisibility.setOptionalFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.editIssueFieldVisibility.setOptionalFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.editIssueFieldVisibility.setOptionalFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
    }

    private void fieldSchemeMoveIssueWithFieldSchemeHidden(String issueKey) {
        this.logger.log((Object)"Move Issue: Test the abilty to hide a field in a particular Field Configuration Scheme");
        this.fieldLayoutSchemes.addFieldLayoutSchemeEntry("Improvement", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.fieldLayoutSchemes.associateFieldLayoutScheme("HSP", "New Field Layout Scheme");
        this.editIssueFieldVisibility.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.editIssueFieldVisibility.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.editIssueFieldVisibility.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("move-issue");
        this.tester.assertTextPresent("Move Issue");
        this.navigation.issue().selectIssueType("Improvement", "issuetype");
        this.tester.submit();
        this.tester.assertTextPresent("All fields will be updated automatically.");
        this.editIssueFieldVisibility.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.editIssueFieldVisibility.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.editIssueFieldVisibility.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        this.fieldLayoutSchemes.associateWithDefaultFieldLayout("HSP");
        this.removeFieldConfigurationSchemeEntry("Improvement", "New Field Layout Scheme");
    }

    private void fieldSchemeMoveIssueWithFieldSchemeRequired(String issueKey) {
        this.logger.log((Object)"Move Issue: Test the abilty to make a field required in a particular Field Configuration Scheme");
        this.fieldLayoutSchemes.addFieldLayoutSchemeEntry("Improvement", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.fieldLayoutSchemes.associateFieldLayoutScheme("HSP", "New Field Layout Scheme");
        this.editIssueFieldVisibility.setRequiredFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.editIssueFieldVisibility.setRequiredFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.editIssueFieldVisibility.setRequiredFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("move-issue");
        this.tester.assertTextPresent("Move Issue");
        this.navigation.issue().selectIssueType("Improvement", "issuetype");
        this.tester.submit();
        this.tester.assertTextPresent("Step 3 of 4");
        this.tester.getDialog().setWorkingForm("jiraform");
        this.tester.submit();
        this.tester.assertTextPresent("Step 3 of 4");
        this.tester.assertTextPresent("Component/s is required");
        this.tester.assertTextPresent("Affects Version/s is required");
        this.tester.assertTextPresent("Fix Version/s is required");
        this.editIssueFieldVisibility.setOptionalFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.editIssueFieldVisibility.setOptionalFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.editIssueFieldVisibility.setOptionalFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        this.fieldLayoutSchemes.associateWithDefaultFieldLayout("HSP");
        this.removeFieldConfigurationSchemeEntry("Improvement", "New Field Layout Scheme");
    }

    private void fieldSchemeCreateSubTaskWithFieldSchemeRequired(String issueKey) {
        this.logger.log((Object)"Sub Task Create: Enforce Sub Tasks on a field configuration scheme");
        this.administration.subtasks().enable();
        this.fieldLayoutSchemes.addFieldLayoutSchemeEntry("Sub-task", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.fieldLayoutSchemes.associateFieldLayoutScheme("HSP", "New Field Layout Scheme");
        this.editIssueFieldVisibility.setRequiredFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.editIssueFieldVisibility.setRequiredFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.editIssueFieldVisibility.setRequiredFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("create-subtask");
        this.tester.assertTextPresent("Create Sub-Task");
        this.tester.setFormElement("summary", "test summary");
        this.tester.submit();
        this.tester.assertTextPresent("Create Sub-Task");
        this.tester.assertTextPresent("Component/s is required");
        this.tester.assertTextPresent("Affects Version/s is required");
        this.tester.assertTextPresent("Fix Version/s is required");
        this.editIssueFieldVisibility.setOptionalFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.editIssueFieldVisibility.setOptionalFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.editIssueFieldVisibility.setOptionalFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        this.fieldLayoutSchemes.associateWithDefaultFieldLayout("HSP");
        this.removeFieldConfigurationSchemeEntry("Sub-task", "New Field Layout Scheme");
        this.administration.subtasks().disable();
    }

    private void fieldSchemeCreateSubTaskWithFieldSchemeHidden(String issueKey) {
        this.logger.log((Object)"Sub Task Create: Enforce Sub Tasks on a field configuration scheme");
        this.administration.subtasks().enable();
        this.fieldLayoutSchemes.addFieldLayoutSchemeEntry("Sub-task", FIELD_CONFIGURATION_NAME_ONE, "New Field Layout Scheme");
        this.fieldLayoutSchemes.associateFieldLayoutScheme("HSP", "New Field Layout Scheme");
        this.editIssueFieldVisibility.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.editIssueFieldVisibility.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.editIssueFieldVisibility.setHiddenFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("create-subtask");
        this.tester.assertTextPresent("Create Sub-Task");
        this.tester.assertFormElementNotPresent("components");
        this.tester.assertFormElementNotPresent("versions");
        this.tester.assertFormElementNotPresent("fixVersions");
        this.editIssueFieldVisibility.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Component/s");
        this.editIssueFieldVisibility.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Affects Version/s");
        this.editIssueFieldVisibility.setShownFieldsOnEnterprise(FIELD_CONFIGURATION_NAME_ONE, "Fix Version/s");
        this.fieldLayoutSchemes.associateWithDefaultFieldLayout("HSP");
        this.removeFieldConfigurationSchemeEntry("Sub-task", "New Field Layout Scheme");
        this.administration.subtasks().disable();
    }
}

